/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider;

import org.thingsboard.trendz.tools.DateTimeUtils;

public class TbWebRequestExecutionInfo {
    private long schedulingTs;
    private long startTs;
    private long endTs;
    private long rateLimitDelay;
    private long exchangeDelay;
    private long executionTime;

    public TbWebRequestExecutionInfo(long schedulingTs, long startTs, long endTs, long rateLimitDelay) {
        this.setSchedulingTs(schedulingTs);
        this.setStartTs(startTs);
        this.setEndTs(endTs);
        this.setRateLimitDelay(rateLimitDelay);
        this.setExchangeDelay(endTs - startTs - rateLimitDelay);
        this.setExecutionTime(endTs - startTs);
    }

    public String toString() {
        return String.format("TbWebRequestExecutionInfo(schedulingTs=%s, startTs=%s, endTs=%s, rateLimitDelay=%s, exchangeDelay=%s, executionTime=%s)", DateTimeUtils.fromTs((long)this.schedulingTs), DateTimeUtils.fromTs((long)this.startTs), DateTimeUtils.fromTs((long)this.endTs), this.rateLimitDelay, this.exchangeDelay, this.executionTime);
    }

    public long getSchedulingTs() {
        return this.schedulingTs;
    }

    public long getStartTs() {
        return this.startTs;
    }

    public long getEndTs() {
        return this.endTs;
    }

    public long getRateLimitDelay() {
        return this.rateLimitDelay;
    }

    public long getExchangeDelay() {
        return this.exchangeDelay;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public void setSchedulingTs(long schedulingTs) {
        this.schedulingTs = schedulingTs;
    }

    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    public void setEndTs(long endTs) {
        this.endTs = endTs;
    }

    public void setRateLimitDelay(long rateLimitDelay) {
        this.rateLimitDelay = rateLimitDelay;
    }

    public void setExchangeDelay(long exchangeDelay) {
        this.exchangeDelay = exchangeDelay;
    }

    public void setExecutionTime(long executionTime) {
        this.executionTime = executionTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbWebRequestExecutionInfo)) {
            return false;
        }
        TbWebRequestExecutionInfo other = (TbWebRequestExecutionInfo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getSchedulingTs() != other.getSchedulingTs()) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        if (this.getEndTs() != other.getEndTs()) {
            return false;
        }
        if (this.getRateLimitDelay() != other.getRateLimitDelay()) {
            return false;
        }
        if (this.getExchangeDelay() != other.getExchangeDelay()) {
            return false;
        }
        return this.getExecutionTime() == other.getExecutionTime();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TbWebRequestExecutionInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $schedulingTs = this.getSchedulingTs();
        result = result * 59 + (int)($schedulingTs >>> 32 ^ $schedulingTs);
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $endTs = this.getEndTs();
        result = result * 59 + (int)($endTs >>> 32 ^ $endTs);
        long $rateLimitDelay = this.getRateLimitDelay();
        result = result * 59 + (int)($rateLimitDelay >>> 32 ^ $rateLimitDelay);
        long $exchangeDelay = this.getExchangeDelay();
        result = result * 59 + (int)($exchangeDelay >>> 32 ^ $exchangeDelay);
        long $executionTime = this.getExecutionTime();
        result = result * 59 + (int)($executionTime >>> 32 ^ $executionTime);
        return result;
    }
}

