/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider;

import java.util.Collections;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.thingsboard.trendz.domain.tb.provider.RequestPriority;

public class TbWebRequest<T> {
    private static final HttpHeaders DEFAULT_HEADERS = HttpHeaders.EMPTY;
    private String uri;
    private Map<String, Object> params;
    private HttpHeaders headers;
    private Object body;
    private RequestPriority priority;
    private ParameterizedTypeReference<T> typeReference;
    private boolean isNotFoundErrorSuppressed;

    public TbWebRequest(String uri, RequestPriority priority, ParameterizedTypeReference<T> typeReference) {
        this(uri, priority, Collections.emptyMap(), DEFAULT_HEADERS, null, typeReference);
    }

    public TbWebRequest(String uri, RequestPriority priority, HttpHeaders headers, ParameterizedTypeReference<T> typeReference) {
        this(uri, priority, Collections.emptyMap(), headers, null, typeReference);
    }

    public TbWebRequest(String uri, RequestPriority priority, Map<String, Object> params, HttpHeaders headers, ParameterizedTypeReference<T> typeReference) {
        this(uri, priority, params, headers, null, typeReference);
    }

    public TbWebRequest(String uri, RequestPriority priority, Object body, ParameterizedTypeReference<T> typeReference) {
        this(uri, priority, Collections.emptyMap(), DEFAULT_HEADERS, body, typeReference);
    }

    public TbWebRequest(String uri, RequestPriority priority, HttpHeaders headers, Object body, ParameterizedTypeReference<T> typeReference) {
        this(uri, priority, Collections.emptyMap(), headers, body, typeReference);
    }

    public TbWebRequest(String uri, RequestPriority priority, Map<String, Object> params, HttpHeaders headers, Object body, ParameterizedTypeReference<T> typeReference) {
        this.validate(typeReference);
        this.uri = uri;
        this.params = params;
        this.headers = headers;
        this.body = body;
        this.typeReference = typeReference;
        this.priority = priority == null ? RequestPriority.LOW : priority;
        this.isNotFoundErrorSuppressed = false;
    }

    public TbWebRequest<T> suppressNotFoundError() {
        this.isNotFoundErrorSuppressed = true;
        return this;
    }

    private void validate(ParameterizedTypeReference<T> typeReference) {
        if (typeReference.getType().equals(Void.class)) {
            throw new IllegalArgumentException("Void type is not supported, use Boolean instead for empty http response");
        }
    }

    public String getUri() {
        return this.uri;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public Object getBody() {
        return this.body;
    }

    public RequestPriority getPriority() {
        return this.priority;
    }

    public ParameterizedTypeReference<T> getTypeReference() {
        return this.typeReference;
    }

    public boolean isNotFoundErrorSuppressed() {
        return this.isNotFoundErrorSuppressed;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public void setPriority(RequestPriority priority) {
        this.priority = priority;
    }

    public void setTypeReference(ParameterizedTypeReference<T> typeReference) {
        this.typeReference = typeReference;
    }

    public void setNotFoundErrorSuppressed(boolean isNotFoundErrorSuppressed) {
        this.isNotFoundErrorSuppressed = isNotFoundErrorSuppressed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbWebRequest)) {
            return false;
        }
        TbWebRequest other = (TbWebRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isNotFoundErrorSuppressed() != other.isNotFoundErrorSuppressed()) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        Map this$params = this.getParams();
        Map other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        HttpHeaders this$headers = this.getHeaders();
        HttpHeaders other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
            return false;
        }
        Object this$body = this.getBody();
        Object other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        RequestPriority this$priority = this.getPriority();
        RequestPriority other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !this$priority.equals(other$priority)) {
            return false;
        }
        ParameterizedTypeReference this$typeReference = this.getTypeReference();
        ParameterizedTypeReference other$typeReference = other.getTypeReference();
        return !(this$typeReference == null ? other$typeReference != null : !this$typeReference.equals(other$typeReference));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TbWebRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNotFoundErrorSuppressed() ? 79 : 97);
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        Map $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        HttpHeaders $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        Object $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        RequestPriority $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : $priority.hashCode());
        ParameterizedTypeReference $typeReference = this.getTypeReference();
        result = result * 59 + ($typeReference == null ? 43 : $typeReference.hashCode());
        return result;
    }

    public String toString() {
        return "TbWebRequest(uri=" + this.getUri() + ", params=" + String.valueOf(this.getParams()) + ", headers=" + String.valueOf(this.getHeaders()) + ", body=" + String.valueOf(this.getBody()) + ", priority=" + String.valueOf(this.getPriority()) + ", typeReference=" + String.valueOf(this.getTypeReference()) + ", isNotFoundErrorSuppressed=" + this.isNotFoundErrorSuppressed() + ")";
    }
}

