/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider;

import java.util.HashMap;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.thingsboard.trendz.exception.service.provider.TbWebClientException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.service.AuthenticationService;
import org.thingsboard.trendz.security.service.TokenExtractor;
import org.thingsboard.trendz.service.provider.cache.CacheConfigurationName;
import org.thingsboard.trendz.service.provider.cache.CacheService;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
@Aspect
public class TbRestDataSourceJwtAspect {
    private static final Logger log = LoggerFactory.getLogger(TbRestDataSourceJwtAspect.class);
    private static final String ARGUMENT_NAME = "jwtToken";
    private final AuthenticationService authenticationService;
    private final TokenExtractor tokenExtractor;
    private final Cache tokenCache;

    @Autowired
    public TbRestDataSourceJwtAspect(AuthenticationService authenticationService, TokenExtractor tokenExtractor, CacheService cacheService) {
        this.authenticationService = authenticationService;
        this.tokenExtractor = tokenExtractor;
        this.tokenCache = cacheService.getCache(CacheConfigurationName.jwtTokenCacheName);
    }

    @Around(value="execution(public * org.thingsboard.trendz.service.provider.TbRestDataSource.*(..))")
    public Object interceptRequest(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Class returnType = signature.getReturnType();
        if ("checkTokenIsValid".equals(signature.getMethod().getName())) {
            return joinPoint.proceed();
        }
        if (Flux.class.equals((Object)returnType)) {
            Flux result;
            try {
                result = (Flux)joinPoint.proceed();
            }
            catch (TbWebClientException e) {
                result = (Flux)joinPoint.proceed(this.makeNewArgs(joinPoint, (Throwable)e));
            }
            Flux finalResult = result;
            return Mono.just((Object)new Object()).flatMapMany(o -> finalResult).onErrorResume(throwable -> {
                try {
                    Object[] newArgs = this.makeNewArgs(joinPoint, throwable);
                    Flux newResult = (Flux)joinPoint.proceed(newArgs);
                    return newResult;
                }
                catch (Throwable e) {
                    return Mono.error((Throwable)e);
                }
            });
        }
        if (Mono.class.equals((Object)returnType)) {
            Mono result;
            try {
                result = (Mono)joinPoint.proceed();
            }
            catch (TbWebClientException e) {
                result = (Mono)joinPoint.proceed(this.makeNewArgs(joinPoint, (Throwable)e));
            }
            Mono finalResult = result;
            return Mono.just((Object)new Object()).flatMap(o -> finalResult).onErrorResume(throwable -> {
                try {
                    Object[] newArgs = this.makeNewArgs(joinPoint, throwable);
                    Mono newResult = (Mono)joinPoint.proceed(newArgs);
                    return newResult;
                }
                catch (Throwable e) {
                    return Mono.error((Throwable)e);
                }
            });
        }
        try {
            return joinPoint.proceed();
        }
        catch (TbWebClientException e) {
            return joinPoint.proceed(this.makeNewArgs(joinPoint, (Throwable)e));
        }
    }

    private Object[] makeNewArgs(ProceedingJoinPoint joinPoint, Throwable throwable) throws Throwable {
        if (throwable instanceof TbWebClientException && throwable.getCause() instanceof WebClientResponseException.Unauthorized) {
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            String[] parameterNames = signature.getParameterNames();
            Object[] args = joinPoint.getArgs();
            HashMap<String, Object> parameterValueMap = new HashMap<String, Object>();
            HashMap<String, Integer> parameterIteratorMap = new HashMap<String, Integer>();
            for (int i = 0; i < parameterNames.length; ++i) {
                parameterValueMap.put(parameterNames[i], args[i]);
                parameterIteratorMap.put(parameterNames[i], i);
            }
            if (!parameterValueMap.containsKey(ARGUMENT_NAME)) {
                throw throwable;
            }
            String jwtToken = parameterValueMap.get(ARGUMENT_NAME).toString();
            JwtSecurityUser user = this.tokenExtractor.extractUser(jwtToken);
            String newJwtToken = this.authenticationService.createTokenFromSigningKey(user);
            this.tokenCache.put((Object)user, (Object)newJwtToken);
            args[((Integer)parameterIteratorMap.get((Object)ARGUMENT_NAME)).intValue()] = newJwtToken;
            log.warn("A new token has created during request interception!");
            return args;
        }
        throw throwable;
    }
}

