/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.EntitySubtype;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ResourceSubType;
import org.thingsboard.server.common.data.ResourceType;
import org.thingsboard.server.common.data.TbResource;
import org.thingsboard.server.common.data.TbResourceInfo;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.asset.AssetSearchQuery;
import org.thingsboard.server.common.data.device.DeviceSearchQuery;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.EntitySearchDirection;
import org.thingsboard.server.common.data.relation.RelationsSearchParameters;
import org.thingsboard.server.common.data.wl.WhiteLabelingParams;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.relation.Direction;
import org.thingsboard.trendz.domain.definition.entity.relation.Relation;
import org.thingsboard.trendz.domain.measurement.MeasuredTaskType;
import org.thingsboard.trendz.domain.measurement.MeasurementInfo;
import org.thingsboard.trendz.domain.measurement.MeasurementParameters;
import org.thingsboard.trendz.domain.runtime.EnhancedAsset;
import org.thingsboard.trendz.domain.runtime.EnhancedCustomer;
import org.thingsboard.trendz.domain.runtime.EnhancedDevice;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.domain.tb.dashboard.dto.Dashboard;
import org.thingsboard.trendz.domain.tb.provider.RequestPriority;
import org.thingsboard.trendz.domain.tb.trendz_settings.TrendzSettings;
import org.thingsboard.trendz.domain.tb.widget.v1.TbWidgetBundleItemV1;
import org.thingsboard.trendz.domain.tb.widget.v1.TbWidgetTypeItemV1;
import org.thingsboard.trendz.domain.tb.widget.v2.TbWidgetBundleItemV2;
import org.thingsboard.trendz.domain.tb.widget.v2.TbWidgetTypeItemV2;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.security.entity.AuthToken;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.jwt.JwtSettings;
import org.thingsboard.trendz.service.definition.TbDataEntry;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.provider.AttributeData;
import org.thingsboard.trendz.service.provider.TbAssetService;
import org.thingsboard.trendz.service.provider.TbCustomerService;
import org.thingsboard.trendz.service.provider.TbDeviceService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.provider.TbWebClient;
import org.thingsboard.trendz.service.provider.TbWebRequest;
import org.thingsboard.trendz.service.provider.TbWebRequestExecutionInfo;
import org.thingsboard.trendz.service.provider.TbWebResponse;
import org.thingsboard.trendz.service.provider.TsData;
import org.thingsboard.trendz.service.provider.cache.WebClientCachier;
import org.thingsboard.trendz.service.provider.tb3.PageDataIterableV3;
import org.thingsboard.trendz.service.provider.tb3.PageLink;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.FilteredEntityDataTransformer;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.PageDataIterableV3Filterable;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.TbFilterQueryBuilder;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.AssetTypeFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.DeviceTypeFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityDataPageLink;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityDataQuery;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityDataSortOrder;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityKey;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityKeyType;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityTypeFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.TsValue;
import org.thingsboard.trendz.service.provider.version.TbVersion;
import org.thingsboard.trendz.service.provider.version.TbVersionChecker;
import org.thingsboard.trendz.service.provider.version.TbVersionNumber;
import org.thingsboard.trendz.service.stats.StatsCollector;
import org.thingsboard.trendz.service.stats.TickType;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Component
public class TbRestDataSource {
    private static final Logger log = LoggerFactory.getLogger(TbRestDataSource.class);
    public static final String JWT_TOKEN_HEADER_PARAM = "X-Authorization";
    public static final int MAX_ITEM_IDS_IN_PARAM = 100;
    public static final int MAX_PARAM_LENGTH = 3072;
    private final TbVersionChecker tbVersionChecker;
    private final TbFilterQueryBuilder tbFilterQueryBuilder;
    private final FilteredEntityDataTransformer entityDataTransformer;
    private final StatsCollector statsCollector;
    private final WebClientCachier webClientCachier;
    private final TbWebClient tbWebClient;
    private final ExecutorManagementService executorManagementService;
    private final int pagesizeItems;
    private final int pagesizeTelemetry;
    private final int sendTelemetryBatchSize;
    private final long sendTelemetryIntervalMs;

    @Autowired
    public TbRestDataSource(TbVersionChecker tbVersionChecker, TbFilterQueryBuilder tbFilterQueryBuilder, FilteredEntityDataTransformer entityDataTransformer, StatsCollector statsCollector, WebClientCachier webClientCachier, TbWebClient tbWebClient, ExecutorManagementService executorManagementService, @Value(value="${tb.api.limits.pagesize.items}") int pagesizeItems, @Value(value="${tb.api.limits.pagesize.telemetry}") int pagesizeTelemetry, @Value(value="${ratelimit.sendTelemetryBatchSize}") int sendTelemetryBatchSize, @Value(value="${ratelimit.sendTelemetryIntervalMs}") long sendTelemetryIntervalMs) {
        this.tbVersionChecker = tbVersionChecker;
        this.tbFilterQueryBuilder = tbFilterQueryBuilder;
        this.entityDataTransformer = entityDataTransformer;
        this.statsCollector = statsCollector;
        this.webClientCachier = webClientCachier;
        this.tbWebClient = tbWebClient;
        this.executorManagementService = executorManagementService;
        this.pagesizeItems = pagesizeItems;
        this.pagesizeTelemetry = pagesizeTelemetry;
        this.sendTelemetryBatchSize = sendTelemetryBatchSize;
        this.sendTelemetryIntervalMs = sendTelemetryIntervalMs;
    }

    private HttpHeaders getJwtHeader(String jwtToken) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add(JWT_TOKEN_HEADER_PARAM, "Bearer " + jwtToken);
        return httpHeaders;
    }

    public Mono<AuthToken> login(String login, String pass) {
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("username", login);
        requestBody.put("password", pass);
        return this.tbWebClient.post(new TbWebRequest("/api/auth/login", RequestPriority.HIGH, requestBody, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<AuthToken> refreshToken(String refreshToken) {
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("refreshToken", refreshToken);
        return this.tbWebClient.post(new TbWebRequest("/api/auth/token", RequestPriority.HIGH, requestBody, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<Boolean> checkTokenIsValid(String jwtToken) {
        return this.tbWebClient.get(new TbWebRequest("/api/user/tokenAccessEnabled", RequestPriority.HIGH, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(i -> Boolean.TRUE).onErrorResume(throwable -> {
            if (throwable.getCause() instanceof WebClientResponseException.Unauthorized) {
                return Mono.just((Object)false);
            }
            return Mono.error((Throwable)throwable);
        });
    }

    public Mono<User> getUserByUserId(String jwtToken, UUID userId) {
        return this.tbWebClient.get(new TbWebRequest("/api/user/" + String.valueOf(userId), RequestPriority.HIGH, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<JsonNode> getSubscriptionDetails(String jwtToken) {
        return this.tbWebClient.get(new TbWebRequest("/api/tenant/subscription/data", RequestPriority.HIGH, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<JsonNode> getSubscription(String jwtToken) {
        return this.tbWebClient.get(new TbWebRequest("/api/billing/tenant/subscription", RequestPriority.HIGH, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Flux<Device> findRelatedDevices(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, Relation relation, String relatedDeviceType, EntityId entityId, String jwtToken) {
        Flux result;
        int pageSize;
        long executionStartTs = System.currentTimeMillis();
        TbVersion tbVersion = this.getTbVersionValidating(jwtToken);
        EntitySearchDirection direction = relation.getDirection() == Direction.FROM ? EntitySearchDirection.FROM : EntitySearchDirection.TO;
        int n = pageSize = request != null && request.isPreviewRequest() ? request.getPreviewItemCount() : this.pagesizeItems;
        if (tbVersion.getVersion().greaterOrEqual(TbVersionNumber.V_3_1_0)) {
            EntityDataQuery query = this.tbFilterQueryBuilder.buildRelationQuery(entityId, direction, businessEntity, request, relatedDeviceType, EntityType.DEVICE, ctx, relation.getRelationType(), pageSize);
            Supplier<Flux> findRelatedDevicesSupplier = () -> Objects.requireNonNull(this.loadDevicesPageV31FilterAsync(ctx, query, jwtToken)).map(pd -> Sets.newHashSet((Iterable)pd.getData())).doOnNext(devices -> {
                List itemList = devices.stream().map(device -> TbDeviceService.map((Device)device, (String)relatedDeviceType, (UUID)entityId.getId())).collect(Collectors.toList());
                this.entityDataTransformer.fetchFilterValues(ctx, request, businessEntity, itemList);
            }).flatMapMany(l -> {
                if (request != null && request.isOwnerRequired()) {
                    return this.entityDataTransformer.enrichDevicesWithCustomerIdAsync((Set)l, deviceIds -> this.loadDevicesByIdsAsync(ctx, deviceIds, jwtToken));
                }
                return Flux.fromIterable((Iterable)l);
            }).map(o -> (EnhancedDevice)o);
            String key = String.valueOf(query);
            result = this.webClientCachier.getOrFetch("findRelatedDevices", key, jwtToken, findRelatedDevicesSupplier, (TypeReference)new /* Unavailable Anonymous Inner Class!! */).map(o -> o);
        } else {
            Map distancesFromRoot = ctx.getDistancesFromRoot();
            Integer distance = (Integer)distancesFromRoot.get(entityId.getId());
            DeviceSearchQuery query = new DeviceSearchQuery();
            query.setParameters(new RelationsSearchParameters(entityId, direction, distance.intValue(), false));
            query.setRelationType(relation.getRelationType());
            query.setDeviceTypes(Collections.singletonList(relatedDeviceType));
            result = this.tbWebClient.post(new TbWebRequest("/api/devices", this.priorityFromCtx(ctx), this.getJwtHeader(jwtToken), (Object)query, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "findRelatedDevices", response)).map(Optional::get).doOnNext(l -> this.statsCollector.tick("findRelatedDevices", executionStartTs, System.currentTimeMillis(), TickType.OTHER)).flatMapIterable(list -> list);
        }
        return result;
    }

    public Flux<Asset> findRelatedAssets(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, Relation relation, String relatedAssetType, EntityId entityId, String jwtToken) {
        int pageSize;
        long executionStartTs = System.currentTimeMillis();
        TbVersion tbVersion = this.getTbVersionValidating(jwtToken);
        EntitySearchDirection direction = relation.getDirection() == Direction.FROM ? EntitySearchDirection.FROM : EntitySearchDirection.TO;
        int n = pageSize = request != null && request.isPreviewRequest() ? request.getPreviewItemCount() : this.pagesizeItems;
        if (tbVersion.getVersion().greaterOrEqual(TbVersionNumber.V_3_1_0)) {
            EntityDataQuery query = this.tbFilterQueryBuilder.buildRelationQuery(entityId, direction, businessEntity, request, relatedAssetType, EntityType.ASSET, ctx, relation.getRelationType(), pageSize);
            Supplier<Flux> findRelatedAssetsSupplier = () -> Objects.requireNonNull(this.loadAssetsPageV31FilterAsync(ctx, query, jwtToken)).map(pd -> Sets.newHashSet((Iterable)pd.getData())).doOnNext(l -> this.statsCollector.tick("findRelatedAssets", executionStartTs, System.currentTimeMillis(), TickType.OTHER)).doOnNext(assets -> {
                List itemList = assets.stream().map(asset -> TbAssetService.map((Asset)asset, (String)relatedAssetType, (UUID)entityId.getId())).collect(Collectors.toList());
                this.entityDataTransformer.fetchFilterValues(ctx, request, businessEntity, itemList);
            }).flatMapMany(l -> {
                if (request != null && request.isOwnerRequired()) {
                    return this.entityDataTransformer.enrichAssetsWithCustomerIdAsync((Set)l, assetIds -> this.loadAssetsByIdsAsync(ctx, assetIds, jwtToken));
                }
                return Flux.fromIterable((Iterable)l);
            }).map(o -> (EnhancedAsset)o);
            String key = String.valueOf(query);
            return this.webClientCachier.getOrFetch("findRelatedDevices", key, jwtToken, findRelatedAssetsSupplier, (TypeReference)new /* Unavailable Anonymous Inner Class!! */).map(o -> o);
        }
        Map distancesFromRoot = ctx.getDistancesFromRoot();
        Integer distance = (Integer)distancesFromRoot.get(entityId.getId());
        AssetSearchQuery query = new AssetSearchQuery();
        query.setParameters(new RelationsSearchParameters(entityId, direction, distance.intValue(), false));
        query.setRelationType(relation.getRelationType());
        query.setAssetTypes(Collections.singletonList(relatedAssetType));
        return this.tbWebClient.post(new TbWebRequest("/api/assets", this.priorityFromCtx(ctx), Collections.emptyMap(), this.getJwtHeader(jwtToken), (Object)query, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "findRelatedAssets", response)).map(Optional::get).flatMapIterable(list -> list);
    }

    public Flux<Customer> findRelatedCustomers(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, Relation relation, String relatedCustomerType, EntityId entityId, String jwtToken) {
        EntitySearchDirection direction = relation.getDirection() == Direction.FROM ? EntitySearchDirection.FROM : EntitySearchDirection.TO;
        int pageSize = request != null && request.isPreviewRequest() ? request.getPreviewItemCount() : this.pagesizeItems;
        long executionStartTs = System.currentTimeMillis();
        TbVersion tbVersion = this.getTbVersionValidating(jwtToken);
        if (tbVersion.getVersion().greaterOrEqual(TbVersionNumber.V_3_1_0)) {
            EntityDataQuery query = this.tbFilterQueryBuilder.buildRelationQuery(entityId, direction, businessEntity, request, relatedCustomerType, EntityType.CUSTOMER, ctx, relation.getRelationType(), pageSize);
            Supplier<Flux> findRelatedCustomersSupplier = () -> this.tbWebClient.post(new TbWebRequest("/api/entitiesQuery/find", this.priorityFromCtx(ctx), Collections.emptyMap(), this.getJwtHeader(jwtToken), (Object)query, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "findRelatedCustomers", response)).map(Optional::get).map(arg_0 -> ((FilteredEntityDataTransformer)this.entityDataTransformer).entityToCustomerPageData(arg_0)).map(PageData::getData).doOnNext(l -> this.statsCollector.tick("findRelatedCustomers", executionStartTs, System.currentTimeMillis(), TickType.OTHER)).doOnNext(customerList -> {
                List itemList = customerList.stream().map(customer -> TbCustomerService.mapCustomerToItem((Customer)customer, (UUID)entityId.getId())).collect(Collectors.toList());
                this.entityDataTransformer.fetchFilterValues(ctx, request, businessEntity, itemList);
            }).flatMapIterable(l -> l).map(o -> (EnhancedCustomer)o);
            String key = String.valueOf(query);
            return this.webClientCachier.getOrFetch("findRelatedCustomers", key, jwtToken, findRelatedCustomersSupplier, (TypeReference)new /* Unavailable Anonymous Inner Class!! */).map(o -> o);
        }
        throw new IllegalStateException("Customer relation search not allowed in this version");
    }

    public Flux<Item> findMultiRootRelatedItems(ViewRequest request, ViewContext ctx, Set<EntityId> entityIds, String jwtToken) {
        int pageSize = request != null && request.isPreviewRequest() ? request.getPreviewItemCount() : this.pagesizeItems;
        long executionStartTs = System.currentTimeMillis();
        TbVersion version = this.getTbVersionValidating(jwtToken);
        if (version.getVersion().greaterOrEqual(TbVersionNumber.V_3_3_3)) {
            Optional optional = this.tbFilterQueryBuilder.buildMultiRelationQuery(entityIds, request, ctx, pageSize);
            if (optional.isEmpty()) {
                return Flux.empty();
            }
            EntityDataQuery query = (EntityDataQuery)optional.get();
            HashSet allItems = Sets.newHashSet();
            PageDataIterableV3Filterable entityIterator = new PageDataIterableV3Filterable(q -> this.loadRawEntityData(ctx, q, jwtToken), query);
            for (Item entityData : entityIterator) {
                allItems.add(entityData);
            }
            this.statsCollector.tick("findMultiRootRelatedItems", executionStartTs, System.currentTimeMillis(), TickType.OTHER);
            return Flux.fromIterable((Iterable)allItems);
        }
        throw new IllegalStateException("findMultiRootRelatedItems function is not allowed for version " + String.valueOf(version));
    }

    public Flux<EntitySubtype> loadAssetTypes(ViewContext ctx, String jwtToken) {
        return this.tbWebClient.get(new TbWebRequest("/api/asset/types", this.priorityFromCtx(ctx), this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "loadAssetTypes", response)).map(Optional::get).flatMapIterable(set -> set);
    }

    public Flux<EntitySubtype> loadDeviceTypes(ViewContext ctx, String jwtToken) {
        return this.tbWebClient.get(new TbWebRequest("/api/device/types", this.priorityFromCtx(ctx), this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "loadDeviceTypes", response)).map(Optional::get).flatMapIterable(set -> set);
    }

    public Mono<Optional<Set<String>>> findAttributeKeys(ViewContext ctx, String scope, String type, UUID id, String jwtToken) {
        String uri = "/api/plugins/telemetry/" + type + "/" + String.valueOf(id) + "/keys/attributes/" + scope;
        return this.tbWebClient.get(new TbWebRequest(uri, this.priorityFromCtx(ctx), this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "findAttributeKeys", response));
    }

    public Mono<Optional<Set<String>>> findTelemetryKeys(ViewContext ctx, String type, UUID id, String jwtToken) {
        String uri = "/api/plugins/telemetry/" + type + "/" + String.valueOf(id) + "/keys/timeseries";
        return this.tbWebClient.get(new TbWebRequest(uri, this.priorityFromCtx(ctx), this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "findTelemetryKeys", response));
    }

    public Flux<EntityRelation> findRelations(UUID entityId, String entityType, String jwtToken, String relationType, Direction direction) {
        HashMap<String, String> requestParam = new HashMap<String, String>();
        switch (67.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$relation$Direction[direction.ordinal()]) {
            case 1: {
                requestParam.put("fromId", entityId.toString());
                requestParam.put("fromType", entityType);
                break;
            }
            case 2: {
                requestParam.put("toId", entityId.toString());
                requestParam.put("toType", entityType);
            }
        }
        if (relationType != null) {
            requestParam.put("relationType", relationType);
        }
        return this.tbWebClient.get(new TbWebRequest("/api/relations", null, requestParam, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get).flatMapIterable(set -> set);
    }

    public Flux<Asset> loadAssets(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, String assetType, String textSearch, JwtSecurityUser user, String jwtToken, Integer limit) {
        TbVersion version = this.getTbVersionValidating(jwtToken);
        Iterable assetIterable = this.getAssetIterable(ctx, request, businessEntity, assetType, textSearch, jwtToken, limit, version, user);
        Set allAssets = this.getAllItems(assetIterable, request, limit);
        if (version.getVersion().greaterOrEqual(TbVersionNumber.V_3_1_0) && request != null) {
            List itemList = allAssets.stream().map(asset -> TbAssetService.map((Asset)asset, (String)assetType, null)).collect(Collectors.toList());
            this.entityDataTransformer.fetchFilterValues(ctx, request, businessEntity, itemList);
        }
        if (version.getVersion().greaterOrEqual(TbVersionNumber.V_3_1_0) && request != null && request.isOwnerRequired()) {
            this.entityDataTransformer.enrichAssetsWithCustomerId(ctx, allAssets, jwtToken, assetIds -> this.loadAssetsByIds(ctx, assetIds, jwtToken));
        }
        return Flux.fromIterable((Iterable)allAssets);
    }

    public Flux<Device> loadDevices(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, String deviceType, String textSearch, JwtSecurityUser user, String jwtToken, Integer limit) {
        return Mono.fromCallable(() -> {
            TbVersion version = this.tbVersionChecker.getVersion(jwtToken);
            Iterable deviceIterator = this.getDeviceIterable(ctx, request, businessEntity, deviceType, textSearch, jwtToken, limit, version, user);
            Set allDevices = this.getAllItems(deviceIterator, request, limit);
            if (version.getVersion().greaterOrEqual(TbVersionNumber.V_3_1_0) && request != null) {
                List itemList = allDevices.stream().map(device -> TbDeviceService.map((Device)device, (String)deviceType, null)).collect(Collectors.toList());
                this.entityDataTransformer.fetchFilterValues(ctx, request, businessEntity, itemList);
            }
            if (version.getVersion().greaterOrEqual(TbVersionNumber.V_3_1_0) && request != null && request.isOwnerRequired()) {
                this.entityDataTransformer.enrichDevicesWithCustomerId(allDevices, deviceIds -> this.loadDevicesByIds(ctx, deviceIds, jwtToken));
            }
            return allDevices;
        }).subscribeOn(Schedulers.boundedElastic()).flatMapIterable(l -> l);
    }

    public Flux<Customer> loadCustomers(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, JwtSecurityUser user, String jwtToken) {
        long executionStartTs = System.currentTimeMillis();
        Iterable customerIterable = this.getCustomerIterable(request, ctx, businessEntity, user, jwtToken);
        Set allCustomers = this.getAllItems(customerIterable, request, null);
        this.statsCollector.tick("loadCustomers", executionStartTs, System.currentTimeMillis(), TickType.OTHER);
        return Flux.fromIterable((Iterable)allCustomers);
    }

    private Iterable<Customer> getCustomerIterable(ViewRequest request, ViewContext ctx, BusinessEntity businessEntity, JwtSecurityUser user, String jwtToken) {
        int pageSize;
        TbVersion version = this.tbVersionChecker.getVersion(jwtToken);
        int n = pageSize = request != null && request.isPreviewRequest() ? request.getPreviewItemCount() : this.pagesizeItems;
        if (version.getVersion().inTheInterval(TbVersionNumber.V_3_0_0, TbVersionNumber.V_3_1_0) || request == null) {
            return new PageDataIterableV3(link -> this.loadCustomersPageV3(ctx, link, user, jwtToken), pageSize);
        }
        if (!version.getVersion().greaterOrEqual(TbVersionNumber.V_3_1_0)) {
            throw new IllegalStateException("Tb Version unknown " + String.valueOf(version));
        }
        EntityDataQuery query = this.tbFilterQueryBuilder.buildFilterQuery(EntityType.CUSTOMER, "", businessEntity, request, ctx, pageSize);
        return new PageDataIterableV3Filterable(q -> this.loadCustomersPageV31Filter(ctx, q, jwtToken), query);
    }

    private <T> Set<T> getAllItems(Iterable<T> iterable, ViewRequest request, Integer limit) {
        HashSet result = Sets.newHashSet();
        for (T item : iterable) {
            if (request != null && request.isPreviewRequest() && result.size() >= request.getPreviewItemCount() || limit != null && result.size() >= limit) break;
            result.add(item);
        }
        return result;
    }

    private Iterable<Asset> getAssetIterable(ViewContext ctx, ViewRequest request, BusinessEntity businessEntity, String assetType, String textSearch, String jwtToken, Integer limit, TbVersion version, JwtSecurityUser user) {
        int pageSize;
        int n = pageSize = request != null && request.isPreviewRequest() ? request.getPreviewItemCount() : this.pagesizeItems;
        if (limit != null) {
            pageSize = limit;
        }
        if (version.getVersion().inTheInterval(TbVersionNumber.V_3_0_0, TbVersionNumber.V_3_1_0) || request == null) {
            return new PageDataIterableV3(link -> this.loadAssetsPageV3(ctx, link, user, assetType, textSearch, jwtToken), pageSize);
        }
        if (!version.getVersion().greaterOrEqual(TbVersionNumber.V_3_1_0)) {
            throw new IllegalStateException("Tb Version unknown " + String.valueOf(version));
        }
        if (textSearch != null) {
            throw new UnsupportedOperationException();
        }
        EntityDataQuery query = this.tbFilterQueryBuilder.buildFilterQuery(EntityType.ASSET, assetType, businessEntity, request, ctx, pageSize);
        return new PageDataIterableV3Filterable(q -> this.loadAssetsPageV31Filter(ctx, q, jwtToken), query);
    }

    private Map<String, Object> searchParamsV3x(PageLink pageLink, String textSearch, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageSize", pageLink.getPageSize());
        params.put("page", pageLink.getPage());
        params.put("sortProperty", null);
        params.put("sortOrder", null);
        params.put("textSearch", textSearch);
        params.put("type", type);
        return params;
    }

    private PageData<Asset> loadAssetsPageV3(ViewContext ctx, PageLink pageLink, JwtSecurityUser user, String assetType, String textSearch, String jwtToken) {
        try {
            Map params = this.searchParamsV3x(pageLink, textSearch, assetType);
            String uri = this.getLoadAssetsUri(user, jwtToken);
            return (PageData)DonReactive.block((Mono)this.tbWebClient.get(new TbWebRequest(uri, this.priorityFromCtx(ctx), params, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "loadAssetsPageV3", response)).map(Optional::get));
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw exception;
        }
    }

    private String getLoadAssetsUri(JwtSecurityUser user, String jwtToken) {
        if (user == null || user.isTenantUser()) {
            return "/api/tenant/assets";
        }
        TbVersion version = this.getTbVersionValidating(jwtToken);
        if (version.isPe()) {
            return "/api/user/assets";
        }
        return "/api/customer/" + String.valueOf(user.getCustomerId()) + "/assets";
    }

    private Iterable<Device> getDeviceIterable(ViewContext ctx, ViewRequest request, BusinessEntity businessEntity, String deviceType, String textSearch, String jwtToken, Integer limit, TbVersion version, JwtSecurityUser user) {
        int pageSize;
        int n = pageSize = request != null && request.isPreviewRequest() ? request.getPreviewItemCount() : this.pagesizeItems;
        if (limit != null) {
            pageSize = limit;
        }
        if (version.getVersion().less(TbVersionNumber.V_3_1_0)) {
            throw new IllegalStateException("Tb Version unknown " + String.valueOf(version));
        }
        if (version.getVersion().inTheInterval(TbVersionNumber.V_3_0_0, TbVersionNumber.V_3_1_0) || request == null) {
            return new PageDataIterableV3(link -> this.loadDevicesPageV3(ctx, link, user, deviceType, textSearch, jwtToken), pageSize);
        }
        EntityDataQuery query = this.tbFilterQueryBuilder.buildFilterQuery(EntityType.DEVICE, deviceType, businessEntity, request, ctx, pageSize);
        return new PageDataIterableV3Filterable(q -> this.loadDevicesPageV31Filter(ctx, q, jwtToken), query);
    }

    private Mono<PageData<Device>> loadDevicesPageV31FilterAsync(ViewContext ctx, EntityDataQuery query, String jwtToken) {
        return this.tbWebClient.post(new TbWebRequest("/api/entitiesQuery/find", this.priorityFromCtx(ctx), this.getJwtHeader(jwtToken), (Object)query, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "loadDevicesPageV31FilterAsync", response)).map(Optional::get).map(arg_0 -> ((FilteredEntityDataTransformer)this.entityDataTransformer).entityToDevicePageData(arg_0));
    }

    private PageData<Device> loadDevicesPageV31Filter(ViewContext ctx, EntityDataQuery query, String jwtToken) {
        try {
            return (PageData)DonReactive.block((Mono)this.loadDevicesPageV31FilterAsync(ctx, query, jwtToken));
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw exception;
        }
    }

    private PageData<Device> loadDevicesPageV3(ViewContext ctx, PageLink pageLink, JwtSecurityUser user, String deviceType, String textSearch, String jwtToken) {
        try {
            Map params = this.searchParamsV3x(pageLink, textSearch, deviceType);
            String uri = this.getLoadDevicesUri(user, jwtToken);
            return (PageData)DonReactive.block((Mono)this.tbWebClient.get(new TbWebRequest(uri, this.priorityFromCtx(ctx), params, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "loadDevicesPageV3", response)).map(Optional::get));
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw exception;
        }
    }

    private String getLoadDevicesUri(JwtSecurityUser user, String jwtToken) {
        if (user == null || user.isTenantUser()) {
            return "/api/tenant/devices";
        }
        TbVersion version = this.getTbVersionValidating(jwtToken);
        if (version.isPe()) {
            return "/api/user/devices";
        }
        return "/api/customer/" + String.valueOf(user.getCustomerId()) + "/devices";
    }

    private PageData<Customer> loadCustomersPageV3(ViewContext ctx, PageLink pageLink, JwtSecurityUser user, String jwtToken) {
        try {
            TbVersion version = this.getTbVersionValidating(jwtToken);
            Map params = this.searchParamsV3x(pageLink, null, null);
            String uri = this.getLoadCustomersUri(user, version);
            if (user != null && user.isCustomerUser() && !version.isPe()) {
                return (PageData)DonReactive.block((Mono)this.tbWebClient.get(new TbWebRequest(uri, this.priorityFromCtx(ctx), params, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "loadCustomersPageV3", response)).map(Optional::get).map(customer -> new PageData(List.of(customer), 1, 1L, false)));
            }
            return (PageData)DonReactive.block((Mono)this.tbWebClient.get(new TbWebRequest(uri, this.priorityFromCtx(ctx), params, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "loadCustomersPageV3", response)).map(Optional::get));
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw exception;
        }
    }

    private String getLoadCustomersUri(JwtSecurityUser user, TbVersion tbVersion) {
        if (user == null || user.isTenantUser()) {
            return "/api/customers";
        }
        if (tbVersion.isPe()) {
            return "/api/user/customers";
        }
        return "/api/customer/" + String.valueOf(user.getCustomerId());
    }

    private PageData<Customer> loadCustomersPageV31Filter(ViewContext ctx, EntityDataQuery query, String jwtToken) {
        try {
            return (PageData)DonReactive.block((Mono)this.tbWebClient.post(new TbWebRequest("/api/entitiesQuery/find", this.priorityFromCtx(ctx), this.getJwtHeader(jwtToken), (Object)query, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "loadCustomersPageV31Filter", response)).map(Optional::get).map(arg_0 -> ((FilteredEntityDataTransformer)this.entityDataTransformer).entityToCustomerPageData(arg_0)));
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw exception;
        }
    }

    public Mono<String> loadTenantById(UUID tenantId, String jwtToken, ViewContext ctx) {
        return this.tbWebClient.get(new TbWebRequest("/api/tenant/" + String.valueOf(tenantId), this.priorityFromCtx(ctx), new HashMap(), this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<String> loadCustomerById(UUID customerId, String jwtToken, ViewContext ctx) {
        return this.tbWebClient.get(new TbWebRequest("/api/customer/" + String.valueOf(customerId), this.priorityFromCtx(ctx), new HashMap(), this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<String> loadCustomerTitleById(UUID customerId, String jwtToken) {
        return this.tbWebClient.get(new TbWebRequest("/api/customer/" + String.valueOf(customerId) + "/title", RequestPriority.HIGH, new HashMap(), this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<List<Device>> loadDevicesByIdsAsync(ViewContext ctx, Set<UUID> deviceIds, String jwtToken) {
        return Flux.fromIterable((Iterable)Lists.partition(new ArrayList<UUID>(deviceIds), (int)100)).map(HashSet::new).flatMap(deviceIdsPartition -> {
            long exchangeStartTs = System.currentTimeMillis();
            List strIds = deviceIdsPartition.stream().map(UUID::toString).collect(Collectors.toList());
            HashMap params = new HashMap();
            params.put("deviceIds", strIds);
            return this.tbWebClient.get(new TbWebRequest("/api/devices", this.priorityFromCtx(ctx), params, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "loadDevicesByIdsAsync", response)).doOnNext(response -> this.statsCollector.tick("loadDevicesByIdsAsync", exchangeStartTs, System.currentTimeMillis(), TickType.OTHER)).map(Optional::get);
        }).flatMapIterable(Function.identity()).collectList();
    }

    public List<Device> loadDevicesByIds(ViewContext ctx, Set<UUID> deviceIds, String jwtToken) {
        try {
            return (List)DonReactive.block((Mono)this.loadDevicesByIdsAsync(ctx, deviceIds, jwtToken));
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Collections.emptyList();
            }
            throw exception;
        }
    }

    public Mono<List<Asset>> loadAssetsByIdsAsync(ViewContext ctx, Set<UUID> assetIds, String jwtToken) {
        return Flux.fromIterable((Iterable)Lists.partition(new ArrayList<UUID>(assetIds), (int)100)).map(HashSet::new).flatMap(assetIdsPartition -> {
            List strIds = assetIdsPartition.stream().map(UUID::toString).collect(Collectors.toList());
            HashMap params = new HashMap();
            params.put("assetIds", strIds);
            return this.tbWebClient.get(new TbWebRequest("/api/assets", this.priorityFromCtx(ctx), params, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "loadAssetsByIdsAsync", response)).map(Optional::get);
        }).flatMapIterable(Function.identity()).collectList();
    }

    public List<Asset> loadAssetsByIds(ViewContext ctx, Set<UUID> assetIds, String jwtToken) {
        try {
            return (List)DonReactive.block((Mono)this.loadAssetsByIdsAsync(ctx, assetIds, jwtToken));
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Collections.emptyList();
            }
            throw exception;
        }
    }

    public Flux<AttributeData> loadAttribute(ViewContext ctx, String entityType, UUID entityId, String scope, String key, String jwtToken) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (key != null) {
            params.put("keys", key);
        }
        String uri = scope == null ? "/api/plugins/telemetry/" + entityType + "/" + String.valueOf(entityId) + "/values/attributes" : "/api/plugins/telemetry/" + entityType + "/" + String.valueOf(entityId) + "/values/attributes/" + scope;
        return this.tbWebClient.get(new TbWebRequest(uri, this.priorityFromCtx(ctx), params, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "loadAttribute_" + key, response)).map(Optional::get).flatMapIterable(l -> l);
    }

    public Mono<Optional<ItemLite>> getLastActiveEntity(BusinessEntity entity, JwtSecurityUser user, String jwtToken) {
        return Mono.fromCallable(() -> {
            BusinessEntityType entityType = entity.getQuery().getEntityType();
            String type = entity.getQuery().getType();
            TbVersion version = this.tbVersionChecker.getVersion(jwtToken);
            if (version.getVersion().less(TbVersionNumber.V_3_1_0)) {
                throw new IllegalStateException("Tb Version unknown " + String.valueOf(version));
            }
            if (version.getVersion().inTheInterval(TbVersionNumber.V_3_0_0, TbVersionNumber.V_3_1_0)) {
                return switch (67.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$BusinessEntityType[entityType.ordinal()]) {
                    case 1 -> new PageDataIterableV3(link -> {
                        PageData pageData = this.loadAssetsPageV3(null, link, user, type, null, jwtToken).mapData(asset -> new ItemLite(asset.getUuidId(), asset.getName()));
                        return pageData;
                    }, 1);
                    case 2 -> new PageDataIterableV3(link -> {
                        PageData pageData = this.loadDevicesPageV3(null, link, user, type, null, jwtToken).mapData(device -> new ItemLite(device.getUuidId(), device.getName()));
                        return pageData;
                    }, 1);
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(entityType));
                };
            }
            EntityDataSortOrder sort = new EntityDataSortOrder(new EntityKey(EntityKeyType.ENTITY_FIELD, "lastActivityTime"), EntityDataSortOrder.Direction.DESC);
            EntityDataPageLink pageLink = new EntityDataPageLink(1, 0, null, sort);
            List<EntityKey> entityKeys = List.of(new EntityKey(EntityKeyType.ENTITY_FIELD, "id"), new EntityKey(EntityKeyType.ENTITY_FIELD, "name"), new EntityKey(EntityKeyType.ENTITY_FIELD, "label"), new EntityKey(EntityKeyType.ENTITY_FIELD, "type"), new EntityKey(EntityKeyType.ENTITY_FIELD, "lastActivityTime"));
            return switch (67.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$BusinessEntityType[entityType.ordinal()]) {
                case 1 -> {
                    AssetTypeFilter filter = new AssetTypeFilter(type, "");
                    EntityDataQuery query = new EntityDataQuery((EntityFilter)filter, pageLink, entityKeys, Collections.emptyList(), Collections.emptyList());
                    yield new PageDataIterableV3Filterable(q -> {
                        PageData itemLitePageData = this.loadAssetsPageV31Filter(null, q, jwtToken).mapData(asset -> new ItemLite(asset.getUuidId(), asset.getName()));
                        return itemLitePageData;
                    }, query);
                }
                case 2 -> {
                    DeviceTypeFilter filter = new DeviceTypeFilter(type, "");
                    EntityDataQuery query = new EntityDataQuery((EntityFilter)filter, pageLink, entityKeys, Collections.emptyList(), Collections.emptyList());
                    yield new PageDataIterableV3Filterable(q -> {
                        PageData itemLitePageData = this.loadDevicesPageV31Filter(null, q, jwtToken).mapData(asset -> new ItemLite(asset.getUuidId(), asset.getName()));
                        return itemLitePageData;
                    }, query);
                }
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(entityType));
            };
        }).map(iterable -> this.getAllItems(iterable, null, Integer.valueOf(1))).map(itemSet -> {
            if (itemSet.size() > 2) {
                throw new IllegalStateException("Too many items");
            }
            if (itemSet.size() == 1) {
                return Optional.of((ItemLite)itemSet.iterator().next());
            }
            return Optional.empty();
        });
    }

    public Mono<Optional<ItemLite>> getLastActiveEntity(JwtSecurityUser user, String jwtToken) {
        return Mono.fromCallable(() -> {
            TbVersion version = this.tbVersionChecker.getVersion(jwtToken);
            if (version.getVersion().less(TbVersionNumber.V_3_1_0)) {
                throw new IllegalStateException("Tb Version unknown " + String.valueOf(version));
            }
            if (version.getVersion().inTheInterval(TbVersionNumber.V_3_0_0, TbVersionNumber.V_3_1_0)) {
                PageDataIterableV3 assetIterable = new PageDataIterableV3(link -> this.loadAssetsPageV3(null, link, user, null, null, jwtToken), 1);
                PageDataIterableV3 deviceIterable = new PageDataIterableV3(link -> this.loadDevicesPageV3(null, link, user, null, null, jwtToken), 1);
                return Pair.of((Object)assetIterable, (Object)deviceIterable);
            }
            EntityDataSortOrder sort = new EntityDataSortOrder(new EntityKey(EntityKeyType.ENTITY_FIELD, "lastActivityTime"), EntityDataSortOrder.Direction.DESC);
            EntityDataPageLink pageLink = new EntityDataPageLink(1, 0, null, sort);
            List<EntityKey> keys = List.of(new EntityKey(EntityKeyType.ENTITY_FIELD, "id"), new EntityKey(EntityKeyType.ENTITY_FIELD, "name"), new EntityKey(EntityKeyType.ENTITY_FIELD, "label"), new EntityKey(EntityKeyType.ENTITY_FIELD, "type"), new EntityKey(EntityKeyType.ENTITY_FIELD, "lastActivityTime"));
            EntityTypeFilter filterAsset = new EntityTypeFilter(EntityType.ASSET);
            EntityTypeFilter filterDevice = new EntityTypeFilter(EntityType.DEVICE);
            EntityDataQuery queryAssets = new EntityDataQuery((EntityFilter)filterAsset, pageLink, keys, List.of(), List.of());
            EntityDataQuery queryDevice = new EntityDataQuery((EntityFilter)filterDevice, pageLink, keys, List.of(), List.of());
            PageDataIterableV3Filterable assets = new PageDataIterableV3Filterable(q -> this.loadAssetsPageV31Filter(null, q, jwtToken), queryAssets);
            PageDataIterableV3Filterable devices = new PageDataIterableV3Filterable(q -> this.loadDevicesPageV31Filter(null, q, jwtToken), queryDevice);
            return Pair.of((Object)assets, (Object)devices);
        }).map(pair -> {
            Set allAssets = this.getAllItems((Iterable)pair.getLeft(), null, Integer.valueOf(1));
            Set allDevices = this.getAllItems((Iterable)pair.getRight(), null, Integer.valueOf(1));
            if (allAssets.size() > 2 || allDevices.size() > 2) {
                throw new IllegalStateException("Too many items");
            }
            if (allDevices.isEmpty() && allAssets.isEmpty()) {
                return Optional.empty();
            }
            if (allDevices.isEmpty()) {
                EnhancedAsset asset = (EnhancedAsset)allAssets.iterator().next();
                return Optional.of(new ItemLite(asset.getUuidId(), asset.getName()));
            }
            if (allAssets.isEmpty()) {
                EnhancedDevice device = (EnhancedDevice)allDevices.iterator().next();
                return Optional.of(new ItemLite(device.getUuidId(), device.getName()));
            }
            EnhancedAsset asset = (EnhancedAsset)allAssets.iterator().next();
            EnhancedDevice device = (EnhancedDevice)allDevices.iterator().next();
            TsValue assetPoint = (TsValue)asset.getAttributes().get("lastActivityTime");
            TsValue devicePoint = (TsValue)device.getAttributes().get("lastActivityTime");
            if (assetPoint == null && devicePoint == null) {
                throw new IllegalStateException("Asset or Device attributes are missing");
            }
            if (assetPoint == null) {
                return Optional.of(new ItemLite(device.getUuidId(), device.getName()));
            }
            if (devicePoint == null) {
                return Optional.of(new ItemLite(asset.getUuidId(), asset.getName()));
            }
            if (assetPoint.getTs() < devicePoint.getTs()) {
                return Optional.of(new ItemLite(device.getUuidId(), device.getName()));
            }
            return Optional.of(new ItemLite(asset.getUuidId(), asset.getName()));
        });
    }

    public Mono<Map<String, List<TsData>>> loadTelemetry(BusinessEntityType entityType, UUID entityId, String key, long startTs, long endTs, String jwtToken) {
        return this.loadTelemetry(null, entityType, entityId, key, startTs, endTs, 0L, "NONE", jwtToken);
    }

    public Mono<Map<String, List<TsData>>> loadTelemetry(BusinessEntityType entityType, UUID entityId, String key, long startTs, long endTs, String jwtToken, String order, int limit) {
        return this.splitTelemetryLoad(null, entityType, entityId, key, startTs, endTs, 0L, "NONE", jwtToken, order, limit);
    }

    public Mono<Map<String, List<TsData>>> loadTelemetry(ViewContext ctx, BusinessEntityType entityType, UUID entityId, String key, long startTs, long endTs, long interval, String agg, String jwtToken) {
        return this.splitTelemetryLoad(ctx, entityType, entityId, key, startTs, endTs, interval, agg, jwtToken, "ASC", this.pagesizeTelemetry);
    }

    private List<String> splitKeys(String key) {
        ArrayList<String> keysList = new ArrayList<String>();
        if (key.length() <= 3072) {
            keysList.add(key);
        } else {
            StringBuilder current = new StringBuilder();
            for (String k : Set.of(key.split(","))) {
                if (k.length() > 3072) {
                    throw new TrendzInternalException("Key has too many symbols: %s".formatted(key));
                }
                if (current.isEmpty()) {
                    current.append(k);
                    continue;
                }
                if (current.length() + 1 + k.length() <= 3072) {
                    current.append(",").append(k);
                    continue;
                }
                keysList.add(current.toString());
                current = new StringBuilder(k);
            }
            if (!current.isEmpty()) {
                keysList.add(current.toString());
            }
        }
        return keysList;
    }

    private Mono<Map<String, List<TsData>>> splitTelemetryLoad(ViewContext ctx, BusinessEntityType entityType, UUID entityId, String keys, long startTs, long endTs, long interval, String agg, String jwtToken, String order, int limit) {
        List keysList = this.splitKeys(keys);
        return Flux.fromIterable((Iterable)keysList).flatMap(singleTelemetryRequestParam -> this.loadSingleTelemetry(ctx, entityType, entityId, singleTelemetryRequestParam, startTs, endTs, interval, agg, jwtToken, order, limit)).flatMapIterable(Map::entrySet).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Mono<Map<String, List<TsData>>> loadSingleTelemetry(ViewContext ctx, BusinessEntityType entityType, UUID entityId, String keys, long startTs, long endTs, long interval, String agg, String jwtToken, String order, int limit) {
        long executionStartTs = System.currentTimeMillis();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("keys", keys);
        params.put("startTs", startTs);
        params.put("endTs", endTs);
        params.put("interval", interval);
        params.put("agg", agg);
        params.put("orderBy", order);
        params.put("limit", limit);
        String uri = "/api/plugins/telemetry/" + String.valueOf(entityType) + "/" + String.valueOf(entityId) + "/values/timeseries";
        Supplier<Mono> loadTelemetrySupplier = () -> this.tbWebClient.get(new TbWebRequest(uri, this.priorityFromCtx(ctx), params, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "loadTelemetry_" + keys, response)).map(Optional::get).doOnNext(l -> this.statsCollector.tick("loadTelemetry_" + keys, executionStartTs, System.currentTimeMillis(), TickType.OTHER));
        String cacheKey = StringUtils.join((Object[])new Serializable[]{entityType, entityId, keys, Long.valueOf(startTs), Long.valueOf(endTs), Long.valueOf(interval), agg});
        return this.webClientCachier.getOrFetchTelemetry(cacheKey, jwtToken, loadTelemetrySupplier).doOnNext(telemetry -> this.gatherLoadTelemetryStatistics(ctx, telemetry));
    }

    public Mono<Map<String, List<TsData>>> loadLatestTelemetry(ViewContext ctx, BusinessEntityType entityType, UUID entityId, String keys, String jwtToken) {
        String uri = "/api/plugins/telemetry/" + String.valueOf(entityType) + "/" + String.valueOf(entityId) + "/values/timeseries";
        List keysList = this.splitKeys(keys);
        return Flux.fromIterable((Iterable)keysList).flatMap(key -> this.tbWebClient.get(new TbWebRequest(uri, this.priorityFromCtx(ctx), Map.of("keys", key), this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */))).map(response -> this.collectMeasurements(ctx, "loadLatestTelemetry_" + keys, response)).map(Optional::get).flatMapIterable(Map::entrySet).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Mono<Boolean> sendTelemetryDirectly(ViewContext ctx, String entityType, UUID entityId, String jwtToken, List<TbDataEntry> telemetryRequest) {
        long now = System.currentTimeMillis();
        log.debug("Preparing to send telemetry directly with size: {}, ts as id = {}", (Object)telemetryRequest.size(), (Object)now);
        telemetryRequest.sort(Comparator.comparing(TbDataEntry::getTs));
        this.validateSendingTelemetry(telemetryRequest);
        int tsRecords = telemetryRequest.size();
        int keyValuePairs = telemetryRequest.stream().mapToInt(r -> r.getValues().size()).sum();
        log.info("Save TB telemetry for {} tsSize {} keyValuePairs {}", new Object[]{entityId, tsRecords, keyValuePairs});
        String uri = "/api/plugins/telemetry/" + entityType + "/" + String.valueOf(entityId) + "/timeseries/ANY";
        List telemetries = this.splitSendTelemetryRequest(telemetryRequest);
        return Flux.fromIterable((Iterable)telemetries).concatMap(telemetry -> Mono.just((Object)telemetry).flatMap(part -> {
            log.debug("Sending telemetry directly, PART with size: {}", (Object)part.size());
            return this.tbWebClient.post(new TbWebRequest(uri, this.priorityFromCtx(ctx), this.getJwtHeader(jwtToken), telemetry, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */));
        }).map(response -> this.collectMeasurements(ctx, "sendTelemetryDirectly", response)).delayElement(Duration.ofMillis(this.sendTelemetryIntervalMs), Schedulers.boundedElastic()).publishOn(Schedulers.fromExecutorService((ExecutorService)this.executorManagementService.getExecutorByName(ExecutorName.UI_POST_BUILD)))).collect(Collectors.reducing((a, b) -> Optional.of(a.orElse(Boolean.FALSE) != false && b.orElse(Boolean.FALSE) != false))).map(aBoolean -> {
            log.info("Received directly sent telemetry response, ts as id: {}", (Object)now);
            return (Optional)aBoolean.get();
        }).map(Optional::get);
    }

    public Mono<List<TbWidgetBundleItemV1>> loadAllWidgetBundlesV1(String jwtToken) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sortProperty", "title");
        params.put("sortOrder", "ASC");
        return this.tbWebClient.get(new TbWebRequest("/api/widgetsBundles", RequestPriority.HIGH, params, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<List<TbWidgetBundleItemV2>> loadAllWidgetBundlesV2(String jwtToken) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sortProperty", "title");
        params.put("sortOrder", "ASC");
        return this.tbWebClient.get(new TbWebRequest("/api/widgetsBundles", RequestPriority.HIGH, params, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<List<TbWidgetTypeItemV1>> loadWidgetTypesV1(String bundleAlias, boolean isSystem, String jwtToken) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("isSystem", isSystem);
        params.put("bundleAlias", bundleAlias);
        return this.tbWebClient.get(new TbWebRequest("/api/widgetTypes", RequestPriority.HIGH, params, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<Optional<TbWidgetTypeItemV2>> loadWidgetTypeLiteByFqnV2(String fqn, String jwtToken) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fqn", fqn);
        TbWebRequest request = new TbWebRequest("/api/widgetType", RequestPriority.HIGH, params, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).suppressNotFoundError();
        return this.tbWebClient.get(request).map(TbWebResponse::getResponse);
    }

    public Mono<TbWidgetTypeItemV2> loadWidgetTypeFullByIdV2(UUID id, String jwtToken) {
        return this.tbWebClient.get(new TbWebRequest("/api/widgetType/" + String.valueOf(id), RequestPriority.HIGH, new HashMap(), this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<Set<String>> loadWidgetTypeFqnsByBundleIdV2(UUID widgetsBundleId, String jwtToken) {
        HashMap<String, UUID> params = new HashMap<String, UUID>();
        params.put("widgetsBundleId", widgetsBundleId);
        return this.tbWebClient.get(new TbWebRequest("/api/widgetTypeFqns", RequestPriority.HIGH, params, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<List<TbWidgetTypeItemV2>> loadWidgetTypeInfos(UUID widgetsBundleId, String jwtToken) {
        HashMap<String, Comparable<UUID>> params = new HashMap<String, Comparable<UUID>>();
        params.put("widgetsBundleId", widgetsBundleId);
        params.put("page", Integer.valueOf(0));
        params.put("pageSize", Integer.valueOf(100000));
        return this.tbWebClient.get(new TbWebRequest("/api/widgetTypesInfos", RequestPriority.HIGH, params, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get).map(PageData::getData);
    }

    public Mono<TbWidgetBundleItemV1> uploadWidgetBundleV1(TbWidgetBundleItemV1 widgetBundle, String jwtToken) {
        return this.tbWebClient.post(new TbWebRequest("/api/widgetsBundle", RequestPriority.HIGH, this.getJwtHeader(jwtToken), (Object)widgetBundle, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<TbWidgetBundleItemV2> uploadWidgetBundleV2(TbWidgetBundleItemV2 widgetBundle, String jwtToken) {
        return this.tbWebClient.post(new TbWebRequest("/api/widgetsBundle", RequestPriority.HIGH, this.getJwtHeader(jwtToken), (Object)widgetBundle, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<TbWidgetTypeItemV1> uploadWidgetTypeV1(TbWidgetTypeItemV1 widgetType, String jwtToken) {
        return this.tbWebClient.post(new TbWebRequest("/api/widgetType", RequestPriority.HIGH, this.getJwtHeader(jwtToken), (Object)widgetType, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<TbWidgetTypeItemV2> uploadWidgetTypeV2(TbWidgetTypeItemV2 widgetType, String jwtToken) {
        return this.tbWebClient.post(new TbWebRequest("/api/widgetType", RequestPriority.HIGH, this.getJwtHeader(jwtToken), (Object)widgetType, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<Boolean> uploadWidgetBundleJoinsToTypes(UUID widgetBundleId, Set<UUID> widgetTypeIdset, String jwtToken) {
        String url = "/api/widgetsBundle/" + String.valueOf(widgetBundleId) + "/widgetTypes";
        return this.tbWebClient.post(new TbWebRequest(url, RequestPriority.HIGH, this.getJwtHeader(jwtToken), widgetTypeIdset, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<PageData<Dashboard>> loadAllDashboards(String jwtToken) {
        HashMap<String, Constable> params = new HashMap<String, Constable>();
        params.put("pageSize", Integer.valueOf(1000));
        params.put("page", Integer.valueOf(0));
        params.put("includeCustomers", Boolean.valueOf(true));
        return this.tbWebClient.get(new TbWebRequest("/api/dashboards/all", RequestPriority.HIGH, params, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<Dashboard> loadDashboardById(UUID dashboardId, String jwtToken) {
        String uri = "/api/dashboard/" + dashboardId.toString();
        return this.tbWebClient.get(new TbWebRequest(uri, RequestPriority.HIGH, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<Dashboard> saveDashboard(Dashboard dashboard, String jwtToken) {
        HttpHeaders httpHeaders = this.getJwtHeader(jwtToken);
        httpHeaders.add("Content-Type", MediaType.APPLICATION_JSON.toString());
        return this.tbWebClient.post(new TbWebRequest("/api/dashboard", RequestPriority.HIGH, this.getJwtHeader(jwtToken), (Object)dashboard, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<String> loadAlarms(ViewContext ctx, BusinessEntityType entityType, UUID entityId, String jwtToken, long startTs, long endTs, int limit) {
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("startTime", startTs);
        params.put("endTime", endTs);
        String uri = "/api/alarm/" + String.valueOf(entityType) + "/" + String.valueOf(entityId);
        params.put("page", 0);
        params.put("pageSize", limit);
        return this.tbWebClient.get(new TbWebRequest(uri, this.priorityFromCtx(ctx), params, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "loadAlarms", response)).map(Optional::get);
    }

    public Mono<Optional<WhiteLabelingParams>> loadCurrentWhiteLabelParams(String jwtToken) {
        String uri = "/api/whiteLabel/currentWhiteLabelParams";
        return this.tbWebClient.get(new TbWebRequest(uri, RequestPriority.HIGH, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse);
    }

    public Mono<JwtSettings> fetchSigningKeyWithSysadminToken(String jwtToken) {
        String uri = "/api/admin/jwtSettings";
        return this.tbWebClient.get(new TbWebRequest(uri, RequestPriority.HIGH, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public TbVersion getTbVersionValidating(String jwtToken) {
        TbVersion version = this.tbVersionChecker.getVersion(jwtToken);
        if (version.getVersion().less(TbVersionNumber.V_3_0_0)) {
            throw new IllegalStateException("Thingsboard versions < 3.0.0 not supported but got version: " + String.valueOf(version));
        }
        return version;
    }

    public <T> T forwardRequest(TbWebRequest<T> tbRequest, String method) {
        return (T)DonReactive.block((Mono)this.tbWebClient.method(tbRequest, method).map(TbWebResponse::getResponse).map(Optional::get));
    }

    public Mono<String> loadTranslationBeforeLogin(String locale) {
        return this.getTranslationsForTBBeforeLogin(true, locale).map(TbWebResponse::getResponse).map(Optional::get).onErrorResume(throwable -> {
            log.debug("Could not get translations (before login) for ThingsBoard PE", throwable);
            if (throwable.getCause() instanceof WebClientResponseException) {
                return this.getTranslationsForTBBeforeLogin(false, locale).map(TbWebResponse::getResponse).map(Optional::get).onErrorResume(e -> {
                    log.debug("Could not get translations (before login) for ThingsBoard CE", throwable);
                    return Mono.error((Throwable)throwable);
                });
            }
            return Mono.error((Throwable)throwable);
        });
    }

    public Mono<List<String>> loadTranslationsAfterLogin(String locale, String jwtToken) {
        TbVersion version = this.tbVersionChecker.getVersion(jwtToken);
        if (version.getVersion().less(TbVersionNumber.V_3_7_0)) {
            return this.getTranslationsForTBAfterLoginBeforeVersion_3_7_0_PE(locale, jwtToken).onErrorResume(throwable -> {
                log.debug("Could not get translations (after login) for ThingsBoard PE for version less than 3.7.0", throwable);
                if (throwable.getCause() instanceof WebClientResponseException) {
                    return this.getTranslationsForTBAfterLogin(false, locale, jwtToken).map(TbWebResponse::getResponse).map(Optional::get).map(List::of).onErrorResume(e -> {
                        log.debug("Could not get translations (after login) for ThingsBoard CE for version less than 3.7.0", throwable);
                        return Mono.error((Throwable)throwable);
                    });
                }
                return Mono.error((Throwable)throwable);
            });
        }
        return this.getTranslationsForTBAfterLogin(true, locale, jwtToken).map(TbWebResponse::getResponse).map(Optional::get).map(List::of).onErrorResume(throwable -> {
            log.debug("Could not get translations (after login) for ThingsBoard PE", throwable);
            if (throwable.getCause() instanceof WebClientResponseException) {
                return this.getTranslationsForTBAfterLogin(false, locale, jwtToken).map(TbWebResponse::getResponse).map(Optional::get).map(List::of).onErrorResume(e -> {
                    log.debug("Could not get translations (after login) for ThingsBoard CE", throwable);
                    return Mono.error((Throwable)throwable);
                });
            }
            return Mono.error((Throwable)throwable);
        });
    }

    public Mono<Optional<TbResource>> getResourceByName(String jwtToken, String name) {
        String tbApiEndpoint = "/api/resource?pageSize=%s&page=%s&textSearch=%s&resourceType=%s&resourceSubType=%s".formatted(10, 0, name.replace(" ", "_"), ResourceType.JS_MODULE, ResourceSubType.MODULE);
        51 parameterizedTypeReference = new /* Unavailable Anonymous Inner Class!! */;
        TbWebRequest tbModulesRequest = new TbWebRequest(tbApiEndpoint, RequestPriority.HIGH, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)parameterizedTypeReference).suppressNotFoundError();
        return this.tbWebClient.get(tbModulesRequest).map(TbWebResponse::getResponse).flatMap(resourceInfoList -> resourceInfoList.map(PageData::getData).stream().flatMap(Collection::stream).filter(tbResourceInfo -> name.equals(tbResourceInfo.getName())).filter(tbResourceInfo -> "ai-summary-module.js".equals(tbResourceInfo.getFileName())).findAny().map(TbResourceInfo::getId).map(EntityId::getId).map(moduleId -> this.getTbResource(jwtToken, moduleId)).orElse(Mono.empty())).defaultIfEmpty(Optional.empty());
    }

    public Mono<Optional<TbResource>> getTbResource(String jwtToken, UUID resourceId) {
        String tbApiEndpoint = "/api/resource/%s".formatted(resourceId);
        52 parameterizedTypeReference = new /* Unavailable Anonymous Inner Class!! */;
        TbWebRequest tbModulesRequest = new TbWebRequest(tbApiEndpoint, RequestPriority.HIGH, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)parameterizedTypeReference).suppressNotFoundError();
        return this.tbWebClient.get(tbModulesRequest).map(TbWebResponse::getResponse);
    }

    public Mono<TbResource> uploadTbResource(String jwtToken, TbResource tbResource) {
        String tbApiEndpoint = "/api/resource";
        return this.tbWebClient.post(new TbWebRequest(tbApiEndpoint, RequestPriority.HIGH, this.getJwtHeader(jwtToken), (Object)tbResource, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<TrendzSettings> loadTbTrendzSettings(String jwtToken) {
        String tbApiEndpoint = "/api/trendz/settings";
        return this.tbWebClient.get(new TbWebRequest(tbApiEndpoint, RequestPriority.HIGH, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<TrendzSettings> saveTbTrendzSettings(TrendzSettings trendzSettings, String jwtToken) {
        String tbApiEndpoint = "/api/trendz/settings";
        return this.tbWebClient.post(new TbWebRequest(tbApiEndpoint, RequestPriority.HIGH, this.getJwtHeader(jwtToken), (Object)trendzSettings, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<AlarmInfo> clearTbAlarm(UUID alarmId, String jwtToken) {
        String tbEndpoint = "/api/alarm/" + String.valueOf(alarmId) + "/clear";
        return this.tbWebClient.post(new TbWebRequest(tbEndpoint, null, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<Alarm> retrieveTbAlarm(UUID alarmId, String jwtToken) {
        String tbEndpoint = "/api/alarm/" + String.valueOf(alarmId);
        return this.tbWebClient.get(new TbWebRequest(tbEndpoint, null, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<Alarm> saveTbAlarm(Alarm alarm, String jwtToken) {
        String tbEndpoint = "/api/alarm";
        return this.tbWebClient.post(new TbWebRequest(tbEndpoint, null, this.getJwtHeader(jwtToken), (Object)alarm, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<Boolean> deleteTbAlarm(UUID alarmId, String jwtToken) {
        String tbEndpoint = "/api/alarm/" + String.valueOf(alarmId);
        return this.tbWebClient.delete(new TbWebRequest(tbEndpoint, null, this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    private void gatherLoadTelemetryStatistics(ViewContext ctx, Map<String, List<TsData>> telemetry) {
        if (ctx == null) {
            return;
        }
        long telemetryPointsCount = telemetry.values().stream().mapToLong(List::size).sum();
        ctx.getTbTelemetryRequestCount().addAndGet(1L);
        ctx.getTelemetryPointsCount().addAndGet(telemetryPointsCount);
    }

    private PageData<Asset> loadAssetsPageV31Filter(ViewContext ctx, EntityDataQuery query, String jwtToken) {
        try {
            return (PageData)DonReactive.block((Mono)this.loadAssetsPageV31FilterAsync(ctx, query, jwtToken));
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw exception;
        }
    }

    private Mono<PageData<Asset>> loadAssetsPageV31FilterAsync(ViewContext ctx, EntityDataQuery query, String jwtToken) {
        return this.tbWebClient.post(new TbWebRequest("/api/entitiesQuery/find", this.priorityFromCtx(ctx), this.getJwtHeader(jwtToken), (Object)query, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "loadAssetsPageV31FilterAsync", response)).map(Optional::get).map(arg_0 -> ((FilteredEntityDataTransformer)this.entityDataTransformer).entityToAssetPageData(arg_0));
    }

    private PageData<Item> loadRawEntityData(ViewContext ctx, EntityDataQuery query, String jwtToken) {
        try {
            long exchangeStartTs = System.currentTimeMillis();
            String key = String.valueOf(query);
            Supplier<Flux> userEntitiesV31FilterSupplier = () -> this.tbWebClient.post(new TbWebRequest("/api/entitiesQuery/find", this.priorityFromCtx(ctx), this.getJwtHeader(jwtToken), (Object)query, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "loadRawEntityData", response)).map(Optional::get).map(arg_0 -> ((FilteredEntityDataTransformer)this.entityDataTransformer).entityToItemPageData(arg_0)).doOnNext(l -> this.statsCollector.tick("loadRawEntityData", exchangeStartTs, System.currentTimeMillis(), TickType.OTHER)).flatMapIterable(Collections::singletonList);
            List data = (List)DonReactive.block((Mono)this.webClientCachier.getOrFetch("loadRawEntityData", key, jwtToken, userEntitiesV31FilterSupplier, (TypeReference)new /* Unavailable Anonymous Inner Class!! */).collectList());
            return (PageData)data.iterator().next();
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw exception;
        }
    }

    private <T> Optional<T> collectMeasurements(ViewContext ctx, String requestName, TbWebResponse<T> response) {
        if (ctx != null) {
            TbWebRequestExecutionInfo executionInfo = response.getExecutionInfo();
            ctx.getMeasurementReport().getMeasurements().add(new MeasurementInfo(MeasuredTaskType.TB_REST_REQUEST, MeasurementParameters.builder().requestName(requestName).build(), executionInfo.getSchedulingTs(), executionInfo.getStartTs(), executionInfo.getEndTs()));
        }
        return response.getResponse();
    }

    private Mono<TbWebResponse<String>> getTranslationsForTBBeforeLogin(boolean isPe, String locale) {
        String tbPeApiEndpoint = "/api/noauth/translation/login/%s".formatted(locale);
        String tbCeApiEndpoint = "/assets/locale/locale.constant-%s.json".formatted(locale);
        String uri = isPe ? tbPeApiEndpoint : tbCeApiEndpoint;
        return this.tbWebClient.get(new TbWebRequest(uri, RequestPriority.HIGH, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */));
    }

    private Mono<TbWebResponse<String>> getTranslationsForTBAfterLogin(boolean isPe, String locale, String jwtToken) {
        String tbPeApiEndpoint = "/api/translation/full/%s".formatted(locale);
        String tbCeApiEndpoint = "/assets/locale/locale.constant-%s.json".formatted(locale);
        String uri = isPe ? tbPeApiEndpoint : tbCeApiEndpoint;
        return this.tbWebClient.get(new TbWebRequest(uri, RequestPriority.HIGH, Map.of(), this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */));
    }

    private Mono<List<String>> getTranslationsForTBAfterLoginBeforeVersion_3_7_0_PE(String locale, String jwtToken) {
        String defaultTranslationEndpoint = "/api/customTranslation/customTranslation";
        String customTranslationEndpoint = "/assets/locale/locale.constant-%s.json".formatted(locale);
        return Flux.concat((Publisher[])new Publisher[]{this.tbWebClient.get(new TbWebRequest("/api/customTranslation/customTranslation", RequestPriority.HIGH, Map.of(), this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)), this.tbWebClient.get(new TbWebRequest(customTranslationEndpoint, RequestPriority.HIGH, Map.of(), this.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */))}).map(respOpt -> (String)respOpt.getResponse().get()).collect(Collectors.toList());
    }

    private List<List<TbDataEntry>> splitSendTelemetryRequest(List<TbDataEntry> request) {
        if (this.sendTelemetryBatchSize < request.size()) {
            log.debug("Splitting request with [{}] body points ", (Object)request.size());
            return Lists.partition(request, (int)this.sendTelemetryBatchSize);
        }
        log.debug("Single request with [{}] body points", (Object)request.size());
        return List.of(request);
    }

    private void validateSendingTelemetry(List<TbDataEntry> telemetryRequest) {
        if (telemetryRequest.isEmpty()) {
            throw new IllegalArgumentException("Empty telemetry request");
        }
        Set duplicatedTimestamps = telemetryRequest.stream().collect(Collectors.groupingBy(TbDataEntry::getTs, Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (!duplicatedTimestamps.isEmpty()) {
            throw new TrendzException("Telemetry request contains duplicated timestamps: " + String.valueOf(duplicatedTimestamps));
        }
    }

    private RequestPriority priorityFromCtx(ViewContext ctx) {
        return ctx == null ? null : ctx.getPriority();
    }
}

