/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider;

import com.google.common.collect.Sets;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityQuery;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityFieldQuery;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.provider.PartitionBuilder;
import org.thingsboard.trendz.service.provider.TbFieldValueService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.provider.TelemetryPartitionQuery;
import org.thingsboard.trendz.service.provider.TsData;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.TsValue;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.FilterService;
import org.thingsboard.trendz.service.view.proto.StreamTelemetryStore;
import org.thingsboard.trendz.service.view.proto.StreamTelemetryStoreKey;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import org.thingsboard.trendz.service.view.proto.WindowedStreamStore;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Service
public class TbFieldValueService {
    private static final Logger log = LoggerFactory.getLogger(TbFieldValueService.class);
    private final TbRestDataSource tbClient;
    private final FilterService filterService;
    private final PartitionBuilder partitionBuilder;
    private final ExecutorManagementService executorManagementService;

    @Autowired
    public TbFieldValueService(TbRestDataSource tbClient, FilterService filterService, PartitionBuilder partitionBuilder, ExecutorManagementService executorManagementService) {
        this.tbClient = tbClient;
        this.filterService = filterService;
        this.partitionBuilder = partitionBuilder;
        this.executorManagementService = executorManagementService;
    }

    public Flux<FieldValue> loadAttribute(ViewContext ctx, Item item, ViewField viewField, BusinessEntityField entityField, BusinessEntity businessEntity, String jwtToken, long nowTs) {
        TsValue attrValue;
        BusinessEntityQuery query = businessEntity.getQuery();
        String entityType = query.getEntityType().name();
        BusinessEntityFieldQuery attrQuery = entityField.getQuery();
        String scope = attrQuery.getScope();
        String key = attrQuery.getKey();
        if (MapUtils.isNotEmpty((Map)item.getAttributes()) && (attrValue = (TsValue)item.getAttributes().get(key)) != null) {
            return Flux.just((Object)this.mapAttr(item, entityField, viewField, attrValue, nowTs));
        }
        return this.tbClient.loadAttribute(ctx, entityType, item.getId(), scope, key, jwtToken).map(d -> this.mapAttr(item, entityField, viewField, d.getValue().toString(), nowTs)).defaultIfEmpty((Object)new FieldValue(item, FieldType.BLANK, null));
    }

    public Flux<FieldValue> loadTelemetry(Item item, ViewField viewField, ViewRequest viewRequest, BusinessEntityField entityField, BusinessEntity businessEntity, WindowedStreamStore windowedStore, ViewContext ctx) {
        UUID entityFieldId = entityField.getId();
        String entityFieldKey = entityField.getQuery().getKey();
        if (viewField.getAggregationType() == FieldAggregation.LATEST && item.getLatestTelemetry().containsKey(entityFieldKey)) {
            TsValue tsValue = (TsValue)item.getLatestTelemetry().get(entityFieldKey);
            if (tsValue.isEmpty()) {
                return Flux.just((Object)new FieldValue(item, FieldType.BLANK, null, 0L));
            }
            return switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$field$FieldType[entityField.getType().ordinal()]) {
                case 1 -> Flux.just((Object)new FieldValue(item, entityField.getType(), (Object)tsValue.getValue(), tsValue.getTs()));
                case 2 -> Flux.just((Object)new FieldValue(item, entityField.getType(), (Object)Double.parseDouble(tsValue.getValue()), tsValue.getTs()));
                case 3 -> Flux.just((Object)new FieldValue(item, entityField.getType(), (Object)Long.parseLong(tsValue.getValue()), tsValue.getTs()));
                case 4 -> Flux.just((Object)new FieldValue(item, entityField.getType(), (Object)Boolean.parseBoolean(tsValue.getValue()), tsValue.getTs()));
                default -> throw new TrendzInternalException("Unsupported type: " + String.valueOf(entityField.getType()));
            };
        }
        BusinessEntityType entityType = businessEntity.getQuery().getEntityType();
        boolean streamProcessing = viewRequest.isStreamProcessingEnabled();
        boolean isTelemetry = entityField.hasTime();
        boolean isNoneAgg = viewField.getAggregationType() == FieldAggregation.NONE;
        boolean forState = viewField.isForStateCondition();
        long queryStartTs = viewRequest.getStartTs(viewField);
        long queryEndTs = viewRequest.getEndTs(viewField);
        StreamTelemetryStore streamStore = ctx.getStreamStore(entityFieldId);
        Set allowedTs = streamProcessing ? this.getTimestampsForGroup(item, viewField, viewRequest, windowedStore, ctx) : null;
        return Mono.just((Object)new Object()).flatMapMany(o -> {
            if (streamProcessing && isTelemetry) {
                return Mono.just((Object)new Object()).publishOn(Schedulers.fromExecutor((Executor)this.executorManagementService.getExecutorByName(ExecutorName.STORE_READER_1))).doOnNext(o2 -> streamStore.getLoadLock(item, viewField.getAggregationType()).ifPresentOrElse(countDownLatch -> {
                    try {
                        log.trace("Awaiting loading stream data for {} {} {}", new Object[]{item.getName(), viewField.getLabel(), viewField.getAggregationType().name()});
                        countDownLatch.await();
                        log.trace("Proceed with stream data for {} {} {}", new Object[]{item.getName(), viewField.getLabel(), viewField.getAggregationType().name()});
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }, () -> log.trace("initial load stream data for {} {} {}", new Object[]{item.getName(), viewField.getLabel(), viewField.getAggregationType().name()}))).publishOn(Schedulers.fromExecutor((Executor)this.executorManagementService.getExecutorByName(ExecutorName.STORE_READER_2))).flatMapMany(o2 -> {
                    if (this.hasValuesInStore(ctx, entityField, item, viewField, viewRequest)) {
                        ((CountDownLatch)streamStore.getLoadLock(item, viewField.getAggregationType()).orElseThrow(() -> new TrendzInternalException("Stream store lock is not present"))).countDown();
                        DateAggregationType usedDateAggregation = viewRequest.isUsePersistedCacheTelemetry() ? viewRequest.getCachingDateAggregationType() : viewRequest.getMinimalDateAggregation();
                        ZoneId requestZoneId = viewRequest.getZoneId();
                        List partitions = this.partitionBuilder.buildPartitionQueries(queryStartTs, queryEndTs + 1L, viewField.getAggregationType(), usedDateAggregation, requestZoneId, true);
                        return Flux.fromIterable((Iterable)partitions).flatMap(partition -> this.readFromStore(ctx, viewRequest, entityField, item, allowedTs, viewField, partition)).map(fv -> {
                            if (viewRequest.isCacheItemTelemetry() && viewField.getAggregationType() == FieldAggregation.COUNT) {
                                return new FieldValue(item, FieldType.NUMERIC, (Object)1, fv.getTs());
                            }
                            return fv;
                        }).defaultIfEmpty((Object)new FieldValue(item, FieldType.BLANK, null));
                    }
                    return this.getFieldValueFlux(item, viewField, viewRequest, entityField, businessEntity, ctx, entityFieldKey, entityType, streamProcessing, isTelemetry, isNoneAgg, forState, queryStartTs, queryEndTs, streamStore, allowedTs);
                });
            }
            return this.getFieldValueFlux(item, viewField, viewRequest, entityField, businessEntity, ctx, entityFieldKey, entityType, streamProcessing, isTelemetry, isNoneAgg, forState, queryStartTs, queryEndTs, streamStore, allowedTs);
        });
    }

    private Flux<FieldValue> getFieldValueFlux(Item item, ViewField viewField, ViewRequest viewRequest, BusinessEntityField entityField, BusinessEntity businessEntity, ViewContext ctx, String entityFieldKey, BusinessEntityType entityType, boolean streamProcessing, boolean isTelemetry, boolean isNoneAgg, boolean forState, long queryStartTs, long queryEndTs, StreamTelemetryStore streamStore, Set<Long> allowedTs) {
        return this.readFromProvider(viewField, item, viewRequest, ctx, entityType, entityFieldKey, entityField, queryStartTs, queryEndTs).doOnNext(fv -> {
            if (streamProcessing && isTelemetry && !isNoneAgg && viewField.getLocalTimeRange() == null) {
                StreamTelemetryStoreKey storeKey = new StreamTelemetryStoreKey(item.getId(), viewField.getAggregationType(), queryStartTs, queryEndTs);
                streamStore.add(businessEntity, storeKey, fv);
            } else if (isTelemetry && !forState && isNoneAgg && viewField.getLocalTimeRange() == null && this.filterService.matchFieldValue(fv, viewField, viewRequest)) {
                ctx.addNoneAgrValue(viewField.getId(), fv);
            }
        }).map(fv -> {
            if (viewRequest.isCacheItemTelemetry() && viewField.getAggregationType() == FieldAggregation.COUNT) {
                return new FieldValue(item, FieldType.NUMERIC, (Object)1, fv.getTs());
            }
            return fv;
        }).filter(fv -> allowedTs == null || allowedTs.contains(fv.getTs())).collectList().doOnNext(r -> streamStore.getLoadLock(item, viewField.getAggregationType()).ifPresent(countDownLatch -> {
            log.trace("Release lock {} {} {}", new Object[]{item.getName(), viewField.getLabel(), viewField.getAggregationType().name()});
            countDownLatch.countDown();
        })).map(l -> {
            if (isTelemetry && !forState && isNoneAgg) {
                return new ArrayList();
            }
            return l;
        }).flatMapIterable(r -> r).defaultIfEmpty((Object)new FieldValue(item, FieldType.BLANK, null));
    }

    private Flux<FieldValue> readFromProvider(ViewField viewField, Item item, ViewRequest viewRequest, ViewContext ctx, BusinessEntityType entityType, String key, BusinessEntityField entityField, long queryStartTs, long queryEndTs) {
        if (viewRequest.isCacheItemTelemetry() && viewField.getLocalTimeRange() == null && viewField.getAggregationType() != FieldAggregation.LATEST) {
            boolean isCountAgg = viewField.getAggregationType() == FieldAggregation.COUNT;
            Collection savedItemTelemetry = ctx.getSavedItemTelemetry(item.getId(), queryStartTs, queryEndTs, key, isCountAgg);
            if (savedItemTelemetry != null) {
                return Flux.fromIterable((Iterable)savedItemTelemetry);
            }
        }
        DateAggregationType usedDateAggregation = viewRequest.isUsePersistedCacheTelemetry() ? viewRequest.getCachingDateAggregationType() : viewRequest.getMinimalDateAggregation();
        boolean loadRawData = viewRequest.isStreamProcessingEnabled() || viewRequest.isCacheItemTelemetry();
        ZoneId requestZoneId = viewRequest.getZoneId();
        List partitions = this.partitionBuilder.buildPartitionQueries(queryStartTs, queryEndTs + 1L, viewField.getAggregationType(), usedDateAggregation, requestZoneId, loadRawData);
        return Flux.fromIterable((Iterable)partitions).parallel().runOn(Schedulers.parallel()).flatMap(partition -> {
            long start = System.currentTimeMillis();
            return Mono.just((Object)new Object()).flatMap(o -> {
                if (viewField.getAggregationType() == FieldAggregation.LATEST) {
                    return this.tbClient.loadLatestTelemetry(ctx, entityType, item.getId(), key, ctx.getJwtToken()).map(arg_0 -> this.makeFlatTelemtryMap(arg_0)).map(map -> Triple.of((Object)map, Collections.emptyMap(), Collections.emptyMap()));
                }
                if (viewField.getAggregationType() == FieldAggregation.AVG && !loadRawData) {
                    Mono sumMono = this.tbClient.loadTelemetry(ctx, entityType, item.getId(), key, partition.getStartTs(), partition.getEndTs(), partition.getInterval(), "SUM", ctx.getJwtToken());
                    Mono countMono = this.tbClient.loadTelemetry(ctx, entityType, item.getId(), key, partition.getStartTs(), partition.getEndTs(), partition.getInterval(), "COUNT", ctx.getJwtToken());
                    return Mono.zip((Mono)sumMono, (Mono)countMono).map(tuple -> {
                        Map sumMap = (Map)tuple.getT1();
                        Map countMap = (Map)tuple.getT2();
                        Map sumFlatmap = this.makeFlatTelemtryMap(sumMap);
                        Map countFlatmap = this.makeFlatTelemtryMap(countMap);
                        HashMap<String, Map> avgFlatmap = new HashMap<String, Map>();
                        Sets.SetView telemetryKeys = Sets.union(sumFlatmap.keySet(), countFlatmap.keySet());
                        for (String telemetryKey : telemetryKeys) {
                            Map sumSubMap = (Map)sumFlatmap.get(telemetryKey);
                            Map countSubMap = (Map)countFlatmap.get(telemetryKey);
                            if (sumSubMap == null || countSubMap == null) continue;
                            Sets.SetView telemetryTs = Sets.union(sumSubMap.keySet(), countSubMap.keySet());
                            Iterator iterator = telemetryTs.iterator();
                            while (iterator.hasNext()) {
                                long ts = (Long)iterator.next();
                                try {
                                    if (!sumSubMap.containsKey(ts) || !countSubMap.containsKey(ts)) continue;
                                    double sum = Double.parseDouble((String)sumSubMap.get(ts));
                                    long count = Long.parseLong((String)countSubMap.get(ts));
                                    double avg = sum / (double)count;
                                    avgFlatmap.computeIfAbsent(telemetryKey, i -> new HashMap()).computeIfAbsent(ts, i -> Double.toString(avg));
                                }
                                catch (NumberFormatException ex) {
                                    avgFlatmap.computeIfAbsent(telemetryKey, i -> new HashMap()).computeIfAbsent(ts, i -> null);
                                }
                            }
                        }
                        return Triple.of(avgFlatmap, (Object)sumFlatmap, (Object)countFlatmap);
                    });
                }
                return this.tbClient.loadTelemetry(ctx, entityType, item.getId(), key, partition.getStartTs(), partition.getEndTs(), partition.getInterval(), partition.getAgg(), ctx.getJwtToken()).map(arg_0 -> this.makeFlatTelemtryMap(arg_0)).map(map -> Triple.of((Object)map, Collections.emptyMap(), Collections.emptyMap()));
            }).doOnNext(i -> ctx.getStats().getFieldQueryTime().computeIfAbsent(viewField, k -> new AtomicLong()).addAndGet(System.currentTimeMillis() - start)).doOnNext(i -> ctx.getStats().getFieldQueryCount().computeIfAbsent(viewField, k -> new AtomicLong()).incrementAndGet());
        }).sequential().map(triple -> {
            Map targetFlatmap = ((Map)triple.getLeft()).getOrDefault(key, Collections.emptyMap());
            Map sumFlatmap = ((Map)triple.getMiddle()).getOrDefault(key, Collections.emptyMap());
            Map countFlatmap = ((Map)triple.getRight()).getOrDefault(key, Collections.emptyMap());
            ArrayList<FieldValue> list = new ArrayList<FieldValue>();
            for (Map.Entry entry : targetFlatmap.entrySet()) {
                long ts = (Long)entry.getKey();
                String value = (String)entry.getValue();
                FieldValue fieldValue = this.mapWithTs(item, entityField, viewField, value, ts, viewRequest, sumFlatmap, countFlatmap, loadRawData);
                list.add(fieldValue);
            }
            return list;
        }).flatMapIterable(list -> list).collectList().doOnNext(list -> {
            if (viewRequest.isCacheItemTelemetry() && viewField.getLocalTimeRange() == null && viewField.getAggregationType() != FieldAggregation.LATEST) {
                boolean isCountAgg = viewField.getAggregationType() == FieldAggregation.COUNT;
                ctx.saveItemTelemetry(item.getId(), queryStartTs, queryEndTs, key, isCountAgg, list);
            }
        }).flatMapIterable(l -> l);
    }

    private boolean hasValuesInStore(ViewContext ctx, BusinessEntityField entityField, Item item, ViewField viewField, ViewRequest viewRequest) {
        if (viewField.getLocalTimeRange() != null) {
            return false;
        }
        StreamTelemetryStoreKey storeKey = new StreamTelemetryStoreKey(item.getId(), viewField.getAggregationType(), viewRequest.getStartTs(viewField), viewRequest.getEndTs(viewField));
        StreamTelemetryStore streamStore = ctx.getStreamStore(entityField.getId());
        List values = streamStore.get(storeKey);
        if (CollectionUtils.isNotEmpty((Collection)values)) {
            return true;
        }
        StreamTelemetryStoreKey uniqueStoreKey = new StreamTelemetryStoreKey(item.getId(), FieldAggregation.UNIQ, viewRequest.getStartTs(viewField), viewRequest.getEndTs(viewField));
        List uniqValueFields = streamStore.get(uniqueStoreKey);
        return CollectionUtils.isNotEmpty((Collection)uniqValueFields);
    }

    private Flux<FieldValue> readFromStore(ViewContext ctx, ViewRequest viewRequest, BusinessEntityField entityField, Item item, Set<Long> allowedTs, ViewField viewField, TelemetryPartitionQuery partition) {
        StreamTelemetryStoreKey storeKey;
        StreamTelemetryStore streamStore = ctx.getStreamStore(entityField.getId());
        List itemValues = streamStore.get(storeKey = new StreamTelemetryStoreKey(item.getId(), viewField.getAggregationType(), viewRequest.getStartTs(viewField), viewRequest.getEndTs(viewField)));
        if (CollectionUtils.isNotEmpty((Collection)itemValues)) {
            return Flux.fromIterable((Iterable)itemValues).filter(fv -> fv.getTs() >= partition.getStartTs() && fv.getTs() <= partition.getEndTs()).filter(fv -> allowedTs == null || allowedTs.contains(fv.getTs()));
        }
        StreamTelemetryStoreKey uniqueStoreKey = new StreamTelemetryStoreKey(item.getId(), FieldAggregation.UNIQ, viewRequest.getStartTs(viewField), viewRequest.getEndTs(viewField));
        List uniqueValueFields = streamStore.get(uniqueStoreKey);
        if (CollectionUtils.isNotEmpty((Collection)uniqueValueFields)) {
            return Flux.fromIterable((Iterable)uniqueValueFields).filter(fv -> fv.getTs() >= partition.getStartTs() && fv.getTs() <= partition.getEndTs()).filter(fv -> allowedTs == null || allowedTs.contains(fv.getTs()));
        }
        return Flux.empty();
    }

    private Set<Long> getTimestampsForGroup(Item item, ViewField viewField, ViewRequest viewRequest, WindowedStreamStore windowedStore, ViewContext ctx) {
        Sets.SetView allowedTs = null;
        for (Map.Entry entry : windowedStore.getGroupKeys().entrySet()) {
            ViewField key = (ViewField)entry.getKey();
            Object value = entry.getValue();
            Object timestamps = new HashSet();
            StreamTelemetryStore streamStore = ctx.getStreamStore(key.getEntityFieldId());
            Set allowedValues = value instanceof Set ? (Set)value : Sets.newHashSet((Object[])new Object[]{value});
            StreamTelemetryStoreKey storeKey = new StreamTelemetryStoreKey(item.getId(), viewField.getAggregationType(), viewRequest.getStartTs(viewField), viewRequest.getEndTs(viewField));
            if (streamStore.get(storeKey) != null) {
                List itemValues = streamStore.get(storeKey);
                if (CollectionUtils.isNotEmpty((Collection)itemValues)) {
                    timestamps = itemValues.stream().filter(fv -> allowedValues.contains(fv.getInnerValue())).map(FieldValue::getTs).collect(Collectors.toSet());
                }
            } else {
                StreamTelemetryStoreKey uniqueStoreKey = new StreamTelemetryStoreKey(item.getId(), FieldAggregation.UNIQ, viewRequest.getStartTs(viewField), viewRequest.getEndTs(viewField));
                timestamps = streamStore.get(uniqueStoreKey).stream().filter(fv -> allowedValues.contains(fv.getInnerValue())).map(FieldValue::getTs).collect(Collectors.toSet());
            }
            if (allowedTs == null) {
                allowedTs = timestamps;
                continue;
            }
            allowedTs = Sets.intersection(allowedTs, timestamps);
        }
        return allowedTs;
    }

    private FieldValue mapAttr(Item item, BusinessEntityField entityField, ViewField viewField, TsValue tsValue, long nowTs) {
        return this.mapAttr(item, entityField, viewField, tsValue.getValue(), nowTs);
    }

    private FieldValue mapAttr(Item item, BusinessEntityField entityField, ViewField viewField, String strValue, long nowTs) {
        if (viewField.getAggregationType() == FieldAggregation.COUNT && StringUtils.isNotBlank((CharSequence)strValue)) {
            return new FieldValue(item, FieldType.NUMERIC, (Object)1, nowTs);
        }
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$field$FieldType[entityField.getType().ordinal()]) {
            case 2, 3 -> {
                if (NumberUtils.isParsable((String)strValue)) {
                    yield new FieldValue(item, entityField.getType(), (Object)Double.parseDouble(strValue));
                }
                yield new FieldValue(item, entityField.getType(), null);
            }
            case 1 -> new FieldValue(item, FieldType.STRING, (Object)strValue);
            case 4 -> new FieldValue(item, FieldType.BOOLEAN, (Object)Boolean.parseBoolean(strValue));
            default -> throw new IllegalStateException("Unsupported filed type: " + String.valueOf(entityField.getType()));
        };
    }

    private FieldValue mapWithTs(Item item, BusinessEntityField entityField, ViewField viewField, String strValue, long ts, ViewRequest viewRequest, Map<Long, String> sumFlatmap, Map<Long, String> countFlatmap, boolean loadRawData) {
        boolean streamProcessing = viewRequest.isStreamProcessingEnabled();
        boolean isTelemetry = entityField.hasTime();
        boolean isCountAgg = viewField.getAggregationType() == FieldAggregation.COUNT;
        FieldType fieldType = entityField.getType();
        if (streamProcessing && isTelemetry && isCountAgg) {
            return new FieldValue(item, FieldType.NUMERIC, (Object)1, ts);
        }
        if (isCountAgg) {
            if (NumberUtils.isParsable((String)strValue)) {
                return new FieldValue(item, FieldType.NUMERIC, (Object)Double.parseDouble(strValue), ts);
            }
            return new FieldValue(item, FieldType.NUMERIC, (Object)1, ts);
        }
        if (viewField.getAggregationType() == FieldAggregation.AVG && !loadRawData) {
            if (fieldType != FieldType.NUMERIC) {
                throw new IllegalStateException("Avg aggregation type not supported");
            }
            try {
                double sum = Double.parseDouble(sumFlatmap.get(ts));
                long count = Long.parseLong(countFlatmap.get(ts));
                double avg = Double.parseDouble(strValue);
                return new FieldValue(Set.of(item), FieldType.NUMERIC, (Object)avg, ts, sum, count);
            }
            catch (NumberFormatException ex) {
                return new FieldValue(Set.of(item), FieldType.NUMERIC, null, ts, 0.0, 0L);
            }
        }
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$field$FieldType[fieldType.ordinal()]) {
            case 2 -> {
                if (StringUtils.isBlank((CharSequence)strValue)) {
                    FieldValue var15_16;
                    yield var15_16 = new FieldValue(item, FieldType.NUMERIC, null, ts);
                }
                if (NumberUtils.isParsable((String)strValue)) {
                    FieldValue var15_17;
                    yield var15_17 = new FieldValue(item, FieldType.NUMERIC, (Object)Double.parseDouble(strValue), ts);
                }
                try {
                    FieldValue var15_18;
                    yield var15_18 = new FieldValue(item, FieldType.NUMERIC, (Object)Double.parseDouble(strValue), ts);
                }
                catch (NumberFormatException ex) {
                    FieldValue var15_19;
                    yield var15_19 = new FieldValue(item, FieldType.NUMERIC, null, ts);
                }
            }
            case 3 -> {
                FieldValue var15_20;
                yield var15_20 = NumberUtils.isParsable((String)strValue) ? new FieldValue(item, FieldType.DATE, (Object)Double.parseDouble(strValue), ts) : new FieldValue(item, FieldType.DATE, null, ts);
            }
            case 1 -> {
                FieldValue var15_21;
                yield var15_21 = new FieldValue(item, FieldType.STRING, (Object)strValue, ts);
            }
            case 4 -> {
                FieldValue var15_22;
                yield var15_22 = new FieldValue(item, FieldType.BOOLEAN, (Object)Boolean.parseBoolean(strValue), ts);
            }
            default -> throw new TrendzInternalException("Unsupported field type: " + String.valueOf(fieldType));
        };
    }

    private Map<String, Map<Long, String>> makeFlatTelemtryMap(Map<String, List<TsData>> map) {
        HashMap<String, Map<Long, String>> flatmap = new HashMap<String, Map<Long, String>>(map.size());
        for (Map.Entry<String, List<TsData>> entry : map.entrySet()) {
            String telemetryKey = entry.getKey();
            List<TsData> telemetryPoints = entry.getValue();
            for (TsData tsData : telemetryPoints) {
                flatmap.computeIfAbsent(telemetryKey, i -> new HashMap(telemetryPoints.size())).computeIfAbsent(tsData.getTs(), i -> tsData.getValue());
            }
        }
        return flatmap;
    }
}

