/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.EntitySubtype;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityQuery;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.relation.Relation;
import org.thingsboard.trendz.domain.runtime.EnhancedDevice;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class TbDeviceService {
    private final TbRestDataSource tbClient;

    @Autowired
    public TbDeviceService(TbRestDataSource tbClient) {
        this.tbClient = tbClient;
    }

    public Flux<Item> loadDevices(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, String jwtToken, JwtSecurityUser secUser, String textSearch, Integer limit) {
        String deviceType = businessEntity == null ? null : businessEntity.getQuery().getType();
        Flux devices = this.tbClient.loadDevices(businessEntity, request, ctx, deviceType, textSearch, secUser, jwtToken, limit);
        return devices.map(device -> TbDeviceService.map((Device)device, (String)deviceType, null));
    }

    public Flux<Item> loadDevicesById(BusinessEntity businessEntity, String jwtToken, Set<UUID> deviceIds) {
        String deviceType = businessEntity == null ? null : businessEntity.getQuery().getType();
        return this.tbClient.loadDevicesByIdsAsync(null, deviceIds, jwtToken).flatMapIterable(Function.identity()).map(device -> TbDeviceService.map((Device)device, (String)deviceType, null));
    }

    public Mono<Item> loadOneDevice(BusinessEntity businessEntity, JwtSecurityUser secUser, String jwtToken) {
        String deviceType = businessEntity.getQuery().getType();
        Flux devices = this.tbClient.loadDevices(businessEntity, null, null, deviceType, null, secUser, jwtToken, null);
        return devices.map(device -> TbDeviceService.map((Device)device, (String)deviceType, null)).next();
    }

    public Flux<Item> loadRelatedDevices(UUID parentId, BusinessEntity parentEntity, ViewRequest request, ViewContext ctx, Relation relation, BusinessEntity relatedBusinessEntity, String jwtToken) {
        BusinessEntityQuery entityQuery = relatedBusinessEntity.getQuery();
        BusinessEntityQuery query = parentEntity.getQuery();
        AssetId parent = new AssetId(parentId);
        String deviceType = entityQuery.getType();
        if (query.getEntityType().equals((Object)BusinessEntityType.DEVICE)) {
            parent = new DeviceId(parentId);
        } else if (query.getEntityType().equals((Object)BusinessEntityType.CUSTOMER)) {
            parent = new CustomerId(parentId);
        }
        Flux relatedDevices = this.tbClient.findRelatedDevices(relatedBusinessEntity, request, ctx, relation, deviceType, (EntityId)parent, jwtToken);
        return relatedDevices.map(device -> TbDeviceService.map((Device)device, (String)deviceType, (UUID)parentId));
    }

    public Set<String> loadDeviceTypes(String jwtToken) {
        return ((List)DonReactive.block((Mono)this.tbClient.loadDeviceTypes(null, jwtToken).collectList())).stream().map(EntitySubtype::getType).collect(Collectors.toSet());
    }

    public Set<Device> loadDeviceByType(String type, String jwtToken) {
        return (Set)DonReactive.block((Mono)this.tbClient.loadDevices(null, null, null, type, null, null, jwtToken, null).collectList().map(Sets::newHashSet));
    }

    public static Item map(Device device, String deviceType, UUID parent) {
        UUID ownerId = device.getOwnerId() != null ? device.getOwnerId().getId() : null;
        Item item = new Item(device.getUuidId(), parent, ownerId, device.getName(), device.getLabel());
        item.setType(deviceType == null ? device.getType() : deviceType);
        if (device instanceof EnhancedDevice) {
            EnhancedDevice enhancedDevice = (EnhancedDevice)device;
            item.setAttributes(enhancedDevice.getAttributes());
            item.setLatestTelemetry(enhancedDevice.getLatestTelemetries());
        }
        return item;
    }
}

