/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.EntitySubtype;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.relation.Relation;
import org.thingsboard.trendz.domain.runtime.EnhancedAsset;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.provider.TbAssetService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class TbAssetService {
    private final TbRestDataSource tbClient;

    @Autowired
    public TbAssetService(TbRestDataSource tbClient) {
        this.tbClient = tbClient;
    }

    public Flux<Item> loadAssets(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, String jwtToken, JwtSecurityUser user, String textSearch, Integer limit) {
        String assetType = businessEntity == null ? null : businessEntity.getQuery().getType();
        Flux assets = this.tbClient.loadAssets(businessEntity, request, ctx, assetType, textSearch, user, jwtToken, limit);
        return assets.map(asset -> TbAssetService.map((Asset)asset, (String)assetType, null));
    }

    public Flux<Item> loadAssetsById(BusinessEntity businessEntity, String jwtToken, Set<UUID> deviceIds) {
        String assetType = businessEntity == null ? null : businessEntity.getQuery().getType();
        return this.tbClient.loadAssetsByIdsAsync(null, deviceIds, jwtToken).flatMapIterable(Function.identity()).map(asset -> TbAssetService.map((Asset)asset, (String)assetType, null));
    }

    public Mono<Item> loadOneAsset(BusinessEntity businessEntity, JwtSecurityUser user, String jwtToken) {
        String assetType = businessEntity.getQuery().getType();
        Flux assets = this.tbClient.loadAssets(businessEntity, null, null, assetType, null, user, jwtToken, Integer.valueOf(1));
        return assets.map(asset -> TbAssetService.map((Asset)asset, (String)assetType, null)).next();
    }

    public Flux<Item> loadRelatedAssets(UUID parentId, BusinessEntity parentEntity, ViewRequest request, ViewContext ctx, Relation relation, BusinessEntity relatedBusinessEntity, String jwtToken) {
        String assetType = relatedBusinessEntity.getQuery().getType();
        DeviceId parent = switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$BusinessEntityType[parentEntity.getQuery().getEntityType().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> new DeviceId(parentId);
            case 2 -> new CustomerId(parentId);
            case 3, 4 -> new AssetId(parentId);
        };
        Flux relatedAssets = this.tbClient.findRelatedAssets(relatedBusinessEntity, request, ctx, relation, assetType, (EntityId)parent, jwtToken);
        return relatedAssets.map(asset -> TbAssetService.map((Asset)asset, (String)assetType, (UUID)parentId));
    }

    public Set<String> loadAssetTypes(String jwtToken) {
        return ((List)DonReactive.block((Mono)this.tbClient.loadAssetTypes(null, jwtToken).collectList())).stream().map(EntitySubtype::getType).collect(Collectors.toSet());
    }

    public Set<Asset> loadAssetByType(String type, String jwtToken) {
        List assetList = (List)DonReactive.block((Mono)this.tbClient.loadAssets(null, null, null, type, null, null, jwtToken, null).collectList());
        return new HashSet<Asset>(assetList);
    }

    public static Item map(Asset asset, String assetType, UUID parent) {
        UUID ownerId = asset.getOwnerId() != null ? asset.getOwnerId().getId() : null;
        Item item = new Item(asset.getUuidId(), parent, ownerId, asset.getName(), asset.getLabel());
        item.setType(assetType == null ? asset.getType() : assetType);
        if (asset instanceof EnhancedAsset) {
            EnhancedAsset enhancedAsset = (EnhancedAsset)asset;
            item.setAttributes(enhancedAsset.getAttributes());
            item.setLatestTelemetry(enhancedAsset.getLatestTelemetries());
        }
        return item;
    }
}

