/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.predict.executors;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.fitting.PolynomialCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoints;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.FastFourierTransformer;
import org.apache.commons.math3.transform.TransformType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.base.Point;
import org.thingsboard.trendz.domain.base.TimeSeries;
import org.thingsboard.trendz.domain.definition.view.PredictionType;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.predict.PredictionMethodData;
import org.thingsboard.trendz.service.predict.PredictionMethodExecutor;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class FFTLearnMethod
implements PredictionMethodExecutor {
    private static final Logger log = LoggerFactory.getLogger(FFTLearnMethod.class);
    private static final int MAX_INDEX_COUNT = 200;

    public PredictionType getPredictiontype() {
        return PredictionType.FOURIER_TRANSFORMATION;
    }

    public Mono<TimeSeries> predict(JwtSecurityUser user, TimeSeries timeSeries, long[] predictionTs, PredictionMethodData methodData) {
        if (timeSeries.getPoints().isEmpty()) {
            return Mono.just((Object)timeSeries);
        }
        long[] predictionTsCut = Arrays.copyOfRange(predictionTs, 1, predictionTs.length);
        return Mono.just((Object)new Object()).map(o -> {
            List learnSet = timeSeries.getPoints();
            double[] values = new double[learnSet.size()];
            int index = 0;
            for (Point p : learnSet) {
                values[index] = p.getValue();
                ++index;
            }
            values = this.trimToPowerOfTwo(values);
            int valuesLength = values.length;
            int indexDelta = learnSet.size() - valuesLength;
            int padSize = valuesLength - learnSet.size();
            WeightedObservedPoints qqq = new WeightedObservedPoints();
            index = 0;
            for (double v : values) {
                qqq.add((double)index, v);
                ++index;
            }
            PolynomialCurveFitter fitter = PolynomialCurveFitter.create((int)1);
            double[] fit = fitter.fit((Collection)qqq.toList());
            index = 0;
            for (double v : values) {
                values[index] = values[index] - fit[1] * (double)index;
                ++index;
            }
            FastFourierTransformer fft = new FastFourierTransformer(DftNormalization.STANDARD);
            Complex[] complx = fft.transform(values, TransformType.FORWARD);
            int[] indexes = this.getSortedIndexes(valuesLength);
            double[] freq = this.fftFreq(valuesLength);
            int forecastSize = predictionTsCut.length;
            double[] restoredArray = new double[valuesLength + forecastSize];
            for (int i : indexes) {
                double amplitude = Math.abs(complx[i].abs()) / (double)valuesLength;
                double phase = Math.atan2(complx[i].getImaginary(), complx[i].getReal());
                for (int j = 0; j < restoredArray.length; ++j) {
                    restoredArray[j] = restoredArray[j] + amplitude * Math.cos(Math.PI * 2 * freq[i] * (double)j + phase);
                }
            }
            ArrayList<Point> prediction = new ArrayList<Point>();
            for (int i = 0; i < restoredArray.length; ++i) {
                if (i < padSize) continue;
                double v = restoredArray[i] + fit[1] * (double)i;
                if (i + indexDelta < learnSet.size()) {
                    Long pointTs = ((Point)learnSet.get(i + indexDelta)).getTs();
                    prediction.add(new Point(pointTs.longValue(), v));
                    continue;
                }
                prediction.add(new Point(predictionTsCut[i + indexDelta - learnSet.size()], v));
            }
            return new TimeSeries(prediction);
        });
    }

    private double[] trimToPowerOfTwo(double[] original) {
        int currLength = original.length;
        int nextLength = FFTLearnMethod.nextPowerOf2((int)currLength);
        if (currLength != nextLength) {
            --currLength;
            while (currLength != FFTLearnMethod.nextPowerOf2((int)currLength)) {
                --currLength;
            }
            return Arrays.copyOfRange(original, original.length - currLength, original.length);
        }
        return original;
    }

    private static int nextPowerOf2(int a) {
        int b;
        for (b = 1; b < a; b <<= 1) {
        }
        return b;
    }

    private int[] getSortedIndexes(int valuesCount) {
        int indexesCount = Math.min(200, valuesCount);
        double[] freq = this.fftFreq(valuesCount);
        ArrayList pairs = Lists.newArrayList();
        int idnex = 0;
        for (double f : freq) {
            pairs.add(Pair.of((Object)idnex++, (Object)f));
        }
        pairs.sort(Comparator.comparingDouble(p -> Math.abs((Double)p.getRight())));
        int[] result = new int[indexesCount];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)((Pair)pairs.get(i)).getLeft();
        }
        return result;
    }

    private double[] fftFreq(int n) {
        int i;
        double val = 1.0 / (double)(n * 1);
        int N = (n - 1) / 2 + 1;
        double[] results = new double[n];
        int[] p1 = new int[N];
        for (int i2 = 0; i2 < p1.length; ++i2) {
            p1[i2] = i2;
        }
        int[] p2 = new int[n / 2 + 1];
        int value = -(n / 2);
        int index = 0;
        while (value <= 0) {
            p2[index++] = value++;
        }
        for (i = 0; i < N; ++i) {
            results[i] = (double)p1[i] * val;
        }
        for (i = 0; i < p2.length - 1; ++i) {
            results[i + N] = (double)p2[i] * val;
        }
        return results;
    }
}

