/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.predict;

import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.base.Point;
import org.thingsboard.trendz.domain.base.TimeSeries;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.PredictionType;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.measurement.Measurable;
import org.thingsboard.trendz.domain.measurement.MeasuredTaskType;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.service.predict.PreaggregationService;
import org.thingsboard.trendz.service.predict.PredictionMethodData;
import org.thingsboard.trendz.service.predict.PredictionMethodExecutor;
import org.thingsboard.trendz.service.startup.TrendzStartupService;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import org.thingsboard.trendz.service.view.proto.WindowedStreamStore;
import org.thingsboard.trendz.tools.DateTimeUtils;
import reactor.core.publisher.Mono;

@Service
public class PredictionService
implements TrendzStartupService {
    private static final Logger log = LoggerFactory.getLogger(PredictionService.class);
    private final Map<PredictionType, PredictionMethodExecutor> predictionTypeToExecutorMap = new EnumMap(PredictionType.class);
    private final PreaggregationService preaggregationService;

    @Autowired
    public PredictionService(PreaggregationService preaggregationService) {
        this.preaggregationService = preaggregationService;
    }

    public void onStartup(ApplicationContext context) {
        context.getBeansOfType(PredictionMethodExecutor.class).forEach((beanName, bean) -> this.predictionTypeToExecutorMap.put(bean.getPredictiontype(), bean));
    }

    public int priority() {
        return 31;
    }

    @Measurable(context="#ctx", type=MeasuredTaskType.PREDICTION_CALCULATION, viewFieldName="#viewField.label", viewFieldAggregation="#viewField.aggregationType")
    public Mono<List<FieldValue>> enrichPrediction(ViewField viewField, List<FieldValue> original, Item item, ViewRequest viewRequest, WindowedStreamStore windowedStreamStore, ViewContext ctx) {
        return Mono.just(original).map(values -> this.preaggregationService.preaggregateIfNeeded(values, viewField, viewRequest, ctx)).doOnNext(values -> values.sort(Comparator.comparingLong(FieldValue::getTs))).flatMap(values -> {
            if (CollectionUtils.isEmpty((Collection)values) || values.size() < 2 || ((FieldValue)values.get(0)).getFieldType().equals((Object)FieldType.BLANK)) {
                return Mono.just((Object)values);
            }
            TimeSeries learnSet = this.toPoints(values);
            if (learnSet.getPoints().isEmpty()) {
                return Mono.just((Object)values);
            }
            return Mono.just((Object)new Object()).flatMap(o2 -> {
                ZoneId requestZoneId = viewRequest.getZoneId();
                ChronoUnit dataAggregationUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)viewRequest.getMinimalDateAggregation());
                long predictionStartTs = learnSet.getPoints().stream().mapToLong(Point::getTs).max().orElseThrow();
                long predictionEndTs = this.getPredictionRangeEnd(viewRequest.getEndTs(viewField), (long)viewField.getPredictionRangeSec(), requestZoneId);
                long[] predictionTimeseries = this.generatePredictionTimestamps(predictionStartTs, predictionEndTs, dataAggregationUnit, viewRequest.getZoneId());
                ctx.setMaxRealTs(Math.max(ctx.getMaxRealTs(), predictionStartTs));
                PredictionType predictionMethod = viewField.getPredictionMethod();
                PredictionMethodExecutor predictionMethodExecutor = (PredictionMethodExecutor)this.predictionTypeToExecutorMap.get(predictionMethod);
                PredictionMethodData methodData = predictionMethodExecutor.makeData(viewField, item, values, viewRequest, windowedStreamStore, ctx);
                return predictionMethodExecutor.predict(ctx.getUser(), learnSet, predictionTimeseries, methodData);
            }).map(predict -> {
                predict = this.proceedHistoricalData(viewField, predict, learnSet);
                return this.fromPoints(values, predict);
            });
        }).onErrorMap(e -> new IllegalStateException("The prediction service processing task was failed.", (Throwable)e));
    }

    private long[] generatePredictionTimestamps(long predictionStartTs, long predictionEndTs, ChronoUnit dataAggregationUnit, ZoneId zoneId) {
        ZonedDateTime start = ZonedDateTime.ofInstant(Instant.ofEpochMilli(predictionStartTs), zoneId);
        ZonedDateTime end = ZonedDateTime.ofInstant(Instant.ofEpochMilli(predictionEndTs), zoneId);
        ZonedDateTime current = start;
        ArrayList<Long> timestamps = new ArrayList<Long>();
        while (current.isBefore(end)) {
            timestamps.add(current.toInstant().toEpochMilli());
            current = current.plus(1L, dataAggregationUnit);
        }
        return Longs.toArray(timestamps);
    }

    TimeSeries proceedHistoricalData(ViewField viewField, TimeSeries predict, TimeSeries learnSet) {
        List predictPoints = predict.getPoints();
        List learnSetPoints = learnSet.getPoints();
        if (predictPoints.isEmpty()) {
            throw new IllegalStateException("Prediction is empty - does not look like okay.");
        }
        int futureIndex = 0;
        boolean found = false;
        Point lastPoint = (Point)learnSetPoints.get(learnSetPoints.size() - 1);
        for (Point point : predictPoints) {
            if (point.getTs() == lastPoint.getTs()) {
                found = true;
                break;
            }
            ++futureIndex;
        }
        if (!found) {
            throw new IllegalStateException("Can not find common point.");
        }
        if (!viewField.isIncludeHistoricalData()) {
            return new TimeSeries(predictPoints.subList(futureIndex + 1, predictPoints.size()));
        }
        ArrayList v2 = Lists.newArrayList((Iterable)learnSetPoints);
        v2.addAll(predictPoints.subList(futureIndex + 1, predictPoints.size()));
        return new TimeSeries((List)v2);
    }

    private long getPercentileOfPointsIntervals(List<Long> time, int percentilePercent) {
        double[] deltas = new double[time.size() - 1];
        for (int i = 0; i < time.size() - 1; ++i) {
            deltas[i] = (double)time.get(i + 1).longValue() - (double)time.get(i).longValue();
        }
        double evaluate = new Percentile().evaluate(deltas, (double)percentilePercent);
        return (long)evaluate;
    }

    private long getPercentileOfPointsIntervalsPoints(List<Point> points, int percent) {
        return this.getPercentileOfPointsIntervals(points.stream().map(Point::getTs).collect(Collectors.toList()), percent);
    }

    private long getPredictionRangeEnd(long requestEndTs, long hardIntervalSeconds, ZoneId zoneId) {
        long predictionRange;
        ChronoUnit predictionUnit;
        if (hardIntervalSeconds % 31536000L == 0L) {
            predictionUnit = ChronoUnit.YEARS;
            predictionRange = hardIntervalSeconds / 31536000L;
        } else if (hardIntervalSeconds % 2592000L == 0L) {
            predictionUnit = ChronoUnit.MONTHS;
            predictionRange = hardIntervalSeconds / 2592000L;
        } else if (hardIntervalSeconds % 86400L == 0L) {
            predictionUnit = ChronoUnit.DAYS;
            predictionRange = hardIntervalSeconds / 86400L;
        } else if (hardIntervalSeconds % 3600L == 0L) {
            predictionUnit = ChronoUnit.HOURS;
            predictionRange = hardIntervalSeconds / 3600L;
        } else if (hardIntervalSeconds % 60L == 0L) {
            predictionUnit = ChronoUnit.SECONDS;
            predictionRange = hardIntervalSeconds / 60L;
        } else {
            throw new IllegalStateException("Cant convert seconds to particular time unit and range of units.");
        }
        ZonedDateTime endTime = DateTimeUtils.fromTs((long)requestEndTs, (ZoneId)zoneId);
        ZonedDateTime endPredictionTime = endTime.plus(predictionRange, predictionUnit);
        return DateTimeUtils.toTs((ZonedDateTime)endPredictionTime);
    }

    private List<FieldValue> fromPoints(List<FieldValue> original, TimeSeries series) {
        FieldValue ref = original.get(0);
        return series.getPoints().stream().map(p -> new FieldValue(ref.getItems(), ref.getFieldType(), (Object)p.getValue(), p.getTs())).collect(Collectors.toList());
    }

    private TimeSeries toPoints(List<FieldValue> original) {
        return original.stream().filter(v -> v.getInnerValue() != null).map(v -> new Point(v.getTs(), ((Number)v.getInnerValue()).doubleValue())).collect(Collectors.collectingAndThen(Collectors.toList(), TimeSeries::new));
    }
}

