/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.predict;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.thingsboard.trendz.domain.base.Point;
import org.thingsboard.trendz.domain.base.TimeSeries;
import org.thingsboard.trendz.domain.definition.view.PredictionType;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.predict.PredictionMethodData;
import org.thingsboard.trendz.service.predict.PredictionMethodExecutor;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import org.thingsboard.trendz.service.view.proto.WindowedStreamStore;
import reactor.core.publisher.Mono;

public interface PredictionMultiVariableMethodExecutor
extends PredictionMethodExecutor {
    public static final String KEY_FEATURE_LABEL = "input";

    public PredictionType getPredictiontype();

    public PredictionMethodData makeData(ViewField var1, Item var2, List<FieldValue> var3, ViewRequest var4, WindowedStreamStore var5, ViewContext var6);

    public Mono<TimeSeries> predict(JwtSecurityUser var1, TimeSeries var2, long[] var3, PredictionMethodData var4);

    default public Map<String, TimeSeries> makeLearnTimeseries(Map<String, List<FieldValue>> additionalData, TimeSeries learnSet) {
        Map<String, TimeSeries> seriesMap = additionalData.entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), ((List)entry.getValue()).stream().filter(v -> v.getInnerValue() != null).map(v -> new Point(v.getTs(), ((Number)v.getInnerValue()).doubleValue())).collect(Collectors.toList()))).map(entry -> Map.entry((String)entry.getKey(), new TimeSeries((List)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        seriesMap.put(KEY_FEATURE_LABEL, learnSet);
        int seriesLengthMax = seriesMap.values().stream().map(TimeSeries::getPoints).mapToInt(List::size).max().orElseThrow();
        List longestPointList = seriesMap.values().stream().map(TimeSeries::getPoints).filter(pointList -> pointList.size() == seriesLengthMax).findAny().orElseThrow();
        for (TimeSeries series : seriesMap.values()) {
            List points = series.getPoints();
            if (points.isEmpty()) {
                List emptyPoints = longestPointList.stream().map(point -> new Point(point.getTs(), 0.0)).collect(Collectors.toList());
                points.addAll(emptyPoints);
                continue;
            }
            int countDifference = seriesLengthMax - points.size();
            List tail = IntStream.range(0, countDifference).mapToObj(point -> {
                Point lastPoint = (Point)points.get(points.size() - 1);
                return new Point(lastPoint.getTs(), lastPoint.getValue());
            }).collect(Collectors.toList());
            points.addAll(tail);
        }
        return seriesMap;
    }

    default public Map<String, TimeSeries> alignByTime(Map<String, TimeSeries> learnTimeseriesMap) {
        if (learnTimeseriesMap.values().size() < 2) {
            return learnTimeseriesMap;
        }
        long totalDistance = 0L;
        int pointCount = 0;
        for (TimeSeries series : learnTimeseriesMap.values()) {
            List points = series.getPoints();
            for (int i = 1; i < points.size(); ++i) {
                totalDistance += ((Point)points.get(i)).getTs() - ((Point)points.get(i - 1)).getTs();
                ++pointCount;
            }
        }
        if (pointCount == 0) {
            return learnTimeseriesMap;
        }
        long step = totalDistance / (long)pointCount;
        HashMap<String, TimeSeries> result = new HashMap<String, TimeSeries>();
        for (Map.Entry<String, TimeSeries> entry : learnTimeseriesMap.entrySet()) {
            String seriesName = entry.getKey();
            TimeSeries inputSeries = entry.getValue();
            TimeSeries resultSeries = result.computeIfAbsent(seriesName, key -> new TimeSeries(new ArrayList()));
            for (Point point : inputSeries.getPoints()) {
                long timestamp = Math.round((double)point.getTs() / (double)step) * step;
                resultSeries.getPoints().add(new Point(timestamp, point.getValue()));
            }
        }
        TimeSeries baseSeries = (TimeSeries)result.values().iterator().next();
        List baseSeriesPoints = baseSeries.getPoints();
        for (TimeSeries series : result.values()) {
            if (series == baseSeries) continue;
            List seriesPoints = series.getPoints();
            if (baseSeriesPoints.size() != seriesPoints.size()) {
                throw new IllegalStateException("Series point count is not corresponding to base series");
            }
            for (int i = 0; i < baseSeriesPoints.size(); ++i) {
                Point basePoint = (Point)baseSeriesPoints.get(i);
                Point point = (Point)seriesPoints.get(i);
                if (Objects.equals(basePoint.getTs(), point.getTs())) continue;
                throw new IllegalStateException("Series point timestamp is not corresponding to base series");
            }
        }
        return result;
    }

    default public List<Long> getHistoryTimestamps(Map<String, TimeSeries> learnTimeseriesMap) {
        TimeSeries series = learnTimeseriesMap.values().iterator().next();
        return series.getPoints().stream().map(Point::getTs).collect(Collectors.toList());
    }

    default public Map<String, List<Double>> getFeatures(Map<String, TimeSeries> learnTimeseriesMap) {
        HashMap<String, List<Double>> result = new HashMap<String, List<Double>>();
        int i = 0;
        for (Map.Entry<String, TimeSeries> entry : learnTimeseriesMap.entrySet()) {
            String key = entry.getKey();
            TimeSeries value = entry.getValue();
            Object label = key.equals(KEY_FEATURE_LABEL) ? key : "input_" + i++;
            List features = value.getPoints().stream().map(Point::getValue).collect(Collectors.toList());
            result.put((String)label, features);
        }
        return result;
    }
}

