/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.prediction.segment;

import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationMethod;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationMethodAuto;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationMethodData;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationMethodFixed;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationMethodSlidingWindowPercent;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationMethodSlidingWindowUnit;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationMethodStickToEnd;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationService;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationType;
import org.thingsboard.trendz.tools.DateTimeUtils;

@Service
public class SegmentationService {
    private static final Logger log = LoggerFactory.getLogger(SegmentationService.class);
    private final SegmentationMethodFixed methodFixed;
    private final SegmentationMethodSlidingWindowPercent methodSlidingWindowPercent;
    private final SegmentationMethodSlidingWindowUnit methodSlidingWindowUnit;
    private final SegmentationMethodStickToEnd methodStickToEnd;
    private final SegmentationMethodAuto methodAuto;

    @Autowired
    public SegmentationService(SegmentationMethodFixed methodFixed, SegmentationMethodSlidingWindowPercent methodSlidingWindowPercent, SegmentationMethodSlidingWindowUnit methodSlidingWindowUnit, SegmentationMethodStickToEnd methodStickToEnd, SegmentationMethodAuto methodAuto) {
        this.methodFixed = methodFixed;
        this.methodSlidingWindowPercent = methodSlidingWindowPercent;
        this.methodSlidingWindowUnit = methodSlidingWindowUnit;
        this.methodStickToEnd = methodStickToEnd;
        this.methodAuto = methodAuto;
    }

    public TimeRange defineInitialSegmentRange(SegmentationMethodData data, TimeRange originalRange, ChronoUnit segmentUnit, int segmentUnitCount, ZoneId zoneId) {
        ZonedDateTime startDate = DateTimeUtils.fromTs((long)originalRange.getStartTs(), (ZoneId)zoneId);
        if (data.getType() == SegmentationType.AUTO) {
            Duration originalDuration = originalRange.duration();
            Duration allSegmentsDuration = DateTimeUtils.toDuration((ZonedDateTime)startDate, (long)((long)segmentUnitCount * 100L), (ChronoUnit)segmentUnit);
            if (allSegmentsDuration.compareTo(originalDuration) < 0) {
                return new TimeRange(originalRange.getStartTs(), originalRange.getStartTs() + originalDuration.minus(allSegmentsDuration).toMillis());
            }
        }
        Duration segmentDuration = DateTimeUtils.toDuration((ZonedDateTime)startDate, (long)segmentUnitCount, (ChronoUnit)segmentUnit);
        return new TimeRange(originalRange.getStartTs(), originalRange.getStartTs() + segmentDuration.toMillis());
    }

    public TimeRange defineAllSegmentRange(SegmentationMethodData data, TimeRange originalRange, ChronoUnit segmentUnit, int segmentUnitCount, ZoneId zoneId) {
        ZonedDateTime startDate = DateTimeUtils.fromTs((long)originalRange.getStartTs(), (ZoneId)zoneId);
        if (data.getType() == SegmentationType.AUTO) {
            Duration originalDuration = originalRange.duration();
            Duration allSegmentsDuration = DateTimeUtils.toDuration((ZonedDateTime)startDate, (long)((long)segmentUnitCount * 100L), (ChronoUnit)segmentUnit);
            if (allSegmentsDuration.compareTo(originalDuration) < 0) {
                return new TimeRange(originalRange.getStartTs() + originalDuration.minus(allSegmentsDuration).toMillis(), originalRange.getEndTs());
            }
        }
        Duration stepDuration = this.defineStepDuration(data, originalRange, startDate, segmentUnit, segmentUnitCount);
        return new TimeRange(originalRange.getStartTs() + stepDuration.toMillis(), originalRange.getEndTs());
    }

    public Duration defineStepDuration(SegmentationMethodData data, TimeRange originalRange, ZonedDateTime referenceDate, ChronoUnit segmentUnit, int segmentUnitCount) {
        SegmentationType type = data.getType();
        SegmentationMethod method = this.getMethodByType(type);
        return method.defineStepDuration(data, originalRange, referenceDate, segmentUnit, segmentUnitCount);
    }

    public Set<TimeRange> makeSegments(SegmentationMethodData data, TimeRange originalRange, ChronoUnit aggregationUnit, ChronoUnit segmentUnit, int segmentUnitCount, ZoneId zoneId) {
        SegmentationType type = data.getType();
        SegmentationMethod method = this.getMethodByType(type);
        Duration duration = originalRange.duration();
        if (duration.isZero() || duration.isNegative()) {
            throw new TrendzException("Invalid range: " + String.valueOf(originalRange));
        }
        return method.makeSegments(data, originalRange, aggregationUnit, segmentUnit, segmentUnitCount, zoneId);
    }

    public TimeRange getPreviousDoubleRange(TimeRange originalRange, ChronoUnit segmentUnit, int segmentUnitCount, ZoneId zoneId) {
        long originalStartTs = originalRange.getStartTs();
        ZonedDateTime endDate = DateTimeUtils.fromTs((long)originalStartTs, (ZoneId)zoneId);
        ZonedDateTime startDate = endDate.minus((long)segmentUnitCount * 2L, segmentUnit);
        return new TimeRange(DateTimeUtils.toTs((ZonedDateTime)startDate), DateTimeUtils.toTs((ZonedDateTime)endDate));
    }

    private SegmentationMethod getMethodByType(SegmentationType type) {
        return switch (1.$SwitchMap$org$thingsboard$trendz$service$model$prediction$segment$SegmentationType[type.ordinal()]) {
            case 1 -> this.methodFixed;
            case 2 -> this.methodSlidingWindowPercent;
            case 3 -> this.methodSlidingWindowUnit;
            case 4 -> this.methodStickToEnd;
            case 5 -> this.methodAuto;
            default -> throw new IllegalArgumentException("Unknown segmentation type: " + String.valueOf(type));
        };
    }
}

