/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.prediction.segment;

import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationMethod;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationMethodData;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationMethodStickToEndData;
import org.thingsboard.trendz.tools.DateTimeUtils;

@Service
public class SegmentationMethodStickToEnd
implements SegmentationMethod {
    private static final Logger log = LoggerFactory.getLogger(SegmentationMethodStickToEnd.class);

    public Duration defineStepDuration(SegmentationMethodData d, TimeRange originalRange, ZonedDateTime referenceDate, ChronoUnit segmentUnit, int segmentUnitCount) {
        return DateTimeUtils.toDuration((ZonedDateTime)referenceDate, (long)segmentUnitCount, (ChronoUnit)segmentUnit);
    }

    public Set<TimeRange> makeSegments(SegmentationMethodData d, TimeRange originalRange, ChronoUnit aggregationUnit, ChronoUnit segmentUnit, int segmentUnitCount, ZoneId zoneId) {
        SegmentationMethodStickToEndData data = (SegmentationMethodStickToEndData)d;
        boolean includedLastUnfinished = data.isIncludedLastUnfinished();
        int segmentCount = data.getSegmentCount();
        ZonedDateTime startDate = DateTimeUtils.fromTs((long)originalRange.getStartTs(), (ZoneId)zoneId);
        ZonedDateTime endDate = DateTimeUtils.fromTs((long)originalRange.getEndTs(), (ZoneId)zoneId);
        TreeSet<TimeRange> result = new TreeSet<TimeRange>();
        for (int i = 0; i < segmentCount; ++i) {
            long segmentEndTs;
            long segmentStartTs;
            ZonedDateTime segmentStartDate = endDate.minus(i + 1, segmentUnit);
            ZonedDateTime segmentEndDate = endDate.minus(i, segmentUnit);
            if (segmentStartDate.isBefore(startDate)) {
                if (!includedLastUnfinished || segmentUnit.between(startDate, segmentEndDate) <= 0L) break;
                segmentStartTs = DateTimeUtils.toTs((ZonedDateTime)startDate);
                segmentEndTs = DateTimeUtils.toTs((ZonedDateTime)segmentEndDate);
                result.add(new TimeRange(segmentStartTs, segmentEndTs));
                break;
            }
            segmentStartTs = DateTimeUtils.toTs((ZonedDateTime)segmentStartDate);
            segmentEndTs = DateTimeUtils.toTs((ZonedDateTime)segmentEndDate);
            result.add(new TimeRange(segmentStartTs, segmentEndTs));
        }
        return result;
    }
}

