/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.prediction.segment;

import org.thingsboard.trendz.service.model.prediction.segment.SegmentationMethodData;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationMethodSlidingWindowPercentData;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationType;

public class SegmentationMethodSlidingWindowPercentData
implements SegmentationMethodData {
    private final SegmentationType type = SegmentationType.SLIDING_WINDOW_PERCENT;
    private boolean includedLastUnfinished;
    private double percent;

    public SegmentationMethodSlidingWindowPercentData(SegmentationMethodSlidingWindowPercentData that) {
        this.includedLastUnfinished = that.includedLastUnfinished;
        this.percent = that.percent;
    }

    public SegmentationMethodSlidingWindowPercentData clone() {
        return new SegmentationMethodSlidingWindowPercentData(this);
    }

    public static SegmentationMethodSlidingWindowPercentDataBuilder builder() {
        return new SegmentationMethodSlidingWindowPercentDataBuilder();
    }

    public SegmentationType getType() {
        return this.type;
    }

    public boolean isIncludedLastUnfinished() {
        return this.includedLastUnfinished;
    }

    public double getPercent() {
        return this.percent;
    }

    public void setIncludedLastUnfinished(boolean includedLastUnfinished) {
        this.includedLastUnfinished = includedLastUnfinished;
    }

    public void setPercent(double percent) {
        this.percent = percent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SegmentationMethodSlidingWindowPercentData)) {
            return false;
        }
        SegmentationMethodSlidingWindowPercentData other = (SegmentationMethodSlidingWindowPercentData)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isIncludedLastUnfinished() != other.isIncludedLastUnfinished()) {
            return false;
        }
        if (Double.compare(this.getPercent(), other.getPercent()) != 0) {
            return false;
        }
        SegmentationType this$type = this.getType();
        SegmentationType other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SegmentationMethodSlidingWindowPercentData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIncludedLastUnfinished() ? 79 : 97);
        long $percent = Double.doubleToLongBits(this.getPercent());
        result = result * 59 + (int)($percent >>> 32 ^ $percent);
        SegmentationType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "SegmentationMethodSlidingWindowPercentData(type=" + String.valueOf(this.getType()) + ", includedLastUnfinished=" + this.isIncludedLastUnfinished() + ", percent=" + this.getPercent() + ")";
    }

    public SegmentationMethodSlidingWindowPercentData() {
    }

    public SegmentationMethodSlidingWindowPercentData(boolean includedLastUnfinished, double percent) {
        this.includedLastUnfinished = includedLastUnfinished;
        this.percent = percent;
    }
}

