/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.prediction.segment;

import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationMethod;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationMethodData;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationMethodSlidingWindowPercentData;
import org.thingsboard.trendz.tools.DateTimeUtils;

@Service
public class SegmentationMethodSlidingWindowPercent
implements SegmentationMethod {
    private static final Logger log = LoggerFactory.getLogger(SegmentationMethodSlidingWindowPercent.class);

    public Duration defineStepDuration(SegmentationMethodData d, TimeRange originalRange, ZonedDateTime referenceDate, ChronoUnit segmentUnit, int segmentUnitCount) {
        SegmentationMethodSlidingWindowPercentData data = (SegmentationMethodSlidingWindowPercentData)d;
        double percent = data.getPercent();
        Duration segmentDuration = DateTimeUtils.toDuration((ZonedDateTime)referenceDate, (long)segmentUnitCount, (ChronoUnit)segmentUnit);
        long segmentDurationMillis = segmentDuration.toMillis();
        long stepDurationMillis = (long)((double)segmentDurationMillis * percent / 100.0);
        return Duration.ofMillis(stepDurationMillis);
    }

    public Set<TimeRange> makeSegments(SegmentationMethodData d, TimeRange originalRange, ChronoUnit aggregationUnit, ChronoUnit segmentUnit, int segmentUnitCount, ZoneId zoneId) {
        SegmentationMethodSlidingWindowPercentData data = (SegmentationMethodSlidingWindowPercentData)d;
        boolean includedLastUnfinished = data.isIncludedLastUnfinished();
        long startTs = originalRange.getStartTs();
        long endTs = originalRange.getEndTs();
        ZonedDateTime startDate = DateTimeUtils.fromTs((long)startTs, (ZoneId)zoneId);
        ZonedDateTime endDate = DateTimeUtils.fromTs((long)endTs, (ZoneId)zoneId);
        TreeSet<TimeRange> result = new TreeSet<TimeRange>();
        ZonedDateTime currentDate = startDate;
        while (currentDate.isBefore(endDate)) {
            TimeRange segmentTimeRange;
            Duration segmentDuration = DateTimeUtils.toDuration((ZonedDateTime)currentDate, (long)segmentUnitCount, (ChronoUnit)segmentUnit);
            Duration stepDuration = this.defineStepDuration((SegmentationMethodData)data, originalRange, currentDate, segmentUnit, segmentUnitCount);
            long segmentStartTs = DateTimeUtils.toTs((ZonedDateTime)currentDate);
            long segmentEndTs = DateTimeUtils.toTs((ZonedDateTime)currentDate.plus(segmentDuration));
            currentDate = currentDate.plus(stepDuration);
            if (endTs < segmentEndTs) {
                if (!includedLastUnfinished) continue;
                segmentTimeRange = new TimeRange(segmentStartTs, endTs);
                result.add(segmentTimeRange);
                continue;
            }
            segmentTimeRange = new TimeRange(segmentStartTs, segmentEndTs);
            result.add(segmentTimeRange);
        }
        return result;
    }
}

