/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.prediction.segment;

import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationMethod;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationMethodData;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationMethodFixedData;
import org.thingsboard.trendz.tools.DateTimeUtils;

@Service
public class SegmentationMethodFixed
implements SegmentationMethod {
    private static final Logger log = LoggerFactory.getLogger(SegmentationMethodFixed.class);

    public Duration defineStepDuration(SegmentationMethodData d, TimeRange originalRange, ZonedDateTime referenceDate, ChronoUnit segmentUnit, int segmentUnitCount) {
        return DateTimeUtils.toDuration((ZonedDateTime)referenceDate, (long)segmentUnitCount, (ChronoUnit)segmentUnit);
    }

    public Set<TimeRange> makeSegments(SegmentationMethodData d, TimeRange originalRange, ChronoUnit aggregationUnit, ChronoUnit segmentUnit, int segmentUnitCount, ZoneId zoneId) {
        SegmentationMethodFixedData data = (SegmentationMethodFixedData)d;
        boolean includedLastUnfinished = data.isIncludedLastUnfinished();
        TreeSet<TimeRange> result = new TreeSet<TimeRange>();
        long startTs = originalRange.getStartTs();
        long endTs = originalRange.getEndTs();
        ZonedDateTime startDate = DateTimeUtils.fromTs((long)startTs, (ZoneId)zoneId);
        ZonedDateTime endDate = DateTimeUtils.fromTs((long)endTs, (ZoneId)zoneId);
        ZonedDateTime currentDate = startDate;
        while (currentDate.isBefore(endDate)) {
            TimeRange segmentTimeRange;
            Duration stepDuration = this.defineStepDuration((SegmentationMethodData)data, originalRange, currentDate, segmentUnit, segmentUnitCount);
            ZonedDateTime previousDate = currentDate;
            currentDate = currentDate.plus(stepDuration);
            long segmentStartTs = DateTimeUtils.toTs((ZonedDateTime)previousDate);
            long segmentEndTs = DateTimeUtils.toTs((ZonedDateTime)currentDate);
            if (endTs < segmentEndTs) {
                if (!includedLastUnfinished) continue;
                segmentTimeRange = new TimeRange(segmentStartTs, endTs);
                result.add(segmentTimeRange);
                continue;
            }
            segmentTimeRange = new TimeRange(segmentStartTs, segmentEndTs);
            result.add(segmentTimeRange);
        }
        return result;
    }
}

