/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.prediction.segment;

import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationMethod;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationMethodAutoData;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationMethodData;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationMethodSlidingWindowPercent;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationMethodSlidingWindowPercentData;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationMethodSlidingWindowUnit;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationMethodSlidingWindowUnitData;
import org.thingsboard.trendz.tools.DateTimeUtils;

@Service
public class SegmentationMethodAuto
implements SegmentationMethod {
    private static final Logger log = LoggerFactory.getLogger(SegmentationMethodAuto.class);
    public static final int AUTO_SEGMENT_COUNT = 100;
    public static final int AUTO_MIN_PERCENT = 1;
    public static final int AUTO_MAX_PERCENT = 100;
    private final SegmentationMethodSlidingWindowPercent slidingWindowPercentMethod;
    private final SegmentationMethodSlidingWindowUnit slidingWindowUnitMethod;

    @Autowired
    public SegmentationMethodAuto(SegmentationMethodSlidingWindowPercent slidingWindowPercentMethod, SegmentationMethodSlidingWindowUnit slidingWindowUnitMethod) {
        this.slidingWindowPercentMethod = slidingWindowPercentMethod;
        this.slidingWindowUnitMethod = slidingWindowUnitMethod;
    }

    public Duration defineStepDuration(SegmentationMethodData d, TimeRange originalRange, ZonedDateTime referenceDate, ChronoUnit segmentUnit, int segmentUnitCount) {
        SegmentationMethodAutoData data = (SegmentationMethodAutoData)d;
        Duration originalDuration = originalRange.duration();
        Duration segmentDuration = DateTimeUtils.toDuration((ZonedDateTime)referenceDate, (long)segmentUnitCount, (ChronoUnit)segmentUnit);
        Duration requiredStepDuration = originalDuration.dividedBy(100L);
        double actualPercent = 100.0 * (double)requiredStepDuration.toMillis() / (double)segmentDuration.toMillis();
        double alignedPercent = Math.max(1.0, Math.min(100.0, actualPercent));
        return Duration.ofMillis((long)((double)segmentDuration.toMillis() * 0.01 * alignedPercent));
    }

    public Set<TimeRange> makeSegments(SegmentationMethodData d, TimeRange originalRange, ChronoUnit aggregationUnit, ChronoUnit segmentUnit, int segmentUnitCount, ZoneId zoneId) {
        SegmentationMethodAutoData data = (SegmentationMethodAutoData)d;
        boolean includedLastUnfinished = data.isIncludedLastUnfinished();
        ZonedDateTime referenceDate = DateTimeUtils.fromTs((long)originalRange.getStartTs(), (ZoneId)zoneId);
        Duration stepDuration = this.defineStepDuration(d, originalRange, referenceDate, segmentUnit, segmentUnitCount);
        if (stepDuration.compareTo(aggregationUnit.getDuration()) < 0) {
            SegmentationMethodSlidingWindowUnitData slidingWindowData = new SegmentationMethodSlidingWindowUnitData(includedLastUnfinished, 1);
            return this.slidingWindowUnitMethod.makeSegments((SegmentationMethodData)slidingWindowData, originalRange, aggregationUnit, aggregationUnit, segmentUnitCount, zoneId);
        }
        Duration segmentDuration = DateTimeUtils.toDuration((ZonedDateTime)referenceDate, (long)segmentUnitCount, (ChronoUnit)segmentUnit);
        double percent = 100.0 * (double)stepDuration.toMillis() / (double)segmentDuration.toMillis();
        SegmentationMethodSlidingWindowPercentData slidingWindowData = new SegmentationMethodSlidingWindowPercentData(includedLastUnfinished, percent);
        return this.slidingWindowPercentMethod.makeSegments((SegmentationMethodData)slidingWindowData, originalRange, aggregationUnit, segmentUnit, segmentUnitCount, zoneId);
    }
}

