/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.prediction.segment;

import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.domain.base.TimeSeries;
import org.thingsboard.trendz.domain.definition.migration.HasId;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentData;

public class SegmentData
implements Comparable<SegmentData>,
HasId {
    private UUID id;
    private UUID modelId;
    private ItemLite item;
    private TimeRange range;
    private TimeSeries prehistoricalTelemetry;
    private TimeSeries historicalTelemetry;
    private Map<UUID, TimeSeries> additionalTelemetries;
    private TimeSeries predictionTelemetry;

    public SegmentData(SegmentData that) {
        this.id = that.id;
        this.modelId = that.modelId;
        this.item = that.item == null ? null : new ItemLite(that.item);
        this.range = that.range == null ? null : new TimeRange(that.range);
        this.prehistoricalTelemetry = that.prehistoricalTelemetry == null ? null : new TimeSeries(that.prehistoricalTelemetry);
        this.historicalTelemetry = that.historicalTelemetry == null ? null : new TimeSeries(that.historicalTelemetry);
        this.additionalTelemetries = that.additionalTelemetries == null ? null : that.additionalTelemetries.entrySet().stream().map(entry -> Map.entry((UUID)entry.getKey(), new TimeSeries((TimeSeries)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.predictionTelemetry = that.predictionTelemetry == null ? null : new TimeSeries(that.predictionTelemetry);
    }

    @Override
    public int compareTo(SegmentData that) {
        return this.range.compareTo(that.range);
    }

    public static SegmentDataBuilder builder() {
        return new SegmentDataBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getModelId() {
        return this.modelId;
    }

    public ItemLite getItem() {
        return this.item;
    }

    public TimeRange getRange() {
        return this.range;
    }

    public TimeSeries getPrehistoricalTelemetry() {
        return this.prehistoricalTelemetry;
    }

    public TimeSeries getHistoricalTelemetry() {
        return this.historicalTelemetry;
    }

    public Map<UUID, TimeSeries> getAdditionalTelemetries() {
        return this.additionalTelemetries;
    }

    public TimeSeries getPredictionTelemetry() {
        return this.predictionTelemetry;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setModelId(UUID modelId) {
        this.modelId = modelId;
    }

    public void setItem(ItemLite item) {
        this.item = item;
    }

    public void setRange(TimeRange range) {
        this.range = range;
    }

    public void setPrehistoricalTelemetry(TimeSeries prehistoricalTelemetry) {
        this.prehistoricalTelemetry = prehistoricalTelemetry;
    }

    public void setHistoricalTelemetry(TimeSeries historicalTelemetry) {
        this.historicalTelemetry = historicalTelemetry;
    }

    public void setAdditionalTelemetries(Map<UUID, TimeSeries> additionalTelemetries) {
        this.additionalTelemetries = additionalTelemetries;
    }

    public void setPredictionTelemetry(TimeSeries predictionTelemetry) {
        this.predictionTelemetry = predictionTelemetry;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SegmentData)) {
            return false;
        }
        SegmentData other = (SegmentData)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$modelId = this.getModelId();
        UUID other$modelId = other.getModelId();
        if (this$modelId == null ? other$modelId != null : !((Object)this$modelId).equals(other$modelId)) {
            return false;
        }
        ItemLite this$item = this.getItem();
        ItemLite other$item = other.getItem();
        if (this$item == null ? other$item != null : !this$item.equals(other$item)) {
            return false;
        }
        TimeRange this$range = this.getRange();
        TimeRange other$range = other.getRange();
        if (this$range == null ? other$range != null : !this$range.equals(other$range)) {
            return false;
        }
        TimeSeries this$prehistoricalTelemetry = this.getPrehistoricalTelemetry();
        TimeSeries other$prehistoricalTelemetry = other.getPrehistoricalTelemetry();
        if (this$prehistoricalTelemetry == null ? other$prehistoricalTelemetry != null : !this$prehistoricalTelemetry.equals(other$prehistoricalTelemetry)) {
            return false;
        }
        TimeSeries this$historicalTelemetry = this.getHistoricalTelemetry();
        TimeSeries other$historicalTelemetry = other.getHistoricalTelemetry();
        if (this$historicalTelemetry == null ? other$historicalTelemetry != null : !this$historicalTelemetry.equals(other$historicalTelemetry)) {
            return false;
        }
        Map this$additionalTelemetries = this.getAdditionalTelemetries();
        Map other$additionalTelemetries = other.getAdditionalTelemetries();
        if (this$additionalTelemetries == null ? other$additionalTelemetries != null : !((Object)this$additionalTelemetries).equals(other$additionalTelemetries)) {
            return false;
        }
        TimeSeries this$predictionTelemetry = this.getPredictionTelemetry();
        TimeSeries other$predictionTelemetry = other.getPredictionTelemetry();
        return !(this$predictionTelemetry == null ? other$predictionTelemetry != null : !this$predictionTelemetry.equals(other$predictionTelemetry));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SegmentData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $modelId = this.getModelId();
        result = result * 59 + ($modelId == null ? 43 : ((Object)$modelId).hashCode());
        ItemLite $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : $item.hashCode());
        TimeRange $range = this.getRange();
        result = result * 59 + ($range == null ? 43 : $range.hashCode());
        TimeSeries $prehistoricalTelemetry = this.getPrehistoricalTelemetry();
        result = result * 59 + ($prehistoricalTelemetry == null ? 43 : $prehistoricalTelemetry.hashCode());
        TimeSeries $historicalTelemetry = this.getHistoricalTelemetry();
        result = result * 59 + ($historicalTelemetry == null ? 43 : $historicalTelemetry.hashCode());
        Map $additionalTelemetries = this.getAdditionalTelemetries();
        result = result * 59 + ($additionalTelemetries == null ? 43 : ((Object)$additionalTelemetries).hashCode());
        TimeSeries $predictionTelemetry = this.getPredictionTelemetry();
        result = result * 59 + ($predictionTelemetry == null ? 43 : $predictionTelemetry.hashCode());
        return result;
    }

    public String toString() {
        return "SegmentData(id=" + String.valueOf(this.getId()) + ", modelId=" + String.valueOf(this.getModelId()) + ", item=" + String.valueOf(this.getItem()) + ", range=" + String.valueOf(this.getRange()) + ", prehistoricalTelemetry=" + String.valueOf(this.getPrehistoricalTelemetry()) + ", historicalTelemetry=" + String.valueOf(this.getHistoricalTelemetry()) + ", additionalTelemetries=" + String.valueOf(this.getAdditionalTelemetries()) + ", predictionTelemetry=" + String.valueOf(this.getPredictionTelemetry()) + ")";
    }

    public SegmentData() {
    }

    public SegmentData(UUID id, UUID modelId, ItemLite item, TimeRange range, TimeSeries prehistoricalTelemetry, TimeSeries historicalTelemetry, Map<UUID, TimeSeries> additionalTelemetries, TimeSeries predictionTelemetry) {
        this.id = id;
        this.modelId = modelId;
        this.item = item;
        this.range = range;
        this.prehistoricalTelemetry = prehistoricalTelemetry;
        this.historicalTelemetry = historicalTelemetry;
        this.additionalTelemetries = additionalTelemetries;
        this.predictionTelemetry = predictionTelemetry;
    }
}

