/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.prediction.methods;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.service.model.prediction.methods.MultivariableProphetMethodParameters;
import org.thingsboard.trendz.service.model.prediction.methods.PredictionMethod;
import org.thingsboard.trendz.service.model.prediction.methods.PredictionMethodParameters;
import org.thingsboard.trendz.service.model.prediction.methods.PredictionMethodType;

@Service
public class MultivariableProphetMethod
implements PredictionMethod {
    private static final Logger log = LoggerFactory.getLogger(MultivariableProphetMethod.class);

    public PredictionMethodType getType() {
        return PredictionMethodType.MULTIVARIABLE_PROPHET;
    }

    public String getMethodDefinition(PredictionMethodParameters methodParameters) {
        MultivariableProphetMethodParameters parameters = (MultivariableProphetMethodParameters)methodParameters;
        return "#####################################################\n# Prediction Method: MULTIVARIABLE PROPHET\nimport pandas as pd\nimport numpy as np\nimport pickle\nfrom prophet import Prophet\nfrom prophet.serialize import model_to_json, model_from_json\nimport logging\n\nEMPTY_PROPHET_MODELS_MAGIC_BYTES = b'\\123'\n\n# \u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u043b\u043e\u0433\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f\nlogging.basicConfig(level=logging.WARNING)\nlogger = logging.getLogger(__name__)\n\nclass CustomModel(IModel):\n\n    def __init__(self, value_transformer=None, timestamp_transformer=None):\n        # \u0425\u0440\u0430\u043d\u0438\u043c \u0434\u043e 2048 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0445 \u0442\u043e\u0447\u0435\u043a \u0434\u043b\u044f \u0433\u043b\u0430\u0432\u043d\u043e\u0433\u043e \u0440\u044f\u0434\u0430\n        self.data_storage_limit = 2048\n        self._main_buffer = pd.DataFrame(columns=['ds', 'y'])\n\n        # \u0424\u0438\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043d\u0430\u0431\u043e\u0440 \u0440\u0435\u0433\u0440\u0435\u0441\u0441\u043e\u0440\u043e\u0432\n        self.regressor_keys = ['regressor1', 'regressor2', 'regressor3']  # \u0417\u0430\u043c\u0435\u043d\u0438\u0442\u0435 \u043d\u0430 \u0432\u0430\u0448\u0438 \u043a\u043b\u044e\u0447\u0438\n\n        # \u0414\u043b\u044f \u043a\u0430\u0436\u0434\u043e\u0433\u043e \u0440\u0435\u0433\u0440\u0435\u0441\u0441\u043e\u0440\u0430 \u0437\u0430\u0432\u0435\u0434\u0451\u043c \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0439 \u0431\u0443\u0444\u0435\u0440 \u0434\u0430\u043d\u043d\u044b\u0445 (\u0438 \u043c\u043e\u0434\u0435\u043b\u044c)\n        self.regressor_data_storage_limit = 2048\n        self._regressor_buffers = {key: pd.DataFrame(columns=['ds', 'y']) for key in self.regressor_keys}\n        self.regressor_models = {key: Prophet() for key in self.regressor_keys}\n\n        # \u0413\u043b\u0430\u0432\u043d\u0430\u044f \u043c\u043e\u0434\u0435\u043b\u044c\n        self.model = Prophet()\n\n    def init_state(self):\n        self.model = Prophet()\n        self._main_buffer = pd.DataFrame(columns=['ds', 'y'])\n        self._regressor_buffers = {key: pd.DataFrame(columns=['ds', 'y']) for key in self.regressor_keys}\n        self.regressor_models = {key: Prophet() for key in self.regressor_keys}\n\n    # ==================== TRAIN ====================\n    def train(self, data, additionalData=None):\n        '''\n        data: \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0439 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u0440\u044f\u0434 [(ts, value), ...]\n        additionalData: dict \u043a\u043b\u044e\u0447 -> \u0441\u043f\u0438\u0441\u043e\u043a [(ts, value), ...] \u0434\u043b\u044f \u0440\u0435\u0433\u0440\u0435\u0441\u0441\u043e\u0440\u043e\u0432\n        '''\n\n        # \u041e\u0431\u043d\u043e\u0432\u043b\u044f\u0435\u043c \u0431\u0443\u0444\u0435\u0440 \u0433\u043b\u0430\u0432\u043d\u043e\u0433\u043e \u0440\u044f\u0434\u0430\n        df_main = self._make_df(data)\n        self._update_main_buffer(df_main)\n\n        # \u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043a\u0430\u0436\u0434\u043e\u0433\u043e \u0440\u0435\u0433\u0440\u0435\u0441\u0441\u043e\u0440\u0430\n        for key in self.regressor_keys:\n            telemetryDetails = additionalData.get(key, []) if additionalData else []\n\n            if telemetryDetails:\n                # \u041e\u0431\u043d\u043e\u0432\u043b\u044f\u0435\u043c \u0431\u0443\u0444\u0435\u0440 \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u043e \u044d\u0442\u043e\u043c\u0443 \u0440\u0435\u0433\u0440\u0435\u0441\u0441\u043e\u0440\u0443\n                df_reg = self._make_df(telemetryDetails)\n                self._update_regressor_buffer(key, df_reg)\n            else:\n                # \u0415\u0441\u043b\u0438 \u043d\u0435\u0442 \u043d\u043e\u0432\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445, \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c \u0434\u0432\u0435 \u0441\u0442\u0440\u043e\u043a\u0438 \u0441 y=0\n                last_ds = self._main_buffer['ds'].iloc[-1] if not self._main_buffer.empty else pd.Timestamp.now()\n                zero_data = pd.DataFrame({\n                    'ds': [last_ds + pd.Timedelta(seconds=1), last_ds + pd.Timedelta(seconds=2)],\n                    'y': [0, 0]\n                })\n                self._update_regressor_buffer(key, zero_data)\n\n            # \u041e\u0431\u0443\u0447\u0430\u0435\u043c (\u0438\u043b\u0438 \u043f\u0435\u0440\u0435\u043e\u0431\u0443\u0447\u0430\u0435\u043c) \u0440\u0435\u0433\u0440\u0435\u0441\u0441\u043e\u0440-\u043c\u043e\u0434\u0435\u043b\u044c\n            if len(self._regressor_buffers[key]) < 2:\n                logger.warning(f\"Not enough data to train regressor '{key}'. Using zeros.\")\n                # \u0415\u0441\u043b\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c \u0431\u0443\u0444\u0435\u0440 \u0441 \u043d\u0443\u043b\u044f\u043c\u0438\n                self.regressor_models[key].fit(self._regressor_buffers[key])\n            else:\n                # \u041f\u0435\u0440\u0435\u0441\u043e\u0437\u0434\u0430\u0451\u043c \u0440\u0435\u0433\u0440\u0435\u0441\u0441\u043e\u0440 \u0441 \u0442\u0435\u043c\u0438 \u0436\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c\u0438\n                reg_config = {\n                    'growth'                : self.regressor_models[key].growth,\n                    'changepoints'          : None,\n                    'n_changepoints'        : self.regressor_models[key].n_changepoints,\n                    'changepoint_range'     : self.regressor_models[key].changepoint_range,\n                    'yearly_seasonality'    : self.regressor_models[key].yearly_seasonality,\n                    'weekly_seasonality'    : self.regressor_models[key].weekly_seasonality,\n                    'daily_seasonality'     : self.regressor_models[key].daily_seasonality,\n                    'holidays'              : self.regressor_models[key].holidays,\n                    'seasonality_mode'      : self.regressor_models[key].seasonality_mode,\n                    'seasonality_prior_scale': self.regressor_models[key].seasonality_prior_scale,\n                    'holidays_prior_scale'  : self.regressor_models[key].holidays_prior_scale,\n                    'changepoint_prior_scale': self.regressor_models[key].changepoint_prior_scale,\n                    'mcmc_samples'          : self.regressor_models[key].mcmc_samples,\n                    'interval_width'        : self.regressor_models[key].interval_width,\n                    'uncertainty_samples'   : self.regressor_models[key].uncertainty_samples,\n                    'stan_backend'          : None\n                }\n                self.regressor_models[key] = Prophet(**reg_config)\n                self.regressor_models[key].fit(self._regressor_buffers[key])\n\n        # \u0422\u0435\u043f\u0435\u0440\u044c \u0441\u0442\u0440\u043e\u0438\u043c \u043d\u043e\u0432\u0443\u044e \u0433\u043b\u0430\u0432\u043d\u0443\u044e \u043c\u043e\u0434\u0435\u043b\u044c\n        # \u0421\u0431\u0440\u0430\u0441\u044b\u0432\u0430\u0435\u043c changepoints, \u0447\u0442\u043e\u0431\u044b \u0438\u0437\u0431\u0435\u0436\u0430\u0442\u044c \u043e\u0448\u0438\u0431\u043a\u0438 ValueError: Changepoints must fall within training data\n        config = {\n            'growth'                : self.model.growth,\n            'changepoints'          : None,\n            'n_changepoints'        : self.model.n_changepoints,\n            'changepoint_range'     : self.model.changepoint_range,\n            'yearly_seasonality'    : self.model.yearly_seasonality,\n            'weekly_seasonality'    : self.model.weekly_seasonality,\n            'daily_seasonality'     : self.model.daily_seasonality,\n            'holidays'              : self.model.holidays,\n            'seasonality_mode'      : self.model.seasonality_mode,\n            'seasonality_prior_scale': self.model.seasonality_prior_scale,\n            'holidays_prior_scale'  : self.model.holidays_prior_scale,\n            'changepoint_prior_scale': self.model.changepoint_prior_scale,\n            'mcmc_samples'          : self.model.mcmc_samples,\n            'interval_width'        : self.model.interval_width,\n            'uncertainty_samples'   : self.model.uncertainty_samples,\n            'stan_backend'          : None\n        }\n        self.model = Prophet(**config)\n\n        # \u0414\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c \u0442\u0435 \u0440\u0435\u0433\u0440\u0435\u0441\u0441\u043e\u0440\u044b, \u0434\u043b\u044f \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u0443 \u043d\u0430\u0441 \u0435\u0441\u0442\u044c \u043c\u043e\u0434\u0435\u043b\u0438\n        for key in self.regressor_models.keys():\n            self.model.add_regressor(key)\n\n        # \u0424\u043e\u0440\u043c\u0438\u0440\u0443\u0435\u043c \u043e\u0431\u0449\u0438\u0439 df \u0434\u043b\u044f \u0433\u043b\u0430\u0432\u043d\u043e\u0439 \u043c\u043e\u0434\u0435\u043b\u0438:\n        #  - \u0433\u043b\u0430\u0432\u043d\u044b\u0439 \u0440\u044f\u0434 y (\u0438\u0437 self._main_buffer)\n        #  - \u043a\u043e\u043b\u043e\u043d\u043a\u0438 \u0434\u043b\u044f \u043a\u0430\u0436\u0434\u043e\u0433\u043e \u0440\u0435\u0433\u0440\u0435\u0441\u0441\u043e\u0440\u0430 (\u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0438\u0435 \u043d\u0430\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f!)\n        df_for_fit = self._merge_main_and_regressors()\n\n        self.model.fit(df_for_fit)\n\n    # ==================== PARTIAL_FIT ====================\n    def partial_fit(self, data, additionalData=None):\n        '''\n        \u0410\u043d\u0430\u043b\u043e\u0433 train, \u043d\u043e \u043c\u044b \u0441\u043d\u043e\u0432\u0430 \u0445\u0440\u0430\u043d\u0438\u043c \u043d\u043e\u0432\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 + \u0441\u0442\u0430\u0440\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435,\n        \u0430 \u0437\u0430\u0442\u0435\u043c \u043f\u0435\u0440\u0435\u043e\u0431\u0443\u0447\u0430\u0435\u043c.\n        '''\n\n        # 1) \u041e\u0431\u043d\u043e\u0432\u043b\u044f\u0435\u043c \u0433\u043b\u0430\u0432\u043d\u044b\u0439 \u0431\u0443\u0444\u0435\u0440\n        df_main = self._make_df(data)\n        self._update_main_buffer(df_main)\n\n        # 2) \u041e\u0431\u043d\u043e\u0432\u043b\u044f\u0435\u043c \u0431\u0443\u0444\u0435\u0440\u044b \u0440\u0435\u0433\u0440\u0435\u0441\u0441\u043e\u0440\u043e\u0432 \u0438 \u043f\u0435\u0440\u0435\u043e\u0431\u0443\u0447\u0430\u0435\u043c \u0438\u0445\n        for key in self.regressor_keys:\n            telemetryDetails = additionalData.get(key, []) if additionalData else []\n\n            if telemetryDetails:\n                # \u041e\u0431\u043d\u043e\u0432\u043b\u044f\u0435\u043c \u0431\u0443\u0444\u0435\u0440 \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u043e \u044d\u0442\u043e\u043c\u0443 \u0440\u0435\u0433\u0440\u0435\u0441\u0441\u043e\u0440\u0443\n                df_reg = self._make_df(telemetryDetails)\n                self._update_regressor_buffer(key, df_reg)\n            else:\n                # \u0415\u0441\u043b\u0438 \u043d\u0435\u0442 \u043d\u043e\u0432\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445, \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c \u0434\u0432\u0435 \u0441\u0442\u0440\u043e\u043a\u0438 \u0441 y=0\n                last_ds = self._main_buffer['ds'].iloc[-1] if not self._main_buffer.empty else pd.Timestamp.now()\n                zero_data = pd.DataFrame({\n                    'ds': [last_ds + pd.Timedelta(seconds=1), last_ds + pd.Timedelta(seconds=2)],\n                    'y': [0, 0]\n                })\n                self._update_regressor_buffer(key, zero_data)\n\n            # \u041e\u0431\u0443\u0447\u0430\u0435\u043c (\u0438\u043b\u0438 \u043f\u0435\u0440\u0435\u043e\u0431\u0443\u0447\u0430\u0435\u043c) \u0440\u0435\u0433\u0440\u0435\u0441\u0441\u043e\u0440-\u043c\u043e\u0434\u0435\u043b\u044c\n            if len(self._regressor_buffers[key]) < 2:\n                logger.warning(f\"Not enough data to train regressor '{key}'. Using zeros.\")\n                # \u0415\u0441\u043b\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c \u0431\u0443\u0444\u0435\u0440 \u0441 \u043d\u0443\u043b\u044f\u043c\u0438\n                self.regressor_models[key].fit(self._regressor_buffers[key])\n            else:\n                # \u041f\u0435\u0440\u0435\u0441\u043e\u0437\u0434\u0430\u0451\u043c \u0440\u0435\u0433\u0440\u0435\u0441\u0441\u043e\u0440 \u0441 \u0442\u0435\u043c\u0438 \u0436\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c\u0438\n                reg_config = {\n                    'growth'                : self.regressor_models[key].growth,\n                    'changepoints'          : None,\n                    'n_changepoints'        : self.regressor_models[key].n_changepoints,\n                    'changepoint_range'     : self.regressor_models[key].changepoint_range,\n                    'yearly_seasonality'    : self.regressor_models[key].yearly_seasonality,\n                    'weekly_seasonality'    : self.regressor_models[key].weekly_seasonality,\n                    'daily_seasonality'     : self.regressor_models[key].daily_seasonality,\n                    'holidays'              : self.regressor_models[key].holidays,\n                    'seasonality_mode'      : self.regressor_models[key].seasonality_mode,\n                    'seasonality_prior_scale': self.regressor_models[key].seasonality_prior_scale,\n                    'holidays_prior_scale'  : self.regressor_models[key].holidays_prior_scale,\n                    'changepoint_prior_scale': self.regressor_models[key].changepoint_prior_scale,\n                    'mcmc_samples'          : self.regressor_models[key].mcmc_samples,\n                    'interval_width'        : self.regressor_models[key].interval_width,\n                    'uncertainty_samples'   : self.regressor_models[key].uncertainty_samples,\n                    'stan_backend'          : None\n                }\n                self.regressor_models[key] = Prophet(**reg_config)\n                self.regressor_models[key].fit(self._regressor_buffers[key])\n\n        # 3) \u041f\u0435\u0440\u0435\u043e\u0431\u0443\u0447\u0430\u0435\u043c \u0433\u043b\u0430\u0432\u043d\u0443\u044e \u043c\u043e\u0434\u0435\u043b\u044c\n        #    \u0412\u0430\u0436\u043d\u043e: \u0435\u0441\u043b\u0438 \u043f\u043e\u044f\u0432\u0438\u043b\u0438\u0441\u044c \u043d\u043e\u0432\u044b\u0435 \u0440\u0435\u0433\u0440\u0435\u0441\u0441\u043e\u0440\u044b, \u043d\u0443\u0436\u043d\u043e \u0438\u0445 \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c\n        config = {\n            'growth'                : self.model.growth,\n            'changepoints'          : None,\n            'n_changepoints'        : self.model.n_changepoints,\n            'changepoint_range'     : self.model.changepoint_range,\n            'yearly_seasonality'    : self.model.yearly_seasonality,\n            'weekly_seasonality'    : self.model.weekly_seasonality,\n            'daily_seasonality'     : self.model.daily_seasonality,\n            'holidays'              : self.model.holidays,\n            'seasonality_mode'      : self.model.seasonality_mode,\n            'seasonality_prior_scale': self.model.seasonality_prior_scale,\n            'holidays_prior_scale'  : self.model.holidays_prior_scale,\n            'changepoint_prior_scale': self.model.changepoint_prior_scale,\n            'mcmc_samples'          : self.model.mcmc_samples,\n            'interval_width'        : self.model.interval_width,\n            'uncertainty_samples'   : self.model.uncertainty_samples,\n            'stan_backend'          : None\n        }\n        self.model = Prophet(**config)\n\n        # \u0414\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c \u0432\u0441\u0435 \u0440\u0435\u0433\u0440\u0435\u0441\u0441\u043e\u0440\u044b, \u0434\u043b\u044f \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u0435\u0441\u0442\u044c \u043c\u043e\u0434\u0435\u043b\u0438\n        for key in self.regressor_models.keys():\n            self.model.add_regressor(key)\n\n        # \u0421\u043b\u0438\u0432\u0430\u0435\u043c \u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u0433\u043b\u0430\u0432\u043d\u043e\u0433\u043e \u0440\u044f\u0434\u0430 + \u0438\u0441\u0442\u043e\u0440\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0440\u0435\u0433\u0440\u0435\u0441\u0441\u043e\u0440\u043e\u0432\n        df_for_fit = self._merge_main_and_regressors()\n\n        self.model.fit(df_for_fit)\n\n    # ==================== PREDICT ====================\n    def predict(self, timestamps):\n        '''\n        \u0428\u0430\u0433 \u043f\u0440\u043e\u0433\u043d\u043e\u0437\u0430:\n        1) \u041f\u0440\u0435\u0434\u0441\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u043c \u0431\u0443\u0434\u0443\u0449\u0438\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043a\u0430\u0436\u0434\u043e\u0433\u043e \u0440\u0435\u0433\u0440\u0435\u0441\u0441\u043e\u0440\u0430 \u0447\u0435\u0440\u0435\u0437 \u0438\u0445 regressor_model\n        2) \u041f\u043e\u0434\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u043c \u0438\u0445 \u043a\u0430\u043a \u043a\u043e\u043b\u043e\u043d\u043a\u0438 \u0432 future DataFrame\n        3) \u0412\u044b\u0437\u044b\u0432\u0430\u0435\u043c self.model.predict\n        '''\n        future = pd.DataFrame()\n        future['ds'] = pd.to_datetime(timestamps, unit='ms')\n\n        # \u041f\u0440\u0435\u0434\u0441\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u043c \u0440\u0435\u0433\u0440\u0435\u0441\u0441\u043e\u0440\u044b (\u0435\u0441\u043b\u0438 \u0435\u0441\u0442\u044c)\n        for key, regressor_model in self.regressor_models.items():\n            future_regressor_df = pd.DataFrame()\n            future_regressor_df['ds'] = pd.to_datetime(timestamps, unit='ms')\n            forecast_reg = regressor_model.predict(future_regressor_df)\n            # \u043a\u043b\u0430\u0434\u0451\u043c \u0432 \u043a\u043e\u043b\u043e\u043d\u043a\u0443 future[key] \u043f\u0440\u0435\u0434\u0441\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f\n            future[key] = forecast_reg['yhat'].values\n\n        forecast = self.model.predict(future)\n        outputY = forecast['yhat'].tolist()\n        return list(zip(timestamps, outputY))\n\n    # ==================== SAVE / LOAD ====================\n    def save_state(self, file_path):\n        '''\n        \u0421\u043e\u0445\u0440\u0430\u043d\u044f\u0435\u043c \u0432\u0441\u0435 \u043c\u043e\u0434\u0435\u043b\u0438 + \u0432\u0441\u0435 \u0431\u0443\u0444\u0435\u0440\u044b \u0434\u0430\u043d\u043d\u044b\u0445.\n        '''\n        state = {\n            'main_model': self._serialize_model(self.model),\n            'regressor_models': {\n                key: self._serialize_model(model)\n                for key, model in self.regressor_models.items()\n            },\n            'main_buffer': self._main_buffer,\n            'regressor_buffers': self._regressor_buffers\n        }\n\n        with open(file_path, 'wb') as file:\n            pickle.dump(state, file)\n\n    def load_state(self, file_path):\n        '''\n        \u0417\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u043c \u0432\u0441\u0435 \u043c\u043e\u0434\u0435\u043b\u0438 + \u0432\u0441\u0435 \u0431\u0443\u0444\u0435\u0440\u044b.\n        '''\n        with open(file_path, 'rb') as file:\n            state = pickle.load(file)\n\n            self.model = self._deserialize_model(state['main_model'])\n            self.regressor_models = {\n                key: self._deserialize_model(json_model)\n                for key, json_model in state['regressor_models'].items()\n            }\n            self._main_buffer = state.get('main_buffer', pd.DataFrame(columns=['ds','y']))\n            self._regressor_buffers = state.get('regressor_buffers', {key: pd.DataFrame(columns=['ds','y']) for key in self.regressor_keys})\n\n    def _serialize_model(self, model):\n        if model.history is None:\n            return EMPTY_PROPHET_MODELS_MAGIC_BYTES\n        else:\n            return model_to_json(model)\n\n    def _deserialize_model(self, model_json):\n        if model_json == EMPTY_PROPHET_MODELS_MAGIC_BYTES:\n            return Prophet()\n        else:\n            return model_from_json(model_json)\n\n    def name(self):\n        return \"MultivariableProphetMethod\"\n\n    # -----------------------------------------------\n    # \u0412\u0441\u043f\u043e\u043c\u043e\u0433\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043c\u0435\u0442\u043e\u0434\u044b\n    # -----------------------------------------------\n    def _make_df(self, data):\n        df = pd.DataFrame()\n        df['ds'] = pd.to_datetime([point[0] for point in data], unit='ms')\n        df['y']  = [point[1] for point in data]\n        return df\n\n    def _update_main_buffer(self, df_new):\n        self._main_buffer = pd.concat([self._main_buffer, df_new], ignore_index=True)\n        # C\u043a\u043e\u043b\u044c\u0437\u044f\u0449\u0435\u0435 \u043e\u043a\u043d\u043e: \u043e\u0431\u0440\u0435\u0436\u0435\u043c \u0434\u043e \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0445 N \u0442\u043e\u0447\u0435\u043a, \u0435\u0441\u043b\u0438 \u043d\u0443\u0436\u043d\u043e\n        if len(self._main_buffer) > self.data_storage_limit:\n            self._main_buffer = self._main_buffer.iloc[-self.data_storage_limit:]\n\n    def _update_regressor_buffer(self, key, df_new):\n        buffer_df = self._regressor_buffers[key]\n        buffer_df = pd.concat([buffer_df, df_new], ignore_index=True)\n        if len(buffer_df) > self.regressor_data_storage_limit:\n            buffer_df = buffer_df.iloc[-self.regressor_data_storage_limit:]\n\n        self._regressor_buffers[key] = buffer_df\n\n    def _merge_main_and_regressors(self):\n        '''\n        \u0424\u043e\u0440\u043c\u0438\u0440\u0443\u0435\u043c DataFrame \u0434\u043b\u044f fit \u0433\u043b\u0430\u0432\u043d\u043e\u0439 \u043c\u043e\u0434\u0435\u043b\u0438:\n          ds, y, [regressor1, regressor2, ...]\n        \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c \"left\" merge \u043e\u0442 _main_buffer,\n        \u043f\u0440\u0435\u0434\u043f\u043e\u043b\u0430\u0433\u0430\u044f, \u0447\u0442\u043e \u043a\u0430\u0436\u0434\u0430\u044f \u0442\u043e\u0447\u043a\u0430 ds \u0432 main \u2014 \"\u0433\u043b\u0430\u0432\u043d\u0430\u044f\".\n        \u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u043d\u044b\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u043e \u0440\u0435\u0433\u0440\u0435\u0441\u0441\u043e\u0440\u0430\u043c \u0437\u0430\u043f\u043e\u043b\u043d\u044f\u0435\u043c \u043d\u0443\u043b\u044f\u043c\u0438.\n        '''\n        df_merged = self._main_buffer.copy()\n        for key in self.regressor_keys:\n            df_reg = self._regressor_buffers[key]\n            if df_reg.empty:\n                # \u0415\u0441\u043b\u0438 \u0431\u0443\u0444\u0435\u0440 \u043f\u0443\u0441\u0442, \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c \u043a\u043e\u043b\u043e\u043d\u043a\u0443 \u0441 \u043d\u0443\u043b\u044f\u043c\u0438\n                df_merged[key] = 0\n            else:\n                # merge \u043f\u043e ds\n                df_merged = pd.merge(\n                    df_merged,\n                    df_reg.rename(columns={'y': key}),\n                    on='ds',\n                    how='left'\n                )\n                # \u0417\u0430\u043f\u043e\u043b\u043d\u0438\u043c \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0438 \u043d\u0443\u043b\u044f\u043c\u0438\n                df_merged[key].fillna(0, inplace=True)\n        return df_merged\n\n#####################################################\n";
    }
}

