/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.prediction.handler;

import org.thingsboard.trendz.service.model.prediction.handler.FftPoint;

public class FftPoint {
    private double real;
    private double imaginary;

    public FftPoint(FftPoint that) {
        this.real = that.real;
        this.imaginary = that.imaginary;
    }

    public static FftPointBuilder builder() {
        return new FftPointBuilder();
    }

    public double getReal() {
        return this.real;
    }

    public double getImaginary() {
        return this.imaginary;
    }

    public void setReal(double real) {
        this.real = real;
    }

    public void setImaginary(double imaginary) {
        this.imaginary = imaginary;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FftPoint)) {
            return false;
        }
        FftPoint other = (FftPoint)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (Double.compare(this.getReal(), other.getReal()) != 0) {
            return false;
        }
        return Double.compare(this.getImaginary(), other.getImaginary()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof FftPoint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $real = Double.doubleToLongBits(this.getReal());
        result = result * 59 + (int)($real >>> 32 ^ $real);
        long $imaginary = Double.doubleToLongBits(this.getImaginary());
        result = result * 59 + (int)($imaginary >>> 32 ^ $imaginary);
        return result;
    }

    public String toString() {
        return "FftPoint(real=" + this.getReal() + ", imaginary=" + this.getImaginary() + ")";
    }

    public FftPoint() {
    }

    public FftPoint(double real, double imaginary) {
        this.real = real;
        this.imaginary = imaginary;
    }
}

