/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.prediction.handler;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.base.TimeSeries;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.model.prediction.handler.JavaPredictionModelHandler;
import org.thingsboard.trendz.service.model.prediction.handler.PythonPredictionModelHandler;
import org.thingsboard.trendz.service.model.prediction.methods.PredictionMethodParameters;
import org.thingsboard.trendz.service.model.prediction.methods.PredictionMethodType;
import reactor.core.publisher.Mono;

@Service
public class DispatchingPredictionModelHandler {
    private static final Logger log = LoggerFactory.getLogger(DispatchingPredictionModelHandler.class);
    public static final Set<Object> JAVA_PREDICTIONS = Set.of(PredictionMethodType.FOURIER_TRANSFORMATION);
    private final PythonPredictionModelHandler pythonPredictionModelHandler;
    private final JavaPredictionModelHandler javaPredictionModelHandler;

    @Autowired
    public DispatchingPredictionModelHandler(PythonPredictionModelHandler pythonPredictionModelHandler, JavaPredictionModelHandler javaPredictionModelHandler) {
        this.pythonPredictionModelHandler = pythonPredictionModelHandler;
        this.javaPredictionModelHandler = javaPredictionModelHandler;
    }

    public Mono<String> createModelState(JwtSecurityUser user, PredictionMethodParameters parameters, PredictionMethodType modelPredictionMethodType) {
        if (JAVA_PREDICTIONS.contains(modelPredictionMethodType)) {
            return this.javaPredictionModelHandler.createModelState(user, parameters);
        }
        return this.pythonPredictionModelHandler.createModelState(user, parameters);
    }

    public Mono<String> fitModel(JwtSecurityUser user, PredictionMethodParameters parameters, PredictionMethodType modelPredictionMethodType, String state, TimeSeries inputTelemetry, Map<UUID, TimeSeries> additionalTelemetryMap) {
        if (JAVA_PREDICTIONS.contains(modelPredictionMethodType)) {
            return this.javaPredictionModelHandler.fitModel(user, parameters, state, inputTelemetry, additionalTelemetryMap);
        }
        return this.pythonPredictionModelHandler.fitModel(user, parameters, state, inputTelemetry, additionalTelemetryMap);
    }

    public Mono<String> partialFitModel(JwtSecurityUser user, PredictionMethodParameters parameters, PredictionMethodType modelPredictionMethodType, String state, TimeSeries inputTelemetry, Map<UUID, TimeSeries> additionalTelemetryMap) {
        if (JAVA_PREDICTIONS.contains(modelPredictionMethodType)) {
            return this.javaPredictionModelHandler.partialFitModel(user, parameters, state, inputTelemetry, additionalTelemetryMap);
        }
        return this.pythonPredictionModelHandler.partialFitModel(user, parameters, state, inputTelemetry, additionalTelemetryMap);
    }

    public Mono<TimeSeries> predict(JwtSecurityUser user, PredictionMethodParameters parameters, PredictionMethodType modelPredictionMethodType, String state, List<Long> outputX) {
        if (JAVA_PREDICTIONS.contains(modelPredictionMethodType)) {
            return this.javaPredictionModelHandler.predict(user, parameters, state, outputX);
        }
        return this.pythonPredictionModelHandler.predict(user, parameters, state, outputX);
    }
}

