/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.prediction.accuracy;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.thingsboard.trendz.domain.base.TimeSeries;
import org.thingsboard.trendz.service.model.prediction.accuracy.AccuracyData;
import org.thingsboard.trendz.service.model.prediction.accuracy.AccuracyMethodData;
import org.thingsboard.trendz.service.model.prediction.accuracy.AccuracyMethodType;
import org.thingsboard.trendz.service.model.prediction.accuracy.AccuracyResponse;

public class AccuracyResponse {
    private UUID modelId;
    private Set<UUID> itemIdSet;
    private int segmentCount;
    private Map<UUID, Map<Integer, TimeSeries>> itemToSegmentPrehistoricalDataMap;
    private Map<UUID, Map<Integer, TimeSeries>> itemToSegmentHistoricalDataMap;
    private Map<UUID, Map<Integer, TimeSeries>> itemToSegmentPredictionDataMap;
    private Set<AccuracyMethodData> accuracyMethodDataSet;
    private Map<AccuracyMethodType, Map<UUID, AccuracyData>> typeToItemToAccuracyDataMap;

    public AccuracyResponse(AccuracyResponse that) {
        this.modelId = that.modelId;
        this.itemIdSet = that.itemIdSet == null ? null : new HashSet(that.itemIdSet);
        this.segmentCount = that.segmentCount;
        this.itemToSegmentPrehistoricalDataMap = this.copy(that.itemToSegmentPrehistoricalDataMap);
        this.itemToSegmentHistoricalDataMap = this.copy(that.itemToSegmentHistoricalDataMap);
        this.itemToSegmentPredictionDataMap = this.copy(that.itemToSegmentPredictionDataMap);
        this.accuracyMethodDataSet = that.accuracyMethodDataSet == null ? null : that.accuracyMethodDataSet.stream().map(AccuracyMethodData::clone).collect(Collectors.toSet());
        this.typeToItemToAccuracyDataMap = that.typeToItemToAccuracyDataMap == null ? null : that.typeToItemToAccuracyDataMap.entrySet().stream().map(entry1 -> {
            AccuracyMethodType key1 = (AccuracyMethodType)entry1.getKey();
            Map<UUID, AccuracyData> value1 = ((Map)entry1.getValue()).entrySet().stream().map(entry2 -> {
                UUID key2 = (UUID)entry2.getKey();
                AccuracyData value2 = entry2.getValue() == null ? null : new AccuracyData((AccuracyData)entry2.getValue());
                return Map.entry(key2, value2);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return Map.entry(key1, value1);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<UUID, Map<Integer, TimeSeries>> copy(Map<UUID, Map<Integer, TimeSeries>> that) {
        return that == null ? null : that.entrySet().stream().map(entry -> {
            UUID key = (UUID)entry.getKey();
            Map<Integer, TimeSeries> value = entry.getValue() == null ? null : ((Map)entry.getValue()).entrySet().stream().map(entry2 -> {
                Integer key2 = (Integer)entry2.getKey();
                TimeSeries value2 = entry2.getValue() == null ? null : new TimeSeries((TimeSeries)entry2.getValue());
                return Map.entry(key2, value2);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return Map.entry(key, value);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static AccuracyResponseBuilder builder() {
        return new AccuracyResponseBuilder();
    }

    public UUID getModelId() {
        return this.modelId;
    }

    public Set<UUID> getItemIdSet() {
        return this.itemIdSet;
    }

    public int getSegmentCount() {
        return this.segmentCount;
    }

    public Map<UUID, Map<Integer, TimeSeries>> getItemToSegmentPrehistoricalDataMap() {
        return this.itemToSegmentPrehistoricalDataMap;
    }

    public Map<UUID, Map<Integer, TimeSeries>> getItemToSegmentHistoricalDataMap() {
        return this.itemToSegmentHistoricalDataMap;
    }

    public Map<UUID, Map<Integer, TimeSeries>> getItemToSegmentPredictionDataMap() {
        return this.itemToSegmentPredictionDataMap;
    }

    public Set<AccuracyMethodData> getAccuracyMethodDataSet() {
        return this.accuracyMethodDataSet;
    }

    public Map<AccuracyMethodType, Map<UUID, AccuracyData>> getTypeToItemToAccuracyDataMap() {
        return this.typeToItemToAccuracyDataMap;
    }

    public void setModelId(UUID modelId) {
        this.modelId = modelId;
    }

    public void setItemIdSet(Set<UUID> itemIdSet) {
        this.itemIdSet = itemIdSet;
    }

    public void setSegmentCount(int segmentCount) {
        this.segmentCount = segmentCount;
    }

    public void setItemToSegmentPrehistoricalDataMap(Map<UUID, Map<Integer, TimeSeries>> itemToSegmentPrehistoricalDataMap) {
        this.itemToSegmentPrehistoricalDataMap = itemToSegmentPrehistoricalDataMap;
    }

    public void setItemToSegmentHistoricalDataMap(Map<UUID, Map<Integer, TimeSeries>> itemToSegmentHistoricalDataMap) {
        this.itemToSegmentHistoricalDataMap = itemToSegmentHistoricalDataMap;
    }

    public void setItemToSegmentPredictionDataMap(Map<UUID, Map<Integer, TimeSeries>> itemToSegmentPredictionDataMap) {
        this.itemToSegmentPredictionDataMap = itemToSegmentPredictionDataMap;
    }

    public void setAccuracyMethodDataSet(Set<AccuracyMethodData> accuracyMethodDataSet) {
        this.accuracyMethodDataSet = accuracyMethodDataSet;
    }

    public void setTypeToItemToAccuracyDataMap(Map<AccuracyMethodType, Map<UUID, AccuracyData>> typeToItemToAccuracyDataMap) {
        this.typeToItemToAccuracyDataMap = typeToItemToAccuracyDataMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccuracyResponse)) {
            return false;
        }
        AccuracyResponse other = (AccuracyResponse)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getSegmentCount() != other.getSegmentCount()) {
            return false;
        }
        UUID this$modelId = this.getModelId();
        UUID other$modelId = other.getModelId();
        if (this$modelId == null ? other$modelId != null : !((Object)this$modelId).equals(other$modelId)) {
            return false;
        }
        Set this$itemIdSet = this.getItemIdSet();
        Set other$itemIdSet = other.getItemIdSet();
        if (this$itemIdSet == null ? other$itemIdSet != null : !((Object)this$itemIdSet).equals(other$itemIdSet)) {
            return false;
        }
        Map this$itemToSegmentPrehistoricalDataMap = this.getItemToSegmentPrehistoricalDataMap();
        Map other$itemToSegmentPrehistoricalDataMap = other.getItemToSegmentPrehistoricalDataMap();
        if (this$itemToSegmentPrehistoricalDataMap == null ? other$itemToSegmentPrehistoricalDataMap != null : !((Object)this$itemToSegmentPrehistoricalDataMap).equals(other$itemToSegmentPrehistoricalDataMap)) {
            return false;
        }
        Map this$itemToSegmentHistoricalDataMap = this.getItemToSegmentHistoricalDataMap();
        Map other$itemToSegmentHistoricalDataMap = other.getItemToSegmentHistoricalDataMap();
        if (this$itemToSegmentHistoricalDataMap == null ? other$itemToSegmentHistoricalDataMap != null : !((Object)this$itemToSegmentHistoricalDataMap).equals(other$itemToSegmentHistoricalDataMap)) {
            return false;
        }
        Map this$itemToSegmentPredictionDataMap = this.getItemToSegmentPredictionDataMap();
        Map other$itemToSegmentPredictionDataMap = other.getItemToSegmentPredictionDataMap();
        if (this$itemToSegmentPredictionDataMap == null ? other$itemToSegmentPredictionDataMap != null : !((Object)this$itemToSegmentPredictionDataMap).equals(other$itemToSegmentPredictionDataMap)) {
            return false;
        }
        Set this$accuracyMethodDataSet = this.getAccuracyMethodDataSet();
        Set other$accuracyMethodDataSet = other.getAccuracyMethodDataSet();
        if (this$accuracyMethodDataSet == null ? other$accuracyMethodDataSet != null : !((Object)this$accuracyMethodDataSet).equals(other$accuracyMethodDataSet)) {
            return false;
        }
        Map this$typeToItemToAccuracyDataMap = this.getTypeToItemToAccuracyDataMap();
        Map other$typeToItemToAccuracyDataMap = other.getTypeToItemToAccuracyDataMap();
        return !(this$typeToItemToAccuracyDataMap == null ? other$typeToItemToAccuracyDataMap != null : !((Object)this$typeToItemToAccuracyDataMap).equals(other$typeToItemToAccuracyDataMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccuracyResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSegmentCount();
        UUID $modelId = this.getModelId();
        result = result * 59 + ($modelId == null ? 43 : ((Object)$modelId).hashCode());
        Set $itemIdSet = this.getItemIdSet();
        result = result * 59 + ($itemIdSet == null ? 43 : ((Object)$itemIdSet).hashCode());
        Map $itemToSegmentPrehistoricalDataMap = this.getItemToSegmentPrehistoricalDataMap();
        result = result * 59 + ($itemToSegmentPrehistoricalDataMap == null ? 43 : ((Object)$itemToSegmentPrehistoricalDataMap).hashCode());
        Map $itemToSegmentHistoricalDataMap = this.getItemToSegmentHistoricalDataMap();
        result = result * 59 + ($itemToSegmentHistoricalDataMap == null ? 43 : ((Object)$itemToSegmentHistoricalDataMap).hashCode());
        Map $itemToSegmentPredictionDataMap = this.getItemToSegmentPredictionDataMap();
        result = result * 59 + ($itemToSegmentPredictionDataMap == null ? 43 : ((Object)$itemToSegmentPredictionDataMap).hashCode());
        Set $accuracyMethodDataSet = this.getAccuracyMethodDataSet();
        result = result * 59 + ($accuracyMethodDataSet == null ? 43 : ((Object)$accuracyMethodDataSet).hashCode());
        Map $typeToItemToAccuracyDataMap = this.getTypeToItemToAccuracyDataMap();
        result = result * 59 + ($typeToItemToAccuracyDataMap == null ? 43 : ((Object)$typeToItemToAccuracyDataMap).hashCode());
        return result;
    }

    public String toString() {
        return "AccuracyResponse(modelId=" + String.valueOf(this.getModelId()) + ", itemIdSet=" + String.valueOf(this.getItemIdSet()) + ", segmentCount=" + this.getSegmentCount() + ", itemToSegmentPrehistoricalDataMap=" + String.valueOf(this.getItemToSegmentPrehistoricalDataMap()) + ", itemToSegmentHistoricalDataMap=" + String.valueOf(this.getItemToSegmentHistoricalDataMap()) + ", itemToSegmentPredictionDataMap=" + String.valueOf(this.getItemToSegmentPredictionDataMap()) + ", accuracyMethodDataSet=" + String.valueOf(this.getAccuracyMethodDataSet()) + ", typeToItemToAccuracyDataMap=" + String.valueOf(this.getTypeToItemToAccuracyDataMap()) + ")";
    }

    public AccuracyResponse() {
    }

    public AccuracyResponse(UUID modelId, Set<UUID> itemIdSet, int segmentCount, Map<UUID, Map<Integer, TimeSeries>> itemToSegmentPrehistoricalDataMap, Map<UUID, Map<Integer, TimeSeries>> itemToSegmentHistoricalDataMap, Map<UUID, Map<Integer, TimeSeries>> itemToSegmentPredictionDataMap, Set<AccuracyMethodData> accuracyMethodDataSet, Map<AccuracyMethodType, Map<UUID, AccuracyData>> typeToItemToAccuracyDataMap) {
        this.modelId = modelId;
        this.itemIdSet = itemIdSet;
        this.segmentCount = segmentCount;
        this.itemToSegmentPrehistoricalDataMap = itemToSegmentPrehistoricalDataMap;
        this.itemToSegmentHistoricalDataMap = itemToSegmentHistoricalDataMap;
        this.itemToSegmentPredictionDataMap = itemToSegmentPredictionDataMap;
        this.accuracyMethodDataSet = accuracyMethodDataSet;
        this.typeToItemToAccuracyDataMap = typeToItemToAccuracyDataMap;
    }
}

