/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.prediction.accuracy;

import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.service.model.prediction.accuracy.AccuracyMethodData;
import org.thingsboard.trendz.service.model.prediction.accuracy.AccuracyRequest;

public class AccuracyRequest {
    private UUID modelId;
    private Set<ItemLite> itemSet;
    private Set<AccuracyMethodData> accuracyMethodDataSet;
    private boolean autoDefineSettings;

    public AccuracyRequest(AccuracyRequest that) {
        this.modelId = that.modelId;
        this.itemSet = that.itemSet == null ? null : that.itemSet.stream().map(ItemLite::new).collect(Collectors.toSet());
        this.accuracyMethodDataSet = that.accuracyMethodDataSet == null ? null : that.accuracyMethodDataSet.stream().map(AccuracyMethodData::clone).collect(Collectors.toSet());
        this.autoDefineSettings = that.autoDefineSettings;
    }

    public static AccuracyRequestBuilder builder() {
        return new AccuracyRequestBuilder();
    }

    public UUID getModelId() {
        return this.modelId;
    }

    public Set<ItemLite> getItemSet() {
        return this.itemSet;
    }

    public Set<AccuracyMethodData> getAccuracyMethodDataSet() {
        return this.accuracyMethodDataSet;
    }

    public boolean isAutoDefineSettings() {
        return this.autoDefineSettings;
    }

    public void setModelId(UUID modelId) {
        this.modelId = modelId;
    }

    public void setItemSet(Set<ItemLite> itemSet) {
        this.itemSet = itemSet;
    }

    public void setAccuracyMethodDataSet(Set<AccuracyMethodData> accuracyMethodDataSet) {
        this.accuracyMethodDataSet = accuracyMethodDataSet;
    }

    public void setAutoDefineSettings(boolean autoDefineSettings) {
        this.autoDefineSettings = autoDefineSettings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccuracyRequest)) {
            return false;
        }
        AccuracyRequest other = (AccuracyRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isAutoDefineSettings() != other.isAutoDefineSettings()) {
            return false;
        }
        UUID this$modelId = this.getModelId();
        UUID other$modelId = other.getModelId();
        if (this$modelId == null ? other$modelId != null : !((Object)this$modelId).equals(other$modelId)) {
            return false;
        }
        Set this$itemSet = this.getItemSet();
        Set other$itemSet = other.getItemSet();
        if (this$itemSet == null ? other$itemSet != null : !((Object)this$itemSet).equals(other$itemSet)) {
            return false;
        }
        Set this$accuracyMethodDataSet = this.getAccuracyMethodDataSet();
        Set other$accuracyMethodDataSet = other.getAccuracyMethodDataSet();
        return !(this$accuracyMethodDataSet == null ? other$accuracyMethodDataSet != null : !((Object)this$accuracyMethodDataSet).equals(other$accuracyMethodDataSet));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccuracyRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAutoDefineSettings() ? 79 : 97);
        UUID $modelId = this.getModelId();
        result = result * 59 + ($modelId == null ? 43 : ((Object)$modelId).hashCode());
        Set $itemSet = this.getItemSet();
        result = result * 59 + ($itemSet == null ? 43 : ((Object)$itemSet).hashCode());
        Set $accuracyMethodDataSet = this.getAccuracyMethodDataSet();
        result = result * 59 + ($accuracyMethodDataSet == null ? 43 : ((Object)$accuracyMethodDataSet).hashCode());
        return result;
    }

    public String toString() {
        return "AccuracyRequest(modelId=" + String.valueOf(this.getModelId()) + ", itemSet=" + String.valueOf(this.getItemSet()) + ", accuracyMethodDataSet=" + String.valueOf(this.getAccuracyMethodDataSet()) + ", autoDefineSettings=" + this.isAutoDefineSettings() + ")";
    }

    public AccuracyRequest() {
    }

    public AccuracyRequest(UUID modelId, Set<ItemLite> itemSet, Set<AccuracyMethodData> accuracyMethodDataSet, boolean autoDefineSettings) {
        this.modelId = modelId;
        this.itemSet = itemSet;
        this.accuracyMethodDataSet = accuracyMethodDataSet;
        this.autoDefineSettings = autoDefineSettings;
    }
}

