/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.prediction.accuracy;

import org.thingsboard.trendz.service.model.prediction.accuracy.AccuracyMethodConfidenceLevelData;
import org.thingsboard.trendz.service.model.prediction.accuracy.AccuracyMethodData;
import org.thingsboard.trendz.service.model.prediction.accuracy.AccuracyMethodType;

public class AccuracyMethodConfidenceLevelData
implements AccuracyMethodData {
    private final AccuracyMethodType type = AccuracyMethodType.CONFIDENCE_LEVEL;
    private long acceptableTsDistance;
    private double acceptableValueDistance;

    public AccuracyMethodConfidenceLevelData(AccuracyMethodConfidenceLevelData that) {
        this.acceptableTsDistance = that.acceptableTsDistance;
        this.acceptableValueDistance = that.acceptableValueDistance;
    }

    public AccuracyMethodConfidenceLevelData clone() {
        return new AccuracyMethodConfidenceLevelData(this);
    }

    public static AccuracyMethodConfidenceLevelDataBuilder builder() {
        return new AccuracyMethodConfidenceLevelDataBuilder();
    }

    public AccuracyMethodType getType() {
        return this.type;
    }

    public long getAcceptableTsDistance() {
        return this.acceptableTsDistance;
    }

    public double getAcceptableValueDistance() {
        return this.acceptableValueDistance;
    }

    public void setAcceptableTsDistance(long acceptableTsDistance) {
        this.acceptableTsDistance = acceptableTsDistance;
    }

    public void setAcceptableValueDistance(double acceptableValueDistance) {
        this.acceptableValueDistance = acceptableValueDistance;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccuracyMethodConfidenceLevelData)) {
            return false;
        }
        AccuracyMethodConfidenceLevelData other = (AccuracyMethodConfidenceLevelData)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getAcceptableTsDistance() != other.getAcceptableTsDistance()) {
            return false;
        }
        if (Double.compare(this.getAcceptableValueDistance(), other.getAcceptableValueDistance()) != 0) {
            return false;
        }
        AccuracyMethodType this$type = this.getType();
        AccuracyMethodType other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccuracyMethodConfidenceLevelData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $acceptableTsDistance = this.getAcceptableTsDistance();
        result = result * 59 + (int)($acceptableTsDistance >>> 32 ^ $acceptableTsDistance);
        long $acceptableValueDistance = Double.doubleToLongBits(this.getAcceptableValueDistance());
        result = result * 59 + (int)($acceptableValueDistance >>> 32 ^ $acceptableValueDistance);
        AccuracyMethodType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "AccuracyMethodConfidenceLevelData(type=" + String.valueOf(this.getType()) + ", acceptableTsDistance=" + this.getAcceptableTsDistance() + ", acceptableValueDistance=" + this.getAcceptableValueDistance() + ")";
    }

    public AccuracyMethodConfidenceLevelData() {
    }

    public AccuracyMethodConfidenceLevelData(long acceptableTsDistance, double acceptableValueDistance) {
        this.acceptableTsDistance = acceptableTsDistance;
        this.acceptableValueDistance = acceptableValueDistance;
    }
}

