/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.prediction;

import com.google.common.collect.Sets;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.dao.model.prediction.PredictionModelDao;
import org.thingsboard.trendz.dao.model.prediction.PredictionModelLastItemPointDao;
import org.thingsboard.trendz.dao.model.prediction.PredictionModelTaskDataDao;
import org.thingsboard.trendz.dao.model.prediction.segment.SegmentDataDao;
import org.thingsboard.trendz.domain.base.Point;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.domain.base.TimeSeries;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityFieldQuery;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.CacheSettings;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationUnit;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.FilterCondition;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.measurement.MeasurementReport;
import org.thingsboard.trendz.domain.runtime.DataCell;
import org.thingsboard.trendz.domain.runtime.DataRow;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.domain.runtime.ViewReport;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.exception.model.prediction.PredictionModelException;
import org.thingsboard.trendz.exception.model.prediction.PredictionModelNotFoundException;
import org.thingsboard.trendz.exception.model.prediction.PredictionModelNullIdException;
import org.thingsboard.trendz.exception.model.prediction.PredictionModelTaskDataNotFound;
import org.thingsboard.trendz.exception.task.TaskNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.service.AuthenticationService;
import org.thingsboard.trendz.service.definition.BusinessEntityClient;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.definition.ChangeEntityValidationInfo;
import org.thingsboard.trendz.service.definition.TbDataEntry;
import org.thingsboard.trendz.service.model.prediction.PredictionModel;
import org.thingsboard.trendz.service.model.prediction.PredictionModelConfig;
import org.thingsboard.trendz.service.model.prediction.PredictionModelDataset;
import org.thingsboard.trendz.service.model.prediction.PredictionModelDatasourceParameters;
import org.thingsboard.trendz.service.model.prediction.PredictionModelFilteringField;
import org.thingsboard.trendz.service.model.prediction.PredictionModelLite;
import org.thingsboard.trendz.service.model.prediction.PredictionModelParameters;
import org.thingsboard.trendz.service.model.prediction.PredictionModelPartialFitResult;
import org.thingsboard.trendz.service.model.prediction.PredictionModelSortingField;
import org.thingsboard.trendz.service.model.prediction.PredictionModelStatus;
import org.thingsboard.trendz.service.model.prediction.PredictionModelTaskData;
import org.thingsboard.trendz.service.model.prediction.handler.DispatchingPredictionModelHandler;
import org.thingsboard.trendz.service.model.prediction.methods.PredictionMethodParameters;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentData;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationMethodData;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationService;
import org.thingsboard.trendz.service.provider.TbCustomerRelationService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskManagementService;
import org.thingsboard.trendz.service.task.TaskService;
import org.thingsboard.trendz.service.task.job.PredictionModelAccuracyRequestJob;
import org.thingsboard.trendz.service.task.job.PredictionModelRefreshJob;
import org.thingsboard.trendz.service.task.job.PredictionModelTrainingJob;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskConfig;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskReferencedEntityType;
import org.thingsboard.trendz.service.task.model.TaskSchedule;
import org.thingsboard.trendz.service.view.ItemService;
import org.thingsboard.trendz.service.view.ViewBuildingService;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.FillGapSettings;
import org.thingsboard.trendz.service.view.proto.FillGapStrategy;
import org.thingsboard.trendz.tools.DateTimeUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PredictionModelService {
    private static final Logger log = LoggerFactory.getLogger(PredictionModelService.class);
    public static final String PREDICTION_MODEL_FIELD_KEY_PREFIX = "_EPD_";
    public static final int MAX_SEGMENT_COUNT = 100;
    private final PredictionModelDao predictionModelDao;
    private final PredictionModelTaskDataDao predictionModelTaskDataDao;
    private final PredictionModelLastItemPointDao predictionModelLastItemPointDao;
    private final DispatchingPredictionModelHandler predictionModelHandler;
    private final TaskService taskService;
    private final TaskManagementService taskManagementService;
    private final ItemService itemService;
    private final BusinessEntityService businessEntityService;
    private final BusinessEntityClient businessEntityClient;
    private final ViewBuildingService viewBuildingService;
    private final SegmentationService segmentationService;
    private final SegmentDataDao segmentDataDao;
    private final TbCustomerRelationService relationService;
    private final TbRestDataSource tbRestDataSource;
    private final AuthenticationService authenticationService;

    @Autowired
    public PredictionModelService(PredictionModelDao predictionModelDao, PredictionModelTaskDataDao predictionModelTaskDataDao, PredictionModelLastItemPointDao predictionModelLastItemPointDao, DispatchingPredictionModelHandler predictionModelHandler, TaskService taskService, TaskManagementService taskManagementService, ItemService itemService, BusinessEntityService businessEntityService, BusinessEntityClient businessEntityClient, ViewBuildingService viewBuildingService, SegmentationService segmentationService, SegmentDataDao segmentDataDao, TbCustomerRelationService relationService, TbRestDataSource tbRestDataSource, AuthenticationService authenticationService) {
        this.predictionModelDao = predictionModelDao;
        this.predictionModelTaskDataDao = predictionModelTaskDataDao;
        this.predictionModelLastItemPointDao = predictionModelLastItemPointDao;
        this.predictionModelHandler = predictionModelHandler;
        this.taskService = taskService;
        this.taskManagementService = taskManagementService;
        this.tbRestDataSource = tbRestDataSource;
        this.authenticationService = authenticationService;
        this.itemService = itemService;
        this.businessEntityService = businessEntityService;
        this.businessEntityClient = businessEntityClient;
        this.viewBuildingService = viewBuildingService;
        this.segmentationService = segmentationService;
        this.segmentDataDao = segmentDataDao;
        this.relationService = relationService;
    }

    public Page<PredictionModelLite> getAllLite(JwtSecurityUser user, int page, int pageSize, List<PredictionModelFilteringField> filteringFields, List<PredictionModelSortingField> sortingFields) {
        return this.predictionModelDao.getAllLite(user, page, pageSize, filteringFields, sortingFields);
    }

    public List<PredictionModel> getAll(JwtSecurityUser user) {
        return this.predictionModelDao.getAll(user);
    }

    public Optional<PredictionModel> findById(JwtSecurityUser user, UUID id) {
        return this.findById(user, id, false);
    }

    public Optional<PredictionModel> findById(JwtSecurityUser user, UUID id, boolean insecure) {
        if (id == null) {
            throw new PredictionModelNullIdException();
        }
        return this.predictionModelDao.findById(user, id, insecure);
    }

    public void deleteById(JwtSecurityUser user, UUID id) {
        PredictionModel predictionModel = (PredictionModel)this.findById(user, id).orElseThrow(() -> new PredictionModelNotFoundException(id));
        Stream.of(TaskReferencedEntityType.PREDICTION_MODEL_TRAIN, TaskReferencedEntityType.PREDICTION_MODEL_REFRESH, TaskReferencedEntityType.PREDICTION_MODEL_ACCURACY).forEach(entityType -> this.taskManagementService.deleteByTaskReference(user, new TaskReference(entityType, predictionModel.getId().toString())));
        this.deleteAssociatedBusinessEntityField(user, predictionModel);
        this.segmentDataDao.deleteByModelId(predictionModel.getId());
        this.predictionModelLastItemPointDao.deleteAllByModelId(predictionModel.getId());
        this.predictionModelTaskDataDao.delete(id);
        this.predictionModelDao.deleteById(user, id);
    }

    public PredictionModel saveModel(JwtSecurityUser user, PredictionModelConfig config) {
        long now = System.currentTimeMillis();
        this.validateTrainingPredictionRatio(config);
        UUID foundId = this.predictionModelDao.findByTbKey(user, config.getTbTelemetryKey());
        if (foundId != null && !foundId.equals(config.getId())) {
            throw new PredictionModelException("The telemetry key of prediction model is already used.");
        }
        PredictionModelDatasourceParameters dsParameters = config.getDatasourceParameters();
        DateAggregationUnit dateAggregationUnit = DateAggregationType.getDateGroupingFromPicker((String)dsParameters.getAggregationInterval()).mapToUnit();
        dsParameters.setFillGapSettings(new FillGapSettings(true, dateAggregationUnit, FillGapStrategy.LINEAR));
        if (config.getId() == null) {
            PredictionModel model = this.createInitialModel(user, config, now);
            PredictionModel savedModel = this.predictionModelDao.save(model);
            this.predictionModelTaskDataDao.save(PredictionModelTaskData.getDefault((UUID)model.getId()));
            this.createTasks(user, model);
            return savedModel;
        }
        PredictionModel model = (PredictionModel)this.findById(user, config.getId()).orElseThrow(() -> new PredictionModelNotFoundException(config.getId()));
        if (model.getStatus() == PredictionModelStatus.TRAINING) {
            throw new PredictionModelException("Model is already training therefore immutable!");
        }
        this.mapConfig(model, config);
        this.createTasks(user, model);
        return this.predictionModelDao.save(model);
    }

    public PredictionModel importModel(JwtSecurityUser user, PredictionModel model) {
        UUID foundId = this.predictionModelDao.findByTbKey(user, model.getTbTelemetryKey());
        if (foundId != null && !foundId.equals(model.getId())) {
            throw new PredictionModelException("The telemetry key of prediction model is already used.");
        }
        PredictionModel savedModel = this.predictionModelDao.save(model);
        this.predictionModelTaskDataDao.save(PredictionModelTaskData.getDefault((UUID)model.getId()));
        this.createTasks(user, model);
        return savedModel;
    }

    public Mono<PredictionModel> fitModel(JwtSecurityUser user, PredictionModel model, long now, boolean avoidDisabling) {
        log.debug("Model fit: {}. Started.", (Object)model.getName());
        AtomicBoolean fitted = new AtomicBoolean(false);
        return Mono.just((Object)new Object()).flatMap(o -> {
            PredictionModelTaskData taskData = this.getTaskData(user, model.getId());
            taskData.setEnabled(false);
            this.saveTaskData(user, taskData, false);
            model.setEnabled(false);
            this.predictionModelDao.updateStatus(user, model.getId(), PredictionModelStatus.TRAINING);
            model.setStatus(PredictionModelStatus.TRAINING);
            this.segmentDataDao.deleteByModelId(model.getId());
            this.predictionModelLastItemPointDao.deleteAllByModelId(model.getId());
            log.debug("Model fit: {}. Creation default state.", (Object)model.getName());
            return this.predictionModelHandler.createModelState(user, model.getMethodParameters(), model.getType());
        }).flatMap(initialModelState -> {
            PredictionModelParameters modelParameters = model.getModelParameters();
            PredictionModelDatasourceParameters dsParameters = model.getDatasourceParameters();
            ChronoUnit aggregationUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)DateAggregationType.getDateGroupingFromPicker((String)dsParameters.getAggregationInterval()));
            ZoneId zoneId = ZoneId.of(dsParameters.getTzName());
            TimeRange range = new TimeRange(dsParameters.getTrainStartTs(), dsParameters.getTrainEndTs() + 1L);
            UUID businessEntityFieldId = dsParameters.getBusinessEntityFieldId();
            Set requestedItemSet = dsParameters.getItemSet();
            return this.itemService.loadItems(dsParameters.getBusinessEntityId(), requestedItemSet, user).collect(Collectors.toSet()).flatMap(loadedItemSet -> Mono.just((Object)loadedItemSet).flatMapIterable(Function.identity()).flatMap(item -> {
                log.debug("Model fit: {}. Loading input data from telemetry, item = {}, range = {}", new Object[]{item.getName(), model.getName(), range.toString(zoneId)});
                return this.loadInputTelemetry(user, model, Set.of(item.toLite()), range).filter(dataset -> {
                    Map data = (Map)dataset.getData().get(item.getId());
                    TimeSeries historicalTelemetry = (TimeSeries)data.get(businessEntityFieldId);
                    return !historicalTelemetry.isEmpty();
                }).map(dataset -> {
                    Map itemToTelemetryMap = dataset.getData();
                    HashMap telemetryMap = new HashMap((Map)itemToTelemetryMap.get(item.getId()));
                    TimeSeries historicalTelemetry = (TimeSeries)telemetryMap.get(businessEntityFieldId);
                    telemetryMap.remove(businessEntityFieldId);
                    UUID id = dataset.getId();
                    SegmentData fullData = new SegmentData(id, model.getId(), item.toLite(), range, historicalTelemetry, historicalTelemetry, telemetryMap, null);
                    log.debug("Model fit: {}. Created dataset for item = {}", (Object)model.getName(), (Object)item.getName());
                    return fullData;
                }).flatMap(fullData -> {
                    Pair extractionResult = this.extractInitialSegmentData(fullData, modelParameters, zoneId);
                    SegmentData initialSegmentData = (SegmentData)extractionResult.getLeft();
                    SegmentData allSegmentData = (SegmentData)extractionResult.getRight();
                    List segmentDataList = this.splitSegmentData(allSegmentData, aggregationUnit, modelParameters, zoneId);
                    if (initialSegmentData.getHistoricalTelemetry().isEmpty() || segmentDataList.isEmpty()) {
                        return Mono.empty();
                    }
                    log.debug("Model fit: {}, item = {}: Created initial segment = {}", new Object[]{model.getName(), item.getName(), initialSegmentData.getRange().toString(zoneId)});
                    log.debug("Model fit: {}, item = {}: Created {} segments ", new Object[]{model.getName(), item.getName(), segmentDataList.size()});
                    return Mono.just((Object)initialModelState).flatMap(currentState -> {
                        TimeSeries historicalTelemetry = initialSegmentData.getHistoricalTelemetry();
                        Map additionalTelemetries = initialSegmentData.getAdditionalTelemetries();
                        log.debug("Model fit: {}, item = {}: Fitting on the initial segment.", (Object)model.getName(), (Object)item.getName());
                        return this.predictionModelHandler.fitModel(user, model.getMethodParameters(), model.getType(), currentState, historicalTelemetry, additionalTelemetries);
                    }).flatMap(initialFittedState -> {
                        AtomicInteger index = new AtomicInteger(0);
                        AtomicReference<String> currentStateRef = new AtomicReference<String>((String)initialFittedState);
                        return Flux.fromIterable((Iterable)segmentDataList).concatMap(segmentData -> {
                            int segmentIndex = index.incrementAndGet();
                            TimeSeries historicalTelemetry = segmentData.getHistoricalTelemetry();
                            Map additionalTelemetries = segmentData.getAdditionalTelemetries();
                            return Mono.just((Object)((String)currentStateRef.get())).flatMap(currentState -> {
                                List<Long> predictionTsList = historicalTelemetry.getPoints().stream().map(Point::getTs).toList();
                                return this.predictionModelHandler.predict(user, model.getMethodParameters(), model.getType(), currentState, predictionTsList).map(predictionTelemetry -> this.applyConstraints(modelParameters, predictionTelemetry)).map(predictionTelemetry -> {
                                    segmentData.setPredictionTelemetry(predictionTelemetry);
                                    return currentState;
                                });
                            }).flatMap(currentState -> {
                                log.debug("Model fit: {}, item = {}: Fitting on the segment {}/{}.", new Object[]{model.getName(), item.getName(), segmentIndex, segmentDataList.size()});
                                return this.predictionModelHandler.partialFitModel(user, model.getMethodParameters(), model.getType(), currentState, historicalTelemetry, additionalTelemetries);
                            }).doOnNext(currentStateRef::set).doOnNext(currentState -> log.trace("The new state: {}", currentState));
                        }).then(Mono.defer(() -> Mono.just((Object)((String)currentStateRef.get()))));
                    }).doOnNext(finalState -> {
                        int savedSegmentCount = this.segmentDataDao.saveLastSubset(model.getId(), segmentDataList, 100);
                        log.debug("Model fit: {}, item = {}: saved {} segments", new Object[]{model.getName(), item.getName(), savedSegmentCount});
                    }).map(finalState -> Pair.of((Object)item.getId(), (Object)finalState));
                });
            }).switchIfEmpty((Publisher)Flux.error((Throwable)new PredictionModelException("Not enough data for model train"))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight)).flatMap(itemToStateAndLatestMap -> {
                Map<UUID, String> itemToStateMap = itemToStateAndLatestMap.entrySet().stream().map(entry -> Map.entry((UUID)entry.getKey(), (String)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                Map<UUID, Long> itemToLatestMap = itemToStateAndLatestMap.keySet().stream().map(s -> Map.entry(s, range.getEndTs())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                Set trainedItemSet = loadedItemSet.stream().filter(item -> itemToStateMap.containsKey(item.getId())).map(Item::toLite).collect(Collectors.toSet());
                this.predictionModelLastItemPointDao.saveItemToLastPointMap(model.getId(), itemToLatestMap);
                model.setItemIdToStateMap(itemToStateMap);
                model.setUpdatedTs(System.currentTimeMillis());
                model.setTrainedItemsSet(trainedItemSet);
                fitted.set(true);
                return Mono.just((Object)this.predictionModelDao.save(model));
            }));
        }).doOnNext(savedModel -> {
            this.predictionModelDao.updateStatus(user, model.getId(), PredictionModelStatus.READY);
            model.setStatus(PredictionModelStatus.READY);
            if (avoidDisabling) {
                PredictionModelTaskData taskData = this.getTaskData(user, model.getId());
                taskData.setEnabled(true);
                this.saveTaskData(user, taskData, true);
                model.setEnabled(true);
            }
            long finishTs = System.currentTimeMillis();
            log.info("The model was build for next duration: {}", (Object)(finishTs - now));
        }).doOnError(throwable -> {
            log.error("Error during prediction model training", throwable);
            this.predictionModelDao.updateStatus(user, model.getId(), PredictionModelStatus.FAILED);
        }).doOnCancel(() -> {
            if (fitted.get()) {
                model.setStatus(PredictionModelStatus.READY);
            } else {
                model.setItemIdToStateMap(null);
                model.setUpdatedTs(System.currentTimeMillis());
                model.setStatus(PredictionModelStatus.INITIALIZED);
                this.predictionModelLastItemPointDao.deleteAllByModelId(model.getId());
            }
            this.predictionModelDao.save(model);
            log.warn("Prediction model training was cancelled, name = {}", (Object)model.getName());
        });
    }

    public Mono<PredictionModelPartialFitResult> partialFitModel(JwtSecurityUser user, PredictionModel model, ItemLite item, TimeRange requestedRange) {
        log.debug("Model partial fit: {}. Started.", (Object)model.getName());
        PredictionModelParameters modelParameters = model.getModelParameters();
        PredictionModelDatasourceParameters dsParameters = model.getDatasourceParameters();
        TimeRange originalRange = new TimeRange(dsParameters.getTrainStartTs(), dsParameters.getTrainEndTs() + 1L);
        SegmentationMethodData segmentationData = modelParameters.getSegmentationData();
        int segmentUnitCount = modelParameters.getPredictionRangeUnitCount();
        ChronoUnit segmentUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)DateAggregationType.getDateGroupingFromPicker((String)modelParameters.getPredictionRangeUnit()));
        ZoneId zoneId = ZoneId.of(dsParameters.getTzName());
        ZonedDateTime requestedRangeStartDate = DateTimeUtils.fromTs((long)requestedRange.getStartTs(), (ZoneId)zoneId);
        Duration segmentDuration = DateTimeUtils.toDuration((ZonedDateTime)requestedRangeStartDate, (long)segmentUnitCount, (ChronoUnit)segmentUnit);
        Duration stepDuration = this.segmentationService.defineStepDuration(segmentationData, originalRange, requestedRangeStartDate, segmentUnit, segmentUnitCount);
        ChronoUnit aggregationUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)DateAggregationType.getDateGroupingFromPicker((String)dsParameters.getAggregationInterval()));
        log.debug("Model partial fit: {}. Item = {}", (Object)model.getName(), (Object)item.getName());
        log.debug("Model partial fit: {}. Segmentation strategy = {}", (Object)model.getName(), (Object)segmentationData.getType());
        log.debug("Model partial fit: {}. Segment duration = {} {}", new Object[]{model.getName(), DateTimeUtils.fromDuration((ZonedDateTime)requestedRangeStartDate, (Duration)segmentDuration, (ChronoUnit)segmentUnit), segmentUnit});
        log.debug("Model partial fit: {}. Step duration = {} {}", new Object[]{model.getName(), DateTimeUtils.fromDuration((ZonedDateTime)requestedRangeStartDate, (Duration)stepDuration, (ChronoUnit)segmentUnit), segmentUnit});
        log.debug("Model partial fit: {}. Original range = {}", (Object)model.getName(), (Object)originalRange);
        log.debug("Model partial fit: {}. Requested range = {}", (Object)model.getName(), (Object)requestedRange);
        Duration requestedDuration = requestedRange.duration();
        if (requestedDuration.compareTo(stepDuration) < 0) {
            if (stepDuration.minus(requestedDuration).equals(DateTimeUtils.toDuration((ZonedDateTime)requestedRangeStartDate, (long)1L, (ChronoUnit)ChronoUnit.HOURS))) {
                log.warn("The one hour difference was found and suppressed in the range: {}", (Object)requestedRange);
            } else {
                log.debug("Model partial fit: {}. Skip = requested range is smaller then step", (Object)model.getName());
                return Mono.just((Object)new PredictionModelPartialFitResult(item, false, "Requested range is smaller then step", 0L, null));
            }
        }
        TimeRange historicalRange = new TimeRange(requestedRange.getStartTs() - segmentDuration.minus(stepDuration).toMillis(), requestedRange.getEndTs());
        TimeRange prehistoricalRange = this.segmentationService.getPreviousDoubleRange(historicalRange, segmentUnit, segmentUnitCount, zoneId);
        TimeRange loadingRange = new TimeRange(prehistoricalRange.getStartTs(), historicalRange.getEndTs());
        log.debug("Model partial fit: {}. Historical range = {}", (Object)model.getName(), (Object)historicalRange);
        log.debug("Model partial fit: {}. Prehistorical range = {}", (Object)model.getName(), (Object)prehistoricalRange);
        log.debug("Model partial fit: {}. Loading range = {}", (Object)model.getName(), (Object)loadingRange);
        UUID businessEntityFieldId = dsParameters.getBusinessEntityFieldId();
        return Mono.just((Object)new Object()).flatMap(o -> {
            log.debug("Model partial fit: {}. Loading input data from telemetry, range = {}", (Object)model.getName(), (Object)loadingRange);
            return this.loadInputTelemetry(user, model, Set.of(item), loadingRange);
        }).filter(dataset -> {
            Map data = (Map)dataset.getData().get(item.getId());
            TimeSeries historicalTelemetry = (TimeSeries)data.get(businessEntityFieldId);
            return !historicalTelemetry.isEmpty();
        }).map(dataset -> {
            Map datasetData = dataset.getData();
            HashMap telemetryMap = new HashMap((Map)datasetData.get(item.getId()));
            TimeSeries historicalTelemetry = (TimeSeries)telemetryMap.get(businessEntityFieldId);
            telemetryMap.remove(businessEntityFieldId);
            UUID id = dataset.getId();
            SegmentData fullData = new SegmentData(id, model.getId(), item, loadingRange, historicalTelemetry, historicalTelemetry, telemetryMap, null);
            SegmentData preparedData = this.filterSegmentData(prehistoricalRange, historicalRange, fullData);
            log.debug("Model partial fit: {}. Created dataset for item = {}", (Object)model.getName(), (Object)item.getName());
            return preparedData;
        }).flatMap(preparedData -> {
            List segmentDataList = this.splitSegmentData(preparedData, aggregationUnit, modelParameters, zoneId);
            long lastSegmentEndTs = segmentDataList.stream().max(Comparable::compareTo).map(SegmentData::getRange).map(TimeRange::getEndTs).orElseThrow();
            log.debug("Model partial fit: {}, item = {}: Created {} segments ", new Object[]{model.getName(), item.getName(), segmentDataList.size()});
            String oldState = (String)model.getItemIdToStateMap().get(item.getId());
            Mono state = Mono.just((Object)oldState);
            int i = 0;
            while (i < segmentDataList.size()) {
                int segmentIndex = i++;
                SegmentData segmentData = (SegmentData)segmentDataList.get(segmentIndex);
                TimeSeries historicalTelemetry = segmentData.getHistoricalTelemetry();
                Map additionalTelemetries = segmentData.getAdditionalTelemetries();
                state = state.flatMap(currentState -> {
                    List<Long> predictionTsList = historicalTelemetry.getPoints().stream().map(Point::getTs).toList();
                    return this.predictionModelHandler.predict(user, model.getMethodParameters(), model.getType(), currentState, predictionTsList).map(predictionTelemetry -> this.applyConstraints(modelParameters, predictionTelemetry)).map(predictionTelemetry -> {
                        segmentData.setPredictionTelemetry(predictionTelemetry);
                        return currentState;
                    });
                }).flatMap(currentState -> {
                    log.debug("Model partial fit: {}, item = {}: Fitting on the segment {}/{}.", new Object[]{model.getName(), item.getName(), segmentIndex + 1, segmentDataList.size()});
                    return this.predictionModelHandler.partialFitModel(user, model.getMethodParameters(), model.getType(), currentState, historicalTelemetry, additionalTelemetries);
                });
            }
            return state.doOnNext(newState -> {
                int savedSegmentCount = this.segmentDataDao.saveLastSubset(model.getId(), segmentDataList, 100);
                log.debug("Model partial fit: {}, item = {}: saved {} segments", new Object[]{model.getName(), item.getName(), savedSegmentCount});
                Map itemIdToStateMap = model.getItemIdToStateMap();
                itemIdToStateMap.put(item.getId(), newState);
                model.setUpdatedTs(System.currentTimeMillis());
                this.predictionModelDao.save(model);
            }).map(newState -> new PredictionModelPartialFitResult(item, true, "Partial fit was successfully finished", lastSegmentEndTs, preparedData));
        }).defaultIfEmpty((Object)new PredictionModelPartialFitResult(item, true, "Not enough data for model partial fit", requestedRange.getEndTs(), null));
    }

    public Mono<TimeSeries> makePrediction(JwtSecurityUser user, PredictionModel model, ItemLite item, TimeRange predictionTimeRange) {
        PredictionModelDatasourceParameters datasourceParameters = model.getDatasourceParameters();
        return Mono.just((Object)new Object()).flatMap(o -> {
            if (!model.getTrainedItemsSet().contains(item)) {
                throw new TrendzException("Cannot predict on un-trained model for item [%s]".formatted(item.getName()));
            }
            PredictionMethodParameters parameters = model.getMethodParameters();
            String state = (String)model.getItemIdToStateMap().get(item.getId());
            ZoneId zoneId = ZoneId.of(datasourceParameters.getTzName());
            DateAggregationUnit aggregationUnit = DateAggregationType.getDateGroupingFromPicker((String)datasourceParameters.getAggregationInterval()).mapToUnit();
            List predictionTsList = predictionTimeRange.makeTsList(aggregationUnit, zoneId);
            if (predictionTsList.isEmpty()) {
                return Mono.just((Object)new TimeSeries());
            }
            return this.predictionModelHandler.predict(user, parameters, model.getType(), state, predictionTsList);
        }).map(prediction -> {
            PredictionModelParameters modelParameters = model.getModelParameters();
            TimeSeries preparedPrediction = this.applyConstraints(modelParameters, prediction);
            preparedPrediction.sort();
            return preparedPrediction;
        });
    }

    public Mono<Map<UUID, Long>> loadLatestTelemetry(JwtSecurityUser user, PredictionModel model, Set<ItemLite> itemSet) {
        return Mono.just((Object)new Object()).flatMap(o -> {
            PredictionModelDatasourceParameters datasourceParameters = model.getDatasourceParameters();
            UUID itemFieldId = TimeStampUUIDGenerator.generateId();
            UUID dateFieldId = TimeStampUUIDGenerator.generateId();
            ViewConfig viewConfig = this.makeViewConfigForLatestLoading(user, dateFieldId, itemFieldId, model.getName(), datasourceParameters, itemSet);
            return Mono.just((Object)new Object()).flatMap(o2 -> this.viewBuildingService.buildView(viewConfig, user, new MeasurementReport())).map(tuple -> {
                ViewReport viewReport = tuple.getViewReport();
                ViewContext viewContext = tuple.getViewContext();
                Map<UUID, ItemLite> itemMap = viewContext.getIdToItemMap().entrySet().stream().map(entry -> {
                    UUID itemId = (UUID)entry.getKey();
                    ItemLite item = ((Item)entry.getValue()).toLite();
                    return Map.entry(itemId, item);
                }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                Map<String, UUID> itemNameMap = itemMap.values().stream().collect(Collectors.toMap(ItemLite::getName, ItemLite::getId));
                HashMap<UUID, Long> itemToLastPointMap = new HashMap<UUID, Long>();
                for (DataRow row : viewReport.getRows()) {
                    Map<UUID, Object> cellMap = row.getCells().stream().filter(dataCell -> Objects.nonNull(dataCell.getData())).collect(Collectors.toMap(DataCell::getViewFieldId, DataCell::getData));
                    String itemName = (String)cellMap.get(itemFieldId);
                    UUID itemId = itemNameMap.get(itemName);
                    String dateStr = (String)cellMap.get(dateFieldId);
                    if (dateStr == null) continue;
                    long ts = Long.parseLong(dateStr);
                    itemToLastPointMap.put(itemId, ts);
                }
                return itemToLastPointMap;
            });
        });
    }

    public TimeRange defineRangePartialFit(@NotNull PredictionModel model, long lastUsedTs, long lastPresentTs, long now) {
        ZonedDateTime limitLeft;
        PredictionModelParameters modelParameters = model.getModelParameters();
        PredictionModelDatasourceParameters dsParameters = model.getDatasourceParameters();
        ZoneId zoneId = ZoneId.of(dsParameters.getTzName());
        int predictionTimeUnitCount = modelParameters.getPredictionRangeUnitCount();
        ChronoUnit predictionTimeUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)DateAggregationType.getDateGroupingFromPicker((String)modelParameters.getPredictionRangeUnit()));
        ZonedDateTime nowDate = DateTimeUtils.fromTs((long)now, (ZoneId)zoneId);
        ZonedDateTime truncatedNowDate = DateTimeUtils.extendedTruncateTo((ZonedDateTime)nowDate, (ChronoUnit)predictionTimeUnit);
        ZonedDateTime lastPresentDate = DateTimeUtils.fromTs((long)lastPresentTs, (ZoneId)zoneId);
        ZonedDateTime truncatedLastPresentDate = DateTimeUtils.extendedTruncateTo((ZonedDateTime)lastPresentDate, (ChronoUnit)predictionTimeUnit);
        ZonedDateTime limitRight = DateTimeUtils.min((ZonedDateTime)truncatedLastPresentDate, (ZonedDateTime)truncatedNowDate);
        ZonedDateTime lastUsedDate = DateTimeUtils.fromTs((long)lastUsedTs, (ZoneId)zoneId);
        ZonedDateTime truncatedLastUsedDate = DateTimeUtils.extendedTruncateTo((ZonedDateTime)lastUsedDate, (ChronoUnit)predictionTimeUnit);
        ZonedDateTime truncatedStartDate = limitLeft = DateTimeUtils.min((ZonedDateTime)truncatedLastUsedDate, (ZonedDateTime)truncatedNowDate);
        ZonedDateTime truncatedEndDate = DateTimeUtils.min((ZonedDateTime)limitLeft.plus(predictionTimeUnitCount, predictionTimeUnit), (ZonedDateTime)limitRight);
        return truncatedEndDate.isBefore(truncatedStartDate) ? new TimeRange() : new TimeRange(DateTimeUtils.toTs((ZonedDateTime)truncatedStartDate), DateTimeUtils.toTs((ZonedDateTime)truncatedEndDate));
    }

    public TimeRange defineRangePrediction(PredictionModel model, long lastUsedTs, long lastPresentTs, long now) {
        PredictionModelParameters modelParameters = model.getModelParameters();
        PredictionModelDatasourceParameters dsParameters = model.getDatasourceParameters();
        ZoneId zoneId = ZoneId.of(dsParameters.getTzName());
        int predictionTimeUnitCount = modelParameters.getPredictionRangeUnitCount();
        ChronoUnit predictionTimeUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)DateAggregationType.getDateGroupingFromPicker((String)modelParameters.getPredictionRangeUnit()));
        ZonedDateTime nowDate = DateTimeUtils.fromTs((long)now, (ZoneId)zoneId);
        ZonedDateTime truncatedNowDate = DateTimeUtils.extendedTruncateTo((ZonedDateTime)nowDate, (ChronoUnit)predictionTimeUnit);
        ZonedDateTime lastUsedDate = DateTimeUtils.extendedTruncateTo((ZonedDateTime)DateTimeUtils.fromTs((long)lastUsedTs, (ZoneId)zoneId), (ChronoUnit)predictionTimeUnit);
        ZonedDateTime lastPresentDate = DateTimeUtils.extendedTruncateTo((ZonedDateTime)DateTimeUtils.fromTs((long)lastPresentTs, (ZoneId)zoneId), (ChronoUnit)predictionTimeUnit);
        ZonedDateTime truncatedStartDate = DateTimeUtils.min((ZonedDateTime)lastUsedDate, (ZonedDateTime)lastPresentDate);
        ZonedDateTime truncatedEndDate = DateTimeUtils.min((ZonedDateTime)truncatedNowDate, (ZonedDateTime)truncatedStartDate.plus(predictionTimeUnitCount, predictionTimeUnit)).plus(predictionTimeUnitCount, predictionTimeUnit);
        TimeRange result = new TimeRange(DateTimeUtils.toTs((ZonedDateTime)truncatedStartDate), DateTimeUtils.toTs((ZonedDateTime)truncatedEndDate));
        return result;
    }

    public Mono<Boolean> sendTelemetryToTb(JwtSecurityUser user, UUID businessEntityId, String tbKey, ItemLite item, TimeSeries timeSeries) {
        log.info("Sending prediction telemetry to TB: {}, item = {}, point count = {}, time range: {}", new Object[]{tbKey, item.getName(), timeSeries.getPoints().size(), timeSeries.getTimeRange()});
        if (timeSeries.isEmpty()) {
            throw new IllegalArgumentException("The timeSeries is empty");
        }
        List dataEntries = timeSeries.getPoints().stream().map(point -> new TbDataEntry(point.getTs(), Map.of(tbKey, point.getValue()))).sorted(Comparator.comparing(TbDataEntry::getTs)).collect(Collectors.toList());
        BusinessEntity businessEntity = (BusinessEntity)this.businessEntityService.findEntityById(user, businessEntityId).orElseThrow();
        BusinessEntityType entityType = businessEntity.getQuery().getEntityType();
        String jwtToken = this.authenticationService.getToken(user);
        return this.tbRestDataSource.sendTelemetryDirectly(null, entityType.name(), item.getId(), jwtToken, dataEntries);
    }

    public PredictionModelTaskData getTaskData(JwtSecurityUser user, UUID modelId) {
        PredictionModel model = (PredictionModel)this.findById(user, modelId).orElseThrow(() -> new PredictionModelNotFoundException(modelId));
        PredictionModelTaskData taskData = (PredictionModelTaskData)this.predictionModelTaskDataDao.findById(modelId).orElseThrow(() -> new PredictionModelTaskDataNotFound(modelId));
        TaskReference reference = new TaskReference(TaskReferencedEntityType.PREDICTION_MODEL_REFRESH, modelId.toString());
        long schedulingTime = (Long)this.taskService.getTaskSchedulingTime(user, reference).orElseThrow(() -> new TaskNotFoundException(modelId));
        taskData.setSchedulingTime(schedulingTime);
        return taskData;
    }

    public PredictionModelTaskData saveTaskData(JwtSecurityUser user, PredictionModelTaskData taskData, boolean reset) {
        UUID modelId = taskData.getPredictionModelId();
        PredictionModel model = (PredictionModel)this.findById(user, modelId).orElseThrow(() -> new PredictionModelNotFoundException(modelId));
        if (model.getStatus() == PredictionModelStatus.TRAINING) {
            throw new PredictionModelException("The prediction model task data can not be changed during training");
        }
        TaskReference taskReference = new TaskReference(TaskReferencedEntityType.PREDICTION_MODEL_REFRESH, modelId.toString());
        Task task = (Task)this.taskService.findTaskByReferencedEntity(user, taskReference).orElseThrow(() -> new TaskNotFoundException(taskReference));
        PredictionModelRefreshJob job = PredictionModelRefreshJob.builder().predictionModelId(taskData.getPredictionModelId()).itemSet(taskData.getItemSet()).enabledPartialFit(taskData.isEnabledPartialFit()).build();
        TaskSchedule schedule = this.taskService.makeSchedulingConfig(taskData.getRefreshTimeUnitCount(), taskData.getRefreshTimeUnit(), taskData.isRefreshTimeUnitTruncated(), model.getDatasourceParameters().getTzName());
        TaskConfig taskConfig = TaskConfig.builder().id(task.getId()).name(task.getName()).enabled(Boolean.valueOf(taskData.isEnabled())).schedule(schedule).reference(taskReference).job((TaskJob)job).build();
        Task updated = this.taskService.updateTask(user, taskConfig);
        this.updateEnabling(user, model, taskData.isEnabled());
        if (reset) {
            this.taskService.resetTaskScheduling(user, task.getId());
        }
        return this.predictionModelTaskDataDao.save(taskData);
    }

    public void updateEnabling(JwtSecurityUser user, PredictionModel model, boolean enabled) {
        if (enabled) {
            this.createAssociatedBusinessEntityField(user, model);
        } else {
            this.deleteAssociatedBusinessEntityField(user, model);
        }
        this.predictionModelDao.updateEnabling(user, model.getId(), enabled);
    }

    public Optional<PredictionModel> findFieldByEntityFieldId(UUID entityFieldId, JwtSecurityUser user) {
        return this.findFieldByEntityFieldId(entityFieldId, user, false);
    }

    public Optional<PredictionModel> findFieldByEntityFieldId(UUID entityFieldId, JwtSecurityUser user, boolean insecure) {
        return this.predictionModelDao.getByEntityFieldId(entityFieldId, user, insecure);
    }

    public ChangeEntityValidationInfo findDependedEntities(JwtSecurityUser user, UUID fieldId) {
        PredictionModel field = (PredictionModel)this.findById(user, fieldId).orElseThrow(() -> new PredictionModelNotFoundException(fieldId));
        Set subCustomers = this.relationService.getAllSubCustomerIds(user);
        return this.predictionModelDao.findDependedEntities(user, fieldId, subCustomers);
    }

    private PredictionModel createInitialModel(JwtSecurityUser user, PredictionModelConfig config, long now) {
        return PredictionModel.builder().id(TimeStampUUIDGenerator.generateId()).tenantId(user.getTenantId()).customerId(user.getCustomerId()).name(config.getName()).enabled(false).partialFitEnabled(false).createdTs(now).updatedTs(now).status(PredictionModelStatus.INITIALIZED).type(config.getType()).methodParameters(config.getMethodParameters()).tbTelemetryKey(config.getTbTelemetryKey()).datasourceParameters(new PredictionModelDatasourceParameters(config.getDatasourceParameters())).modelParameters(new PredictionModelParameters(config.getModelParameters())).associatedBusinessEntityFieldId(TimeStampUUIDGenerator.generateId()).itemIdToStateMap(new HashMap()).build();
    }

    private void mapConfig(PredictionModel model, PredictionModelConfig config) {
        model.setName(config.getName());
        model.setType(config.getType());
        model.setMethodParameters(config.getMethodParameters());
        model.setTbTelemetryKey(config.getTbTelemetryKey());
        model.setDatasourceParameters(new PredictionModelDatasourceParameters(config.getDatasourceParameters()));
        model.setModelParameters(new PredictionModelParameters(config.getModelParameters()));
    }

    private void createTasks(JwtSecurityUser user, PredictionModel model) {
        this.createModelCreationTask(user, model);
        this.createModelRefreshTask(user, model);
        this.createModelAccuracyRequestTask(user, model);
    }

    private void createModelCreationTask(JwtSecurityUser user, PredictionModel model) {
        TaskReference reference = new TaskReference(TaskReferencedEntityType.PREDICTION_MODEL_TRAIN, model.getId().toString());
        PredictionModelTrainingJob taskJob = PredictionModelTrainingJob.builder().modelId(model.getId()).avoidDisabling(model.isAvoidDisabling()).build();
        String taskName = "Prediction model, create: " + model.getName();
        this.taskManagementService.createOrUpdateTask(user, reference, taskName, (TaskJob)taskJob);
    }

    private void createModelRefreshTask(JwtSecurityUser user, PredictionModel model) {
        TaskReference reference = new TaskReference(TaskReferencedEntityType.PREDICTION_MODEL_REFRESH, model.getId().toString());
        PredictionModelTaskData defaultData = PredictionModelTaskData.getDefault((UUID)model.getId());
        PredictionModelRefreshJob taskJob = PredictionModelRefreshJob.builder().predictionModelId(defaultData.getPredictionModelId()).itemSet(defaultData.getItemSet()).enabledPartialFit(false).build();
        String taskName = "Prediction model, refresh: " + model.getName();
        this.taskManagementService.createOrUpdateTask(user, reference, taskName, (TaskJob)taskJob);
    }

    private void createModelAccuracyRequestTask(JwtSecurityUser user, PredictionModel model) {
        TaskReference reference = new TaskReference(TaskReferencedEntityType.PREDICTION_MODEL_ACCURACY, model.getId().toString());
        PredictionModelAccuracyRequestJob taskJob = PredictionModelAccuracyRequestJob.builder().modelId(model.getId()).itemSet(Collections.emptySet()).accuracyMethodDataSet(Collections.emptySet()).autoDefineSettings(true).build();
        String name = "Prediction model, accuracy: " + model.getName();
        this.taskManagementService.createOrUpdateTask(user, reference, name, (TaskJob)taskJob);
    }

    private void createAssociatedBusinessEntityField(JwtSecurityUser user, PredictionModel model) {
        String queryKey = PredictionModelService.createTbKey((String)model.getTbTelemetryKey());
        UUID businessEntityId = model.getDatasourceParameters().getBusinessEntityId();
        BusinessEntityField entityField = BusinessEntityField.builder().id(model.getAssociatedBusinessEntityFieldId()).businessEntityId(businessEntityId).name(model.getName()).description("Telemetry field of prediction model created by Trendz.").hidden(false).type(FieldType.NUMERIC).query(PredictionModelService.createTbQuery((String)queryKey)).build();
        BusinessEntity businessEntity = (BusinessEntity)this.businessEntityService.findEntityById(user, businessEntityId).orElseThrow();
        businessEntity.getFields().add(entityField);
        this.businessEntityService.saveEntity(user, businessEntity);
    }

    private void deleteAssociatedBusinessEntityField(JwtSecurityUser user, PredictionModel model) {
        this.businessEntityClient.deleteBusinessEntityFieldById(user, model.getDatasourceParameters().getBusinessEntityId(), model.getAssociatedBusinessEntityFieldId());
    }

    private ViewConfig makeViewConfigForLatestLoading(JwtSecurityUser user, UUID dateFieldId, UUID itemFieldId, String name, PredictionModelDatasourceParameters datasourceParameters, Set<ItemLite> itemSet) {
        UUID businessEntityId = datasourceParameters.getBusinessEntityId();
        UUID businessEntityFieldId = datasourceParameters.getBusinessEntityFieldId();
        Set itemNameSet = itemSet.stream().map(ItemLite::getName).collect(Collectors.toSet());
        BusinessEntity businessEntity = (BusinessEntity)this.businessEntityService.findEntityById(user, businessEntityId).orElseThrow();
        BusinessEntityField nameEntityField = businessEntity.getFields().stream().filter(entityField -> FieldQueryType.ENTITY_NAME.equals((Object)entityField.getQuery().getQueryType())).findAny().orElseThrow();
        ViewConfig config = new ViewConfig();
        config.setName("Prediction Model fit config: " + name);
        config.setDatePickerConfig(new DatePickerConfig(1L, 2L, "minute"));
        config.setTzName(datasourceParameters.getTzName());
        ViewField dateField = new ViewField();
        dateField.setId(dateFieldId);
        dateField.setLabel("Date (RAW)");
        dateField.setVirtualDateField(true);
        dateField.setDateGrouping(DateAggregationType.RAW);
        ViewField latestTelemetryField = new ViewField();
        latestTelemetryField.setId(businessEntityFieldId);
        latestTelemetryField.setLabel("Latest telemetry field");
        latestTelemetryField.setBusinessEntityId(businessEntityId);
        latestTelemetryField.setEntityFieldId(businessEntityFieldId);
        latestTelemetryField.setAggregationType(FieldAggregation.LATEST);
        latestTelemetryField.setFillGapSettings(FillGapSettings.getDefaultSettings());
        ViewField filterField = new ViewField();
        filterField.setId(itemFieldId);
        filterField.setLabel("Filter field");
        filterField.setBusinessEntityId(businessEntityId);
        filterField.setEntityFieldId(nameEntityField.getId());
        filterField.setAggregationType(FieldAggregation.UNIQ);
        RuntimeFilterField runtimeFilterField = new RuntimeFilterField();
        runtimeFilterField.setName("Filter");
        runtimeFilterField.setViewFieldId(filterField.getId());
        runtimeFilterField.setCondition(FilterCondition.ONE_OF);
        runtimeFilterField.setOptions(itemNameSet);
        runtimeFilterField.setSelection(itemNameSet);
        config.getXAxis().add(filterField);
        config.getXAxis().add(latestTelemetryField);
        config.getXAxis().add(dateField);
        config.getRuntimeFilters().add(runtimeFilterField);
        config.setCacheSettings(CacheSettings.noCaching());
        return config;
    }

    private Mono<PredictionModelDataset> loadInputTelemetry(JwtSecurityUser user, PredictionModel model, Set<ItemLite> itemSet, TimeRange range) {
        return Mono.just((Object)new Object()).flatMap(o -> {
            PredictionModelDatasourceParameters datasourceParameters = model.getDatasourceParameters();
            UUID dateFieldId = TimeStampUUIDGenerator.generateId();
            UUID itemFieldId = TimeStampUUIDGenerator.generateId();
            UUID businessEntityFieldId = datasourceParameters.getBusinessEntityFieldId();
            PredictionMethodParameters methodParameters = model.getMethodParameters();
            boolean multiVariable = methodParameters.isMultiVariable();
            Set variableReferences = methodParameters.getVariableReferences();
            ViewConfig viewConfig = this.makeViewConfigForTelemetryLoading(user, dateFieldId, itemFieldId, model.getName(), datasourceParameters, range.getStartTs(), range.getEndTs() - 1L, itemSet, multiVariable, variableReferences);
            return Mono.just((Object)new Object()).flatMap(o2 -> this.viewBuildingService.buildView(viewConfig, user, new MeasurementReport())).map(tuple -> {
                ViewReport viewReport = tuple.getViewReport();
                ViewContext viewContext = tuple.getViewContext();
                Map<UUID, ItemLite> itemMap = viewContext.getIdToItemMap().entrySet().stream().map(entry -> {
                    UUID itemId = (UUID)entry.getKey();
                    ItemLite item = ((Item)entry.getValue()).toLite();
                    return Map.entry(itemId, item);
                }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                Map itemToTelemetryToPointListMap = this.extractTelemetryFromViewReport(viewReport, itemMap, dateFieldId, itemFieldId, businessEntityFieldId, multiVariable, variableReferences);
                Map<UUID, Map> data = itemToTelemetryToPointListMap.entrySet().stream().map(entry1 -> {
                    UUID itemId = (UUID)entry1.getKey();
                    Map telemetryToPointListMap = (Map)entry1.getValue();
                    Map<UUID, TimeSeries> timeSeriesMap = telemetryToPointListMap.entrySet().stream().map(entry2 -> Map.entry((UUID)entry2.getKey(), new TimeSeries((List)entry2.getValue()))).peek(entry -> ((TimeSeries)entry.getValue()).sort()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    return Map.entry(itemId, timeSeriesMap);
                }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                return PredictionModelDataset.builder().id(TimeStampUUIDGenerator.generateId()).modelId(model.getId()).itemMap(itemMap).data(data).build();
            });
        });
    }

    private ViewConfig makeViewConfigForTelemetryLoading(JwtSecurityUser user, UUID dateFieldId, UUID itemFieldId, String name, PredictionModelDatasourceParameters datasourceParameters, long startTs, long endTs, Set<ItemLite> itemSet, boolean multiVariable, Set<UUID> variableReferences) {
        UUID businessEntityId = datasourceParameters.getBusinessEntityId();
        UUID businessEntityFieldId = datasourceParameters.getBusinessEntityFieldId();
        Set itemNameSet = itemSet.stream().map(ItemLite::getName).collect(Collectors.toSet());
        BusinessEntity businessEntity = (BusinessEntity)this.businessEntityService.findEntityById(user, businessEntityId).orElseThrow();
        BusinessEntityField nameEntityField = businessEntity.getFields().stream().filter(entityField -> FieldQueryType.ENTITY_NAME.equals((Object)entityField.getQuery().getQueryType())).findAny().orElseThrow();
        ViewConfig config = new ViewConfig();
        config.setName("Prediction Model fit config: " + name);
        config.setDatePickerConfig(new DatePickerConfig(startTs, endTs, datasourceParameters.getAggregationInterval()));
        config.setTzName(datasourceParameters.getTzName());
        ViewField dateField = new ViewField();
        dateField.setId(dateFieldId);
        dateField.setLabel("Date (RAW)");
        dateField.setVirtualDateField(true);
        dateField.setDateGrouping(DateAggregationType.RAW);
        ViewField telemetryField = new ViewField();
        telemetryField.setId(businessEntityFieldId);
        telemetryField.setLabel("Telemetry field");
        telemetryField.setBusinessEntityId(businessEntityId);
        telemetryField.setEntityFieldId(businessEntityFieldId);
        telemetryField.setAggregationType(datasourceParameters.getAggregationType());
        telemetryField.setFillGapSettings(datasourceParameters.getFillGapSettings());
        ViewField filterField = new ViewField();
        filterField.setId(itemFieldId);
        filterField.setLabel("Filter field");
        filterField.setBusinessEntityId(businessEntityId);
        filterField.setEntityFieldId(nameEntityField.getId());
        filterField.setAggregationType(FieldAggregation.UNIQ);
        RuntimeFilterField runtimeFilterField = new RuntimeFilterField();
        runtimeFilterField.setName("Filter");
        runtimeFilterField.setViewFieldId(filterField.getId());
        runtimeFilterField.setCondition(FilterCondition.ONE_OF);
        runtimeFilterField.setOptions(itemNameSet);
        runtimeFilterField.setSelection(itemNameSet);
        config.getXAxis().add(dateField);
        config.getXAxis().add(filterField);
        config.getXAxis().add(telemetryField);
        config.getRuntimeFilters().add(runtimeFilterField);
        if (multiVariable) {
            for (UUID referenceId : variableReferences) {
                ViewField field = new ViewField();
                field.setId(referenceId);
                field.setLabel("Additional telemetry field");
                field.setBusinessEntityId(businessEntityId);
                field.setEntityFieldId(referenceId);
                field.setAggregationType(datasourceParameters.getAggregationType());
                field.setFillGapSettings(datasourceParameters.getFillGapSettings());
                config.getXAxis().add(field);
            }
        }
        return config;
    }

    private Map<UUID, Map<UUID, List<Point>>> extractTelemetryFromViewReport(ViewReport viewReport, Map<UUID, ItemLite> itemMap, UUID dateFieldId, UUID itemFieldId, UUID telemetryFieldId, boolean multiVariable, Set<UUID> variableReferences) {
        HashMap<UUID, Map<UUID, List<Point>>> itemToTelemetryToPointListMap = new HashMap<UUID, Map<UUID, List<Point>>>();
        Map<String, UUID> itemNameMap = itemMap.values().stream().collect(Collectors.toMap(ItemLite::getName, ItemLite::getId));
        Sets.SetView telemetryIdSet = multiVariable ? Sets.union(Set.of(telemetryFieldId), variableReferences) : Set.of(telemetryFieldId);
        for (DataRow row : viewReport.getRows()) {
            Map<UUID, Object> cellMap = row.getCells().stream().filter(dataCell -> Objects.nonNull(dataCell.getData())).collect(Collectors.toMap(DataCell::getViewFieldId, DataCell::getData));
            String itemName = (String)cellMap.get(itemFieldId);
            UUID itemId = itemNameMap.get(itemName);
            Map telemetryMap = itemToTelemetryToPointListMap.computeIfAbsent(itemId, k -> new HashMap());
            for (UUID telemetryId : telemetryIdSet) {
                List pointList = telemetryMap.computeIfAbsent(telemetryId, key -> new ArrayList());
                if (!cellMap.containsKey(telemetryId)) continue;
                long tsValue = Long.parseLong(cellMap.get(dateFieldId).toString());
                double dataValue = Double.parseDouble(cellMap.get(telemetryId).toString());
                pointList.add(new Point(tsValue, dataValue));
            }
        }
        return itemToTelemetryToPointListMap;
    }

    private Pair<SegmentData, SegmentData> extractInitialSegmentData(SegmentData fullItemData, PredictionModelParameters modelParameters, ZoneId zoneId) {
        SegmentData allSegmentData;
        SegmentData initialSegmentData;
        TimeRange allSegmentRange;
        SegmentationMethodData segmentationData = modelParameters.getSegmentationData();
        int segmentUnitCount = modelParameters.getPredictionRangeUnitCount();
        ChronoUnit segmentUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)DateAggregationType.getDateGroupingFromPicker((String)modelParameters.getPredictionRangeUnit()));
        TimeRange currentRange = fullItemData.getRange();
        do {
            TimeRange initialSegmentRange = this.segmentationService.defineInitialSegmentRange(segmentationData, currentRange, segmentUnit, segmentUnitCount, zoneId);
            allSegmentRange = this.segmentationService.defineAllSegmentRange(segmentationData, currentRange, segmentUnit, segmentUnitCount, zoneId);
            initialSegmentData = this.filterSegmentData(TimeRange.zero(), initialSegmentRange, fullItemData);
            allSegmentData = this.filterSegmentData(allSegmentRange, allSegmentRange, fullItemData);
        } while (!(currentRange = allSegmentRange).duration().isZero() && initialSegmentData.getHistoricalTelemetry().isEmpty());
        return Pair.of((Object)initialSegmentData, (Object)allSegmentData);
    }

    private List<SegmentData> splitSegmentData(SegmentData fullItemData, ChronoUnit aggregationUnit, PredictionModelParameters modelParameters, ZoneId zoneId) {
        SegmentationMethodData segmentationData = modelParameters.getSegmentationData();
        int segmentUnitCount = modelParameters.getPredictionRangeUnitCount();
        ChronoUnit segmentUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)DateAggregationType.getDateGroupingFromPicker((String)modelParameters.getPredictionRangeUnit()));
        TimeRange fullRange = fullItemData.getRange();
        Set segmentRangeList = this.segmentationService.makeSegments(segmentationData, fullRange, aggregationUnit, segmentUnit, segmentUnitCount, zoneId);
        return segmentRangeList.stream().map(historicalRange -> {
            TimeRange prehistoricalRange = this.segmentationService.getPreviousDoubleRange(historicalRange, segmentUnit, segmentUnitCount, zoneId);
            return this.filterSegmentData(prehistoricalRange, historicalRange, fullItemData);
        }).filter(segmentData -> !segmentData.getHistoricalTelemetry().isEmpty()).sorted().toList();
    }

    private SegmentData filterSegmentData(TimeRange prehistoricalRange, TimeRange historicalRange, SegmentData data) {
        UUID id = TimeStampUUIDGenerator.generateId();
        UUID modelId = data.getModelId();
        ItemLite item = data.getItem();
        TimeSeries prehistoricalTelemetry = data.getPrehistoricalTelemetry().getPoints().stream().filter(arg_0 -> ((TimeRange)prehistoricalRange).contains(arg_0)).collect(Collectors.collectingAndThen(Collectors.toList(), TimeSeries::new));
        TimeSeries historicalTelemetry = data.getHistoricalTelemetry().getPoints().stream().filter(arg_0 -> ((TimeRange)historicalRange).contains(arg_0)).sorted().collect(Collectors.collectingAndThen(Collectors.toList(), TimeSeries::new));
        Map<UUID, TimeSeries> additionalTelemetries = data.getAdditionalTelemetries().entrySet().stream().map(entry -> {
            UUID telemetryKey = (UUID)entry.getKey();
            TimeSeries telemetry = ((TimeSeries)entry.getValue()).getPoints().stream().filter(arg_0 -> ((TimeRange)historicalRange).contains(arg_0)).sorted().collect(Collectors.collectingAndThen(Collectors.toList(), TimeSeries::new));
            return Map.entry(telemetryKey, telemetry);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new SegmentData(id, modelId, item, historicalRange, prehistoricalTelemetry, historicalTelemetry, additionalTelemetries, null);
    }

    private TimeSeries applyConstraints(PredictionModelParameters parameters, TimeSeries predictionSeries) {
        TimeSeries result = predictionSeries;
        if (parameters.isLimitRangeEnabled()) {
            double min = parameters.getLimitRangeMin();
            double max = parameters.getLimitRangeMax();
            result = result.getPoints().stream().map(point -> new Point(point.getTs(), Math.min(max, Math.max(min, point.getValue())))).sorted().collect(Collectors.collectingAndThen(Collectors.toList(), TimeSeries::new));
        }
        return result;
    }

    private void validateTrainingPredictionRatio(PredictionModelConfig config) {
        DateAggregationType dateAggregationType;
        Duration predictionDuration;
        PredictionModelDatasourceParameters datasourceParameters = config.getDatasourceParameters();
        PredictionModelParameters modelParameters = config.getModelParameters();
        TimeRange trainRange = new TimeRange(datasourceParameters.getTrainStartTs(), datasourceParameters.getTrainEndTs());
        Duration trainingDuration = trainRange.duration();
        if (trainingDuration.compareTo(predictionDuration = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)(dateAggregationType = DateAggregationType.getDateGroupingFromPicker((String)modelParameters.getPredictionRangeUnit()))).getDuration().multipliedBy(modelParameters.getPredictionRangeUnitCount())) < 0) {
            throw new PredictionModelException("The prediction time range should be less than the time range for model training.");
        }
    }

    public static String createTbKey(String label) {
        return "_EPD_" + label;
    }

    public static BusinessEntityFieldQuery createTbQuery(String tbKey) {
        return new BusinessEntityFieldQuery(FieldQueryType.MODEL_PREDICTION, tbKey, null);
    }
}

