/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.prediction;

import org.thingsboard.trendz.service.model.prediction.PredictionModelParameters;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationMethodData;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentationType;

public class PredictionModelParameters {
    private String predictionRangeUnit;
    private int predictionRangeUnitCount;
    private SegmentationType segmentationType;
    private SegmentationMethodData segmentationData;
    private boolean limitRangeEnabled;
    private double limitRangeMax;
    private double limitRangeMin;

    public PredictionModelParameters(PredictionModelParameters that) {
        this.predictionRangeUnit = that.predictionRangeUnit;
        this.predictionRangeUnitCount = that.predictionRangeUnitCount;
        this.segmentationType = that.segmentationType;
        this.segmentationData = that.segmentationData == null ? null : that.segmentationData.clone();
        this.limitRangeEnabled = that.limitRangeEnabled;
        this.limitRangeMax = that.limitRangeMax;
        this.limitRangeMin = that.limitRangeMin;
    }

    public static PredictionModelParametersBuilder builder() {
        return new PredictionModelParametersBuilder();
    }

    public String getPredictionRangeUnit() {
        return this.predictionRangeUnit;
    }

    public int getPredictionRangeUnitCount() {
        return this.predictionRangeUnitCount;
    }

    public SegmentationType getSegmentationType() {
        return this.segmentationType;
    }

    public SegmentationMethodData getSegmentationData() {
        return this.segmentationData;
    }

    public boolean isLimitRangeEnabled() {
        return this.limitRangeEnabled;
    }

    public double getLimitRangeMax() {
        return this.limitRangeMax;
    }

    public double getLimitRangeMin() {
        return this.limitRangeMin;
    }

    public void setPredictionRangeUnit(String predictionRangeUnit) {
        this.predictionRangeUnit = predictionRangeUnit;
    }

    public void setPredictionRangeUnitCount(int predictionRangeUnitCount) {
        this.predictionRangeUnitCount = predictionRangeUnitCount;
    }

    public void setSegmentationType(SegmentationType segmentationType) {
        this.segmentationType = segmentationType;
    }

    public void setSegmentationData(SegmentationMethodData segmentationData) {
        this.segmentationData = segmentationData;
    }

    public void setLimitRangeEnabled(boolean limitRangeEnabled) {
        this.limitRangeEnabled = limitRangeEnabled;
    }

    public void setLimitRangeMax(double limitRangeMax) {
        this.limitRangeMax = limitRangeMax;
    }

    public void setLimitRangeMin(double limitRangeMin) {
        this.limitRangeMin = limitRangeMin;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PredictionModelParameters)) {
            return false;
        }
        PredictionModelParameters other = (PredictionModelParameters)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getPredictionRangeUnitCount() != other.getPredictionRangeUnitCount()) {
            return false;
        }
        if (this.isLimitRangeEnabled() != other.isLimitRangeEnabled()) {
            return false;
        }
        if (Double.compare(this.getLimitRangeMax(), other.getLimitRangeMax()) != 0) {
            return false;
        }
        if (Double.compare(this.getLimitRangeMin(), other.getLimitRangeMin()) != 0) {
            return false;
        }
        String this$predictionRangeUnit = this.getPredictionRangeUnit();
        String other$predictionRangeUnit = other.getPredictionRangeUnit();
        if (this$predictionRangeUnit == null ? other$predictionRangeUnit != null : !this$predictionRangeUnit.equals(other$predictionRangeUnit)) {
            return false;
        }
        SegmentationType this$segmentationType = this.getSegmentationType();
        SegmentationType other$segmentationType = other.getSegmentationType();
        if (this$segmentationType == null ? other$segmentationType != null : !this$segmentationType.equals(other$segmentationType)) {
            return false;
        }
        SegmentationMethodData this$segmentationData = this.getSegmentationData();
        SegmentationMethodData other$segmentationData = other.getSegmentationData();
        return !(this$segmentationData == null ? other$segmentationData != null : !this$segmentationData.equals(other$segmentationData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PredictionModelParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPredictionRangeUnitCount();
        result = result * 59 + (this.isLimitRangeEnabled() ? 79 : 97);
        long $limitRangeMax = Double.doubleToLongBits(this.getLimitRangeMax());
        result = result * 59 + (int)($limitRangeMax >>> 32 ^ $limitRangeMax);
        long $limitRangeMin = Double.doubleToLongBits(this.getLimitRangeMin());
        result = result * 59 + (int)($limitRangeMin >>> 32 ^ $limitRangeMin);
        String $predictionRangeUnit = this.getPredictionRangeUnit();
        result = result * 59 + ($predictionRangeUnit == null ? 43 : $predictionRangeUnit.hashCode());
        SegmentationType $segmentationType = this.getSegmentationType();
        result = result * 59 + ($segmentationType == null ? 43 : $segmentationType.hashCode());
        SegmentationMethodData $segmentationData = this.getSegmentationData();
        result = result * 59 + ($segmentationData == null ? 43 : $segmentationData.hashCode());
        return result;
    }

    public String toString() {
        return "PredictionModelParameters(predictionRangeUnit=" + this.getPredictionRangeUnit() + ", predictionRangeUnitCount=" + this.getPredictionRangeUnitCount() + ", segmentationType=" + String.valueOf(this.getSegmentationType()) + ", segmentationData=" + String.valueOf(this.getSegmentationData()) + ", limitRangeEnabled=" + this.isLimitRangeEnabled() + ", limitRangeMax=" + this.getLimitRangeMax() + ", limitRangeMin=" + this.getLimitRangeMin() + ")";
    }

    public PredictionModelParameters() {
    }

    public PredictionModelParameters(String predictionRangeUnit, int predictionRangeUnitCount, SegmentationType segmentationType, SegmentationMethodData segmentationData, boolean limitRangeEnabled, double limitRangeMax, double limitRangeMin) {
        this.predictionRangeUnit = predictionRangeUnit;
        this.predictionRangeUnitCount = predictionRangeUnitCount;
        this.segmentationType = segmentationType;
        this.segmentationData = segmentationData;
        this.limitRangeEnabled = limitRangeEnabled;
        this.limitRangeMax = limitRangeMax;
        this.limitRangeMin = limitRangeMin;
    }
}

