/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.prediction;

import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.service.model.prediction.PredictionModelDatasourceParameters;
import org.thingsboard.trendz.service.view.proto.FillGapSettings;

public class PredictionModelDatasourceParameters {
    private UUID businessEntityId;
    private UUID businessEntityFieldId;
    private Set<ItemLite> itemSet;
    private long trainStartTs;
    private long trainEndTs;
    private String tzName;
    private String aggregationInterval;
    private FieldAggregation aggregationType;
    private FillGapSettings fillGapSettings;

    public PredictionModelDatasourceParameters(PredictionModelDatasourceParameters that) {
        this.businessEntityId = that.businessEntityId;
        this.businessEntityFieldId = that.businessEntityFieldId;
        this.itemSet = that.itemSet.stream().map(ItemLite::new).collect(Collectors.toSet());
        this.trainStartTs = that.trainStartTs;
        this.trainEndTs = that.trainEndTs;
        this.tzName = that.tzName;
        this.aggregationInterval = that.aggregationInterval;
        this.aggregationType = that.aggregationType;
        this.fillGapSettings = that.fillGapSettings == null ? null : new FillGapSettings(that.fillGapSettings);
    }

    public static PredictionModelDatasourceParametersBuilder builder() {
        return new PredictionModelDatasourceParametersBuilder();
    }

    public UUID getBusinessEntityId() {
        return this.businessEntityId;
    }

    public UUID getBusinessEntityFieldId() {
        return this.businessEntityFieldId;
    }

    public Set<ItemLite> getItemSet() {
        return this.itemSet;
    }

    public long getTrainStartTs() {
        return this.trainStartTs;
    }

    public long getTrainEndTs() {
        return this.trainEndTs;
    }

    public String getTzName() {
        return this.tzName;
    }

    public String getAggregationInterval() {
        return this.aggregationInterval;
    }

    public FieldAggregation getAggregationType() {
        return this.aggregationType;
    }

    public FillGapSettings getFillGapSettings() {
        return this.fillGapSettings;
    }

    public void setBusinessEntityId(UUID businessEntityId) {
        this.businessEntityId = businessEntityId;
    }

    public void setBusinessEntityFieldId(UUID businessEntityFieldId) {
        this.businessEntityFieldId = businessEntityFieldId;
    }

    public void setItemSet(Set<ItemLite> itemSet) {
        this.itemSet = itemSet;
    }

    public void setTrainStartTs(long trainStartTs) {
        this.trainStartTs = trainStartTs;
    }

    public void setTrainEndTs(long trainEndTs) {
        this.trainEndTs = trainEndTs;
    }

    public void setTzName(String tzName) {
        this.tzName = tzName;
    }

    public void setAggregationInterval(String aggregationInterval) {
        this.aggregationInterval = aggregationInterval;
    }

    public void setAggregationType(FieldAggregation aggregationType) {
        this.aggregationType = aggregationType;
    }

    public void setFillGapSettings(FillGapSettings fillGapSettings) {
        this.fillGapSettings = fillGapSettings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PredictionModelDatasourceParameters)) {
            return false;
        }
        PredictionModelDatasourceParameters other = (PredictionModelDatasourceParameters)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getTrainStartTs() != other.getTrainStartTs()) {
            return false;
        }
        if (this.getTrainEndTs() != other.getTrainEndTs()) {
            return false;
        }
        UUID this$businessEntityId = this.getBusinessEntityId();
        UUID other$businessEntityId = other.getBusinessEntityId();
        if (this$businessEntityId == null ? other$businessEntityId != null : !((Object)this$businessEntityId).equals(other$businessEntityId)) {
            return false;
        }
        UUID this$businessEntityFieldId = this.getBusinessEntityFieldId();
        UUID other$businessEntityFieldId = other.getBusinessEntityFieldId();
        if (this$businessEntityFieldId == null ? other$businessEntityFieldId != null : !((Object)this$businessEntityFieldId).equals(other$businessEntityFieldId)) {
            return false;
        }
        Set this$itemSet = this.getItemSet();
        Set other$itemSet = other.getItemSet();
        if (this$itemSet == null ? other$itemSet != null : !((Object)this$itemSet).equals(other$itemSet)) {
            return false;
        }
        String this$tzName = this.getTzName();
        String other$tzName = other.getTzName();
        if (this$tzName == null ? other$tzName != null : !this$tzName.equals(other$tzName)) {
            return false;
        }
        String this$aggregationInterval = this.getAggregationInterval();
        String other$aggregationInterval = other.getAggregationInterval();
        if (this$aggregationInterval == null ? other$aggregationInterval != null : !this$aggregationInterval.equals(other$aggregationInterval)) {
            return false;
        }
        FieldAggregation this$aggregationType = this.getAggregationType();
        FieldAggregation other$aggregationType = other.getAggregationType();
        if (this$aggregationType == null ? other$aggregationType != null : !this$aggregationType.equals(other$aggregationType)) {
            return false;
        }
        FillGapSettings this$fillGapSettings = this.getFillGapSettings();
        FillGapSettings other$fillGapSettings = other.getFillGapSettings();
        return !(this$fillGapSettings == null ? other$fillGapSettings != null : !this$fillGapSettings.equals(other$fillGapSettings));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PredictionModelDatasourceParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $trainStartTs = this.getTrainStartTs();
        result = result * 59 + (int)($trainStartTs >>> 32 ^ $trainStartTs);
        long $trainEndTs = this.getTrainEndTs();
        result = result * 59 + (int)($trainEndTs >>> 32 ^ $trainEndTs);
        UUID $businessEntityId = this.getBusinessEntityId();
        result = result * 59 + ($businessEntityId == null ? 43 : ((Object)$businessEntityId).hashCode());
        UUID $businessEntityFieldId = this.getBusinessEntityFieldId();
        result = result * 59 + ($businessEntityFieldId == null ? 43 : ((Object)$businessEntityFieldId).hashCode());
        Set $itemSet = this.getItemSet();
        result = result * 59 + ($itemSet == null ? 43 : ((Object)$itemSet).hashCode());
        String $tzName = this.getTzName();
        result = result * 59 + ($tzName == null ? 43 : $tzName.hashCode());
        String $aggregationInterval = this.getAggregationInterval();
        result = result * 59 + ($aggregationInterval == null ? 43 : $aggregationInterval.hashCode());
        FieldAggregation $aggregationType = this.getAggregationType();
        result = result * 59 + ($aggregationType == null ? 43 : $aggregationType.hashCode());
        FillGapSettings $fillGapSettings = this.getFillGapSettings();
        result = result * 59 + ($fillGapSettings == null ? 43 : $fillGapSettings.hashCode());
        return result;
    }

    public String toString() {
        return "PredictionModelDatasourceParameters(businessEntityId=" + String.valueOf(this.getBusinessEntityId()) + ", businessEntityFieldId=" + String.valueOf(this.getBusinessEntityFieldId()) + ", itemSet=" + String.valueOf(this.getItemSet()) + ", trainStartTs=" + this.getTrainStartTs() + ", trainEndTs=" + this.getTrainEndTs() + ", tzName=" + this.getTzName() + ", aggregationInterval=" + this.getAggregationInterval() + ", aggregationType=" + String.valueOf(this.getAggregationType()) + ", fillGapSettings=" + String.valueOf(this.getFillGapSettings()) + ")";
    }

    public PredictionModelDatasourceParameters() {
    }

    public PredictionModelDatasourceParameters(UUID businessEntityId, UUID businessEntityFieldId, Set<ItemLite> itemSet, long trainStartTs, long trainEndTs, String tzName, String aggregationInterval, FieldAggregation aggregationType, FillGapSettings fillGapSettings) {
        this.businessEntityId = businessEntityId;
        this.businessEntityFieldId = businessEntityFieldId;
        this.itemSet = itemSet;
        this.trainStartTs = trainStartTs;
        this.trainEndTs = trainEndTs;
        this.tzName = tzName;
        this.aggregationInterval = aggregationInterval;
        this.aggregationType = aggregationType;
        this.fillGapSettings = fillGapSettings;
    }
}

