/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.anomaly.segment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.anomaly.ComplexTsPoint;
import org.thingsboard.trendz.domain.base.Point;

@Service
public class DataVectorTransformer {
    private static final Logger log = LoggerFactory.getLogger(DataVectorTransformer.class);

    public List<ComplexTsPoint> toComplexPoints(Map<UUID, List<Point>> allPoints) {
        ArrayList<ComplexTsPoint> points = new ArrayList<ComplexTsPoint>();
        Map<UUID, Map> hashedPoints = allPoints.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().collect(Collectors.toMap(Point::getTs, Function.identity(), (o1, o2) -> {
            log.warn("The collision happened when complex point during complex point construction (1)");
            return o2;
        })), (o1, o2) -> {
            log.warn("The collision happened when complex point during complex point construction (2)");
            return o2;
        }));
        Set allTs = allPoints.values().stream().flatMap(Collection::stream).map(Point::getTs).collect(Collectors.toCollection(TreeSet::new));
        for (Long ts : allTs) {
            HashMap<UUID, Double> values = new HashMap<UUID, Double>();
            for (Map.Entry<UUID, Map> entry2 : hashedPoints.entrySet()) {
                Point Point2 = (Point)entry2.getValue().get(ts);
                if (Point2 != null) {
                    values.put(entry2.getKey(), Point2.getValue());
                    continue;
                }
                values.put(entry2.getKey(), null);
            }
            ComplexTsPoint complexTsPoint = new ComplexTsPoint();
            complexTsPoint.setTs(ts.longValue());
            complexTsPoint.setValues(values);
            points.add(complexTsPoint);
        }
        points.sort(Comparator.comparingLong(ComplexTsPoint::getTs));
        return points;
    }
}

