/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.anomaly.fetcher;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.domain.anomaly.DataVector;
import org.thingsboard.trendz.domain.anomaly.DatasetConfig;
import org.thingsboard.trendz.domain.base.Point;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.exception.BadConfiguredTaskException;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.exception.service.definition.BusinessEntityFieldNotFoundException;
import org.thingsboard.trendz.exception.service.definition.BusinessEntityNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.service.AuthenticationService;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.model.anomaly.fetcher.DatasetFetcher;
import org.thingsboard.trendz.service.model.anomaly.fetcher.DatasetIterator;
import org.thingsboard.trendz.service.model.anomaly.fetcher.DirectDatasetFetcher;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.view.ItemService;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Mono;

@Service
public class DirectDatasetFetcher
implements DatasetFetcher {
    private static final Logger log = LoggerFactory.getLogger(DirectDatasetFetcher.class);
    private final BusinessEntityService businessEntityService;
    private final AuthenticationService authenticationService;
    private final ItemService itemService;
    private final TbRestDataSource dataSource;
    private final int pagesizeTelemetry;
    private final Map<UUID, Map<String, AtomicLong>> taskLoadedPointsMap = new ConcurrentHashMap();
    private final Map<UUID, AtomicLong> taskLoadedItemsMap = new ConcurrentHashMap();

    public DirectDatasetFetcher(BusinessEntityService businessEntityService, AuthenticationService authenticationService, ItemService itemService, TbRestDataSource dataSource, @Value(value="${tb.api.limits.pagesize.telemetry}") int pagesizeTelemetry) {
        this.businessEntityService = businessEntityService;
        this.itemService = itemService;
        this.authenticationService = authenticationService;
        this.dataSource = dataSource;
        this.pagesizeTelemetry = pagesizeTelemetry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataVector> fetchDataset(JwtSecurityUser user, DatasetConfig datasetConfig) {
        UUID fetchTaskId = null;
        try {
            fetchTaskId = this.initCounters();
            Set items = (Set)DonReactive.block((Mono)this.itemService.loadItems(datasetConfig.getBusinessEntityId(), datasetConfig.getItemSet(), user).map(Item::toLite).collect(Collectors.toSet()));
            log.info("Found {} items", (Object)items.size());
            List dataVectors = this.loadValues(user, items, datasetConfig, fetchTaskId);
            long totalPoints = dataVectors.stream().mapToLong(dv -> dv.getPoints().values().stream().mapToLong(List::size).sum()).sum();
            log.info("Total {} points loaded for {} items / from {}", new Object[]{totalPoints, dataVectors.size(), items.size()});
            List list = dataVectors;
            return list;
        }
        finally {
            this.clearByFetchTaskId(fetchTaskId);
        }
    }

    public DatasetIterator getDatasetIterator(JwtSecurityUser user, DatasetConfig datasetConfig) {
        UUID fetchTaskId = this.initCounters();
        Set items = (Set)DonReactive.block((Mono)this.itemService.loadItems(datasetConfig.getBusinessEntityId(), datasetConfig.getItemSet(), user).map(Item::toLite).collect(Collectors.toSet()));
        return new DatasetIterator(items, item -> this.loadValues(user, Collections.singleton(item), datasetConfig, fetchTaskId), fetchTaskId);
    }

    public void clearByFetchTaskId(UUID fetchTaskId) {
        if (fetchTaskId == null) {
            return;
        }
        this.taskLoadedItemsMap.remove(fetchTaskId);
        this.taskLoadedPointsMap.remove(fetchTaskId);
    }

    private UUID initCounters() {
        UUID fetchTaskId = TimeStampUUIDGenerator.generateId();
        this.taskLoadedItemsMap.put(fetchTaskId, new AtomicLong());
        this.taskLoadedPointsMap.put(fetchTaskId, new ConcurrentHashMap());
        return fetchTaskId;
    }

    private List<DataVector> loadValues(JwtSecurityUser user, Set<ItemLite> items, DatasetConfig datasetConfig, UUID fetchTaskId) {
        Set businessEntityIds = datasetConfig.getFields().stream().map(ViewField::getBusinessEntityId).collect(Collectors.toSet());
        if (businessEntityIds.size() != 1) {
            throw new BadConfiguredTaskException("Fields from multiple Business Entities are not supported");
        }
        UUID businessEntityId = (UUID)businessEntityIds.iterator().next();
        BusinessEntity entity = (BusinessEntity)this.businessEntityService.findEntityById(user, businessEntityId).orElseThrow(() -> new BusinessEntityNotFoundException(businessEntityId, user.getTenantId()));
        HashMap fieldMap = new HashMap();
        datasetConfig.getFields().forEach(vf -> {
            BusinessEntityField entityField = entity.getFields().stream().filter(bef -> bef.getId().equals(vf.getEntityFieldId())).findFirst().orElseThrow(() -> new BusinessEntityFieldNotFoundException(vf.getEntityFieldId()));
            switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$field$FieldQueryType[entityField.getQuery().getQueryType().ordinal()]) {
                case 1: 
                case 2: {
                    fieldMap.put(vf, entityField);
                }
            }
        });
        BusinessEntityType entityType = entity.getQuery().getEntityType();
        int maxPointsCount = datasetConfig.getMaxPointsCount();
        if (maxPointsCount <= 0) {
            maxPointsCount = 1000000;
        }
        ArrayList dataVectors = Lists.newArrayList();
        for (ItemLite item : items) {
            Map itemValues = this.loadItemValues(user, item, entityType, fieldMap, datasetConfig, fetchTaskId);
            DataVector dv = new DataVector();
            dv.setItemId(item.getId());
            dv.setItemName(item.getName());
            dv.setPoints(itemValues);
            dataVectors.add(dv);
            long loadedPointsCnt = ((Map)this.taskLoadedPointsMap.get(fetchTaskId)).values().stream().mapToLong(AtomicLong::get).max().orElse(0L);
            if (loadedPointsCnt > (long)maxPointsCount) {
                log.info("dataset max points threshold reached. Stop loading {} / {}", (Object)maxPointsCount, (Object)loadedPointsCnt);
                break;
            }
            ((AtomicLong)this.taskLoadedItemsMap.get(fetchTaskId)).incrementAndGet();
        }
        return dataVectors;
    }

    private Map<UUID, List<Point>> loadItemValues(JwtSecurityUser user, ItemLite item, BusinessEntityType entityType, Map<ViewField, BusinessEntityField> fieldMap, DatasetConfig datasetConfig, UUID fetchTaskId) {
        ConcurrentHashMap<UUID, List<Point>> values = new ConcurrentHashMap<UUID, List<Point>>();
        for (ViewField viewField : fieldMap.keySet()) {
            BusinessEntityField entityField = fieldMap.get(viewField);
            String key = entityField.getQuery().getKey();
            List points = this.pageableTelemetryLoad(user, item, entityType, key, datasetConfig, fetchTaskId);
            values.put(viewField.getId(), points);
        }
        return values;
    }

    private List<Point> pageableTelemetryLoad(JwtSecurityUser user, ItemLite item, BusinessEntityType entityType, String key, DatasetConfig datasetConfig, UUID fetchTaskId) {
        Map fieldValues;
        Set keySet;
        ArrayList allPoints = Lists.newArrayList();
        long startTs = datasetConfig.getStartTs();
        long endTs = datasetConfig.getEndTs();
        int maxPointsCount = datasetConfig.getMaxPointsCount();
        if (maxPointsCount <= 0) {
            maxPointsCount = 1000000;
        }
        Map fieldToCounterMap = (Map)this.taskLoadedPointsMap.get(fetchTaskId);
        String jwtToken = this.authenticationService.getToken(user);
        while (!(keySet = (fieldValues = (Map)DonReactive.block((Mono)this.dataSource.loadTelemetry(entityType, item.getId(), key, startTs, endTs, jwtToken))).keySet()).isEmpty()) {
            if (keySet.size() != 1) {
                throw new TrendzInternalException("Unexpected result: too many keys");
            }
            String fieldId = (String)keySet.iterator().next();
            if (!fieldId.equals(key)) {
                throw new TrendzInternalException("Unexpected result: different key");
            }
            List<Point> pageData = ((List)fieldValues.get(fieldId)).stream().filter(tsData -> NumberUtils.isCreatable((String)tsData.getValue())).map(tsData -> new Point(tsData.getTs(), NumberUtils.createNumber((String)tsData.getValue()).doubleValue())).sorted(Comparator.comparingLong(Point::getTs)).toList();
            allPoints.addAll(pageData);
            AtomicLong itemsCounter = (AtomicLong)this.taskLoadedItemsMap.get(fetchTaskId);
            AtomicLong pointsCounter = fieldToCounterMap.computeIfAbsent(key, i -> new AtomicLong());
            pointsCounter.addAndGet(pageData.size());
            long maxTs = pageData.stream().mapToLong(Point::getTs).max().orElse(0L);
            startTs = maxTs + 1L;
            log.info("Page data loaded {}. Total size {} Items {}", new Object[]{pageData.size(), pointsCounter.get(), itemsCounter.get()});
            if (pointsCounter.get() <= (long)maxPointsCount && pageData.size() == this.pagesizeTelemetry) continue;
            break;
        }
        return allPoints;
    }
}

