/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.anomaly.fetcher;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import org.thingsboard.trendz.domain.anomaly.DataVector;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.service.model.anomaly.fetcher.DatasetIterator;

public class DatasetIterator
implements Iterator<List<DataVector>> {
    private final FetchFunction fetchFunction;
    private final Queue<ItemLite> unprocessedItems;
    private final List<ItemLite> processedItems;
    private final UUID fetchTaskId;

    public DatasetIterator(Set<ItemLite> items, FetchFunction function, UUID fetchTaskId) {
        this.fetchFunction = function;
        this.unprocessedItems = Lists.newLinkedList(items);
        this.processedItems = Lists.newArrayList();
        this.fetchTaskId = fetchTaskId;
    }

    @Override
    public boolean hasNext() {
        return !this.unprocessedItems.isEmpty();
    }

    @Override
    public List<DataVector> next() {
        ItemLite item = (ItemLite)this.unprocessedItems.poll();
        List data = this.fetchFunction.fetch(item);
        this.processedItems.add(item);
        return data;
    }

    public UUID getFetchTaskId() {
        return this.fetchTaskId;
    }
}

