/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.anomaly.features;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.anomaly.ComplexTsPoint;
import org.thingsboard.trendz.domain.anomaly.FeatureStatistic;
import org.thingsboard.trendz.domain.anomaly.MlProperties;
import org.thingsboard.trendz.domain.anomaly.Segment;
import org.thingsboard.trendz.service.model.anomaly.features.FeatureBuilder;
import org.thingsboard.trendz.service.model.anomaly.features.TsFeatureExtractor;
import org.thingsboard.trendz.service.model.anomaly.segment.AggregateReducer;

@Service
public class FeatureBuilder {
    private static final Logger log = LoggerFactory.getLogger(FeatureBuilder.class);
    private final TsFeatureExtractor featureExtractor;
    private final AggregateReducer aggregateReducer;

    @Autowired
    public FeatureBuilder(TsFeatureExtractor featureExtractor, AggregateReducer aggregateReducer) {
        this.featureExtractor = featureExtractor;
        this.aggregateReducer = aggregateReducer;
    }

    public List<Segment> buildFeatures(List<Segment> segments, MlProperties.FeatureBuilderProperties properties) {
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$anomaly$MlProperties$FeatureBuilderType[properties.getType().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> this.computeFeatures(segments, properties);
            case 2 -> this.reducePoints(segments, properties.getAggregatedIntervals(), properties.getAgg(), properties);
        };
    }

    private List<Segment> computeFeatures(List<Segment> segments, MlProperties.FeatureBuilderProperties properties) {
        segments.forEach(s -> {
            List normalizedPoints = this.normalizeValues(s.getRecords(), properties.getFieldStatistic());
            double[] features = this.featureExtractor.extract(normalizedPoints, properties.getFieldStatistic().keySet());
            s.setFeatures(features);
        });
        return segments;
    }

    private List<Segment> reducePoints(List<Segment> segments, int requiredSize, MlProperties.FeatureAggregation aggregation, MlProperties.FeatureBuilderProperties properties) {
        Set fieldIds = segments.stream().map(Segment::getRecords).flatMap(Collection::stream).map(ComplexTsPoint::getValues).map(Map::keySet).flatMap(Collection::stream).collect(Collectors.toSet());
        for (Segment segment : segments) {
            List reducedPoints = this.aggregateReducer.reduce(segment.getRecords(), fieldIds, requiredSize, aggregation);
            List normalizedPoints = this.normalizeValues(reducedPoints, properties.getFieldStatistic());
            int i = 0;
            double[] features = new double[normalizedPoints.size() * fieldIds.size()];
            for (ComplexTsPoint point : normalizedPoints) {
                for (UUID fieldId : fieldIds) {
                    features[i] = (Double)point.getValues().get(fieldId);
                    ++i;
                }
            }
            segment.setRecords(reducedPoints);
            segment.setFeatures(features);
        }
        return segments;
    }

    private List<ComplexTsPoint> normalizeValues(List<ComplexTsPoint> original, Map<UUID, FeatureStatistic> fieldStatistic) {
        return original.stream().map(r -> {
            ComplexTsPoint newPoint = new ComplexTsPoint();
            newPoint.setTs(r.getTs());
            for (Map.Entry entry : fieldStatistic.entrySet()) {
                UUID fieldId = (UUID)entry.getKey();
                FeatureStatistic stats = (FeatureStatistic)entry.getValue();
                Double originalValue = (Double)r.getValues().get(fieldId);
                double normalisedValue = 0.0;
                if (originalValue != null) {
                    normalisedValue = (originalValue - stats.getAvg()) / (stats.getMax() - stats.getMin());
                }
                newPoint.getValues().put(fieldId, normalisedValue);
            }
            return newPoint;
        }).collect(Collectors.toList());
    }
}

