/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.anomaly.distance;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.distance.EuclideanDistance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EuclidDistance
implements DistanceMeasure {
    private static final Logger log = LoggerFactory.getLogger(EuclidDistance.class);
    private final EuclideanDistance euclideanDistance = new EuclideanDistance();
    private final AtomicLong operations = new AtomicLong();

    public double compute(double[] a, double[] b) {
        long operations = this.operations.incrementAndGet();
        if (operations % 1000000L == 0L) {
            log.info("Euclidean operations {}", (Object)operations);
        }
        double compute = this.euclideanDistance.compute(a, b);
        return this.normalize(compute, a.length);
    }

    private double normalize(double original, int length) {
        double maxDistance = Math.sqrt(4 * length);
        return original / maxDistance;
    }
}

