/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.anomaly.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.anomaly.Anomaly;
import org.thingsboard.trendz.domain.anomaly.MlProperties;
import org.thingsboard.trendz.domain.anomaly.ScoredPoint;

@Service
public class AnomalyJoiner {
    private static final Logger log = LoggerFactory.getLogger(AnomalyJoiner.class);

    public List<Anomaly> joinAnomalies(List<Anomaly> anomalies, MlProperties.AnomalyExtractProperties anomalyExtractProperties) {
        anomalies.sort(Comparator.comparingDouble(Anomaly::getStartTs));
        double joinThreshold = 0.1;
        long joinMaxGap = TimeUnit.DAYS.toMillis(3L);
        Map itemAnomaliesMap = anomalies.stream().collect(Collectors.groupingBy(Anomaly::getItemId, Collectors.toList()));
        List<Object> joinedAnomalies = new ArrayList();
        for (UUID itemId : itemAnomaliesMap.keySet()) {
            ArrayList<Anomaly> forJoin = new ArrayList<Anomaly>();
            Anomaly prev = null;
            boolean isLowScore = false;
            for (Anomaly anomaly : itemAnomaliesMap.get(itemId)) {
                if (prev == null) {
                    isLowScore = anomaly.getScore() < joinThreshold;
                } else if (anomaly.getScore() < joinThreshold && isLowScore || anomaly.getScore() >= joinThreshold && !isLowScore) {
                    boolean overlaps;
                    boolean bl = overlaps = prev.getEndTs() >= anomaly.getStartTs() && prev.getEndTs() <= anomaly.getEndTs() || anomaly.getStartTs() - prev.getEndTs() < joinMaxGap;
                    if (prev.getClusterId() != anomaly.getClusterId() && !anomalyExtractProperties.isJoinClusters() || !overlaps) {
                        joinedAnomalies.add(this.join(forJoin));
                        forJoin.clear();
                        isLowScore = anomaly.getScore() < joinThreshold;
                    }
                } else {
                    joinedAnomalies.add(this.join(forJoin));
                    forJoin.clear();
                    isLowScore = anomaly.getScore() < joinThreshold;
                }
                prev = anomaly;
                forJoin.add(anomaly);
            }
            if (forJoin.isEmpty()) continue;
            joinedAnomalies.add(this.join(forJoin));
            forJoin.clear();
        }
        long minAnomalyDurationMs = anomalyExtractProperties.getMinAnomalyDurationMs();
        joinedAnomalies = joinedAnomalies.stream().filter(a -> a.getScore() > 0.001).filter(a -> a.getEndTs() - a.getStartTs() > minAnomalyDurationMs).collect(Collectors.toList());
        log.info("Anomalies after join {}. Joined {}", (Object)joinedAnomalies.size(), (Object)(anomalies.size() - joinedAnomalies.size()));
        return joinedAnomalies;
    }

    private Anomaly join(List<Anomaly> anomalies) {
        if (anomalies.isEmpty()) {
            throw new IllegalStateException("Unexpected behaviour");
        }
        Anomaly anomaly = anomalies.iterator().next();
        long clusterId = anomaly.getClusterId();
        String itemName = anomaly.getItemName();
        UUID itemId = anomaly.getItemId();
        List allPoints = anomalies.stream().map(Anomaly::getData).flatMap(Collection::stream).toList();
        Map minScoresByTimestamp = allPoints.stream().collect(Collectors.groupingBy(ScoredPoint::getT, Collectors.mapping(ScoredPoint::getS, Collectors.reducing(Math::min))));
        List<ScoredPoint> segRecords = minScoresByTimestamp.entrySet().stream().map(entry -> new ScoredPoint(((Long)entry.getKey()).longValue(), (Double)((Optional)entry.getValue()).orElseThrow())).sorted(Comparator.comparingLong(ScoredPoint::getT)).toList();
        Anomaly joined = Anomaly.builder().itemId(itemId).itemName(itemName).clusterId(clusterId).build();
        joined.populateFromScoredPoints(segRecords);
        return joined;
    }
}

