/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.anomaly.components;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.commons.math3.ml.clustering.Cluster;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.anomaly.Anomaly;
import org.thingsboard.trendz.domain.anomaly.AnomalyModel;
import org.thingsboard.trendz.domain.anomaly.ClusterInfo;
import org.thingsboard.trendz.domain.anomaly.ClusterableSegment;
import org.thingsboard.trendz.domain.anomaly.ComplexTsPoint;
import org.thingsboard.trendz.domain.anomaly.MlProperties;
import org.thingsboard.trendz.domain.anomaly.ScoredPoint;
import org.thingsboard.trendz.domain.anomaly.Segment;
import org.thingsboard.trendz.service.model.anomaly.components.AnomalyJoiner;
import org.thingsboard.trendz.service.model.anomaly.util.AnomaliesUtil;

@Service
public class AnomalyExtractor {
    private static final Logger log = LoggerFactory.getLogger(AnomalyExtractor.class);
    private final AnomalyJoiner anomalyJoiner;

    @Autowired
    public AnomalyExtractor(AnomalyJoiner anomalyJoiner) {
        this.anomalyJoiner = anomalyJoiner;
    }

    public List<Anomaly> buildAnomalies(AnomalyModel model, List<Segment> segments) {
        List centroids = model.getClusters().stream().map(ClusterInfo::getCentroid).collect(Collectors.toList());
        return (List)this.extract(centroids, segments, model.getProperties(), false).getRight();
    }

    public Pair<Double, List<Anomaly>> buildPrecomputedAnomalies(List<CentroidCluster<ClusterableSegment>> centroids, MlProperties properties) {
        List clusterCentroids = centroids.stream().map(CentroidCluster::getCenter).map(cl -> Doubles.asList((double[])cl.getPoint()).stream().map(d -> new ScoredPoint(0L, d)).collect(Collectors.toList())).collect(Collectors.toList());
        List segments = centroids.stream().map(Cluster::getPoints).flatMap(Collection::stream).map(ClusterableSegment::getSegment).collect(Collectors.toList());
        return this.extract(clusterCentroids, segments, properties, true);
    }

    private Pair<Double, List<Anomaly>> extract(List<List<ScoredPoint>> centroids, List<Segment> segments, MlProperties properties, boolean recalculateThreshold) {
        segments.sort(Comparator.comparingLong(Segment::getMinTs));
        DistanceMeasure measure = this.getMeasure(properties);
        ArrayList anomalies = Lists.newArrayList();
        for (Segment segment : segments) {
            long nearestClusterId = Long.MIN_VALUE;
            double minDistance = Double.MAX_VALUE;
            long clusterId = 0L;
            for (List<ScoredPoint> centroid : centroids) {
                ++clusterId;
                double[] centerPoints = Doubles.toArray((Collection)centroid.stream().map(ScoredPoint::getS).collect(Collectors.toList()));
                double distance = measure.compute(centerPoints, segment.getFeatures());
                if (!(minDistance > distance) && nearestClusterId != Long.MIN_VALUE) continue;
                minDistance = distance;
                nearestClusterId = clusterId;
            }
            Anomaly anomaly2 = this.createAnomaly(segment, nearestClusterId, minDistance);
            anomalies.add(anomaly2);
        }
        double threshold = recalculateThreshold || properties.getAnomalyExtractProperties().getThresholdScore() == 0.0 ? this.computeScoreThreshold((List)anomalies, properties.getAnomalyExtractProperties()) : properties.getAnomalyExtractProperties().getThresholdScore();
        anomalies.stream().filter(anomaly -> anomaly.getScore() < threshold).peek(anomaly -> anomaly.setScore(0.0)).map(Anomaly::getData).flatMap(Collection::stream).forEach(scoredPoint -> scoredPoint.setS(Double.valueOf(0.0)));
        List joinedAnomalies = this.anomalyJoiner.joinAnomalies((List)anomalies, properties.getAnomalyExtractProperties());
        log.info("{} anomalies found", (Object)joinedAnomalies.size());
        return Pair.of((Object)threshold, (Object)joinedAnomalies);
    }

    private Anomaly createAnomaly(Segment segment, long clusterId, double distance) {
        ComplexTsPoint lastPoint = (ComplexTsPoint)Iterables.getLast((Iterable)segment.getRecords());
        int score = this.distanceToScore(distance);
        Anomaly anomaly = new Anomaly();
        anomaly.setItemId(segment.getItemId());
        anomaly.setClusterId(clusterId);
        anomaly.setStartTs(lastPoint.getTs());
        anomaly.setEndTs(lastPoint.getTs());
        anomaly.setScore((double)score);
        anomaly.setData((List)Lists.newArrayList((Object[])new ScoredPoint[]{new ScoredPoint(lastPoint.getTs(), Double.valueOf(score))}));
        return anomaly;
    }

    private double computeScoreThreshold(List<Anomaly> anomalies, MlProperties.AnomalyExtractProperties anomalyExtractProperties) {
        double percentile = anomalyExtractProperties.getPercentile();
        if (percentile < 1.0 || percentile > 100.0) {
            percentile = 10.0;
        }
        double[] scores = Doubles.toArray((Collection)anomalies.stream().map(Anomaly::getScore).collect(Collectors.toList()));
        return new Percentile().evaluate(scores, 100.0 - percentile);
    }

    private DistanceMeasure getMeasure(MlProperties properties) {
        return AnomaliesUtil.getMeasure((MlProperties.DistanceFunctionType)properties.getAnomalyScoreDistFunc());
    }

    private int distanceToScore(double distance) {
        return (int)(distance * 1000.0);
    }
}

