/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.anomaly;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.DoubleSummaryStatistics;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.domain.anomaly.Anomaly;
import org.thingsboard.trendz.domain.anomaly.AnomalyModel;
import org.thingsboard.trendz.domain.anomaly.ClusterReport;
import org.thingsboard.trendz.domain.anomaly.ClusterableSegment;
import org.thingsboard.trendz.domain.anomaly.DataVector;
import org.thingsboard.trendz.domain.anomaly.FeatureStatistic;
import org.thingsboard.trendz.domain.anomaly.MlProperties;
import org.thingsboard.trendz.domain.anomaly.Segment;
import org.thingsboard.trendz.domain.anomaly.SegmentReport;
import org.thingsboard.trendz.domain.base.Point;
import org.thingsboard.trendz.service.model.anomaly.cluster.ClusterInfoBuilder;
import org.thingsboard.trendz.service.model.anomaly.cluster.CompositeSegmentClusterer;
import org.thingsboard.trendz.service.model.anomaly.components.AnomalyExtractor;
import org.thingsboard.trendz.service.model.anomaly.features.FeatureBuilder;
import org.thingsboard.trendz.service.model.anomaly.segment.CompositSegmentSplitter;
import org.thingsboard.trendz.service.model.anomaly.segment.DataVectorTransformer;
import org.thingsboard.trendz.service.model.anomaly.segment.SegmentFilterer;

@Component
public class ClusteringService {
    private static final Logger log = LoggerFactory.getLogger(ClusteringService.class);
    private final CompositSegmentSplitter segmentSplitter;
    private final SegmentFilterer segmentFilterer;
    private final FeatureBuilder featureBuilder;
    private final CompositeSegmentClusterer segmentClusterer;
    private final AnomalyExtractor anomalyExtractor;
    private final ClusterInfoBuilder clusterInfoBuilder;
    private final DataVectorTransformer dataVectorTransformer;

    @Autowired
    public ClusteringService(CompositSegmentSplitter segmentSplitter, SegmentFilterer segmentFilterer, FeatureBuilder featureBuilder, CompositeSegmentClusterer segmentClusterer, AnomalyExtractor anomalyExtractor, ClusterInfoBuilder clusterInfoBuilder, DataVectorTransformer dataVectorTransformer) {
        this.segmentSplitter = segmentSplitter;
        this.segmentFilterer = segmentFilterer;
        this.featureBuilder = featureBuilder;
        this.segmentClusterer = segmentClusterer;
        this.anomalyExtractor = anomalyExtractor;
        this.clusterInfoBuilder = clusterInfoBuilder;
        this.dataVectorTransformer = dataVectorTransformer;
    }

    public ClusterReport computeClusters(AnomalyModel model, List<DataVector> data) {
        Map fieldsStatistic = this.buildStatistic(data);
        model.getProperties().getFeatureProperties().setFieldStatistic(fieldsStatistic);
        SegmentReport segmentReport = this.buildSegments(data, model.getProperties());
        List segments = segmentReport.getSegmentList();
        if (segments.size() < model.getProperties().getClusteringProperties().getClustersCount() && !segments.isEmpty()) {
            model.getProperties().getClusteringProperties().setClustersCount(segments.size());
        }
        List clusters = this.segmentClusterer.cluster(segments, model.getProperties().getClusteringProperties());
        Pair anomalies = this.discoverPrecomputedAnomalies(clusters, model, data);
        List clusterInfos = this.clusterInfoBuilder.build(clusters, (List)anomalies.getValue());
        ClusterReport clusterReport = new ClusterReport();
        clusterReport.setAnomalies((List)anomalies.getValue());
        clusterReport.setClusters(clusterInfos);
        clusterReport.setThreshold(((Double)anomalies.getKey()).doubleValue());
        clusterReport.setEndOfTheLastSegmentPerItem(segmentReport.getEndOfTheLastSegmentPerItem());
        model.setClusters(clusterInfos);
        model.getProperties().getAnomalyExtractProperties().setThresholdScore(((Double)anomalies.getLeft()).doubleValue());
        return clusterReport;
    }

    public SegmentReport buildSegments(List<DataVector> data, MlProperties mlProperties) {
        List result = Lists.newArrayList();
        for (DataVector itemData : data) {
            List complexTsPoints = this.dataVectorTransformer.toComplexPoints(itemData.getPoints());
            List segments = this.segmentSplitter.split(complexTsPoints, mlProperties.getSegmentSplitProperties());
            segments.forEach(s -> s.setItemId(itemData.getItemId()));
            result.addAll(segments);
        }
        log.info("Total segments found {} for {} items", (Object)result.size(), (Object)data.size());
        result = this.segmentFilterer.filter(result, mlProperties.getSegmentFilterProperties());
        result = this.featureBuilder.buildFeatures(result, mlProperties.getFeatureProperties());
        Map<UUID, Long> endOfTheLastSegmentPerItem = result.stream().collect(Collectors.groupingBy(Segment::getItemId, Collectors.reducing(0L, Segment::getMaxTs, BinaryOperator.maxBy(Long::compare))));
        return new SegmentReport(result, endOfTheLastSegmentPerItem);
    }

    private Pair<Double, List<Anomaly>> discoverPrecomputedAnomalies(List<CentroidCluster<ClusterableSegment>> clusters, AnomalyModel model, List<DataVector> data) {
        Pair thresholdAnomaliesPair = this.anomalyExtractor.buildPrecomputedAnomalies(clusters, model.getProperties());
        ((List)thresholdAnomaliesPair.getValue()).forEach(a -> a.setModelId(model.getId()));
        this.fillItemNames((List)thresholdAnomaliesPair.getValue(), data);
        return thresholdAnomaliesPair;
    }

    private void fillItemNames(List<Anomaly> anomalies, List<DataVector> data) {
        Map<UUID, String> idToName = data.stream().collect(Collectors.toMap(DataVector::getItemId, DataVector::getItemName));
        anomalies.forEach(a -> a.setItemName((String)idToName.get(a.getItemId())));
    }

    private Map<UUID, FeatureStatistic> buildStatistic(List<DataVector> data) {
        HashMap<UUID, FeatureStatistic> fieldStats = new HashMap<UUID, FeatureStatistic>();
        Set fieldIds = data.stream().map(DataVector::getPoints).map(Map::keySet).flatMap(Collection::stream).collect(Collectors.toSet());
        for (UUID fieldId : fieldIds) {
            DoubleSummaryStatistics statistics = data.stream().map(DataVector::getPoints).map(pointsMap -> (List)pointsMap.get(fieldId)).flatMap(Collection::stream).mapToDouble(Point::getValue).summaryStatistics();
            FeatureStatistic fs = new FeatureStatistic();
            fs.setMin(statistics.getMin());
            fs.setMax(statistics.getMax());
            fs.setAvg(statistics.getAverage());
            fieldStats.put(fieldId, fs);
        }
        return fieldStats;
    }
}

