/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.anomaly;

import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.model.anomaly.AnomalyModelDao;
import org.thingsboard.trendz.dao.model.anomaly.AnomalyModelTaskDataDao;
import org.thingsboard.trendz.domain.anomaly.AnomalyAlarmConfig;
import org.thingsboard.trendz.domain.anomaly.AnomalyModel;
import org.thingsboard.trendz.domain.anomaly.AnomalyModelLite;
import org.thingsboard.trendz.domain.anomaly.AnomalyModelProperties;
import org.thingsboard.trendz.domain.anomaly.AnomalyModelReport;
import org.thingsboard.trendz.domain.anomaly.AnomalyModelStatus;
import org.thingsboard.trendz.domain.anomaly.AnomalyModelTaskData;
import org.thingsboard.trendz.domain.anomaly.AnomalyPersistenceReport;
import org.thingsboard.trendz.domain.anomaly.ChangeAnomalyModelConfig;
import org.thingsboard.trendz.domain.anomaly.DatasetConfig;
import org.thingsboard.trendz.domain.anomaly.MlProperties;
import org.thingsboard.trendz.domain.anomaly.ModelFilteringField;
import org.thingsboard.trendz.domain.anomaly.ModelSortingField;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.exception.model.anomaly.AnomalyModelNullIdModelException;
import org.thingsboard.trendz.exception.model.anomaly.TrendzAnomalyModelException;
import org.thingsboard.trendz.exception.task.TaskNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.ChangeEntityValidationInfo;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.model.anomaly.AnomalyAlarmService;
import org.thingsboard.trendz.service.model.anomaly.AnomalyModelAssociatedFieldService;
import org.thingsboard.trendz.service.model.anomaly.AnomalyModelBuildService;
import org.thingsboard.trendz.service.model.anomaly.AnomalyModelService;
import org.thingsboard.trendz.service.model.anomaly.AnomalyService;
import org.thingsboard.trendz.service.model.anomaly.util.AnomaliesUtil;
import org.thingsboard.trendz.service.provider.TbCustomerRelationService;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskManagementService;
import org.thingsboard.trendz.service.task.TaskService;
import org.thingsboard.trendz.service.task.job.AnomalyModelBuildJob;
import org.thingsboard.trendz.service.task.job.AnomalyModelRefreshJob;
import org.thingsboard.trendz.service.task.job.AnomalyModelReprocessJob;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskConfig;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskReferencedEntityType;
import org.thingsboard.trendz.service.task.model.TaskSchedule;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Service
public class AnomalyModelService {
    private static final Logger log = LoggerFactory.getLogger(AnomalyModelService.class);
    public static final String ANOMALY_SCORE_KEY_PREFIX = "_EAD_";
    public static final String ANOMALY_SCORE_INDEX_KEY_PREFIX = "_EID_";
    private final Scheduler anomalyScheduler;
    private final AnomalyModelBuildService anomalyModelBuildService;
    private final AnomalyModelDao anomalyModelDao;
    private final AnomalyModelTaskDataDao anomalyModelTaskDataDao;
    private final AnomalyService anomalyService;
    private final AnomalyAlarmService anomalyAlarmService;
    private final AnomalyModelAssociatedFieldService anomalyModelAssociatedFieldService;
    private final TaskService taskService;
    private final TaskManagementService taskManagementService;
    private final TbCustomerRelationService relationService;
    private final boolean isCloud;

    @Autowired
    public AnomalyModelService(AnomalyModelBuildService anomalyModelBuildService, AnomalyModelDao anomalyModelDao, AnomalyModelTaskDataDao anomalyModelTaskDataDao, AnomalyService anomalyService, AnomalyAlarmService anomalyAlarmService, AnomalyModelAssociatedFieldService anomalyModelAssociatedFieldService, ExecutorManagementService executorManagementService, TaskService taskService, TaskManagementService taskManagementService, TbCustomerRelationService relationService, @Value(value="${deployment.cloud}") boolean isCloud) {
        this.taskManagementService = taskManagementService;
        this.isCloud = isCloud;
        ExecutorService executor = executorManagementService.getExecutorByName(ExecutorName.ANOMLALY_PROCESSOR);
        this.anomalyScheduler = Schedulers.fromExecutorService((ExecutorService)executor, (String)"anomaly model refresh scheduler");
        this.anomalyModelBuildService = anomalyModelBuildService;
        this.anomalyModelDao = anomalyModelDao;
        this.anomalyModelTaskDataDao = anomalyModelTaskDataDao;
        this.anomalyService = anomalyService;
        this.anomalyAlarmService = anomalyAlarmService;
        this.anomalyModelAssociatedFieldService = anomalyModelAssociatedFieldService;
        this.taskService = taskService;
        this.relationService = relationService;
    }

    public AnomalyModelReport createAnomalyModel(JwtSecurityUser user, AnomalyModelProperties properties) {
        AnomalyModel anomalyModel = this.anomalyModelBuildService.createInitialModel(user, properties);
        this.validateName(user, anomalyModel.getName());
        this.validate(anomalyModel);
        anomalyModel = this.saveModel(user, anomalyModel, false, false);
        this.createTasks(user, anomalyModel);
        return new AnomalyModelReport(anomalyModel, true);
    }

    public AnomalyModelReport modifyAnomalyModel(JwtSecurityUser user, AnomalyModelProperties properties) {
        AnomalyModel foundAnomalyModel = this.getModelByIdOrThrow(user, properties.getModelId());
        if (foundAnomalyModel.getStatus() == AnomalyModelStatus.IN_PROGRESS || foundAnomalyModel.getStatus() == AnomalyModelStatus.QUEUED) {
            throw new TrendzAnomalyModelException("The anomaly model can not be changed during processing");
        }
        ChangeAnomalyModelConfig config = ChangeAnomalyModelConfig.getInstance((AnomalyModel)foundAnomalyModel, (AnomalyModelProperties)properties);
        UUID oldBusinessEntityId = null;
        if (!config.isDatasetTheSame()) {
            DatasetConfig oldConfig = foundAnomalyModel.getDatasetConfig();
            oldBusinessEntityId = oldConfig.getFields() == null ? oldConfig.getBusinessEntityId() : oldConfig.getFields().stream().filter(Objects::nonNull).map(ViewField::getBusinessEntityId).findAny().orElse(oldConfig.getBusinessEntityId());
        }
        this.anomalyModelBuildService.populateModel(user, foundAnomalyModel, properties, config);
        this.validate(foundAnomalyModel);
        if (!config.isNameTheSame()) {
            this.validateName(user, foundAnomalyModel.getName());
        }
        UUID newBusinessEntityId = foundAnomalyModel.getDatasetConfig().getBusinessEntityId();
        if (foundAnomalyModel.getTaskData() != null && foundAnomalyModel.getTaskData().isEnabledSaveToTb()) {
            if (oldBusinessEntityId != null && !oldBusinessEntityId.equals(newBusinessEntityId)) {
                this.anomalyModelAssociatedFieldService.changeAssociatedBusinessEntityFields(user, foundAnomalyModel, oldBusinessEntityId, newBusinessEntityId);
            } else if (!config.isNameTheSame() || !config.isTelemetryKeyTheSame()) {
                this.anomalyModelAssociatedFieldService.changeAssociatedBusinessEntityFields(user, foundAnomalyModel, newBusinessEntityId, null);
            }
        }
        AnomalyModelTaskData taskData = foundAnomalyModel.getTaskData();
        if (config.isRebuildRequired() && taskData.isEnabledRefresh()) {
            taskData.setEnabledRefresh(false);
            taskData.setEnabledAlarmCreation(false);
            taskData.setEnabledSaveToTb(false);
            this.saveTaskData(user, taskData, false);
        }
        foundAnomalyModel = config.isRebuildRequired() ? this.saveModel(user, foundAnomalyModel, true, false) : this.saveModel(user, foundAnomalyModel, false, true);
        this.createTasks(user, foundAnomalyModel);
        return new AnomalyModelReport(foundAnomalyModel, config.isRebuildRequired());
    }

    public void validate(AnomalyModel anomalyModel) {
        MlProperties properties = anomalyModel.getProperties();
        if (properties == null) {
            throw new TrendzAnomalyModelException("Anomaly model properties cannot be null.");
        }
        MlProperties.SegmentSplitProperties segmentSplitProperties = properties.getSegmentSplitProperties();
        if (segmentSplitProperties == null) {
            throw new TrendzAnomalyModelException("Anomaly model segment split properties cannot be null.");
        }
        if (segmentSplitProperties.getWindowSizeMs() < 60000L) {
            throw new TrendzAnomalyModelException("Segment time range cannot be less than a minute.");
        }
        if (segmentSplitProperties.getSlidingStepPercent() <= 0 || 100 <= segmentSplitProperties.getSlidingStepPercent()) {
            throw new TrendzAnomalyModelException("Sliding step percent should be between 0 and 100.");
        }
        MlProperties.SegmentFilterProperties segmentFilterProperties = properties.getSegmentFilterProperties();
        if (segmentFilterProperties == null) {
            throw new TrendzAnomalyModelException("Anomaly model segment filter properties cannot be null.");
        }
        if (segmentFilterProperties.getMinDurationMs() >= segmentSplitProperties.getWindowSizeMs()) {
            throw new TrendzAnomalyModelException("Anomaly model segment size cannot be less than min available segment size.");
        }
        MlProperties.AnomalyExtractProperties anomalyExtractProperties = properties.getAnomalyExtractProperties();
        if (anomalyExtractProperties == null) {
            throw new TrendzAnomalyModelException("Anomaly extract properties cannot be null.");
        }
        if (anomalyExtractProperties.getPercentile() <= 0 || 100 <= anomalyExtractProperties.getPercentile()) {
            throw new TrendzAnomalyModelException("Score threshold percent should be between 0 and 100.");
        }
        MlProperties.FeatureBuilderProperties featureBuilderProperties = properties.getFeatureProperties();
        if (featureBuilderProperties == null) {
            throw new TrendzAnomalyModelException("Anomaly detection properties cannot be null.");
        }
        if (featureBuilderProperties.getAggregatedIntervals() <= 0) {
            throw new TrendzAnomalyModelException("Aggregated intervals cannot be less than 1.");
        }
        if (segmentSplitProperties.getWindowSizeMs() / (long)featureBuilderProperties.getAggregatedIntervals() < 60000L) {
            throw new TrendzAnomalyModelException("Too small aggregation unit. Please increase segment size or decrease aggregated intervals.");
        }
        ChronoUnit chronoUnit = AnomaliesUtil.unitToChronoUnit((String)anomalyModel.getTelemetrySavePeriodUnit());
        if (this.isCloud && chronoUnit == ChronoUnit.MINUTES) {
            throw new TrendzAnomalyModelException("Too small telemetry saving frequency.");
        }
    }

    public Page<AnomalyModelLite> getAllLite(int page, int pageSize, JwtSecurityUser user, List<ModelFilteringField> filteringFields, List<ModelSortingField> sortingFields) {
        return this.anomalyModelDao.getAllLite(page, pageSize, user, filteringFields, sortingFields);
    }

    public List<AnomalyModel> getAll(JwtSecurityUser user) {
        return this.anomalyModelDao.getAll(user);
    }

    public AnomalyModel getModelByIdOrThrow(JwtSecurityUser user, UUID modelId) {
        return this.getModelByIdOrThrow(user, modelId, false);
    }

    public AnomalyModel getModelByIdOrThrow(JwtSecurityUser user, UUID modelId, boolean insecure) {
        if (modelId == null) {
            throw new AnomalyModelNullIdModelException();
        }
        return this.anomalyModelDao.findByIdOrThrow(user, modelId, insecure);
    }

    public Optional<AnomalyModelLite> findAnomalyModelByEntityFieldId(UUID entityFieldId, JwtSecurityUser user, boolean insecure) {
        return this.anomalyModelDao.findByEntityFieldId(entityFieldId, user, insecure);
    }

    public ChangeEntityValidationInfo findDependedEntities(JwtSecurityUser user, UUID modelId) {
        this.getModelByIdOrThrow(user, modelId);
        Set subCustomers = this.relationService.getAllSubCustomerIds(user);
        return this.anomalyModelDao.findDependedEntities(user, modelId, subCustomers);
    }

    public AnomalyModel saveModel(JwtSecurityUser user, AnomalyModel anomalyModel, boolean removeBeforeSave, boolean saveOnlyParameters) {
        if (saveOnlyParameters) {
            log.debug("Saving only parameters for model with id = {}", (Object)anomalyModel.getId());
            this.anomalyModelDao.saveOnlyAnomalyModelParameters(anomalyModel);
            return anomalyModel;
        }
        if (removeBeforeSave) {
            log.debug("Removing and save model with id = {}", (Object)anomalyModel.getId());
            this.anomalyModelDao.delete(user, anomalyModel.getId());
        } else {
            log.debug("Saving new model with id = {}", (Object)anomalyModel.getId());
        }
        return this.anomalyModelDao.save(anomalyModel);
    }

    public void deleteModel(JwtSecurityUser user, UUID modelId) {
        if (modelId == null) {
            throw new AnomalyModelNullIdModelException();
        }
        AnomalyModel foundAnomalyModel = this.getModelByIdOrThrow(user, modelId);
        this.removeTasks(user, modelId);
        this.anomalyModelAssociatedFieldService.deleteAssociatedBusinessEntityFields(user, foundAnomalyModel);
        this.deleteAllAnomaliesFromModel(user, foundAnomalyModel);
        this.anomalyModelDao.delete(user, modelId);
    }

    private void deleteAllAnomaliesFromModel(JwtSecurityUser user, AnomalyModel anomalyModel) {
        AnomalyPersistenceReport anomalyPersistenceReport = this.anomalyService.deleteAll(anomalyModel.getId());
        this.anomalyAlarmService.clearOrDeleteAlarmsFrom(user, anomalyPersistenceReport.getDeletedAnomalies(), anomalyModel.isEnabledAlarmDeletion()).subscribeOn(this.anomalyScheduler);
    }

    public void createTasks(JwtSecurityUser user, AnomalyModel anomalyModel) {
        this.createTask(user, anomalyModel, TaskReferencedEntityType.ANOMALY_MODEL_REPROCESS, "reprocess", (TaskJob)new AnomalyModelReprocessJob());
        this.createTask(user, anomalyModel, TaskReferencedEntityType.ANOMALY_MODEL_REFRESH, "refresh", (TaskJob)new AnomalyModelRefreshJob());
        this.createTask(user, anomalyModel, TaskReferencedEntityType.ANOMALY_MODEL_BUILD, "build", (TaskJob)new AnomalyModelBuildJob());
    }

    public AnomalyModelTaskData saveTaskData(JwtSecurityUser user, AnomalyModelTaskData taskData, boolean reset) {
        UUID modelId = taskData.getAnomalyModelId();
        AnomalyModel model = this.getModelByIdOrThrow(user, modelId);
        if (taskData.isEnabledSaveToTb() && model.getTelemetrySavePeriodUnit() == null) {
            throw new TrendzAnomalyModelException("Impossible to enable telemetry saving without telemetry storage frequency parameters or a telemetry key.");
        }
        AnomaliesUtil.unitToChronoUnit((String)model.getTelemetrySavePeriodUnit());
        switch (1.$SwitchMap$org$thingsboard$trendz$domain$anomaly$AnomalyModelStatus[model.getStatus().ordinal()]) {
            case 1: 
            case 2: {
                throw new TrendzAnomalyModelException("The anomaly model task data can not be changed during processing");
            }
            case 3: {
                throw new TrendzAnomalyModelException("The anomaly model task data can not be changed for canceled model");
            }
            case 4: {
                throw new TrendzAnomalyModelException("The anomaly model task data can not be changed for failed model");
            }
        }
        TaskReference taskReference = new TaskReference(TaskReferencedEntityType.ANOMALY_MODEL_REFRESH, modelId.toString());
        Task task = (Task)this.taskService.findTaskByReferencedEntity(user, taskReference).orElseThrow(() -> new TaskNotFoundException(taskReference));
        AnomalyModelRefreshJob job = task.getJob() == null ? AnomalyModelRefreshJob.builder().build() : (AnomalyModelRefreshJob)task.getJob();
        job.setModelId(taskData.getAnomalyModelId());
        job.setItemSet(taskData.getItemSet());
        this.populateRefreshJob(user, modelId, job);
        TaskSchedule schedule = this.taskService.makeSchedulingConfig(taskData.getRefreshTimeUnitCount(), taskData.getRefreshTimeUnit(), taskData.isRefreshTimeUnitTruncated(), model.getDatasetConfig().getTzName());
        TaskConfig taskConfig = TaskConfig.builder().id(task.getId()).name(task.getName()).enabled(Boolean.valueOf(taskData.isEnabledRefresh())).schedule(schedule).reference(taskReference).job((TaskJob)job).build();
        this.updateEnabling(user, model, taskData.isEnabledSaveToTb());
        Task updated = this.taskService.updateTask(user, taskConfig);
        if (reset) {
            this.taskService.resetTaskScheduling(user, task.getId());
        }
        return this.anomalyModelTaskDataDao.save(taskData);
    }

    public AnomalyModelTaskData getTaskData(JwtSecurityUser user, UUID modelId) {
        this.getModelByIdOrThrow(user, modelId);
        Optional taskDataOptional = this.anomalyModelTaskDataDao.findById(modelId);
        if (taskDataOptional.isEmpty()) {
            return AnomalyModelTaskData.getDefault((UUID)modelId);
        }
        AnomalyModelTaskData taskData = (AnomalyModelTaskData)taskDataOptional.get();
        TaskReference reference = new TaskReference(TaskReferencedEntityType.ANOMALY_MODEL_REFRESH, modelId.toString());
        long schedulingTime = (Long)this.taskService.getTaskSchedulingTime(user, reference).orElseThrow(() -> new TaskNotFoundException(modelId));
        taskData.setSchedulingTime(schedulingTime);
        return taskData;
    }

    public void populateAnomalyModelWithScoreThreshold(JwtSecurityUser user, AnomalyModel anomalyModel) {
        double scoreThreshold = anomalyModel.getProperties().getAnomalyExtractProperties().getThresholdScore();
        if (scoreThreshold != 0.0) {
            return;
        }
        Optional minAnomalyScoreFromAnomalies = this.anomalyService.getDefaultAnomalyScoreThreshold(anomalyModel.getId());
        scoreThreshold = minAnomalyScoreFromAnomalies.isEmpty() || (Integer)minAnomalyScoreFromAnomalies.get() == 0 ? 81.0 : (double)((Integer)minAnomalyScoreFromAnomalies.get()).intValue();
        anomalyModel.getProperties().getAnomalyExtractProperties().setThresholdScore(scoreThreshold);
        anomalyModel.setAnomalyAlarmConfig(AnomalyAlarmConfig.defaultAlertConfig((double)scoreThreshold));
        this.saveModel(user, anomalyModel, false, true);
    }

    private void populateRefreshJob(JwtSecurityUser user, UUID modelId, AnomalyModelRefreshJob anomalyModelRefreshJob) {
        TaskReference buildTaskReference = new TaskReference(TaskReferencedEntityType.ANOMALY_MODEL_BUILD, modelId.toString());
        Task build = (Task)this.taskService.findTaskByReferencedEntity(user, buildTaskReference).orElseThrow(() -> new TaskNotFoundException(buildTaskReference));
        Map buildMap = ((AnomalyModelBuildJob)build.getJob()).getItemIdLastSegmentMap();
        Map refreshMap = anomalyModelRefreshJob.getItemIdLastSegmentMap();
        if (buildMap == null) {
            return;
        }
        if (refreshMap == null) {
            anomalyModelRefreshJob.setItemIdLastSegmentMap(buildMap);
            return;
        }
        HashSet items = new HashSet();
        items.addAll(buildMap.keySet());
        items.addAll(refreshMap.keySet());
        Map mergedMap = items.stream().collect(Collectors.toMap(Function.identity(), id -> Math.max(buildMap.getOrDefault(id, Long.MIN_VALUE), refreshMap.getOrDefault(id, Long.MIN_VALUE))));
        anomalyModelRefreshJob.setItemIdLastSegmentMap(mergedMap);
    }

    private void createTask(JwtSecurityUser user, AnomalyModel anomalyModel, TaskReferencedEntityType entityType, String action, TaskJob emptyTaskJob) {
        TaskReference reference = new TaskReference(entityType, anomalyModel.getId().toString());
        String taskName = "Anomaly model, %s: %s".formatted(action, anomalyModel.getName());
        this.taskManagementService.createOrUpdateTask(user, reference, taskName, emptyTaskJob);
    }

    private void removeTasks(JwtSecurityUser user, UUID modelId) {
        Stream.of(TaskReferencedEntityType.ANOMALY_MODEL_BUILD, TaskReferencedEntityType.ANOMALY_MODEL_REPROCESS, TaskReferencedEntityType.ANOMALY_MODEL_REFRESH).forEach(entityType -> this.taskManagementService.deleteByTaskReference(user, new TaskReference(entityType, modelId.toString())));
    }

    private void updateEnabling(JwtSecurityUser user, AnomalyModel anomalyModel, boolean enabled) {
        if (anomalyModel.getTbTelemetryKey() == null) {
            log.warn("Business entities are not associated with anomaly model: {}", (Object)anomalyModel.getName());
            return;
        }
        if (enabled) {
            this.anomalyModelAssociatedFieldService.createAssociatedBusinessEntityFields(user, anomalyModel);
        } else {
            this.anomalyModelAssociatedFieldService.deleteAssociatedBusinessEntityFields(user, anomalyModel);
        }
        this.saveModel(user, anomalyModel, false, true);
    }

    private void validateName(JwtSecurityUser user, String newName) {
        int countWithSuchName = this.anomalyModelDao.countAllByTenantIdAndName(newName, user.getTenantId());
        if (countWithSuchName > 0) {
            throw new TrendzAnomalyModelException("The name of anomaly model is already used: " + newName);
        }
    }
}

