/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.anomaly;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.anomaly.Anomaly;
import org.thingsboard.trendz.domain.anomaly.AnomalyAggregatedData;
import org.thingsboard.trendz.domain.anomaly.ScoredPoint;
import org.thingsboard.trendz.service.model.anomaly.util.AnomaliesUtil;
import org.thingsboard.trendz.tools.DateTimeUtils;

@Service
public class AnomalyMapper {
    public Map<Long, AnomalyAggregatedData> generateTelemetryMap(long startTs, long endTs, ChronoUnit unit, ZoneId zoneId) {
        ZonedDateTime zonedDateTime = DateTimeUtils.extendedTruncateTo((ZonedDateTime)DateTimeUtils.fromTs((long)startTs, (ZoneId)zoneId), (ChronoUnit)unit);
        while (DateTimeUtils.toTs((ZonedDateTime)zonedDateTime) < startTs) {
            zonedDateTime = zonedDateTime.plus(DateTimeUtils.toDuration((ZonedDateTime)zonedDateTime, (long)1L, (ChronoUnit)unit));
        }
        return Stream.iterate(zonedDateTime, dateTime -> DateTimeUtils.toTs((ZonedDateTime)dateTime) <= endTs, dateTime -> dateTime.plus(DateTimeUtils.toDuration((ZonedDateTime)dateTime, (long)1L, (ChronoUnit)unit))).mapToLong(DateTimeUtils::toTs).boxed().collect(Collectors.toMap(Function.identity(), ts -> AnomalyAggregatedData.EMPTY));
    }

    public void populateTelemetryMapWithAnomaly(Map<Long, AnomalyAggregatedData> telemetryMap, Anomaly anomaly, ChronoUnit unit, ZoneId zoneId) {
        List tsScoreScoreIndexList = this.aggregateTimeSegmentsToTsScoreScoreIndexList(anomaly, unit, zoneId);
        this.fillGaps(tsScoreScoreIndexList);
        tsScoreScoreIndexList.stream().filter(data -> telemetryMap.containsKey(data.getKey())).forEach(data -> this.mergeScoreScoreIndexInTelemetryMap(telemetryMap, data));
    }

    private Map<Long, List<ScoredPoint>> mapAnomalyOnTimeSegments(Anomaly anomaly, ZonedDateTime startTime, ChronoUnit unit, ZoneId zoneId) {
        Map<Long, List<ScoredPoint>> timeSegments = Stream.iterate(startTime, dateTime -> DateTimeUtils.toTs((ZonedDateTime)dateTime) <= anomaly.getEndTs(), dateTime -> dateTime.plus(DateTimeUtils.toDuration((ZonedDateTime)dateTime, (long)1L, (ChronoUnit)unit))).mapToLong(DateTimeUtils::toTs).boxed().collect(Collectors.toMap(Function.identity(), i -> new ArrayList()));
        anomaly.getData().forEach(scoredPoint -> ((List)timeSegments.get(DateTimeUtils.extendedTruncateTo((long)scoredPoint.getT(), (ZoneId)zoneId, (ChronoUnit)unit))).add(scoredPoint));
        return timeSegments;
    }

    private List<Pair<Long, AnomalyAggregatedData>> aggregateTimeSegmentsToTsScoreScoreIndexList(Anomaly anomaly, ChronoUnit unit, ZoneId zoneId) {
        ZonedDateTime zonedDateTime = DateTimeUtils.extendedTruncateTo((ZonedDateTime)DateTimeUtils.fromTs((long)anomaly.getStartTs(), (ZoneId)zoneId), (ChronoUnit)unit);
        Map timeSegments = this.mapAnomalyOnTimeSegments(anomaly, zonedDateTime, unit, zoneId);
        ArrayList<Pair<Long, AnomalyAggregatedData>> tsScoreScoreIndexList = new ArrayList<Pair<Long, AnomalyAggregatedData>>();
        double[] scoreIndex = new double[]{0.0};
        ScoredPoint[] lastScoredPoint = new ScoredPoint[]{null};
        Stream.iterate(zonedDateTime, dateTime -> DateTimeUtils.toTs((ZonedDateTime)dateTime) <= anomaly.getEndTs(), dateTime -> dateTime.plus(DateTimeUtils.toDuration((ZonedDateTime)dateTime, (long)1L, (ChronoUnit)unit))).mapToLong(DateTimeUtils::toTs).boxed().forEach(ts -> {
            if (((List)timeSegments.get(ts)).isEmpty()) {
                tsScoreScoreIndexList.add(Pair.of((Object)ts, null));
                return;
            }
            double score = Double.MIN_VALUE;
            for (ScoredPoint scoredPoint : (List)timeSegments.get(ts)) {
                score = Double.max(score, scoredPoint.getS());
                if (lastScoredPoint[0] != null) {
                    scoreIndex[0] = scoreIndex[0] + AnomaliesUtil.calculateScoreIndexDiff((ScoredPoint)scoredPoint, (ScoredPoint)lastScoredPoint[0]);
                }
                lastScoredPoint[0] = scoredPoint;
            }
            tsScoreScoreIndexList.add(Pair.of((Object)ts, (Object)new AnomalyAggregatedData(score, scoreIndex[0], 1)));
        });
        return tsScoreScoreIndexList;
    }

    private void fillGaps(List<Pair<Long, AnomalyAggregatedData>> tsScoreScoreIndexList) {
        Pair<Long, AnomalyAggregatedData> lastFullFittedSegment = tsScoreScoreIndexList.get(0);
        int indexOfLastFullFittedSegment = 0;
        for (int i = 1; i < tsScoreScoreIndexList.size(); ++i) {
            Pair<Long, AnomalyAggregatedData> currentSegment = tsScoreScoreIndexList.get(i);
            if (currentSegment.getRight() == null) continue;
            if (i - indexOfLastFullFittedSegment == 1) {
                ++indexOfLastFullFittedSegment;
                lastFullFittedSegment = currentSegment;
                continue;
            }
            for (int j = indexOfLastFullFittedSegment + 1; j < i; ++j) {
                int leftWeight = j - indexOfLastFullFittedSegment;
                int rightWeight = i - j;
                int totalWeight = i - indexOfLastFullFittedSegment;
                double leftScore = ((AnomalyAggregatedData)lastFullFittedSegment.getValue()).getScore();
                double rightScore = ((AnomalyAggregatedData)currentSegment.getValue()).getScore();
                double leftScoreIndex = ((AnomalyAggregatedData)lastFullFittedSegment.getValue()).getScoreIndex();
                double rightScoreIndex = ((AnomalyAggregatedData)currentSegment.getValue()).getScoreIndex();
                tsScoreScoreIndexList.set(j, (Pair<Long, AnomalyAggregatedData>)Pair.of((Object)((Long)tsScoreScoreIndexList.get(j).getLeft()), (Object)new AnomalyAggregatedData(((double)leftWeight * rightScore + (double)rightWeight * leftScore) / (double)totalWeight, ((double)leftWeight * rightScoreIndex + (double)rightWeight * leftScoreIndex) / (double)totalWeight, 1)));
            }
        }
    }

    private void mergeScoreScoreIndexInTelemetryMap(Map<Long, AnomalyAggregatedData> telemetryMap, Pair<Long, AnomalyAggregatedData> data) {
        AnomalyAggregatedData fromMap = telemetryMap.get(data.getKey());
        AnomalyAggregatedData toMerge = (AnomalyAggregatedData)data.getRight();
        if (fromMap.isEmpty() && !toMerge.isEmpty()) {
            fromMap = new AnomalyAggregatedData();
            telemetryMap.put((Long)data.getKey(), fromMap);
        }
        double score = Math.max(fromMap.getScore(), toMerge.getScore());
        double scoreIndex = fromMap.getScoreIndex() + toMerge.getScoreIndex();
        int count = fromMap.getCount() + toMerge.getCount();
        fromMap.setScore(score);
        fromMap.setScoreIndex(scoreIndex);
        fromMap.setCount(count);
    }
}

