/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.mfa;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.provider.TbWebRequest;

@Service
public class TbMfaProxyService {
    private static final String TB_API_PREFIX = "api";
    private static final String TRENDZ_API_PREFIX = "apiTrendz";
    private static final String TB_AUTHORIZATION_HEADER_KEY = "x-authorization";
    private static final String TRENDZ_AUTHORIZATION_HEADER_KEY = "jwt";
    private static final Set<String> TB_REQUESTS_WITH_EMPTY_RESPONSE = Set.of("/api/auth/2fa/verification/send");
    private final TbRestDataSource tbRestDataSource;

    public TbMfaProxyService(TbRestDataSource tbRestDataSource) {
        this.tbRestDataSource = tbRestDataSource;
    }

    public String forwardRequest(HttpServletRequest request) throws IOException {
        String method = request.getMethod();
        String path = request.getRequestURI().replace(TRENDZ_API_PREFIX, TB_API_PREFIX);
        Map params = this.getRequestParameters(request);
        HttpHeaders headers = this.setTbAuthenticationTokenHeader(request);
        if (TB_REQUESTS_WITH_EMPTY_RESPONSE.contains(path)) {
            TbWebRequest tbRequest = new TbWebRequest(path, null, params, headers, (Object)IOUtils.toString((Reader)request.getReader()), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return String.valueOf(this.tbRestDataSource.forwardRequest(tbRequest, method));
        }
        TbWebRequest tbRequest = new TbWebRequest(path, null, params, headers, (Object)IOUtils.toString((Reader)request.getReader()), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        return (String)this.tbRestDataSource.forwardRequest(tbRequest, method);
    }

    private Map<String, Object> getRequestParameters(HttpServletRequest request) {
        return request.getParameterMap().entrySet().stream().collect(HashMap::new, (map, entry) -> map.put((String)entry.getKey(), List.of((String[])entry.getValue())), HashMap::putAll);
    }

    private HttpHeaders setTbAuthenticationTokenHeader(HttpServletRequest request) {
        HttpHeaders headers = new HttpHeaders();
        headers.put(TB_AUTHORIZATION_HEADER_KEY, List.of("Bearer " + request.getHeader(TRENDZ_AUTHORIZATION_HEADER_KEY)));
        return headers;
    }
}

