/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.metrics;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.customize.UserManagementService;
import org.thingsboard.trendz.service.metrics.MetricService;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskExecution;
import org.thingsboard.trendz.service.task.model.TaskTimeoutConfig;

@Service
public class TaskMetricService
extends MetricService {
    private static final Logger log = LoggerFactory.getLogger(TaskMetricService.class);
    private final Map<UUID, Gauge> executionIdToDurationGaugeMap = new ConcurrentHashMap();
    private final Map<UUID, Gauge> executionIdToTimeToTimeoutGaugeMap = new ConcurrentHashMap();

    @Autowired
    public TaskMetricService(MeterRegistry meterRegistry, UserManagementService userManagementService) {
        super(meterRegistry, userManagementService);
    }

    protected String getMetricPrefix() {
        return super.getMetricPrefix() + "task.";
    }

    public void registerExecution(Task task, TaskExecution execution) {
        JwtSecurityUser user = execution.getUser();
        UUID executionId = execution.getId();
        Gauge durationGauge = Gauge.builder((String)(this.getMetricPrefix() + "duration.current"), () -> System.currentTimeMillis() - execution.getStartTs()).description("Current running task duration").baseUnit("milliseconds").tags(this.tagsFor(task, user)).register(this.meterRegistry);
        Gauge timeoutGauge = Gauge.builder((String)(this.getMetricPrefix() + "time_to_timeout.current"), () -> this.getExecutionTimeToTimeout(task, execution)).description("Remaining time until task timeout").baseUnit("milliseconds").tags(this.tagsFor(task, user)).register(this.meterRegistry);
        this.executionIdToDurationGaugeMap.put(executionId, durationGauge);
        this.executionIdToTimeToTimeoutGaugeMap.put(executionId, timeoutGauge);
        this.meterRegistry.counter(this.getMetricPrefix() + "executions.count", this.tagsFor(task, user)).increment();
    }

    public void removeExecution(Task task, TaskExecution execution) {
        JwtSecurityUser user = execution.getUser();
        UUID executionId = execution.getId();
        Gauge durationGauge = (Gauge)this.executionIdToDurationGaugeMap.remove(executionId);
        Gauge timeoutGauge = (Gauge)this.executionIdToTimeToTimeoutGaugeMap.remove(executionId);
        if (durationGauge != null) {
            this.meterRegistry.remove((Meter)durationGauge);
        }
        if (timeoutGauge != null) {
            this.meterRegistry.remove((Meter)timeoutGauge);
        }
        long durationMs = System.currentTimeMillis() - execution.getStartTs();
        Timer.builder((String)(this.getMetricPrefix() + "duration")).description("Histogram of task execution durations").tags(this.tagsFor(task, user)).publishPercentileHistogram().register(this.meterRegistry).record(durationMs, TimeUnit.MILLISECONDS);
    }

    private long getExecutionTimeToTimeout(Task task, TaskExecution execution) {
        TaskTimeoutConfig timeoutConfig = task.getTimeoutConfig();
        if (timeoutConfig.isEnabled()) {
            return timeoutConfig.getDuration() - (System.currentTimeMillis() - execution.getStartTs());
        }
        return 0L;
    }

    private String[] tagsFor(Task task, JwtSecurityUser user) {
        TaskTimeoutConfig cfg = task.getTimeoutConfig();
        return new String[]{"task_id", task.getId().toString(), "task_name", task.getName(), "task_job_type", task.getJobType().name(), "task_reference_type", task.getReference().getType().name(), "task_reference_key", task.getReference().getKey(), "task_timeout_enabled", String.valueOf(cfg.isEnabled()), "task_timeout_ms", String.valueOf(cfg.getDuration()), "tenant", this.getTenantId(user), "tenant_name", this.getTenantName(user), "customer", this.getCustomerId(user), "customer_name", this.getCustomerName(user)};
    }
}

