/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.customize.UserManagementService;

public abstract class MetricService {
    private static final Logger log = LoggerFactory.getLogger(MetricService.class);
    public static final String ROOT_METRIC_PREFIX = "trendz.";
    protected final MeterRegistry meterRegistry;
    protected final UserManagementService userManagementService;

    public MetricService(MeterRegistry meterRegistry, UserManagementService userManagementService) {
        this.meterRegistry = meterRegistry;
        this.userManagementService = userManagementService;
    }

    protected String getMetricPrefix() {
        return ROOT_METRIC_PREFIX;
    }

    protected String getTenantId(JwtSecurityUser user) {
        return user.getTenantId().toString();
    }

    protected String getTenantName(JwtSecurityUser user) {
        return this.userManagementService.getTenantName(user.getTenantId());
    }

    protected String getCustomerId(JwtSecurityUser user) {
        return user.getCustomerId().toString();
    }

    protected String getCustomerName(JwtSecurityUser user) {
        return this.userManagementService.getCustomerName(user);
    }
}

