/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.metric.item;

import java.time.ZoneId;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.metric.item.pattern.ItemMetricTimePatternRequest;
import org.thingsboard.trendz.domain.metric.item.pattern.ItemMetricTimePatternResponse;
import org.thingsboard.trendz.domain.metric.item.pattern.TimePatternGroupingConfig;
import org.thingsboard.trendz.domain.metric.item.pattern.TimePatternGroupingType;
import org.thingsboard.trendz.exception.task.TaskNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.metric.item.configmaker.TimePatternConfigMaker;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskService;
import org.thingsboard.trendz.service.task.job.ViewReportBuildJob;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskReferencedEntityType;
import org.thingsboard.trendz.tools.DateTimeUtils;

@Service
public class ItemMetricTimePatternService {
    private static final Logger log = LoggerFactory.getLogger(ItemMetricTimePatternService.class);
    private final TaskService taskService;
    private final Map<TimePatternGroupingType, TimePatternConfigMaker> configMakers;

    @Autowired
    public ItemMetricTimePatternService(TaskService taskService, Map<String, TimePatternConfigMaker> configMakerBeanMap) {
        this.taskService = taskService;
        this.configMakers = new EnumMap(TimePatternGroupingType.class);
        for (TimePatternConfigMaker configMaker : configMakerBeanMap.values()) {
            this.configMakers.put(configMaker.getType(), configMaker);
        }
    }

    public ItemMetricTimePatternResponse getTimePatterns(JwtSecurityUser user, ItemMetricTimePatternRequest request) {
        ViewReportBuildJob job;
        UUID entityFieldId = request.getEntityFieldId();
        ZoneId zoneId = DateTimeUtils.fromTzName((String)request.getTzName());
        Map configMap = request.getConfigMap();
        Set requestedGroupingTypes = configMap.keySet();
        if (requestedGroupingTypes.isEmpty()) {
            throw new IllegalArgumentException("requestedGroupingTypes is empty");
        }
        HashMap<TimePatternGroupingType, ViewReportBuildJob> taskJobs = new HashMap<TimePatternGroupingType, ViewReportBuildJob>();
        for (TimePatternGroupingType groupingType : requestedGroupingTypes) {
            TimePatternGroupingConfig config = (TimePatternGroupingConfig)configMap.get(groupingType);
            if (config == null) {
                throw new IllegalStateException("TimePatternGroupingType " + String.valueOf(groupingType) + " not found with type: " + String.valueOf(groupingType));
            }
            TimePatternConfigMaker maker = (TimePatternConfigMaker)this.configMakers.get(groupingType);
            ViewConfig viewConfig = maker.makeViewConfig(user, config, entityFieldId, request.getItemLite(), zoneId);
            job = ViewReportBuildJob.builder().viewConfig(viewConfig).build();
            taskJobs.put(groupingType, job);
        }
        TaskReference reference = new TaskReference(TaskReferencedEntityType.VIEW_CONFIG_BUILD_VIEW, user.getTenantCustomerKey());
        Task task = (Task)this.taskService.findTaskByReferencedEntity(user, reference, true).orElseThrow(() -> new TaskNotFoundException(reference));
        EnumMap<TimePatternGroupingType, UUID> groupingTypeToExecutionIdMap = new EnumMap<TimePatternGroupingType, UUID>(TimePatternGroupingType.class);
        for (TimePatternGroupingType type : requestedGroupingTypes) {
            job = (TaskJob)taskJobs.get(type);
            UUID executionId = this.taskService.runExecution(user, task.getId(), (TaskJob)job, false, true);
            groupingTypeToExecutionIdMap.put(type, executionId);
        }
        return ItemMetricTimePatternResponse.builder().groupingTypeToExecutionIdMap(groupingTypeToExecutionIdMap).build();
    }
}

