/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.metric.item;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.metric.item.ItemSummary;
import org.thingsboard.trendz.domain.metric.item.MetricExplorationGenericRequest;
import org.thingsboard.trendz.domain.metric.item.TrendzEntityType;
import org.thingsboard.trendz.domain.metric.item.telemetry.TelemetryDetails;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.service.AuthenticationService;
import org.thingsboard.trendz.service.calculation.CalculationFieldService;
import org.thingsboard.trendz.service.metric.MetricExplorationService;
import org.thingsboard.trendz.service.metric.item.ItemMetricSummaryService;
import org.thingsboard.trendz.service.model.anomaly.AnomalyModelService;
import org.thingsboard.trendz.service.model.prediction.PredictionModelService;
import org.thingsboard.trendz.service.provider.AttributeData;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.tools.DateTimeUtils;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

@Service
public class ItemMetricSummaryService {
    private static final Logger log = LoggerFactory.getLogger(ItemMetricSummaryService.class);
    private final AuthenticationService authenticationService;
    private final MetricExplorationService metricExplorationService;
    private final PredictionModelService predictionModelService;
    private final CalculationFieldService calculationFieldService;
    private final AnomalyModelService anomalyModelService;
    private final TbRestDataSource tbRestDataSource;

    @Autowired
    public ItemMetricSummaryService(AuthenticationService authenticationService, MetricExplorationService metricExplorationService, PredictionModelService predictionModelService, CalculationFieldService calculationFieldService, AnomalyModelService anomalyModelService, TbRestDataSource tbRestDataSource) {
        this.authenticationService = authenticationService;
        this.metricExplorationService = metricExplorationService;
        this.predictionModelService = predictionModelService;
        this.calculationFieldService = calculationFieldService;
        this.anomalyModelService = anomalyModelService;
        this.tbRestDataSource = tbRestDataSource;
    }

    public ItemSummary getItemSummary(BusinessEntity businessEntity, UUID itemId, JwtSecurityUser user, MetricExplorationGenericRequest request) {
        ZoneId zoneId = DateTimeUtils.fromTzName((String)request.getTzName());
        TimeRange timeRange = request.getDatePickerConfig().buildStartEndPair(zoneId, System.currentTimeMillis());
        ItemSummary itemSummary = new ItemSummary(new ArrayList());
        String jwtToken = this.authenticationService.getToken(user);
        List attributeNodes = this.getNodesFromAttributeData(businessEntity, itemId, jwtToken);
        List telemetryNodes = this.getNodesFromTelemetryData(businessEntity, itemId, user, jwtToken, timeRange);
        List metricNodes = this.getNodesFromMetricDefinitions(businessEntity.getId(), user, telemetryNodes);
        itemSummary.getNodes().addAll(this.hideNodesMissedInTheSelectedItem(attributeNodes));
        itemSummary.getNodes().addAll(this.hideNodesMissedInTheSelectedItem(telemetryNodes));
        itemSummary.getNodes().addAll(metricNodes);
        return itemSummary;
    }

    private List<ItemSummary.Node> hideNodesMissedInTheSelectedItem(List<ItemSummary.Node> nodes) {
        return nodes.stream().filter(node -> node.getLiveness() != ItemSummary.Node.Liveness.NOT_IN_ITEM).toList();
    }

    private List<ItemSummary.Node> getNodesFromAttributeData(BusinessEntity businessEntity, UUID itemId, String jwtToken) {
        Map sourceMap = businessEntity.getFields().stream().filter(entityField -> entityField.uniqKey() != null).filter(entityField -> entityField.getQuery().getQueryType() == FieldQueryType.ATTRIBUTE).collect(Collectors.groupingBy(BusinessEntityField::uniqKey, Collectors.mapping(arg_0 -> this.attributeEntityFieldToNode(arg_0), Collectors.toList())));
        Map scopeToAttributeListMap = this.loadAllAttributes(businessEntity, itemId, jwtToken);
        return sourceMap.values().stream().flatMap(Collection::stream).peek(node -> {
            boolean isPresentInItem = scopeToAttributeListMap.getOrDefault(node.getScope(), Collections.emptyList()).contains(node.getKey());
            ItemSummary.Node.Liveness liveness = isPresentInItem ? ItemSummary.Node.Liveness.ALIVE : ItemSummary.Node.Liveness.NOT_IN_ITEM;
            node.setLiveness(liveness);
        }).toList();
    }

    private List<ItemSummary.Node> getNodesFromTelemetryData(BusinessEntity businessEntity, UUID itemId, JwtSecurityUser user, String jwtToken, TimeRange timeRange) {
        Map sourceMap = businessEntity.getFields().stream().filter(BusinessEntityField::hasTime).filter(entityField -> entityField.uniqKey() != null).collect(Collectors.groupingBy(BusinessEntityField::uniqKey, Collectors.mapping(entityField -> this.telemetryEntityFieldToNode(entityField, user), Collectors.toList())));
        String keys = sourceMap.values().stream().flatMap(Collection::stream).filter(node -> node.getScope() == null).map(ItemSummary.Node::getKey).distinct().collect(Collectors.joining(","));
        if (StringUtils.isEmpty((String)keys)) {
            return Collections.emptyList();
        }
        Map livenessMap = this.checkLivenessOfTelemetriesOnGivenRange(businessEntity, keys, itemId, timeRange, jwtToken);
        for (Map.Entry entry : livenessMap.entrySet()) {
            String telemetryKey = (String)entry.getKey();
            ItemSummary.Node.Liveness liveness = (ItemSummary.Node.Liveness)entry.getValue();
            String telemetryUniqKey = TelemetryDetails.uniqKey((String)telemetryKey);
            List telemetrySummaryNodes = sourceMap.getOrDefault(telemetryUniqKey, Collections.emptyList());
            for (ItemSummary.Node node2 : telemetrySummaryNodes) {
                node2.setLiveness(liveness);
            }
        }
        return sourceMap.values().stream().flatMap(Collection::stream).toList();
    }

    private List<ItemSummary.Node> getNodesFromMetricDefinitions(UUID businessEntityId, JwtSecurityUser user, List<ItemSummary.Node> telemetryNodes) {
        Map calculatedNodes = telemetryNodes.stream().filter(node -> node.getAssociatedEntityType() == TrendzEntityType.CALCULATED_FIELD).filter(node -> node.getAssociatedEntityId() != null).collect(Collectors.toMap(ItemSummary.Node::getAssociatedEntityId, Function.identity(), (n1, n2) -> {
            throw new TrendzInternalException("Found entity field that associated with two calculation fields: " + String.valueOf(n1.getEntityFieldId()));
        }));
        return this.metricExplorationService.getAllSavedByBusinessEntityId(businessEntityId, user).stream().map(metricDefinition -> {
            ItemSummary.Node node = new ItemSummary.Node();
            node.setName(metricDefinition.getName());
            node.setAssociatedEntityId(metricDefinition.getId());
            node.setAssociatedEntityName(metricDefinition.getName());
            node.setAssociatedEntityType(TrendzEntityType.METRIC_DEFINITION);
            node.setLiveness(ItemSummary.Node.Liveness.ALIVE);
            Optional.ofNullable(metricDefinition.getCalculationFieldId()).map(calculatedNodes::get).ifPresent(calculatedNode -> {
                node.setKey(calculatedNode.getKey());
                node.setEntityFieldId(calculatedNode.getEntityFieldId());
                node.setFieldType(calculatedNode.getFieldType());
            });
            return node;
        }).toList();
    }

    private ItemSummary.Node telemetryEntityFieldToNode(BusinessEntityField entityField, JwtSecurityUser user) {
        ItemSummary.Node node = new ItemSummary.Node();
        switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$field$FieldQueryType[entityField.getQuery().getQueryType().ordinal()]) {
            case 1: {
                node.setAssociatedEntityType(TrendzEntityType.PREDICATION_MODEL);
                this.predictionModelService.findFieldByEntityFieldId(entityField.getId(), user).ifPresent(predictionModel -> {
                    node.setAssociatedEntityId(predictionModel.getId());
                    node.setAssociatedEntityName(predictionModel.getName());
                });
                break;
            }
            case 2: 
            case 3: {
                node.setAssociatedEntityType(TrendzEntityType.ANOMALY_MODEL);
                this.anomalyModelService.findAnomalyModelByEntityFieldId(entityField.getId(), user, false).ifPresent(anomalyModelLite -> {
                    node.setAssociatedEntityId(anomalyModelLite.getId());
                    node.setAssociatedEntityName(anomalyModelLite.getName());
                });
                break;
            }
            case 4: {
                node.setAssociatedEntityType(TrendzEntityType.CALCULATED_FIELD);
                this.calculationFieldService.findFieldByEntityFieldId(entityField.getId(), user).ifPresent(calculationField -> {
                    node.setAssociatedEntityId(calculationField.getId());
                    node.setAssociatedEntityName(calculationField.getName());
                });
            }
        }
        node.setKey(entityField.getQuery().getKey());
        node.setName(entityField.getName());
        node.setEntityFieldId(entityField.getId());
        node.setFieldQueryType(entityField.getQuery().getQueryType());
        node.setFieldType(entityField.getType());
        return node;
    }

    private ItemSummary.Node attributeEntityFieldToNode(BusinessEntityField entityField) {
        return ItemSummary.Node.builder().key(entityField.getQuery().getKey()).scope(entityField.getQuery().getScope()).fieldQueryType(entityField.getQuery().getQueryType()).name(entityField.getName()).entityFieldId(entityField.getId()).fieldType(entityField.getType()).build();
    }

    private Map<String, ItemSummary.Node.Liveness> checkLivenessOfTelemetriesOnGivenRange(BusinessEntity businessEntity, String keys, UUID itemId, TimeRange timeRange, String jwtToken) {
        BusinessEntityType entityType = businessEntity.getQuery().getEntityType();
        Mono inTimerangeMapRequest = this.tbRestDataSource.loadTelemetry(entityType, itemId, keys, timeRange.getStartTs(), timeRange.getEndTs(), jwtToken, "ASC", 1);
        Mono fullMapRequest = this.tbRestDataSource.loadTelemetry(entityType, itemId, keys, -30610224000000L, 32503680000000L, jwtToken, "ASC", 1);
        Mono livenessMap = Mono.zip((Mono)inTimerangeMapRequest, (Mono)fullMapRequest).map(tuple -> {
            Map currentData = (Map)tuple.getT1();
            Map allData = (Map)tuple.getT2();
            HashMap<String, ItemSummary.Node.Liveness> result = new HashMap<String, ItemSummary.Node.Liveness>();
            for (BusinessEntityField field : businessEntity.getFields()) {
                String key = field.getQuery().getKey();
                List currentValues = (List)currentData.get(key);
                List allValues = (List)allData.get(key);
                ItemSummary.Node.Liveness status = currentValues != null && !currentValues.isEmpty() ? ItemSummary.Node.Liveness.ALIVE : (allValues != null && !allValues.isEmpty() ? ItemSummary.Node.Liveness.NOT_IN_TIMERANGE : ItemSummary.Node.Liveness.NOT_IN_ITEM);
                result.put(key, status);
            }
            return result;
        });
        return (Map)DonReactive.block((Mono)livenessMap);
    }

    private Map<String, List<String>> loadAllAttributes(BusinessEntity businessEntity, UUID itemId, String jwtToken) {
        Mono mono = Flux.just((Object[])new String[]{"SERVER_SCOPE", "CLIENT_SCOPE", "SHARED_SCOPE"}).flatMap(scope -> this.tbRestDataSource.loadAttribute(null, businessEntity.getQuery().getEntityType().name(), itemId, scope, null, jwtToken).map(AttributeData::getKey).collectList().zipWith(Mono.just((Object)scope))).collect(Collectors.toMap(Tuple2::getT2, Tuple2::getT1));
        return (Map)DonReactive.block((Mono)mono);
    }
}

