/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.metric.item;

import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationUnit;
import org.thingsboard.trendz.domain.metric.item.MetricExplorationGenericRequest;
import org.thingsboard.trendz.domain.metric.item.statistics.DataAvailabilityStatistics;
import org.thingsboard.trendz.domain.metric.item.statistics.ItemMetricStatistics;
import org.thingsboard.trendz.domain.metric.item.statistics.ItemNumericMetricStatistics;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.exception.service.definition.BusinessEntityNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.service.AuthenticationService;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.metric.item.ItemMetricStatisticsService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.provider.TsData;
import org.thingsboard.trendz.tools.DateTimeUtils;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class ItemMetricStatisticsService {
    private final AuthenticationService authenticationService;
    private final BusinessEntityService businessEntityService;
    private final TbRestDataSource tbRestDataSource;

    @Autowired
    public ItemMetricStatisticsService(AuthenticationService authenticationService, BusinessEntityService businessEntityService, TbRestDataSource tbRestDataSource) {
        this.authenticationService = authenticationService;
        this.businessEntityService = businessEntityService;
        this.tbRestDataSource = tbRestDataSource;
    }

    public ItemMetricStatistics getStatistics(JwtSecurityUser user, UUID itemId, UUID entityFieldId, MetricExplorationGenericRequest request) {
        BusinessEntityField entityField = this.businessEntityService.findEntityFieldById(user, entityFieldId);
        BusinessEntity businessEntity = (BusinessEntity)this.businessEntityService.findEntityById(user, entityField.getBusinessEntityId()).orElseThrow(() -> new BusinessEntityNotFoundException(entityField.getBusinessEntityId(), user.getTenantId()));
        String jwtToken = this.authenticationService.getToken(user);
        ZoneId zoneId = DateTimeUtils.fromTzName((String)request.getTzName());
        TimeRange timeRange = request.getDatePickerConfig().buildStartEndPair(zoneId, System.currentTimeMillis());
        Map telemetry = this.loadTelemetry(entityField.getQuery().getKey(), businessEntity.getQuery().getEntityType(), itemId, jwtToken, timeRange);
        switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$field$FieldType[entityField.getType().ordinal()]) {
            case 1: {
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        ItemMetricStatistics metricStatistics = this.fromNumeric((List)telemetry.get(TelemetryType.PRESENT));
        ((List)telemetry.get(TelemetryType.FIRST)).stream().findAny().ifPresent(tsData -> metricStatistics.setFirstPresentPointTs(tsData.getTs()));
        ((List)telemetry.get(TelemetryType.LAST)).stream().findAny().ifPresent(tsData -> metricStatistics.setLastPresentPointTs(tsData.getTs()));
        this.populateWithTsData(metricStatistics, (List)telemetry.get(TelemetryType.PRESENT), timeRange, zoneId, request.getDatePickerConfig().getRangeBy());
        return metricStatistics;
    }

    private void populateWithTsData(ItemMetricStatistics metricStatistics, List<TsData> telemetry, TimeRange timeRange, ZoneId zoneId, String rangeBy) {
        metricStatistics.setDataPoints((long)telemetry.size());
        List<Long> tsList = telemetry.stream().map(TsData::getTs).toList();
        metricStatistics.setDataAvailabilityStatistics(this.calculateDataAvailabilityStatistics(tsList, DateAggregationType.getDateGroupingFromPicker((String)rangeBy).mapToUnit(), timeRange, zoneId));
        if (telemetry.isEmpty()) {
            return;
        }
        LongSummaryStatistics tsStats = tsList.stream().mapToLong(i -> i).summaryStatistics();
        double avgStep = tsStats.getCount() < 2L ? 0.0 : ((double)(tsStats.getMax() - tsStats.getMin()) + 0.0) / (double)(tsStats.getCount() - 1L);
        metricStatistics.setAvgStepMs(avgStep);
        metricStatistics.setFirstAnalyzedPointTs(tsStats.getMin());
        metricStatistics.setLastAnalyzedPointTs(tsStats.getMax());
    }

    private DataAvailabilityStatistics calculateDataAvailabilityStatistics(List<Long> tsList, DateAggregationUnit unit, TimeRange timeRange, ZoneId zoneId) {
        List timeRanges = timeRange.splitTimeRange(unit, zoneId);
        Map map = timeRanges.stream().collect(Collectors.toMap(Function.identity(), range -> {
            long startTs = range.getStartTs();
            long truncatedStartTs = DateTimeUtils.extendedTruncateTo((long)startTs, (ZoneId)zoneId, (ChronoUnit)unit.mapToChronoUnit());
            return new DataAvailabilityStatistics.Node(0L, truncatedStartTs);
        }, (n1, n2) -> {
            throw new TrendzInternalException("Timeranges overlapping error. Unit: " + String.valueOf(unit) + ", timerange: " + String.valueOf(timeRange));
        }, TreeMap::new));
        tsList.stream().flatMap(ts -> timeRanges.stream().filter(range -> range.contains(ts.longValue())).findFirst().stream()).map(map::get).forEach(node -> node.setCount(node.getCount() + 1L));
        return DataAvailabilityStatistics.builder().dateAggregationUnit(unit).nodes(map.values().stream().toList()).build();
    }

    private ItemMetricStatistics fromNumeric(List<TsData> telemetry) {
        ItemNumericMetricStatistics numericMetricStatistics = new ItemNumericMetricStatistics();
        if (telemetry.isEmpty()) {
            numericMetricStatistics.setHistogram(Collections.emptyList());
            return numericMetricStatistics;
        }
        List<Double> doubles = telemetry.stream().sorted().map(TsData::getValue).map(Double::parseDouble).toList();
        DoubleSummaryStatistics summaryStatistics = doubles.stream().mapToDouble(i -> i).summaryStatistics();
        double volatility = this.calculateVolatility(summaryStatistics.getMin(), summaryStatistics.getMax());
        List histogramItems = this.calculateHistogram(doubles, summaryStatistics.getMin(), summaryStatistics.getMax(), summaryStatistics.getCount());
        numericMetricStatistics.setAvg(summaryStatistics.getAverage());
        numericMetricStatistics.setMin(summaryStatistics.getMin());
        numericMetricStatistics.setMax(summaryStatistics.getMax());
        numericMetricStatistics.setVolatility(volatility);
        numericMetricStatistics.setHistogram(histogramItems);
        return numericMetricStatistics;
    }

    private double calculateVolatility(double min, double max) {
        if (min > max) {
            throw new IllegalArgumentException();
        }
        if (min == max) {
            return 0.0;
        }
        return Math.min((max - min) / (Math.abs(max) + Math.abs(min)), 1.0) * 100.0;
    }

    private List<ItemNumericMetricStatistics.HistogramItem> calculateHistogram(List<Double> dataPoints, double min, double max, long count) {
        int uniqCount = Math.toIntExact(dataPoints.stream().distinct().count());
        int bucketCount = Math.min(10, uniqCount);
        if (bucketCount == 0) {
            return Collections.emptyList();
        }
        double step = (max - min) / (double)bucketCount;
        List<ItemNumericMetricStatistics.HistogramItem> histogram = IntStream.range(0, bucketCount).mapToObj(i -> new ItemNumericMetricStatistics.HistogramItem(min + step * (double)i, max - step * (double)(bucketCount - 1 - i), 0L, 0.0)).toList();
        List<Double> minLimits = histogram.stream().map(ItemNumericMetricStatistics.HistogramItem::getMin).toList();
        dataPoints.forEach(data -> {
            int bucketNumber = IntStream.range(0, bucketCount).filter(i -> (Double)minLimits.get(i) > data).findFirst().orElse(bucketCount);
            ItemNumericMetricStatistics.HistogramItem bucket = (ItemNumericMetricStatistics.HistogramItem)histogram.get(Math.max(0, bucketNumber - 1));
            bucket.setCount(bucket.getCount() + 1L);
        });
        histogram.forEach(bucket -> bucket.setPercent((double)bucket.getCount() * 100.0 / (double)count));
        return histogram;
    }

    private Map<TelemetryType, List<TsData>> loadTelemetry(String key, BusinessEntityType entityType, UUID itemId, String jwtToken, TimeRange timeRange) {
        Mono requestPresent = this.tbRestDataSource.loadTelemetry(entityType, itemId, key, timeRange.getStartTs(), timeRange.getEndTs(), jwtToken).map(map -> Pair.of((Object)TelemetryType.PRESENT, (Object)map));
        Mono requestFirst = this.tbRestDataSource.loadTelemetry(entityType, itemId, key, -30610224000000L, 32503680000000L, jwtToken, "ASC", 1).map(map -> Pair.of((Object)TelemetryType.FIRST, (Object)map));
        Mono requestLast = this.tbRestDataSource.loadTelemetry(entityType, itemId, key, -30610224000000L, 32503680000000L, jwtToken, "DESC", 1).map(map -> Pair.of((Object)TelemetryType.LAST, (Object)map));
        Mono request = Flux.merge((Publisher[])new Publisher[]{requestPresent, requestLast, requestFirst}).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        return ((Map)DonReactive.block((Mono)request)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Map)entry.getValue()).getOrDefault(key, Collections.emptyList())));
    }
}

