/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.metric.item;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityFieldQuery;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.metric.TestResult;
import org.thingsboard.trendz.domain.metric.item.AttributeDetails;
import org.thingsboard.trendz.domain.metric.item.ItemDetails;
import org.thingsboard.trendz.domain.metric.item.telemetry.BooleanTelemetryDetails;
import org.thingsboard.trendz.domain.metric.item.telemetry.CountPercentPair;
import org.thingsboard.trendz.domain.metric.item.telemetry.DateTelemetryDetails;
import org.thingsboard.trendz.domain.metric.item.telemetry.HistogramNumericStats;
import org.thingsboard.trendz.domain.metric.item.telemetry.NumericTelemetryDetails;
import org.thingsboard.trendz.domain.metric.item.telemetry.StringTelemetryDetails;
import org.thingsboard.trendz.domain.metric.item.telemetry.TelemetryDetails;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.service.AuthenticationService;
import org.thingsboard.trendz.service.metric.item.ItemDetailsMapper;
import org.thingsboard.trendz.service.metric.item.ItemDetailsService;
import org.thingsboard.trendz.service.provider.AttributeData;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.provider.TsData;
import org.thingsboard.trendz.service.view.ItemService;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class ItemDetailsService {
    private static final Logger log = LoggerFactory.getLogger(ItemDetailsService.class);
    private final AuthenticationService authenticationService;
    private final TbRestDataSource tbRestDataSource;
    private final ItemService itemService;
    private final ItemDetailsMapper itemDetailsMapper;

    @Autowired
    public ItemDetailsService(AuthenticationService authenticationService, TbRestDataSource tbRestDataSource, ItemService itemService, ItemDetailsMapper itemDetailsMapper) {
        this.authenticationService = authenticationService;
        this.tbRestDataSource = tbRestDataSource;
        this.itemService = itemService;
        this.itemDetailsMapper = itemDetailsMapper;
    }

    public String loadItemDetailsAsString(JwtSecurityUser user, BusinessEntity businessEntity, UUID itemId, DatePickerConfig datePickerConfig, ZoneId zoneId) {
        ItemDetails itemDetails = this.loadItemDetails(user, businessEntity, itemId, datePickerConfig, zoneId);
        return this.itemDetailsMapper.mapToString(itemDetails);
    }

    public ItemDetails loadItemDetails(JwtSecurityUser user, BusinessEntity businessEntity, UUID itemId, DatePickerConfig datePickerConfig, ZoneId zoneId) {
        String jwtToken = this.authenticationService.getToken(user);
        List filtered = this.filterEntityFields(businessEntity.getFields());
        Item item = this.loadItem(businessEntity, itemId, user);
        Map attributes = this.loadAttribute(businessEntity, filtered, itemId, jwtToken);
        List attributeData = this.analyzeAttribute(businessEntity, attributes);
        ItemDetails itemDetails = ItemDetails.builder().item(item).itemName(item.getName()).itemLabel(item.getLabel()).itemProfileName(businessEntity.getName()).itemProfileDescription(businessEntity.getDescription()).businessEntityType(businessEntity.getQuery().getEntityType()).attributeDetails(attributeData).build();
        Map telemetry = this.loadTelemetry(businessEntity, filtered, itemId, jwtToken, datePickerConfig, zoneId);
        List telemetryData = this.analyzeTelemetry(businessEntity, telemetry);
        itemDetails.setTelemetryDetails(telemetryData);
        return itemDetails;
    }

    public Item loadItem(BusinessEntity businessEntity, UUID itemId, JwtSecurityUser user) {
        String jwtToken = this.authenticationService.getToken(user);
        Mono request = this.itemService.loadItem(businessEntity, itemId, jwtToken);
        return (Item)DonReactive.block((Mono)request);
    }

    public TelemetryDetails analyzeMetric(TestResult testResult) {
        if (testResult.getResult() == null || !testResult.isValid()) {
            return null;
        }
        FieldType fieldType = testResult.getResult().stream().map(FieldValue::getFieldType).reduce(FieldType.BLANK, (ft1, ft2) -> {
            if (ft1 == ft2 || ft1 == FieldType.BLANK) {
                return ft2;
            }
            if (ft2 == FieldType.BLANK) {
                return ft1;
            }
            return FieldType.STRING;
        });
        List<TsData> tsData = testResult.getResult().stream().filter(fieldValue -> fieldValue.getInnerValue() != null).map(fieldValue -> new TsData(fieldValue.getTs(), fieldValue.getInnerValue().toString())).toList();
        return this.analyzeTelemetry(fieldType, tsData);
    }

    private Map<String, List<TsData>> loadTelemetry(BusinessEntity businessEntity, List<BusinessEntityField> businessEntityFields, UUID itemId, String jwtToken, DatePickerConfig datePickerConfig, ZoneId zoneId) {
        String keys = businessEntityFields.stream().map(BusinessEntityField::getQuery).filter(i -> i.getQueryType().hasTime()).map(BusinessEntityFieldQuery::getKey).collect(Collectors.joining(","));
        TimeRange timeRange = datePickerConfig.buildStartEndPair(zoneId, System.currentTimeMillis());
        Mono request = this.tbRestDataSource.loadTelemetry(businessEntity.getQuery().getEntityType(), itemId, keys, timeRange.getStartTs(), timeRange.getEndTs(), jwtToken);
        return (Map)DonReactive.block((Mono)request);
    }

    private Map<String, List<AttributeData>> loadAttribute(BusinessEntity businessEntity, List<BusinessEntityField> businessEntityFields, UUID itemId, String jwtToken) {
        Map<String, String> scopeKeysMap = businessEntityFields.stream().map(BusinessEntityField::getQuery).filter(i -> i.getQueryType() == FieldQueryType.ATTRIBUTE).collect(Collectors.groupingBy(BusinessEntityFieldQuery::getScope, Collectors.mapping(BusinessEntityFieldQuery::getKey, Collectors.joining(","))));
        return scopeKeysMap.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(entry -> this.tbRestDataSource.loadAttribute(null, businessEntity.getQuery().getEntityType().name(), itemId, (String)entry.getKey(), (String)entry.getValue(), jwtToken), Collectors.mapping(Flux::collectList, Collectors.mapping(DonReactive::block, Collectors.flatMapping(Collection::stream, Collectors.toList()))))));
    }

    private List<AttributeDetails> analyzeAttribute(BusinessEntity businessEntity, Map<String, List<AttributeData>> attributeDataMap) {
        return attributeDataMap.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(attributeData -> this.analyzeAttribute(businessEntity, (String)entry.getKey(), attributeData))).filter(Objects::nonNull).toList();
    }

    private AttributeDetails analyzeAttribute(BusinessEntity businessEntity, String scope, AttributeData attributeData) {
        return businessEntity.getFields().stream().filter(entityField -> entityField.getQuery().getKey().equals(attributeData.getKey())).findAny().map(businessEntityField -> AttributeDetails.builder().description(businessEntityField.getDescription()).fieldType(businessEntityField.getType()).name(businessEntityField.getName()).key(attributeData.getKey()).data(attributeData.getValue() instanceof String ? this.mapStringToShorterVersion(attributeData.getValue().toString()) : attributeData.getValue()).scope(scope).build()).orElse(null);
    }

    private List<TelemetryDetails> analyzeTelemetry(BusinessEntity businessEntity, Map<String, List<TsData>> telemetry) {
        Set keySet = businessEntity.getFields().stream().map(BusinessEntityField::getQuery).map(BusinessEntityFieldQuery::getKey).collect(Collectors.toSet());
        return telemetry.entrySet().stream().filter(entry -> keySet.contains(entry.getKey())).filter(entry -> ((List)entry.getValue()).stream().map(TsData::getValue).anyMatch(Objects::nonNull)).map(entry -> this.analyzeTelemetry(businessEntity, (String)entry.getKey(), (List)entry.getValue())).filter(Objects::nonNull).toList();
    }

    private TelemetryDetails analyzeTelemetry(BusinessEntity businessEntity, String key, List<TsData> tsData) {
        if (tsData.isEmpty()) {
            log.warn("TsData is empty for key {} for business entity {}", (Object)key, (Object)businessEntity.getId());
            return null;
        }
        BusinessEntityField businessEntityField = businessEntity.getFields().stream().filter(entityField -> entityField.getQuery().getKey().equals(key)).findAny().orElse(null);
        if (businessEntityField == null) {
            log.warn("Business entity field is not found for key {} for business entity {}", (Object)key, (Object)businessEntity.getId());
            return null;
        }
        TelemetryDetails telemetryDetails = this.analyzeTelemetry(businessEntityField.getType(), tsData);
        if (telemetryDetails == null) {
            log.warn("Telemetry data is blank for key {} for business entity {}", (Object)key, (Object)businessEntity.getId());
            return null;
        }
        telemetryDetails.setCount((long)tsData.size());
        telemetryDetails.setKey(key);
        telemetryDetails.setDescription(businessEntityField.getDescription());
        telemetryDetails.setName(businessEntityField.getName());
        return telemetryDetails;
    }

    private TelemetryDetails analyzeTelemetry(FieldType fieldType, List<TsData> tsData) {
        DateTelemetryDetails telemetryDetails;
        switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$field$FieldType[fieldType.ordinal()]) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 1: {
                DateTelemetryDetails dateTelemetryDetails = this.getStringFrom(tsData);
                break;
            }
            case 2: {
                DateTelemetryDetails dateTelemetryDetails = this.getNumericFrom(tsData);
                break;
            }
            case 3: {
                DateTelemetryDetails dateTelemetryDetails = new DateTelemetryDetails();
                break;
            }
            case 4: {
                DateTelemetryDetails dateTelemetryDetails = this.getBooleanFrom(tsData);
                break;
            }
            case 5: {
                DateTelemetryDetails dateTelemetryDetails = telemetryDetails = null;
            }
        }
        if (telemetryDetails == null) {
            return null;
        }
        long avgInterval = tsData.size() > 1 ? (tsData.get(tsData.size() - 1).getTs() - tsData.get(0).getTs()) / ((long)tsData.size() - 1L) : -1L;
        telemetryDetails.setAvgInterval(avgInterval);
        telemetryDetails.setFirstTelemetryTs(tsData.get(0).getTs());
        telemetryDetails.setLastTelemetryTs(tsData.get(tsData.size() - 1).getTs());
        return telemetryDetails;
    }

    private NumericTelemetryDetails getNumericFrom(List<TsData> tsData) {
        NumericTelemetryDetails numericTelemetryData = new NumericTelemetryDetails();
        List<Double> doubles = tsData.stream().map(TsData::getValue).map(Double::parseDouble).toList();
        DoubleSummaryStatistics summaryStatistics = doubles.stream().mapToDouble(i -> i).summaryStatistics();
        double lastValue = Double.parseDouble(tsData.get(tsData.size() - 1).getValue());
        HistogramNumericStats histogramNumericStats = this.createHistogram(doubles);
        numericTelemetryData.setMaxValue(summaryStatistics.getMax());
        numericTelemetryData.setAvgValue(summaryStatistics.getAverage());
        numericTelemetryData.setMinValue(summaryStatistics.getMin());
        numericTelemetryData.setLastValue(lastValue);
        numericTelemetryData.setHistogramNumericStats(histogramNumericStats);
        return numericTelemetryData;
    }

    private BooleanTelemetryDetails getBooleanFrom(List<TsData> tsData) {
        BooleanTelemetryDetails booleanTelemetryDetails = new BooleanTelemetryDetails();
        Map details = tsData.stream().map(TsData::getValue).map(Boolean::getBoolean).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        int truePercent = (int)(details.get(true) * 100L / (long)tsData.size());
        int falsePercent = (int)(details.get(false) * 100L / (long)tsData.size());
        boolean lastValue = Boolean.parseBoolean(tsData.get(tsData.size() - 1).getValue());
        booleanTelemetryDetails.setFalseStats(new CountPercentPair(details.get(false).longValue(), falsePercent));
        booleanTelemetryDetails.setTrueStats(new CountPercentPair(details.get(true).longValue(), truePercent));
        booleanTelemetryDetails.setLastValue(lastValue);
        return booleanTelemetryDetails;
    }

    private StringTelemetryDetails getStringFrom(List<TsData> tsData) {
        StringTelemetryDetails stringTelemetryDetails = new StringTelemetryDetails();
        Map options = tsData.stream().map(TsData::getValue).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        Map<String, CountPercentPair> topValues = options.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).limit(5L).collect(Collectors.toMap(entry -> this.mapStringToShorterVersion((String)entry.getKey()), entry -> new CountPercentPair(((Long)entry.getValue()).longValue(), (int)((Long)entry.getValue() * 100L / (long)tsData.size()))));
        String lastValue = this.mapStringToShorterVersion(tsData.get(tsData.size() - 1).getValue());
        stringTelemetryDetails.setTopValues(topValues);
        stringTelemetryDetails.setLastValue(lastValue);
        return stringTelemetryDetails;
    }

    private HistogramNumericStats createHistogram(List<Double> data) {
        int binCount = Math.min(data.size(), 4);
        int totalSize = data.size();
        int baseSize = totalSize / binCount;
        int remainder = totalSize % binCount;
        List<Integer> sizes = IntStream.range(0, binCount).map(i -> baseSize + (i < remainder ? 1 : 0)).boxed().toList();
        List sortedByValue = data.stream().sorted().toList();
        ArrayList<HistogramNumericStats.Item> items = new ArrayList<HistogramNumericStats.Item>();
        int currentIndex = 0;
        for (int size : sizes) {
            DoubleSummaryStatistics summaryStatistics = sortedByValue.subList(currentIndex, currentIndex + size).stream().mapToDouble(i -> i).summaryStatistics();
            currentIndex += size;
            items.add(new HistogramNumericStats.Item(summaryStatistics.getMin(), summaryStatistics.getMax()));
        }
        return new HistogramNumericStats(binCount, items);
    }

    private List<BusinessEntityField> filterEntityFields(List<BusinessEntityField> entityFields) {
        return entityFields.stream().filter(entityField -> entityField.getType() != FieldType.BLANK && entityField.getQuery().getQueryType() != FieldQueryType.ENTITY_ID && entityField.getQuery().getQueryType() != FieldQueryType.OWNER).toList();
    }

    private String mapStringToShorterVersion(String example) {
        if (example.length() > 100) {
            return example.substring(0, 100) + "... ";
        }
        return example;
    }
}

