/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.metric.agent.output;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.metric.TestResult;
import org.thingsboard.trendz.domain.metric.assistance.MetricCodeAssistanceContext;
import org.thingsboard.trendz.domain.metric.item.telemetry.TelemetryDetails;
import org.thingsboard.trendz.service.metric.MetricPythonCalculationTester;
import org.thingsboard.trendz.service.metric.agent.MetricExplorerAiService;
import org.thingsboard.trendz.service.metric.agent.input.domain.MetricBusinessAnalystExpertResult;
import org.thingsboard.trendz.service.metric.agent.memorymanager.domain.MetricMemoryManagerExpertResult;
import org.thingsboard.trendz.service.metric.agent.output.domain.MetricOutputExpertResult;
import org.thingsboard.trendz.service.metric.item.ItemDetailsMapper;
import org.thingsboard.trendz.service.metric.item.ItemDetailsService;

@Service
public class MetricOutputExpertAgent {
    private final ItemDetailsService itemDetailsService;
    private final ItemDetailsMapper itemDetailsMapper;
    private final MetricExplorerAiService metricExplorerAiService;
    private final MetricPythonCalculationTester calculationExecutor;

    @Autowired
    public MetricOutputExpertAgent(ItemDetailsService itemDetailsService, ItemDetailsMapper itemDetailsMapper, MetricExplorerAiService metricExplorerAiService, MetricPythonCalculationTester calculationExecutor) {
        this.itemDetailsService = itemDetailsService;
        this.itemDetailsMapper = itemDetailsMapper;
        this.metricExplorerAiService = metricExplorerAiService;
        this.calculationExecutor = calculationExecutor;
    }

    public MetricOutputExpertResult makeAnswerForUser(MetricCodeAssistanceContext context, TestResult newTestResult, MetricMemoryManagerExpertResult memoryManagerExpertResult, MetricBusinessAnalystExpertResult businessAnalystExpertResult) {
        String answer = this.metricExplorerAiService.explainResults(context.getUser(), context.getAgentMetadataContainer(), context.getQuestion(), memoryManagerExpertResult.getTask(), context.getMetricDefinition(), businessAnalystExpertResult.getNewMetricDefinition(), this.oldExecutionResult(context), this.newExecutionResult(businessAnalystExpertResult, newTestResult), businessAnalystExpertResult.isCodeChangeRequired(), businessAnalystExpertResult.isMetricDefinitionChangeRequired());
        return MetricOutputExpertResult.builder().answer(answer).build();
    }

    private String newExecutionResult(MetricBusinessAnalystExpertResult inputExpertResult, TestResult newTestResult) {
        if (!inputExpertResult.isCodeChangeRequired()) {
            return null;
        }
        TelemetryDetails newMetricDetails = this.itemDetailsService.analyzeMetric(newTestResult);
        return this.itemDetailsMapper.mapTelemetryDetailsToString(newMetricDetails, newTestResult);
    }

    private String oldExecutionResult(MetricCodeAssistanceContext context) {
        TestResult oldTestResult = this.calculationExecutor.test(context.getDatePickerConfig(), context.getZoneId(), context.getBusinessEntity().getQuery().getEntityType(), context.getMetricDefinition(), context.getUser());
        TelemetryDetails oldMetricDetails = this.itemDetailsService.analyzeMetric(oldTestResult);
        return this.itemDetailsMapper.mapTelemetryDetailsToString(oldMetricDetails, oldTestResult);
    }
}

