/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.metric.agent.developer;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.assistance.agent.AgentMetadata;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.metric.MetricDefinition;
import org.thingsboard.trendz.domain.metric.TestResult;
import org.thingsboard.trendz.domain.metric.assistance.MetricCodeAssistanceContext;
import org.thingsboard.trendz.domain.metric.item.telemetry.TelemetryDetails;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.metric.MetricPythonCalculationTester;
import org.thingsboard.trendz.service.metric.agent.MetricExplorerAiService;
import org.thingsboard.trendz.service.metric.agent.developer.PythonDeveloperExpertAgent;
import org.thingsboard.trendz.service.metric.agent.input.domain.MetricBusinessAnalystExpertResult;
import org.thingsboard.trendz.service.metric.item.ItemDetailsMapper;
import org.thingsboard.trendz.service.metric.item.ItemDetailsService;
import org.thingsboard.trendz.service.task.TaskExecutionProgressContent;
import org.thingsboard.trendz.service.task.TaskExecutionProgressDecorator;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.task.progress_content.MetricDefinitionGenerateContent;
import org.thingsboard.trendz.service.task.progress_content.MetricDefinitionImplementationContent;

@Service
public class PythonDeveloperExpertAgent {
    private static final int MAX_CALCULATION_CREATION_ITERATIONS = 3;
    private final ItemDetailsService itemDetailsService;
    private final ItemDetailsMapper itemDetailsMapper;
    private final MetricExplorerAiService metricExplorerAiService;
    private final MetricPythonCalculationTester calculationExecutor;

    @Autowired
    public PythonDeveloperExpertAgent(ItemDetailsService itemDetailsService, ItemDetailsMapper itemDetailsMapper, MetricExplorerAiService metricExplorerAiService, MetricPythonCalculationTester calculationExecutor) {
        this.itemDetailsService = itemDetailsService;
        this.itemDetailsMapper = itemDetailsMapper;
        this.metricExplorerAiService = metricExplorerAiService;
        this.calculationExecutor = calculationExecutor;
    }

    public TestResult calculateMetric(TaskExecutionProgressStepBuilder stepBuilder, MetricCodeAssistanceContext context, MetricBusinessAnalystExpertResult businessAnalystExpertResult, String source) {
        if (!businessAnalystExpertResult.isCodeChangeRequired()) {
            return null;
        }
        return this.calculateMetric(stepBuilder, businessAnalystExpertResult.getNewMetricDefinition(), context.getUser(), source, context.getBusinessEntity(), context.getAgentMetadataContainer(), context.getDatePickerConfig(), context.getZoneId(), businessAnalystExpertResult.getReviewNotes());
    }

    @TaskExecutionProgressDecorator(name="Calculate metric")
    public TestResult calculateMetric(TaskExecutionProgressStepBuilder stepBuilder, MetricDefinition metricDefinition, JwtSecurityUser user, String source, BusinessEntity businessEntity, List<AgentMetadata> agentMetadataContainer, DatePickerConfig datePickerConfig, ZoneId zoneId, List<String> tasks) {
        TestResult testResult;
        TaskExecutionProgressContent mutableContent = stepBuilder.getMutableContent();
        CalculateMetricProgressContent progressContent = new CalculateMetricProgressContent(this, mutableContent);
        metricDefinition.setAutoDeletable(false);
        if (metricDefinition.getCode() == null) {
            testResult = new TestResult();
        } else {
            try (TaskExecutionProgressStepBuilder step = stepBuilder.makeStep("Test results");){
                progressContent.setState((Object)MetricDefinitionImplementationContent.State.TEST_METRIC_DEFINITION);
                progressContent.setState((Object)MetricDefinitionGenerateContent.State.TEST_METRIC_DEFINITION);
                testResult = this.calculationExecutor.test(datePickerConfig, zoneId, businessEntity.getQuery().getEntityType(), metricDefinition, user);
            }
        }
        testResult.setLogs(Collections.emptyList());
        for (int i = 0; i < 3; ++i) {
            try (TaskExecutionProgressStepBuilder step = stepBuilder.makeStep("Calculation creation iteration " + i);){
                ArrayList<String> newTasks = new ArrayList<String>(tasks);
                if (testResult.getError() != null) {
                    newTasks.add("Fix error: \"%s\"".formatted(testResult.getError()));
                }
                TaskExecutionProgressStepBuilder stepAnalyzeMetrics = step.makeStep("Analyze metrics");
                progressContent.setState((Object)MetricDefinitionImplementationContent.State.ANALYZE_METRIC);
                progressContent.setState((Object)MetricDefinitionGenerateContent.State.ANALYZE_METRIC);
                TelemetryDetails telemetryDetails = this.itemDetailsService.analyzeMetric(testResult);
                String resultSummary = this.itemDetailsMapper.mapTelemetryDetailsToString(telemetryDetails, testResult);
                stepAnalyzeMetrics.close();
                TaskExecutionProgressStepBuilder stepGeneratePythonCode = step.makeStep("Generate Python code");
                progressContent.setState((Object)MetricDefinitionImplementationContent.State.GENERATE_PYTHON_SCRIPT);
                progressContent.setState((Object)MetricDefinitionGenerateContent.State.GENERATE_PYTHON_SCRIPT);
                String pythonCode = this.metricExplorerAiService.generatePythonCode(user, agentMetadataContainer, source, metricDefinition, newTasks, resultSummary, testResult.getLogs()).replace("```python\n", "").replace("```", "");
                metricDefinition.setCode(pythonCode);
                stepGeneratePythonCode.close();
                progressContent.setState((Object)MetricDefinitionImplementationContent.State.TEST_METRIC_SCRIPT);
                progressContent.setState((Object)MetricDefinitionGenerateContent.State.TEST_METRIC_SCRIPT);
                TaskExecutionProgressStepBuilder stepTestMetric = step.makeStep("Test metric");
                testResult = this.calculationExecutor.test(datePickerConfig, zoneId, businessEntity.getQuery().getEntityType(), metricDefinition, user);
                if (testResult.isValid()) {
                    TestResult testResult2 = testResult;
                    return testResult2;
                }
                stepTestMetric.close();
                continue;
            }
        }
        return testResult;
    }
}

