/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.metric.agent;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.assistance.agent.AgentMetadata;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.domain.metric.MetricDefinition;
import org.thingsboard.trendz.domain.metric.MetricDefinitionMetadata;
import org.thingsboard.trendz.domain.metric.MetricDefinitionRequirement;
import org.thingsboard.trendz.domain.metric.MetricGeneratorResponse;
import org.thingsboard.trendz.domain.metric.ai.MetricDefinitionAiLite;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.assistance.agent.AgentService;
import org.thingsboard.trendz.service.metric.agent.AiRequestDataMapper;
import org.thingsboard.trendz.service.metric.agent.input.domain.MetricBusinessAnalystExpertResponse;
import org.thingsboard.trendz.service.metric.agent.memorymanager.domain.MetricMemoryManagerExpertResponse;
import org.thingsboard.trendz.service.task.TaskExecutionProgressDecorator;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.task.progress_content.MetricDefinitionGenerateContent;

@Service
public class MetricExplorerAiService {
    private final AiRequestDataMapper aiRequestDataMapper;
    private final AgentService agentService;

    @Autowired
    public MetricExplorerAiService(AiRequestDataMapper aiRequestDataMapper, AgentService agentService) {
        this.aiRequestDataMapper = aiRequestDataMapper;
        this.agentService = agentService;
    }

    public List<MetricDefinitionAiLite> generateMetricDefinitions(JwtSecurityUser user, List<AgentMetadata> agentMetadataContainer, String source, int count, String seed, boolean advancedMode, List<MetricDefinitionMetadata> recentMetadata) {
        String request = this.aiRequestDataMapper.prepareRequestForMetricGenerator(source, count, seed, advancedMode, recentMetadata);
        if (advancedMode) {
            return ((MetricGeneratorResponse)this.agentService.processAiRequest(user, agentMetadataContainer, (Object)request, AiAgentType.METRIC_GENERATION_SENIOR_EXPERT)).getMetricDefinitionAiLiteList();
        }
        return ((MetricGeneratorResponse)this.agentService.processAiRequest(user, agentMetadataContainer, (Object)request, AiAgentType.METRIC_GENERATION_EXPERT)).getMetricDefinitionAiLiteList();
    }

    @TaskExecutionProgressDecorator(name="Create metric")
    public MetricDefinitionAiLite createMetricDefinition(TaskExecutionProgressStepBuilder stepBuilder, JwtSecurityUser user, List<AgentMetadata> agentMetadataContainer, String source, String name, String description, boolean advancedMode) {
        MetricDefinitionGenerateContent mutableContent = (MetricDefinitionGenerateContent)stepBuilder.getMutableContent();
        TaskExecutionProgressStepBuilder stepPrepareRequest = stepBuilder.makeStep("Prepare request");
        String request = this.aiRequestDataMapper.prepareRequestForMetricCreator(source, name, description, advancedMode);
        stepPrepareRequest.close();
        if (advancedMode) {
            try (TaskExecutionProgressStepBuilder stepProcessAdvanced = stepBuilder.makeStep("Process (advanced)");){
                mutableContent.setState(MetricDefinitionGenerateContent.State.CREATE_METRIC_ADVANCED);
                MetricDefinitionAiLite metricDefinitionAiLite = (MetricDefinitionAiLite)this.agentService.processAiRequest(user, agentMetadataContainer, (Object)request, AiAgentType.METRIC_CREATION_SENIOR_EXPERT);
                return metricDefinitionAiLite;
            }
        }
        try (TaskExecutionProgressStepBuilder stepProcess = stepBuilder.makeStep("Process");){
            mutableContent.setState(MetricDefinitionGenerateContent.State.CREATE_METRIC_SIMPLE);
            MetricDefinitionAiLite metricDefinitionAiLite = (MetricDefinitionAiLite)this.agentService.processAiRequest(user, agentMetadataContainer, (Object)request, AiAgentType.METRIC_CREATION_EXPERT);
            return metricDefinitionAiLite;
        }
    }

    public String generatePythonCode(JwtSecurityUser user, List<AgentMetadata> agentMetadataContainer, String source, MetricDefinition metricDefinition, List<String> tasks, String resultSummary, List<String> logs) {
        String request = this.aiRequestDataMapper.prepareRequestForMetricCodeGenerator(source, metricDefinition, tasks, metricDefinition.isAdvancedMode(), resultSummary, logs);
        return (String)this.agentService.processAiRequest(user, agentMetadataContainer, (Object)request, AiAgentType.PYTHON_DEVELOPER_SENIOR_EXPERT);
    }

    public MetricMemoryManagerExpertResponse aggregateMemory(JwtSecurityUser user, List<AgentMetadata> agentMetadataContainer, List<MetricDefinitionRequirement> requirementList, List<String> history, String finalQuestion, String oldChatSummary) {
        String request = this.aiRequestDataMapper.prepareRequestForMetricMemoryManager(history, finalQuestion, requirementList, oldChatSummary);
        return (MetricMemoryManagerExpertResponse)this.agentService.processAiRequest(user, agentMetadataContainer, (Object)request, AiAgentType.METRIC_MEMORY_MANAGER_EXPERT);
    }

    public MetricBusinessAnalystExpertResponse analyze(JwtSecurityUser user, List<AgentMetadata> agentMetadataContainer, String itemDetails, String topologyDetails, String mainTask, MetricDefinition metricDefinition, String code) {
        String request = this.aiRequestDataMapper.prepareRequestForMetricBusinessAnalyst(metricDefinition, itemDetails, topologyDetails, mainTask, code);
        return (MetricBusinessAnalystExpertResponse)this.agentService.processAiRequest(user, agentMetadataContainer, (Object)request, AiAgentType.METRIC_BUSINESS_ANALYST_EXPERT);
    }

    public String explainResults(JwtSecurityUser user, List<AgentMetadata> agentMetadataContainer, String userRequest, String extractedTask, MetricDefinition oldMetricDefinition, MetricDefinition newMetricDefinition, String oldTestResult, String newTestResult, boolean isCodeChanged, boolean isMetricDefinitionChanged) {
        String request = this.aiRequestDataMapper.explainResult(userRequest, extractedTask, oldMetricDefinition, newMetricDefinition, oldTestResult, newTestResult, isCodeChanged, isMetricDefinitionChanged);
        return (String)this.agentService.processAiRequest(user, agentMetadataContainer, (Object)request, AiAgentType.METRIC_OUTPUT_EXPERT);
    }
}

