/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.metric.agent;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.metric.MetricDefinition;
import org.thingsboard.trendz.domain.metric.MetricDefinitionMetadata;
import org.thingsboard.trendz.domain.metric.MetricDefinitionRequirement;

@Service
public class AiRequestDataMapper {
    public String prepareRequestForMetricCodeGenerator(String source, MetricDefinition metricDefinition, List<String> tasks, boolean advancedMode, String resultSummary, List<String> logs) {
        String tasksBlock = tasks.stream().map(task -> " - " + task).collect(Collectors.joining("\n"));
        String logsBlock = logs.stream().map(log -> "\t" + log).collect(Collectors.joining("\n"));
        return "%s\nMetric definition:\n    Name: %s\n    Description: %s\n    How to calculate: %s\n\nCode to change:\n```python\n%s\n```\n\nLogs of prev interation:\n%s\n\nRetrieved Result (Summary)\n%s\n\nTasks:\n%s\n".formatted(this.prepareSource(advancedMode, source), metricDefinition.getName(), metricDefinition.getDescription(), metricDefinition.getHowToCalculate(), metricDefinition.getCode(), tasksBlock, resultSummary, logsBlock);
    }

    public String prepareRequestForMetricGenerator(String source, int count, String seed, boolean advancedMode, List<MetricDefinitionMetadata> recentMetadata) {
        String seedLine = seed == null ? "" : "All generated metrics should totally cover the next user query: \"%s\"\n".formatted(seed);
        String savedBlock = recentMetadata.stream().filter(MetricDefinitionMetadata::isSaved).map(m -> " - " + m.getName()).collect(Collectors.joining("\n"));
        String deletedBlock = recentMetadata.stream().filter(m -> !m.isSaved()).map(m -> " - " + m.getName()).collect(Collectors.joining("\n"));
        return "Count of metrics to generate: %s\n%s\n\nUser saved next metrics:\n%s\n\nUser deleted next metrics:\n%s\n\n%s\n".formatted(count, seedLine, savedBlock, deletedBlock, this.prepareSource(advancedMode, source));
    }

    public String prepareRequestForMetricCreator(String source, String name, String description, boolean advancedMode) {
        return "Name: %s;\nDescription: %s;\n\n%s\n".formatted(name, description, this.prepareSource(advancedMode, source));
    }

    public String prepareRequestForMetricMemoryManager(List<String> history, String finalQuestion, List<MetricDefinitionRequirement> requirementList, String oldChatSummary) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean isUserTurn = false;
        for (String message : history) {
            stringBuilder.append("\t - (%s) \"%s\"\n".formatted(isUserTurn ? "USER" : "YOU", message));
            isUserTurn = !isUserTurn;
        }
        String historyBlock = stringBuilder.toString();
        String requirementsBlock = requirementList.stream().map(MetricDefinitionRequirement::getRequirement).map(i -> "\t" + i).collect(Collectors.joining("\n"));
        return "Chat Summary:\n    %s\n\nHistory:\n%s\n\nFinal Request:\n    %s\n\nPrevious Requirements:\n%s\n".formatted(oldChatSummary, historyBlock, finalQuestion, requirementsBlock);
    }

    public String prepareRequestForMetricBusinessAnalyst(MetricDefinition metricDefinition, String itemDetails, String topology, String task, String code) {
        String isUserChangedCode = Objects.equals(code, metricDefinition.getCode()) ? "User did not changed the code" : "User changed code (Upper what code user writes)";
        return "Item Details:\n%s\n\nTopology:\n%s\n\nWhat was generated together with user:\n    Name: %s\n    Description: %s\n    How to calculate: %s\n    Advanced mode: %s\n\nCode:\n\n```python\n%s\n```\n%s\n\nYour main task:\n    %s\n\n".formatted(itemDetails, topology, metricDefinition.getName(), metricDefinition.getDescription(), metricDefinition.getHowToCalculate(), metricDefinition.isAdvancedMode(), code, isUserChangedCode, task);
    }

    public String explainResult(String userRequest, String extractedTask, MetricDefinition oldMetricDefinition, MetricDefinition newMetricDefinition, String oldTestResult, String newTestResult, boolean isCodeChanged, boolean isMetricDefinitionChanged) {
        String codeBlock = this.prepareCodeBlock(isCodeChanged, oldMetricDefinition.getCode(), newMetricDefinition.getCode());
        String metricDefinitionBlock = this.prepareMetricDefinitionBlock(isMetricDefinitionChanged, oldMetricDefinition, newMetricDefinition);
        String testResultsBlock = this.prepareTestResults(isCodeChanged, oldTestResult, newTestResult);
        return "User request was: %s\nExtracted task from user request: %s\n\n%s\n\n%s\n\n%s\n".formatted(userRequest, extractedTask, codeBlock, metricDefinitionBlock, testResultsBlock);
    }

    private String prepareMetricDefinitionBlock(boolean isChanged, MetricDefinition oldMetricDefinition, MetricDefinition newMetricDefinition) {
        if (isChanged) {
            String nameAfter = oldMetricDefinition.getName().equals(newMetricDefinition.getName()) ? "<Unchanged>" : newMetricDefinition.getName();
            String descriptionAfter = oldMetricDefinition.getDescription().equals(newMetricDefinition.getDescription()) ? "<Unchanged>" : newMetricDefinition.getDescription();
            String howToCalculateAfter = oldMetricDefinition.getHowToCalculate().equals(newMetricDefinition.getHowToCalculate()) ? "<Unchanged>" : newMetricDefinition.getHowToCalculate();
            String useRelationsAfter = oldMetricDefinition.isAdvancedMode() == newMetricDefinition.isAdvancedMode() ? "<Unchanged>" : String.valueOf(newMetricDefinition.isAdvancedMode());
            return "Metric definition before our modifications:\n    Name: %s\n    Description: %s\n    How to calculate: %s\n    Use relations: %s\n\nMetric definition after our modifications:\n    Name: %s\n    Description: %s\n    How to calculate: %s\n    Use relations: %s\n".formatted(oldMetricDefinition.getName(), oldMetricDefinition.getDescription(), oldMetricDefinition.getHowToCalculate(), oldMetricDefinition.isAdvancedMode(), nameAfter, descriptionAfter, howToCalculateAfter, useRelationsAfter);
        }
        return "Metric definition was unchanged during request:\n    Name: %s\n    Description: %s\n    How to calculate: %s\n    Use relations: %s\n".formatted(oldMetricDefinition.getName(), oldMetricDefinition.getDescription(), oldMetricDefinition.getHowToCalculate(), oldMetricDefinition.isAdvancedMode());
    }

    private String prepareCodeBlock(boolean isChanged, String oldCode, String newCode) {
        if (isChanged || !oldCode.equals(newCode)) {
            return "Code before our modifications:\n```python\n%s\n```\n\nCode after our modifications:\n```python\n%s\n```\n".formatted(oldCode, newCode);
        }
        return "Code was unchanged during request:\n```python\n%s\n```\n".formatted(oldCode);
    }

    private String prepareTestResults(boolean isCodeChanged, String oldTestResults, String newTestResults) {
        if (isCodeChanged || !oldTestResults.equals(newTestResults)) {
            return "Test results before our modifications:\n%s\n\nTest results after our modifications:\n%s\n".formatted(oldTestResults, newTestResults);
        }
        return "Test results were unchanged during request:\n%s\n".formatted(oldTestResults);
    }

    private String prepareSource(boolean isAdvancedMode, String source) {
        return "%s:\n%s\n".formatted(isAdvancedMode ? "Topology" : "Item Details", source);
    }
}

