/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.install;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.service.install.EntityDatabaseSchemaService;
import org.thingsboard.trendz.service.install.InstallSettingsService;

@Service
@Profile(value={"install"})
public class TrendzInstallService {
    private static final Logger log = LoggerFactory.getLogger(TrendzInstallService.class);
    @Value(value="${install.upgrade:false}")
    private Boolean isUpgrade;
    @Value(value="${install.upgrade.from_version:undefined}")
    private String upgradeFromVersion;
    @Value(value="${spring.datasource.url}")
    private String dbUrl;
    @Value(value="${spring.datasource.username}")
    private String dbUserName;
    @Value(value="${spring.datasource.password}")
    private String dbPassword;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private EntityDatabaseSchemaService entityDatabaseSchemaService;
    @Autowired
    private InstallSettingsService installSettingsService;

    public void updateDbConnectionInfo(String dbUrl, String dbUserName, String dbPassword) {
        this.dbUrl = dbUrl;
        this.dbUserName = dbUserName;
        this.dbPassword = dbPassword;
    }

    public void launch() {
        try {
            if (this.isUpgrade.booleanValue()) {
                this.performUpgrade();
            } else {
                this.performInstall();
            }
        }
        catch (Exception e) {
            log.error("Unexpected error during Trendz installation!", (Throwable)e);
            throw new IllegalStateException("Unexpected error during Trendz installation!", e);
        }
        finally {
            SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[0]);
        }
    }

    private void performUpgrade() throws Exception {
        try (Connection connection = DriverManager.getConnection(this.dbUrl, this.dbUserName, this.dbPassword);){
            String version = this.defineVersion(connection);
            log.info("Start upgrading Trendz from version {} ...", (Object)version);
            switch (version) {
                case "1.7.0": {
                    log.info("Upgrading Trendz from version 1.7.0 to 1.8.0 ...");
                    this.entityDatabaseSchemaService.upgradeDatabase(connection, "1.7.0");
                }
                case "1.8.0": {
                    log.info("Upgrading Trendz from version 1.8.0 to 1.9.0 ...");
                    this.entityDatabaseSchemaService.upgradeDatabase(connection, "1.8.0");
                }
                case "1.9.0": {
                    log.info("Upgrading Trendz from version 1.9.0 to 1.9.1 ...");
                    this.entityDatabaseSchemaService.upgradeDatabase(connection, "1.9.0");
                }
                case "1.9.1": {
                    log.info("Upgrading Trendz from version 1.9.1 to 1.9.2 ...");
                    this.entityDatabaseSchemaService.upgradeDatabase(connection, "1.9.1");
                }
                case "1.9.2": {
                    log.info("Upgrading Trendz from version 1.9.2 to 1.10.0 ...");
                    this.entityDatabaseSchemaService.upgradeDatabase(connection, "1.9.2");
                }
                case "1.10.0": {
                    log.info("Upgrading Trendz from version 1.10.0 to 1.10.1 ...");
                    this.entityDatabaseSchemaService.upgradeDatabase(connection, "1.10.0");
                }
                case "1.10.1": {
                    log.info("Upgrading Trendz from version 1.10.1 to 1.10.2 ...");
                    this.entityDatabaseSchemaService.upgradeDatabase(connection, "1.10.1");
                }
                case "1.10.2": {
                    log.info("Upgrading Trendz from version 1.10.2 to 1.10.3 ...");
                    this.entityDatabaseSchemaService.upgradeDatabase(connection, "1.10.2");
                }
                case "1.10.3": {
                    log.info("Upgrading Trendz from version 1.10.3 to 1.11.0 ...");
                    this.entityDatabaseSchemaService.upgradeDatabase(connection, "1.10.3");
                }
                case "1.11.0": {
                    log.info("Upgrading Trendz from version 1.11.0 to 1.11.1 ...");
                    this.entityDatabaseSchemaService.upgradeDatabase(connection, "1.11.0");
                }
                case "1.11.1": {
                    log.info("Upgrading Trendz from version 1.11.1 to 1.11.2 ...");
                    this.entityDatabaseSchemaService.upgradeDatabase(connection, "1.11.1");
                }
                case "1.11.2": {
                    log.info("Upgrading Trendz from version 1.11.2 to 1.12.0 ...");
                    this.entityDatabaseSchemaService.upgradeDatabase(connection, "1.11.2");
                }
                case "1.12.0": {
                    log.info("Upgrading Trendz from version 1.12.0 to 1.12.1 ...");
                    this.entityDatabaseSchemaService.upgradeDatabase(connection, "1.12.0");
                }
                case "1.12.1": {
                    log.info("Upgrading Trendz from version 1.12.1 to 1.12.2 ...");
                    this.entityDatabaseSchemaService.upgradeDatabase(connection, "1.12.1");
                }
                case "1.12.2": {
                    log.info("Upgrading Trendz from version 1.12.2 to 1.12.3 ...");
                    this.entityDatabaseSchemaService.upgradeDatabase(connection, "1.12.2");
                }
                case "1.12.3": {
                    log.info("Upgrading Trendz from version 1.12.3 to 1.13.0 ...");
                    this.entityDatabaseSchemaService.upgradeDatabase(connection, "1.12.3");
                }
                case "1.13.0": {
                    log.info("Upgrading Trendz from version 1.13.0 to 1.13.1 ...");
                    this.entityDatabaseSchemaService.upgradeDatabase(connection, "1.13.0");
                }
                case "1.13.1": {
                    log.info("Upgrading Trendz from version 1.13.1 to 1.13.2 ...");
                    this.entityDatabaseSchemaService.upgradeDatabase(connection, "1.13.1");
                }
                case "1.13.2": {
                    log.info("Upgrading Trendz from version 1.13.2 to 1.13.3 ...");
                    this.entityDatabaseSchemaService.upgradeDatabase(connection, "1.13.2");
                }
                case "1.13.3": {
                    log.info("Upgrading Trendz from version 1.13.3 to 1.14.0 ...");
                    this.entityDatabaseSchemaService.upgradeDatabase(connection, "1.13.3");
                }
                case "1.14.0": {
                    this.entityDatabaseSchemaService.writeDatabaseVersion(connection, "1.14.0");
                    log.info("Current version is {}, upgrade is not needed.", (Object)"1.14.0");
                    break;
                }
                default: {
                    throw new RuntimeException("Unable to upgrade Trendz, unsupported fromVersion: " + version);
                }
            }
            this.entityDatabaseSchemaService.installAiAssistantPrompts(connection);
        }
    }

    private void performInstall() throws Exception {
        log.info("Starting Trendz Installation...");
        try (Connection connection = DriverManager.getConnection(this.dbUrl, this.dbUserName, this.dbPassword);){
            Optional dbVersion = this.entityDatabaseSchemaService.readDatabaseVersion(connection);
            if (dbVersion.isPresent()) {
                log.info("The database schema is already installed, skip installation...");
            } else {
                this.installSettingsService.installTrendzSettings((arg_0, arg_1, arg_2) -> this.updateDbConnectionInfo(arg_0, arg_1, arg_2));
                this.entityDatabaseSchemaService.createDatabaseSchema(connection);
                this.entityDatabaseSchemaService.installAiAssistantPrompts(connection);
                log.info("Installation finished successfully!");
            }
        }
    }

    private String defineVersion(Connection connection) {
        Optional dbVersion = this.entityDatabaseSchemaService.readDatabaseVersion(connection);
        if (dbVersion.isEmpty() && this.upgradeFromVersion == null) {
            throw new IllegalStateException("DB does not have version info and 'upgrade from version' argument.");
        }
        if (dbVersion.isEmpty()) {
            return this.upgradeFromVersion;
        }
        if ("undefined".equals(this.upgradeFromVersion)) {
            return (String)dbVersion.get();
        }
        if (this.upgradeFromVersion.equals(dbVersion.get())) {
            return (String)dbVersion.get();
        }
        log.warn("DB version [" + (String)dbVersion.get() + "] is not match 'upgrade from version' argument [" + this.upgradeFromVersion + "], using last...");
        return this.upgradeFromVersion;
    }
}

