/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.graph;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.thingsboard.trendz.service.graph.RelationEdge;
import org.thingsboard.trendz.service.graph.RelationGraph;
import org.thingsboard.trendz.service.graph.RelationNode;

public class RelationGraph {
    @NonNull
    private final Set<RelationNode> nodes;
    @NonNull
    private final Set<RelationEdge> edges;

    public RelationGraph() {
        this.nodes = new HashSet();
        this.edges = new HashSet();
    }

    public RelationGraph(RelationGraph that) {
        this.nodes = that.nodes.stream().map(RelationNode::new).collect(Collectors.toSet());
        this.edges = that.edges.stream().map(RelationEdge::new).collect(Collectors.toSet());
    }

    public String toString() {
        Map<UUID, String> idToNameMap = this.nodes.stream().collect(Collectors.toMap(RelationNode::getEntityId, RelationNode::getEntityName));
        List sortedNodes = this.nodes.stream().sorted(Comparator.comparing(RelationNode::getEntityName)).collect(Collectors.toList());
        List sortedEdges = this.edges.stream().sorted((o1, o2) -> {
            String s2;
            String s1 = (String)idToNameMap.get(o1.getEntityFrom());
            if (s1.equals(s2 = (String)idToNameMap.get(o2.getEntityFrom()))) {
                String q1 = (String)idToNameMap.get(o1.getEntityTo());
                String q2 = (String)idToNameMap.get(o2.getEntityTo());
                return q1.compareTo(q2);
            }
            return s1.compareTo(s2);
        }).collect(Collectors.toList());
        StringBuilder builder = new StringBuilder();
        builder.append("RelationGraph:\n");
        builder.append("* Nodes:\n");
        for (RelationNode node : sortedNodes) {
            String nodeString = String.format("\t - %s [%s]\n", node.getEntityId(), node.getEntityName());
            builder.append(nodeString);
        }
        builder.append("* Edges:\n");
        for (RelationEdge edge : sortedEdges) {
            String from = idToNameMap.get(edge.getEntityFrom());
            String to = idToNameMap.get(edge.getEntityTo());
            String edgeString = String.format("\t - (%s) %s -> %s : [%s] -> [%s]\n", edge.getEdgeId(), edge.getEntityFrom(), edge.getEntityTo(), from, to);
            builder.append(edgeString);
        }
        builder.append("\n");
        return builder.toString();
    }

    public static RelationGraphBuilder builder() {
        return new RelationGraphBuilder();
    }

    @NonNull
    public Set<RelationNode> getNodes() {
        return this.nodes;
    }

    @NonNull
    public Set<RelationEdge> getEdges() {
        return this.edges;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelationGraph)) {
            return false;
        }
        RelationGraph other = (RelationGraph)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Set this$nodes = this.getNodes();
        Set other$nodes = other.getNodes();
        if (this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes)) {
            return false;
        }
        Set this$edges = this.getEdges();
        Set other$edges = other.getEdges();
        return !(this$edges == null ? other$edges != null : !((Object)this$edges).equals(other$edges));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RelationGraph;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        Set $edges = this.getEdges();
        result = result * 59 + ($edges == null ? 43 : ((Object)$edges).hashCode());
        return result;
    }

    public RelationGraph(@NonNull Set<RelationNode> nodes, @NonNull Set<RelationEdge> edges) {
        if (nodes == null) {
            throw new NullPointerException("nodes is marked non-null but is null");
        }
        if (edges == null) {
            throw new NullPointerException("edges is marked non-null but is null");
        }
        this.nodes = nodes;
        this.edges = edges;
    }
}

