/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.graph;

import java.util.UUID;
import lombok.NonNull;
import org.thingsboard.trendz.service.graph.RelationEdge;

public class RelationEdge {
    @NonNull
    private final UUID edgeId;
    @NonNull
    private final UUID entityFrom;
    @NonNull
    private final UUID entityTo;
    @NonNull
    private final String type;
    private final boolean enabled;

    public RelationEdge(RelationEdge that) {
        this.edgeId = that.edgeId;
        this.entityFrom = that.entityFrom;
        this.entityTo = that.entityTo;
        this.type = that.type;
        this.enabled = that.enabled;
    }

    public static RelationEdgeBuilder builder() {
        return new RelationEdgeBuilder();
    }

    @NonNull
    public UUID getEdgeId() {
        return this.edgeId;
    }

    @NonNull
    public UUID getEntityFrom() {
        return this.entityFrom;
    }

    @NonNull
    public UUID getEntityTo() {
        return this.entityTo;
    }

    @NonNull
    public String getType() {
        return this.type;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelationEdge)) {
            return false;
        }
        RelationEdge other = (RelationEdge)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        UUID this$edgeId = this.getEdgeId();
        UUID other$edgeId = other.getEdgeId();
        if (this$edgeId == null ? other$edgeId != null : !((Object)this$edgeId).equals(other$edgeId)) {
            return false;
        }
        UUID this$entityFrom = this.getEntityFrom();
        UUID other$entityFrom = other.getEntityFrom();
        if (this$entityFrom == null ? other$entityFrom != null : !((Object)this$entityFrom).equals(other$entityFrom)) {
            return false;
        }
        UUID this$entityTo = this.getEntityTo();
        UUID other$entityTo = other.getEntityTo();
        if (this$entityTo == null ? other$entityTo != null : !((Object)this$entityTo).equals(other$entityTo)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RelationEdge;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        UUID $edgeId = this.getEdgeId();
        result = result * 59 + ($edgeId == null ? 43 : ((Object)$edgeId).hashCode());
        UUID $entityFrom = this.getEntityFrom();
        result = result * 59 + ($entityFrom == null ? 43 : ((Object)$entityFrom).hashCode());
        UUID $entityTo = this.getEntityTo();
        result = result * 59 + ($entityTo == null ? 43 : ((Object)$entityTo).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "RelationEdge(edgeId=" + String.valueOf(this.getEdgeId()) + ", entityFrom=" + String.valueOf(this.getEntityFrom()) + ", entityTo=" + String.valueOf(this.getEntityTo()) + ", type=" + this.getType() + ", enabled=" + this.isEnabled() + ")";
    }

    public RelationEdge(@NonNull UUID edgeId, @NonNull UUID entityFrom, @NonNull UUID entityTo, @NonNull String type, boolean enabled) {
        if (edgeId == null) {
            throw new NullPointerException("edgeId is marked non-null but is null");
        }
        if (entityFrom == null) {
            throw new NullPointerException("entityFrom is marked non-null but is null");
        }
        if (entityTo == null) {
            throw new NullPointerException("entityTo is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.edgeId = edgeId;
        this.entityFrom = entityFrom;
        this.entityTo = entityTo;
        this.type = type;
        this.enabled = enabled;
    }
}

